/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.EmptyMemberSet;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.DistributedCacheResponse;
import com.tangosol.coherence.component.net.message.DistributedPartialResponse;
import com.tangosol.coherence.component.net.message.requestMessage.DistributedCacheRequest;
import com.tangosol.coherence.component.net.requestContext.IdempotentContext;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$MemberConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$MemberConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyMemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyMemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyMessageReceipt;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyPollClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyServiceAnnounced;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyStartup;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$PollArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ProtocolContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigSync;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$AggregateAllRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$AggregateFilterRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$BackingMapContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$BinaryMap;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ClearRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ConfigListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ContainsAllRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ContainsKeyRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ContainsValueRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ConverterFromBinary;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ConverterKeyToBinary;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$DispatchMemberEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$DistributionRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$GetAllRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$GetRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$IndexRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$InvokeAllRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$InvokeAllRequest$InvokeJob;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$InvokeFilterRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$InvokeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$KeyIteratorRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$KeyListenerRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ListenerRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$LockRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$MapEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$MemberConfigListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$MemberConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$NotifyServiceJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$NotifyServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$NotifyServiceLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$NotifyShutdown;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$OwnershipRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$PartialMapResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$PartialValueResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$PinningIterator;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$PutAllRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$PutAllRequest$PutJob;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$PutRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$QueryRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$QueryResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$RemoveAllRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$RemoveAllRequest$RemoveJob;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$RemoveRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ServiceConfigMap;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$SimpleResponseContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$SizeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$Storage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$Storage$BinaryEntry;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$Storage$EntryStatus;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$Storage$MapIndex;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$StorageIdRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$TransferRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$UnlockRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ValueFilter;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ViewMap;
import com.tangosol.io.ReadBuffer;
import com.tangosol.license.CoherenceApplicationEdition;
import com.tangosol.license.LicenseException;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.partition.DefaultKeyAssociator;
import com.tangosol.net.partition.KeyAssociator;
import com.tangosol.net.partition.KeyPartitioningStrategy;
import com.tangosol.net.partition.PartitionAssignmentStrategy;
import com.tangosol.net.partition.PartitionEvent;
import com.tangosol.net.partition.PartitionListener;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ClassFilter;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterEnumerator;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.SparseArray;
import com.tangosol.util.ThreadGate;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import com.tangosol.util.filter.LimitFilter;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;

public class DistributedCache
extends Service
implements CacheService,
DistributedCacheService {
    private transient DistributedCache$BackingMapContext __m_BackingMapContext;
    private transient BackingMapManager __m_BackingMapManager;
    private Class __m_BackupClass;
    private int __m_BackupCount;
    private File __m_BackupDir;
    private int __m_BackupInitSize;
    private int __m_BackupMaxSize;
    private String __m_BackupScheme;
    private int __m_BackupType;
    private int __m_DistributionAggressiveness;
    private transient boolean __m_DistributionInProgress;
    private volatile transient long __m_DistributionNextMillis;
    private int __m_DistributionRepeatMillis;
    private boolean __m_DistributionSynchronized;
    private transient KeyAssociator __m_KeyAssociator;
    private transient KeyPartitioningStrategy __m_KeyPartitioningStrategy;
    private int __m_LeaseGranularity;
    private boolean __m_LocalStorageEnabled;
    private transient long __m_LockingNextMillis;
    private transient String __m_MsgCAE;
    private transient int __m_OwnershipInProgress;
    private transient PartitionAssignmentStrategy __m_PartitionAssignmentStrategy;
    private transient ThreadGate[] __m_PartitionControl;
    private int __m_PartitionCount;
    private transient PartitionListener __m_PartitionListener;
    private transient Map __m_PendingEventInfo;
    private volatile transient int __m_PrimaryTransfer;
    private Map __m_ReferencesBinaryMap;
    private Map __m_ReferencesViewMap;
    private long __m_StandardLeaseMillis;
    private LongArray __m_StorageArray;
    private volatile int[][] __m_StorageAssignments;
    private String[] __m_StorageAttribute;
    private volatile transient int __m_TransferCount;
    private transient List __m_TransferList;
    private int __m_TransferThreshold;
    private transient PartitionSet __m_TransitionalPartitions;
    private static ListMap __mapChildren;
    private static /* synthetic */ Class __sf0;
    private static /* synthetic */ Class __sf1;

    static {
        DistributedCache.__initStatic();
    }

    public DistributedCache() {
        this(null, null, true);
    }

    public DistributedCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAcceptingClients(false);
            this.setAcceptingOthers(false);
            this.setBackupCount(0);
            this.setBackupInitSize(0x100000);
            this.setBackupMaxSize(0x40000000);
            this.setBackupType(0);
            this.setDaemonState(0);
            this.setDistributionAggressiveness(20);
            this.setDistributionNextMillis(Long.MAX_VALUE);
            this.setDistributionRepeatMillis(2000);
            this.setDistributionSynchronized(true);
            this.setLeaseGranularity(0);
            this.setLocalStorageEnabled(true);
            this.setLockingNextMillis(Long.MAX_VALUE);
            this.setPartitionCount(1021);
            this.setPendingRequestInfo((LongArray)new SparseArray());
            this.setPrimaryTransfer(-1);
            this.setReferencesBinaryMap((Map)new SafeHashMap());
            this.setReferencesViewMap((Map)new SafeHashMap());
            this.setStandardLeaseMillis(0L);
            this.setStorageArray((LongArray)new SparseArray());
            this.setTransferList(new ArrayList());
            this.setTransferThreshold(524288);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this._addChild(new DistributedCache$ConfigListener("ConfigListener", this, true), "ConfigListener");
        this._addChild(new DistributedCache$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Service$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new DistributedCache$MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Service$PollArray("PollArray", this, true), "PollArray");
        this._addChild(new DistributedCache$ServiceConfigMap("ServiceConfigMap", this, true), "ServiceConfigMap");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"AggregateAllRequest", (Object)DistributedCache$AggregateAllRequest.get_CLASS());
        Object object2 = __mapChildren.put((Object)"AggregateFilterRequest", (Object)DistributedCache$AggregateFilterRequest.get_CLASS());
        Object object3 = __mapChildren.put((Object)"BackingMapContext", (Object)DistributedCache$BackingMapContext.get_CLASS());
        Object object4 = __mapChildren.put((Object)"BinaryMap", (Object)DistributedCache$BinaryMap.get_CLASS());
        Object object5 = __mapChildren.put((Object)"ClearRequest", (Object)DistributedCache$ClearRequest.get_CLASS());
        Object object6 = __mapChildren.put((Object)"ContainsAllRequest", (Object)DistributedCache$ContainsAllRequest.get_CLASS());
        Object object7 = __mapChildren.put((Object)"ContainsKeyRequest", (Object)DistributedCache$ContainsKeyRequest.get_CLASS());
        Object object8 = __mapChildren.put((Object)"ContainsValueRequest", (Object)DistributedCache$ContainsValueRequest.get_CLASS());
        Object object9 = __mapChildren.put((Object)"ConverterFromBinary", (Object)DistributedCache$ConverterFromBinary.get_CLASS());
        Object object10 = __mapChildren.put((Object)"ConverterKeyToBinary", (Object)DistributedCache$ConverterKeyToBinary.get_CLASS());
        Object object11 = __mapChildren.put((Object)"DispatchMemberEvent", (Object)DistributedCache$DispatchMemberEvent.get_CLASS());
        Object object12 = __mapChildren.put((Object)"DistributionRequest", (Object)DistributedCache$DistributionRequest.get_CLASS());
        Object object13 = __mapChildren.put((Object)"GetAllRequest", (Object)DistributedCache$GetAllRequest.get_CLASS());
        Object object14 = __mapChildren.put((Object)"GetRequest", (Object)DistributedCache$GetRequest.get_CLASS());
        Object object15 = __mapChildren.put((Object)"IndexRequest", (Object)DistributedCache$IndexRequest.get_CLASS());
        Object object16 = __mapChildren.put((Object)"InvokeAllRequest", (Object)DistributedCache$InvokeAllRequest.get_CLASS());
        Object object17 = __mapChildren.put((Object)"InvokeFilterRequest", (Object)DistributedCache$InvokeFilterRequest.get_CLASS());
        Object object18 = __mapChildren.put((Object)"InvokeRequest", (Object)DistributedCache$InvokeRequest.get_CLASS());
        Object object19 = __mapChildren.put((Object)"KeyIteratorRequest", (Object)DistributedCache$KeyIteratorRequest.get_CLASS());
        Object object20 = __mapChildren.put((Object)"KeyListenerRequest", (Object)DistributedCache$KeyListenerRequest.get_CLASS());
        Object object21 = __mapChildren.put((Object)"ListenerRequest", (Object)DistributedCache$ListenerRequest.get_CLASS());
        Object object22 = __mapChildren.put((Object)"LockRequest", (Object)DistributedCache$LockRequest.get_CLASS());
        Object object23 = __mapChildren.put((Object)"MapEvent", (Object)DistributedCache$MapEvent.get_CLASS());
        Object object24 = __mapChildren.put((Object)"MemberConfigRequest", (Object)DistributedCache$MemberConfigRequest.get_CLASS());
        Object object25 = __mapChildren.put((Object)"MemberConfigResponse", (Object)Service$MemberConfigResponse.get_CLASS());
        Object object26 = __mapChildren.put((Object)"MemberConfigUpdate", (Object)Service$MemberConfigUpdate.get_CLASS());
        Object object27 = __mapChildren.put((Object)"NotifyMemberJoined", (Object)Service$NotifyMemberJoined.get_CLASS());
        Object object28 = __mapChildren.put((Object)"NotifyMemberLeaving", (Object)Service$NotifyMemberLeaving.get_CLASS());
        Object object29 = __mapChildren.put((Object)"NotifyMemberLeft", (Object)Service$NotifyMemberLeft.get_CLASS());
        Object object30 = __mapChildren.put((Object)"NotifyMessageReceipt", (Object)Service$NotifyMessageReceipt.get_CLASS());
        Object object31 = __mapChildren.put((Object)"NotifyPollClosed", (Object)Service$NotifyPollClosed.get_CLASS());
        Object object32 = __mapChildren.put((Object)"NotifyServiceAnnounced", (Object)Service$NotifyServiceAnnounced.get_CLASS());
        Object object33 = __mapChildren.put((Object)"NotifyServiceJoined", (Object)DistributedCache$NotifyServiceJoined.get_CLASS());
        Object object34 = __mapChildren.put((Object)"NotifyServiceLeaving", (Object)DistributedCache$NotifyServiceLeaving.get_CLASS());
        Object object35 = __mapChildren.put((Object)"NotifyServiceLeft", (Object)DistributedCache$NotifyServiceLeft.get_CLASS());
        Object object36 = __mapChildren.put((Object)"NotifyShutdown", (Object)DistributedCache$NotifyShutdown.get_CLASS());
        Object object37 = __mapChildren.put((Object)"NotifyStartup", (Object)Service$NotifyStartup.get_CLASS());
        Object object38 = __mapChildren.put((Object)"OwnershipRequest", (Object)DistributedCache$OwnershipRequest.get_CLASS());
        Object object39 = __mapChildren.put((Object)"PartialMapResponse", (Object)DistributedCache$PartialMapResponse.get_CLASS());
        Object object40 = __mapChildren.put((Object)"PartialValueResponse", (Object)DistributedCache$PartialValueResponse.get_CLASS());
        Object object41 = __mapChildren.put((Object)"PinningIterator", (Object)DistributedCache$PinningIterator.get_CLASS());
        Object object42 = __mapChildren.put((Object)"ProtocolContext", (Object)Service$ProtocolContext.get_CLASS());
        Object object43 = __mapChildren.put((Object)"PutAllRequest", (Object)DistributedCache$PutAllRequest.get_CLASS());
        Object object44 = __mapChildren.put((Object)"PutRequest", (Object)DistributedCache$PutRequest.get_CLASS());
        Object object45 = __mapChildren.put((Object)"QueryRequest", (Object)DistributedCache$QueryRequest.get_CLASS());
        Object object46 = __mapChildren.put((Object)"QueryResponse", (Object)DistributedCache$QueryResponse.get_CLASS());
        Object object47 = __mapChildren.put((Object)"Queue", (Object)QueueProcessor$Queue.get_CLASS());
        Object object48 = __mapChildren.put((Object)"RemoveAllRequest", (Object)DistributedCache$RemoveAllRequest.get_CLASS());
        Object object49 = __mapChildren.put((Object)"RemoveRequest", (Object)DistributedCache$RemoveRequest.get_CLASS());
        Object object50 = __mapChildren.put((Object)"Response", (Object)DistributedCache$Response.get_CLASS());
        Object object51 = __mapChildren.put((Object)"ServiceConfigRequest", (Object)Service$ServiceConfigRequest.get_CLASS());
        Object object52 = __mapChildren.put((Object)"ServiceConfigResponse", (Object)Service$ServiceConfigResponse.get_CLASS());
        Object object53 = __mapChildren.put((Object)"ServiceConfigSync", (Object)Service$ServiceConfigSync.get_CLASS());
        Object object54 = __mapChildren.put((Object)"ServiceConfigUpdate", (Object)Service$ServiceConfigUpdate.get_CLASS());
        Object object55 = __mapChildren.put((Object)"SimpleResponseContext", (Object)DistributedCache$SimpleResponseContext.get_CLASS());
        Object object56 = __mapChildren.put((Object)"SizeRequest", (Object)DistributedCache$SizeRequest.get_CLASS());
        Object object57 = __mapChildren.put((Object)"Storage", (Object)DistributedCache$Storage.get_CLASS());
        Object object58 = __mapChildren.put((Object)"StorageIdRequest", (Object)DistributedCache$StorageIdRequest.get_CLASS());
        Object object59 = __mapChildren.put((Object)"TransferRequest", (Object)DistributedCache$TransferRequest.get_CLASS());
        Object object60 = __mapChildren.put((Object)"UnlockRequest", (Object)DistributedCache$UnlockRequest.get_CLASS());
        Object object61 = __mapChildren.put((Object)"ValueFilter", (Object)DistributedCache$ValueFilter.get_CLASS());
        Object object62 = __mapChildren.put((Object)"ViewMap", (Object)DistributedCache$ViewMap.get_CLASS());
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm1() {
        Class<?> clazz = __sf1;
        if (clazz == null) {
            try {
                clazz = __sf1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected void assignBucketOwner(int iBucket, int iStore, int nMember) {
        int[][] aaiBucketOwner = this.getStorageAssignments();
        int[] aiBucketOwner = aaiBucketOwner[iBucket];
        if (iStore == 0) {
            aaiBucketOwner = (int[][])aaiBucketOwner.clone();
            aiBucketOwner = (int[])aiBucketOwner.clone();
            aaiBucketOwner[iBucket] = aiBucketOwner;
        }
        aiBucketOwner[iStore] = nMember;
        this.setStorageAssignments(aaiBucketOwner);
    }

    protected void assignOrphans() {
        block5: {
            PartitionListener listener;
            int[][] aaiBucketOwner = this.getStorageAssignments();
            int cBuckets = aaiBucketOwner.length;
            PartitionSet partitions = new PartitionSet(cBuckets);
            StringBuffer sb = new StringBuffer();
            int iBucket = 0;
            while (iBucket < cBuckets) {
                if (aaiBucketOwner[iBucket][0] == 0) {
                    XmlElement xmlBucket = this.assignPrimaryBucket(iBucket);
                    this.putBucketConfig(iBucket, xmlBucket);
                    partitions.add(iBucket);
                    sb.append(iBucket).append(", ");
                }
                ++iBucket;
            }
            if (partitions.isEmpty() ^ true) {
                Component._trace(String.valueOf("Assigned ") + partitions.cardinality() + " orphaned primary partitions", 2);
                Component._trace(sb.toString(), 4);
            }
            if (!((listener = this.getPartitionListener()) != null)) break block5;
            try {
                listener.onPartitionEvent(new PartitionEvent((PartitionedService)this, PartitionEvent.PARTITION_LOST, partitions, null, (Member)this.getThisMember()));
            }
            catch (RuntimeException e) {
                Component._trace(String.valueOf("The following exception was thrown by PartitionListener:\n") + Component.getStackTrace(e) + "\n(The service thread has logged the exception and is continuing.)", 1);
            }
        }
    }

    protected XmlElement assignPrimaryBucket(int iBucket) {
        XmlElement xmlBucket = this.getBucketConfig(iBucket);
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        int nMemberThis = memberThis.getId();
        int nMachineThis = memberThis.getMachineId();
        int[] aiBucketOwner = this.getStorageAssignments()[iBucket];
        int cBackups = this.getBackupCount();
        if (cBackups > 0) {
            ServiceMemberSet setMember = this.getServiceMemberSet();
            int nPrimeOwner = aiBucketOwner[0];
            boolean fStrongPrime = false;
            if (!(nPrimeOwner != nMemberThis) ? false : setMember.contains(nPrimeOwner)) {
                fStrongPrime = ((MemberSet)setMember).getMember(nPrimeOwner).getMachineId() != nMachineThis;
            } else {
                nPrimeOwner = 0;
            }
            int iBackupWeak = 0;
            int iBackup = 1;
            while (iBackup <= cBackups) {
                int nBackupOwner = aiBucketOwner[iBackup];
                if (nBackupOwner == nMemberThis) {
                    this.releaseBucket(iBucket, false);
                    iBackupWeak = iBackup;
                    break;
                }
                if (iBackupWeak == 0) {
                    com.tangosol.coherence.component.net.Member memberBackup = nBackupOwner == 0 ? null : ((MemberSet)setMember).getMember(nBackupOwner);
                    if (memberBackup == null) {
                        iBackupWeak = iBackup;
                    } else if (!fStrongPrime ? false : memberBackup.getMachineId() == nMachineThis) {
                        iBackupWeak = iBackup;
                    }
                }
                ++iBackup;
            }
            if (iBackupWeak > 0) {
                aiBucketOwner[iBackupWeak] = nPrimeOwner;
                xmlBucket.addAttribute(this.getStorageAttribute(iBackupWeak)).setInt(nPrimeOwner);
            }
        }
        this.assignBucketOwner(iBucket, 0, nMemberThis);
        xmlBucket.addAttribute(this.getStorageAttribute(0)).setInt(nMemberThis);
        return xmlBucket;
    }

    public int calculateEndangeredMembers() {
        int[][] aaiBucketOwner = this.getStorageAssignments();
        int cBuckets = aaiBucketOwner.length;
        int cBackups = this.getBackupCount();
        HashSet<Integer> setId = new HashSet<Integer>();
        int iBucket = 0;
        while (iBucket < cBuckets) {
            int[] aiBucketOwner = aaiBucketOwner[iBucket];
            int iBackup = 1;
            while (iBackup <= cBackups) {
                if (aiBucketOwner[iBackup] == 0) {
                    setId.add(Base.makeInteger((int)aiBucketOwner[0]));
                }
                ++iBackup;
            }
            ++iBucket;
        }
        return setId.size();
    }

    public int[] calculateOwnership(MemberSet setStorage, boolean fPrimary) {
        if (setStorage == null) {
            setStorage = this.getStorageMemberSet();
        }
        int[][] aaiBucketOwner = this.getStorageAssignments();
        int cBucketsTotal = aaiBucketOwner.length;
        int nMaxMember = setStorage.getLastId();
        int[] acBuckets = new int[nMaxMember + 1];
        if (fPrimary) {
            int iBucket = 0;
            while (iBucket < cBucketsTotal) {
                int nMemberOwner = aaiBucketOwner[iBucket][0];
                if (nMemberOwner <= nMaxMember) {
                    int n = nMemberOwner;
                    acBuckets[n] = acBuckets[n] + 1;
                }
                ++iBucket;
            }
        } else {
            int cBackups = this.getBackupCount();
            int iBucket = 0;
            while (iBucket < cBucketsTotal) {
                int[] aiBucketOwner = aaiBucketOwner[iBucket];
                int iBackup = 1;
                while (iBackup <= cBackups) {
                    int nMemberOwner = aiBucketOwner[iBackup];
                    if (nMemberOwner <= nMaxMember) {
                        int n = nMemberOwner;
                        acBuckets[n] = acBuckets[n] + 1;
                    }
                    ++iBackup;
                }
                ++iBucket;
            }
        }
        return acBuckets;
    }

    public PartitionSet calculateOwnershipConflicts(int nMemberThat, int[][] aaiBucketOwnerThat, int cAttempts, PartitionSet partsConflict) {
        int nMemberThis = this.getThisMember().getId();
        int[][] aaiBucketOwnerThis = this.getStorageAssignments();
        int iBucket = 0;
        int cBuckets = aaiBucketOwnerThis.length;
        while (iBucket < cBuckets) {
            int nOwnerThis = aaiBucketOwnerThis[iBucket][0];
            int nOwnerThat = aaiBucketOwnerThat[iBucket][0];
            if (nOwnerThis != nOwnerThat) {
                this.syncBucketAssignment(iBucket, 0);
                nOwnerThis = this.getStorageAssignments()[iBucket][0];
            }
            if (nOwnerThis != nOwnerThat) {
                if (partsConflict == null) {
                    partsConflict = new PartitionSet(cBuckets);
                }
                if (partsConflict.contains(iBucket) ^ true) {
                    partsConflict.add(iBucket);
                    if (cAttempts > DistributedCache$OwnershipRequest.REQUEST_COUNT_THRESHOLD) {
                        if ((!(nOwnerThat == nMemberThis) ? false : nOwnerThis == 0) ? true : (!(nOwnerThis == nMemberThis) ? false : nOwnerThat == 0)) {
                            Component._trace(String.valueOf("Re-publishing the ownership for partition ") + iBucket + " [" + nOwnerThis + ']', 4);
                            this.publishBucketOwnership(iBucket, 0, nOwnerThis);
                        } else {
                            Component._trace(String.valueOf(cAttempts) + "> Ownership conflict for partition " + iBucket + " with member " + nMemberThat + " (" + nOwnerThis + "!=" + nOwnerThat + ")", 2);
                            if (nOwnerThis == nMemberThis) {
                                if (nMemberThis == this.getStorageOldestMember().getId()) {
                                    this.publishBucketOwnership(iBucket, 0, nOwnerThis);
                                } else {
                                    Component._trace("Unreconcilable ownership conflict; conceeding the ownership.", 1);
                                    this.assignBucketOwner(iBucket, 0, 0);
                                    this.releaseBucket(iBucket, true);
                                    this.publishBucketOwnership(iBucket, 0, 0);
                                }
                            }
                        }
                    }
                }
            }
            ++iBucket;
        }
        return partsConflict;
    }

    public PartitionSet calculatePartitionSet(com.tangosol.coherence.component.net.Member member, int iStore) {
        Component._assert(iStore <= this.getBackupCount());
        int[][] aaiBucketOwner = this.getStorageAssignments();
        int cBuckets = aaiBucketOwner.length;
        int nMember = member == null ? 0 : member.getId();
        PartitionSet partitions = new PartitionSet(cBuckets);
        int iBucket = 0;
        while (iBucket < cBuckets) {
            if (aaiBucketOwner[iBucket][iStore] == nMember) {
                partitions.add(iBucket);
            }
            ++iBucket;
        }
        return partitions;
    }

    public PartitionSet calculatePartitionSet(Set setKeys) {
        PartitionSet partitions = new PartitionSet(this.getPartitionCount());
        Iterator iter = setKeys.iterator();
        while (iter.hasNext()) {
            partitions.add(this.getKeyBucket((Binary)iter.next()));
        }
        return partitions;
    }

    public int calculateThisOwnership(boolean fPrimary) {
        int nMemberThis = this.getThisMember().getId();
        int[][] aaiBucketOwner = this.getStorageAssignments();
        int cBucketsTotal = aaiBucketOwner.length;
        int cBuckets = 0;
        if (fPrimary) {
            int iBucket = 0;
            while (iBucket < cBucketsTotal) {
                if (aaiBucketOwner[iBucket][0] == nMemberThis) {
                    ++cBuckets;
                }
                ++iBucket;
            }
        } else {
            int cBackups = this.getBackupCount();
            int iBucket = 0;
            while (iBucket < cBucketsTotal) {
                int[] aiBucketOwner = aaiBucketOwner[iBucket];
                int iBackup = 1;
                while (iBackup <= cBackups) {
                    if (aiBucketOwner[iBackup] == nMemberThis) {
                        ++cBuckets;
                    }
                    ++iBackup;
                }
                ++iBucket;
            }
        }
        return cBuckets;
    }

    public int calculateVulnerable() {
        int cBuckets = this.getPartitionCount();
        if (this.getBackupCount() == 0) {
            return cBuckets;
        }
        int cVulnerable = 0;
        int iBucket = 0;
        while (iBucket < cBuckets) {
            if (this.isBucketVulnerable(iBucket)) {
                ++cVulnerable;
            }
            ++iBucket;
        }
        return cVulnerable;
    }

    protected boolean checkBackupDistribution(MemberSet setStorage, MemberSet setOthers) {
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        int nMemberThis = memberThis.getId();
        int cMembers = setOthers.size() + 1;
        int[][] aaiBucketOwner = this.getStorageAssignments();
        int cBucketsTotal = aaiBucketOwner.length;
        int cBackups = this.getBackupCount();
        this.validateBucketAssignments(setOthers);
        if (cMembers <= cBackups) {
            int iBucket = 0;
            while (iBucket < cBucketsTotal) {
                int[] aiBucketOwner = aaiBucketOwner[iBucket];
                if (!(aiBucketOwner[0] != nMemberThis)) {
                    XmlElement xmlBucket = null;
                    int iBackup = 1;
                    int iValidBackup = 1;
                    while (iBackup <= cBackups) {
                        int nBackupOwner = aiBucketOwner[iBackup];
                        if (nBackupOwner != 0) {
                            if (iBackup > iValidBackup) {
                                if (xmlBucket == null) {
                                    xmlBucket = this.getBucketConfig(iBucket);
                                }
                                aiBucketOwner[iValidBackup] = nBackupOwner;
                                xmlBucket.addAttribute(this.getStorageAttribute(iValidBackup)).setInt(nBackupOwner);
                                aiBucketOwner[iBackup] = 0;
                                xmlBucket.addAttribute(this.getStorageAttribute(iBackup)).setInt(0);
                            }
                            ++iValidBackup;
                        }
                        ++iBackup;
                    }
                    Component._assert(aiBucketOwner[cMembers] == 0);
                    if (xmlBucket != null) {
                        this.putBucketConfig(iBucket, xmlBucket);
                    }
                }
                ++iBucket;
            }
            cBackups = cMembers - 1;
        }
        boolean fVulnerabilityAvoidable = this.isVulnerabilityAvoidable(setStorage);
        int cFairShare = Math.min(cBucketsTotal * cBackups / cMembers + 1, cBucketsTotal);
        int[] acBuckets = this.calculateOwnership(setStorage, false);
        List listOthers = this.sortMembers(setOthers, acBuckets);
        int cbTransfer = 0;
        int cbThreshold = this.getTransferThreshold();
        int nMachineThis = memberThis.getMachineId();
        int iBackup = 1;
        block8: while (iBackup <= cBackups) {
            int[] aiEndangered = this.collectEndangeredBuckets(iBackup);
            int cEndangered = aiEndangered.length;
            if (!(cEndangered == 0)) {
                int cStrongMembers = 0;
                int cEndangeredMembers = this.calculateEndangeredMembers();
                Component._assert(cEndangeredMembers > 0);
                int iPass = 1;
                while (iPass <= 4) {
                    Iterator iter = listOthers.iterator();
                    block10: while (!iter.hasNext() ? false : cEndangered > 0) {
                        com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
                        int nMember = member.getId();
                        boolean fStrong = member.getMachineId() != nMachineThis;
                        int cUnderload = cFairShare - acBuckets[nMember];
                        int cTransfer = 0;
                        switch (iPass) {
                            case 1: {
                                if (fStrong) {
                                    ++cStrongMembers;
                                } else if (fVulnerabilityAvoidable) {
                                    Component._assert(cStrongMembers > 0);
                                    break block10;
                                }
                                if (cUnderload <= 0) continue block10;
                                cTransfer = Math.min(cUnderload / cEndangeredMembers + 1, cEndangered);
                                break;
                            }
                            case 2: {
                                if (!(!fVulnerabilityAvoidable ? false : fStrong)) break block10;
                                cTransfer = cEndangered / cStrongMembers + 1;
                                break;
                            }
                            case 3: {
                                if (cMembers > 2) {
                                    cTransfer = cEndangered / (cMembers - 1) + 1;
                                    break;
                                }
                            }
                            case 4: {
                                cTransfer = cEndangered;
                                break;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                        int[] aiTransfer = this.collectTransfer(aiEndangered, nMember, cTransfer);
                        cTransfer = aiTransfer.length;
                        if (!(cTransfer > 0)) continue;
                        Component._trace(String.valueOf(iPass) + "> Transferring " + cTransfer + " out of " + cEndangered + " partitions to a " + (fStrong ? "machine-safe" : "node-safe") + " backup " + iBackup + " at member " + nMember + " (under " + cUnderload + ")", 4);
                        int iTransfer = 0;
                        while (iTransfer < cTransfer) {
                            int iBucket = aiTransfer[iTransfer];
                            aaiBucketOwner[iBucket][iBackup] = nMember;
                            cbTransfer = this.transferBucket(null, member, iBucket, iBackup, cbTransfer, iTransfer == cTransfer - 1);
                            --cEndangered;
                            int n = nMember;
                            acBuckets[n] = acBuckets[n] + 1;
                            if (!(cbTransfer > cbThreshold) ? false : iTransfer < cTransfer - 1) {
                                Component._trace(String.valueOf("Limiting backup transfer to ") + cbTransfer / 1024 + "KB (" + (iTransfer + 1) + " partitions)", 4);
                                break block8;
                            }
                            ++iTransfer;
                        }
                    }
                    if (cbTransfer > 0) break block8;
                    ++iPass;
                }
            }
            ++iBackup;
        }
        if (cbTransfer > 0) {
            return false;
        }
        int nMaxOverload = Math.max(0, acBuckets[nMemberThis] - cFairShare);
        int[] aiVulnerable = this.collectVulnerableBuckets();
        int iPass = 1;
        while (iPass <= 3) {
            int[] aiBucket = iPass == 2 ? this.collectOwnedBuckets() : aiVulnerable;
            int cBuckets = aiBucket.length;
            if (!(cBuckets == 0)) {
                Iterator iter = listOthers.iterator();
                while (iter.hasNext()) {
                    com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
                    int nMember = member.getId();
                    int cOverload = acBuckets[nMember] - cFairShare;
                    if (!(iPass < 3) ? false : cOverload >= 0) {
                        nMaxOverload = Math.max(nMaxOverload, cOverload);
                        continue;
                    }
                    if (Base.getRandom().nextDouble() >= (double)(-cOverload) / (double)cMembers) continue;
                    int i = 0;
                    while (i < cBuckets) {
                        int iBucket = aiBucket[i];
                        if (!this.isBackupOwner(iBucket, nMember)) {
                            boolean fBucketVulnerable = this.isBucketVulnerable(iBucket);
                            int[] aiBucketOwner = aaiBucketOwner[iBucket];
                            int iBackup2 = 1;
                            while (iBackup2 <= cBackups) {
                                int nBackupOwner = aiBucketOwner[iBackup2];
                                Component._assert(nBackupOwner != 0);
                                int cBackupOverload = acBuckets[nBackupOwner] - cFairShare;
                                boolean fTransferVulnerable = this.isTransferVulnerable(iBucket, iBackup2, member);
                                if (!((fTransferVulnerable ^ fBucketVulnerable ^ true ? true : fVulnerabilityAvoidable ^ true) ? (cBackupOverload <= 0 ? true : cOverload >= 0) : fTransferVulnerable)) {
                                    Component._trace(String.valueOf(iPass) + "> Transferring backup[" + iBackup2 + "] for partition " + iBucket + " from member " + nBackupOwner + " (over " + cBackupOverload + ") to member " + nMember + " (under " + -cOverload + ")", 5);
                                    aiBucketOwner[iBackup2] = nMember;
                                    this.transferBucket(null, member, iBucket, iBackup2, 0, true);
                                    return false;
                                }
                                ++iBackup2;
                            }
                        }
                        ++i;
                    }
                }
            }
            ++iPass;
        }
        return nMaxOverload == 0;
    }

    public boolean checkDeferredDistribution() {
        if (this.isDistributionInProgress() ? true : this.getTransferCount() > 0) {
            return true;
        }
        int cPending = this.getPendingConfigRequestCount();
        if (!this.isDistributionSynchronized() ? false : cPending > 0) {
            Component._trace(String.valueOf("Deferring the distribution due to ") + cPending + " pending configuration updates", 5);
            return true;
        }
        return false;
    }

    protected void checkDistribution() {
        this.setDistributionNextMillis(Base.getSafeTimeMillis() + (long)this.getDistributionRepeatMillis());
        if (this.checkDeferredDistribution()) {
            return;
        }
        MemberSet setStorage = this.getStorageMemberSet();
        MemberSet setOthers = this.getStorageOtherMemberSet(setStorage);
        Set setLeaving = this.getStorageLeavingMembers(setStorage);
        boolean fAlone = setOthers.isEmpty();
        boolean fRegular = setLeaving.isEmpty();
        int nState = this.getServiceState();
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        int nMemberThis = memberThis.getId();
        if (nState == Service.SERVICE_STOPPING) {
            int cRemains = this.calculateThisOwnership(true);
            if (cRemains == 0) {
                this.stop();
            } else if (setLeaving.size() == 1 + setOthers.size()) {
                this.stop();
            } else {
                Component._trace(String.valueOf("Remains to transfer before shutting down: ") + cRemains, 3);
            }
            return;
        }
        Component._assert(this.isLocalStorageEnabled());
        int[] acBuckets = this.calculateOwnership(setStorage, true);
        int cOrphans = acBuckets[0];
        if (!fRegular ? false : cOrphans > 0) {
            this.publishTransitionalOwnership();
            if (!(memberThis == this.getStorageOldestMember()) ? false : this.getOwnershipInProgress() <= 0) {
                DistributedCache$OwnershipRequest msg = (DistributedCache$OwnershipRequest)this.instantiateMessage("OwnershipRequest");
                msg.setToMemberSet(setStorage);
                msg.setRestore(false);
                this.setOwnershipInProgress(-this.getOwnershipInProgress() + 1);
                this.post(msg);
            }
            return;
        }
        this.setOwnershipInProgress(0);
        if (fAlone) {
            this.resetBucketConfig();
            this.setDistributionNextMillis(Long.MAX_VALUE);
            return;
        }
        com.tangosol.coherence.component.net.Member memberOverload = null;
        int cOverload = 0;
        int cMembers = 1 + setOthers.size() - setLeaving.size();
        int cBucketsTotal = this.getPartitionCount();
        int cFairShare = cBucketsTotal / cMembers + 1;
        int cUnderloadThis = cFairShare - acBuckets[nMemberThis];
        if (cUnderloadThis > 0) {
            Set setMembers;
            if (fRegular) {
                setMembers = setOthers;
            } else {
                setMembers = setLeaving;
                cFairShare = 0;
            }
            Iterator iter = DistributedCache.randomize(setMembers).iterator();
            while (iter.hasNext()) {
                com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
                cOverload = acBuckets[member.getId()] - cFairShare;
                if (!(cOverload > 0)) continue;
                memberOverload = member;
                break;
            }
        }
        if (memberOverload != null) {
            int cRequest = Math.min(cUnderloadThis, cOverload);
            DistributedCache$DistributionRequest msg = (DistributedCache$DistributionRequest)this.instantiateMessage("DistributionRequest");
            msg.addToMember(memberOverload);
            msg.setBucketsCount(cRequest);
            Component._trace(String.valueOf("Asking member ") + memberOverload.getId() + " for " + cRequest + " out of " + cOverload + " primary partitions", 4);
            this.setDistributionInProgress(true);
            this.post(msg);
            this.setDistributionNextMillis(Long.MAX_VALUE);
        } else if (fRegular) {
            int nError = cMembers * cFairShare - cBucketsTotal;
            if (cUnderloadThis <= nError) {
                int cOverloadThis = -cUnderloadThis;
                if (cOverloadThis <= 0) {
                    if (this.getBackupCount() > 0) {
                        this.checkBackupDistribution(setStorage, setOthers);
                    }
                    if (this.getTransferCount() == 0) {
                        this.setDistributionNextMillis(Base.getSafeTimeMillis() + (long)(4 * this.getDistributionRepeatMillis()));
                    }
                }
            } else {
                Component._trace(String.valueOf("Failed to find an overloaded member to request: ") + cUnderloadThis + " partitions", 2);
            }
        }
    }

    private void clearIterator(Iterator iter) {
        iter.remove();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    public void closePolls() {
        super.closePolls();
    }

    protected int[] collectEndangeredBuckets(int iBackup) {
        int nMemberThis = this.getThisMember().getId();
        int[][] aaiBucketOwner = this.getStorageAssignments();
        int cBuckets = aaiBucketOwner.length;
        int[] aiEndangered = new int[cBuckets];
        int cEndangered = 0;
        int iBucket = 0;
        while (iBucket < cBuckets) {
            int[] aiBucketOwner = aaiBucketOwner[iBucket];
            if (!(aiBucketOwner[0] == nMemberThis) ? false : aiBucketOwner[iBackup] == 0) {
                aiEndangered[cEndangered++] = iBucket;
            }
            ++iBucket;
        }
        int[] ai = new int[cEndangered];
        System.arraycopy(aiEndangered, 0, ai, 0, cEndangered);
        return ai;
    }

    protected int[] collectOwnedBuckets() {
        int cBuckets = this.getPartitionCount();
        int[] aiOwned = new int[cBuckets];
        int cOwned = 0;
        int iBucket = 0;
        while (iBucket < cBuckets) {
            if (this.isPrimaryOwner(iBucket)) {
                aiOwned[cOwned++] = iBucket;
            }
            ++iBucket;
        }
        int[] ai = new int[cOwned];
        System.arraycopy(aiOwned, 0, ai, 0, cOwned);
        return ai;
    }

    protected int[] collectTransfer(int[] aiEndangered, int nMember, int cTransfer) {
        int[] aiTransfer = new int[cTransfer];
        int cActual = 0;
        int i = 0;
        int c = aiEndangered.length;
        while (i < c) {
            int iBucket = aiEndangered[i];
            if (!(iBucket >= 0) ? false : this.isBackupOwner(iBucket, nMember) ^ true) {
                aiTransfer[cActual++] = iBucket;
                aiEndangered[i] = -1;
                if (cActual == cTransfer) break;
            }
            ++i;
        }
        int[] ai = new int[cActual];
        System.arraycopy(aiTransfer, 0, ai, 0, cActual);
        return ai;
    }

    protected int[] collectVulnerableBuckets() {
        int cBuckets = this.getPartitionCount();
        int[] aiVulnerable = new int[cBuckets];
        int cVulnerable = 0;
        int iBucket = 0;
        while (iBucket < cBuckets) {
            if (!this.isPrimaryOwner(iBucket) ? false : this.isBucketVulnerable(iBucket)) {
                aiVulnerable[cVulnerable++] = iBucket;
            }
            ++iBucket;
        }
        int[] ai = new int[cVulnerable];
        System.arraycopy(aiVulnerable, 0, ai, 0, cVulnerable);
        return ai;
    }

    public int compareImportance(com.tangosol.coherence.component.net.Member memberThat) {
        boolean fThisStorage = this.isLocalStorageEnabled();
        boolean fThatStorage = this.getStorageMemberSet().contains(memberThat);
        int iResult = super.compareImportance(memberThat);
        if (!(iResult == 0) ? false : fThisStorage ^ fThatStorage) {
            iResult = fThisStorage ? 1 : -1;
            int nWeight = this.getServiceConfig().getSafeElement("service-weight").getInt();
            if (nWeight > 0) {
                iResult *= nWeight;
            }
        }
        return iResult;
    }

    public synchronized void configure(XmlElement xml) {
        super.configure(xml);
        if (xml != null) {
            String sFlag;
            String sFactor;
            String sListener;
            String sAssociator;
            String sLeaseGranularity;
            long cLeaseMillis;
            int cBackups;
            int cKbTransferThreshold;
            int KB = 1024;
            int MB = 1024 * 1024;
            boolean fLocalStorage = !(((Coherence)Coherence.get_Instance()).getEdition() > 2) ? false : xml.getSafeElement("local-storage").getBoolean(this.isLocalStorageEnabled());
            this.setLocalStorageEnabled(fLocalStorage);
            int cPartitions = xml.getSafeElement("partition-count").getInt(this.getPartitionCount());
            if (cPartitions > 0) {
                this.setPartitionCount(cPartitions);
            }
            if ((cKbTransferThreshold = xml.getSafeElement("transfer-threshold").getInt(512)) > 0) {
                this.setTransferThreshold(cKbTransferThreshold * KB);
            }
            if (!((cBackups = xml.getSafeElement("backup-count").getInt(this.getBackupCount())) >= 0) ? false : cBackups <= 256) {
                this.setBackupCount(cBackups);
            }
            if ((cLeaseMillis = xml.getSafeElement("standard-lease-milliseconds").getLong(this.getStandardLeaseMillis())) >= (long)0) {
                this.setStandardLeaseMillis(cLeaseMillis);
            }
            this.setLeaseGranularity((sLeaseGranularity = xml.getSafeElement("lease-granularity").getString("thread")).equals("member") ? Lease.BY_MEMBER : Lease.BY_THREAD);
            if (fLocalStorage) {
                XmlElement xmlBackup = xml.getSafeElement("backup-storage");
                String sType = xmlBackup.getSafeElement("type").getString("on-heap");
                if (sType.equals("on-heap")) {
                    this.setBackupType(DistributedCache$Storage.BACKUP_ONHEAP);
                } else if (sType.equals("off-heap") ? true : sType.equals("file-mapped")) {
                    long cbInit = Base.parseMemorySize((String)xmlBackup.getSafeElement("initial-size").getString("1"), (int)Base.POWER_M);
                    long cbMax = Base.parseMemorySize((String)xmlBackup.getSafeElement("maximum-size").getString("1024"), (int)Base.POWER_M);
                    int cbMaxSize = (int)Math.min(Math.max(cbMax, 1L), (long)Integer.MAX_VALUE - (long)1023);
                    int cbInitSize = (int)Math.min(Math.max(cbInit, 1L), (long)cbMaxSize);
                    this.setBackupInitSize(cbInitSize);
                    this.setBackupMaxSize(cbMaxSize);
                    if (sType.equals("off-heap")) {
                        this.setBackupType(DistributedCache$Storage.BACKUP_OFFHEAP);
                    } else {
                        File dir;
                        String sPath = xmlBackup.getSafeElement("directory").getString();
                        if (sPath.length() > 0 && (dir = new File(sPath)).isDirectory()) {
                            this.setBackupDir(dir);
                        }
                        this.setBackupType(DistributedCache$Storage.BACKUP_FILE);
                    }
                } else if (sType.equals("custom")) {
                    String sBackupClass = xmlBackup.getSafeElement("class-name").getString();
                    try {
                        Class<?> clzBackup = this.getContextClassLoader().loadClass(sBackupClass);
                        Component._assert(DistributedCache.__sm0().isAssignableFrom(clzBackup));
                        this.setBackupClass(clzBackup);
                    }
                    catch (Exception e) {
                        throw new WrapperException((Throwable)e, String.valueOf("Invalid backup class: ") + sBackupClass);
                    }
                    this.setBackupType(DistributedCache$Storage.BACKUP_CUSTOM);
                } else if (sType.equals("scheme")) {
                    String sSchemeName = xmlBackup.getSafeElement("scheme-name").getString();
                    this.setBackupScheme(sSchemeName);
                    this.setBackupType(DistributedCache$Storage.BACKUP_SCHEME);
                } else {
                    throw new IllegalArgumentException(String.valueOf("Unknown backup type: ") + sType);
                }
            }
            if ((sAssociator = xml.getSafeElement("key-associator/class-name").getString()).length() > 0) {
                if (sAssociator.equals("none") ^ true) {
                    try {
                        Class<?> clzAssociator = this.getContextClassLoader().loadClass(sAssociator);
                        this.setKeyAssociator((KeyAssociator)clzAssociator.newInstance());
                    }
                    catch (Exception e) {
                        throw new WrapperException((Throwable)e, String.valueOf("Invalid KeyAssociator class: ") + sAssociator);
                    }
                }
            } else {
                this.setKeyAssociator((KeyAssociator)new DefaultKeyAssociator());
            }
            String sPartitioning = xml.getSafeElement("key-partitioning/class-name").getString();
            if (sPartitioning.length() > 0) {
                try {
                    Class<?> clzPartitioning = this.getContextClassLoader().loadClass(sPartitioning);
                    this.setKeyPartitioningStrategy((KeyPartitioningStrategy)clzPartitioning.newInstance());
                }
                catch (Exception e) {
                    throw new WrapperException((Throwable)e, String.valueOf("Invalid KeyPartitioning class: ") + sPartitioning);
                }
            }
            if (fLocalStorage && (sListener = xml.getSafeElement("partition-listener/class-name").getString()).length() > 0) {
                try {
                    Class<?> clzListener = this.getContextClassLoader().loadClass(sListener);
                    this.setPartitionListener((PartitionListener)clzListener.newInstance());
                }
                catch (Exception e) {
                    throw new WrapperException((Throwable)e, String.valueOf("Invalid PartitionListener class: ") + sListener);
                }
            }
            if (!((sFactor = System.getProperty("tangosol.coherence.distributed.aggressive")) != null) ? false : sFactor.length() > 0) {
                try {
                    this.setDistributionAggressiveness(Integer.parseInt(sFactor));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((sFlag = System.getProperty("tangosol.coherence.distributed.synchronize")) != null) {
                this.setDistributionSynchronized(Boolean.valueOf(sFlag));
            }
        }
    }

    protected DistributedCache$PinningIterator createPinningIterator(Set setKeys) {
        DistributedCache$PinningIterator pinner = (DistributedCache$PinningIterator)this._newChild("PinningIterator");
        pinner.setFullSet(setKeys);
        return pinner;
    }

    public IdempotentContext createRequestContext() {
        IdempotentContext ctx = this.instantiateRequestContext();
        long suidCurrent = this.getSUID();
        long suidOldest = this.getOldestPendingRequestSUID();
        ctx.setRequestSUID(suidCurrent);
        ctx.setOldestPendingSUID(suidOldest == -1L ? suidCurrent : suidOldest);
        return ctx;
    }

    protected IdempotentContext createSimpleResponseContext(IdempotentContext ctx, Binary binResult) {
        DistributedCache$SimpleResponseContext ctxSimple = new DistributedCache$SimpleResponseContext();
        ctxSimple.setRequestSUID(ctx.getRequestSUID());
        ctxSimple.setOldestPendingSUID(ctx.getOldestPendingSUID());
        ctxSimple.setResult(binResult);
        return ctxSimple;
    }

    protected Iterator createWrapperIterator(Iterator iter, boolean fExcludeNullValues) {
        DistributedCache$ValueFilter filterConverter = new DistributedCache$ValueFilter();
        filterConverter.setExcludeNullValues(fExcludeNullValues);
        FilterEnumerator iterEntries = new FilterEnumerator(iter, (Filter)filterConverter);
        return fExcludeNullValues ? iterEntries : new ConverterEnumerator((Iterator)iterEntries, (Converter)filterConverter);
    }

    public synchronized void destroyCache(NamedCache cache) {
        if (cache.getCacheService() != this) {
            throw new IllegalArgumentException(String.valueOf("The cache to destroy is not owned by this service: ") + this);
        }
        this.releaseCache(cache);
        this.getServiceConfigMap().remove(cache.getCacheName());
    }

    protected NamedCache ensureCache(String sName) {
        Map mapRefsBinary;
        NamedCache mapBinary;
        if (sName == null ? true : sName.length() == 0) {
            sName = "Default";
        }
        if ((mapBinary = (NamedCache)(mapRefsBinary = this.getReferencesBinaryMap()).get(sName)) != null) {
            return mapBinary;
        }
        ObservableMap mapConfig = this.getServiceConfigMap();
        XmlElement xmlCacheInfo = (XmlElement)mapConfig.get(sName);
        while (xmlCacheInfo == null) {
            DistributedCache$StorageIdRequest msg = (DistributedCache$StorageIdRequest)this.instantiateMessage("StorageIdRequest");
            msg.addToMember(this.getServiceOldestMember());
            msg.setCacheName(sName);
            xmlCacheInfo = (XmlElement)this.poll(msg);
        }
        long lCacheId = xmlCacheInfo.getAttribute("id").getLong();
        DistributedCache distributedCache = this;
        synchronized (distributedCache) {
            mapBinary = (NamedCache)mapRefsBinary.get(sName);
            if (mapBinary == null) {
                mapBinary = this.instantiateBinaryMap(sName, lCacheId);
                mapRefsBinary.put(sName, mapBinary);
            }
        }
        return mapBinary;
    }

    public NamedCache ensureCache(String sName, ClassLoader loader) {
        if (this.isRunning() ^ true) {
            throw new IllegalStateException(String.valueOf("Service is not running: ") + this);
        }
        if (sName == null ? true : sName.length() == 0) {
            sName = "Default";
        }
        if (loader == null) {
            loader = this.getContextClassLoader();
            Component._assert(loader != null, "ContextClassLoader is missing");
        }
        DistributedCache$ViewMap mapCache = null;
        Map mapByName = this.getReferencesViewMap();
        Map mapByLoader = (Map)mapByName.get(sName);
        if (mapByLoader != null && (mapCache = (DistributedCache$ViewMap)mapByLoader.get(loader)) != null) {
            return mapCache;
        }
        NamedCache mapBinary = this.ensureCache(sName);
        DistributedCache distributedCache = this;
        synchronized (distributedCache) {
            mapByLoader = (Map)mapByName.get(sName);
            if (mapByLoader == null) {
                mapByLoader = new LiteMap();
                mapByName.put(sName, mapByLoader);
            }
            if ((mapCache = (DistributedCache$ViewMap)mapByLoader.get(loader)) != null) {
                DistributedCache$ViewMap distributedCache$ViewMap = mapCache;
                Object var9_9 = null;
                return distributedCache$ViewMap;
            }
            mapCache = (DistributedCache$ViewMap)this._newChild("ViewMap");
            mapCache.setBinaryMap(mapBinary);
            mapCache.setClassLoader(loader);
            mapByLoader.put(loader, mapCache);
        }
        return mapCache;
    }

    protected void ensureKnownStorage() {
        if (this.isLocalStorageEnabled() ^ true) {
            Component._assert(this.getServiceState() >= Service.SERVICE_STOPPING);
            return;
        }
        int cMembers = this.getStorageMemberSet().size();
        int cBuckets = this.getPartitionCount();
        if (cBuckets < cMembers * cMembers) {
            Component._trace(String.valueOf("The number of partitions (") + cBuckets + ") is too small for the number of storage-enabled cluster nodes (" + cMembers + ") that run this service; " + "please refer to the 'partition-count' element in coherence.dtd", 2);
        }
        ObservableMap mapConfig = this.getServiceConfigMap();
        Enumeration enumeration = this.getCacheNames();
        while (enumeration.hasMoreElements()) {
            String sCacheName = (String)enumeration.nextElement();
            XmlElement xmlCacheInfo = (XmlElement)mapConfig.get(sCacheName);
            long lCacheId = xmlCacheInfo.getSafeAttribute("id").getLong();
            Component._assert(sCacheName.equals(xmlCacheInfo.getSafeAttribute("name").getString()));
            this.ensureStorage(lCacheId).setCacheName(sCacheName);
        }
        this.setAcceptingOthers(true);
        this.setDistributionNextMillis(0L);
    }

    public DistributedCache$Storage ensureStorage(long lCacheId) {
        Component._assert(this.isLocalStorageEnabled());
        LongArray aStorage = this.getStorageArray();
        DistributedCache$Storage storage = (DistributedCache$Storage)aStorage.get(lCacheId);
        if (storage == null) {
            LongArray longArray = aStorage;
            synchronized (longArray) {
                storage = (DistributedCache$Storage)aStorage.get(lCacheId);
                if (storage == null) {
                    storage = (DistributedCache$Storage)this._newChild("Storage");
                    storage.setCacheId(lCacheId);
                    aStorage.set(lCacheId, (Object)storage);
                }
            }
        }
        return storage;
    }

    private Throwable ensureSupport(DistributedCacheRequest msgRequest, String sFeature) {
        IOException e = msgRequest == null ? null : msgRequest.getReadException();
        if (!(e == null) ? false : this.getMsgCAE() != null) {
            e = new LicenseException(String.valueOf(sFeature) + ": " + this.getMsgCAE());
        }
        return e;
    }

    public ThreadGate enterBucket(int iBucket) {
        ThreadGate gate = this.getPartitionControl()[iBucket];
        long cWait = this.getPrimaryTransfer() == iBucket ? -1L : 0L;
        return gate.enter(cWait) ? gate : null;
    }

    protected void evaluateLockRequests() {
        LongArray aStorage;
        long lTime = this.getClusterTime();
        long lNext = Long.MAX_VALUE;
        DistributedCache distributedCache = this;
        synchronized (distributedCache) {
            this.setLockingNextMillis(lNext);
        }
        LongArray longArray = aStorage = this.getStorageArray();
        synchronized (longArray) {
            LongArray.Iterator iterStore = aStorage.iterator();
            while (iterStore.hasNext()) {
                List listPending;
                DistributedCache$Storage storage = (DistributedCache$Storage)iterStore.next();
                if (storage.isValid() ^ true) continue;
                ArrayList<DistributedCache$LockRequest> listRetry = null;
                List list = listPending = storage.getPendingLockRequest();
                synchronized (list) {
                    int cPending = listPending.size();
                    if (cPending > 0) {
                        listRetry = new ArrayList<DistributedCache$LockRequest>(cPending);
                        Iterator iter = listPending.iterator();
                        while (iter.hasNext()) {
                            DistributedCache$LockRequest msgLock = (DistributedCache$LockRequest)iter.next();
                            long lTimeout = msgLock.getLeaseWaitTimeout();
                            if (lTimeout <= lTime) {
                                iter.remove();
                                listRetry.add(msgLock);
                                continue;
                            }
                            if (!(lTimeout != Long.MAX_VALUE)) continue;
                            lNext = Math.min(lNext, lTimeout);
                        }
                    }
                }
                if (!(listRetry != null)) continue;
                Iterator iter = listRetry.iterator();
                while (iter.hasNext()) {
                    DistributedCache$LockRequest msgLock = (DistributedCache$LockRequest)iter.next();
                    try {
                        msgLock.onReceived();
                    }
                    catch (EventDeathException e) {
                        // empty catch block
                    }
                }
            }
        }
        if (lNext != Long.MAX_VALUE) {
            this.scheduleLockEvaluation(lNext - lTime);
        }
    }

    public DistributedCache$BackingMapContext getBackingMapContext() {
        return this.__m_BackingMapContext;
    }

    public BackingMapManager getBackingMapManager() {
        return this.__m_BackingMapManager;
    }

    public Class getBackupClass() {
        return this.__m_BackupClass;
    }

    public int getBackupCount() {
        return this.__m_BackupCount;
    }

    public File getBackupDir() {
        return this.__m_BackupDir;
    }

    public int getBackupInitSize() {
        return this.__m_BackupInitSize;
    }

    public int getBackupMaxSize() {
        return this.__m_BackupMaxSize;
    }

    public MemberSet getBackupOwners(int iBucket) {
        MemberSet setOwners = null;
        com.tangosol.coherence.component.net.Member memberFirstOwner = null;
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        int[] aiBucketOwner = this.getStorageAssignments()[iBucket];
        int iBackup = 1;
        int cBackups = this.getBackupCount();
        while (iBackup <= cBackups) {
            com.tangosol.coherence.component.net.Member memberOwner;
            int nOwner = aiBucketOwner[iBackup];
            if ((!(nOwner > 0) ? false : setMembers.isServiceLeaving(nOwner) ^ true) && (memberOwner = setMembers.getMember(nOwner)) != null) {
                if (memberFirstOwner == null) {
                    memberFirstOwner = memberOwner;
                } else {
                    if (setOwners == null) {
                        setOwners = new ActualMemberSet();
                        setOwners.add(memberFirstOwner);
                    }
                    setOwners.add(memberOwner);
                }
            }
            ++iBackup;
        }
        return memberFirstOwner == null ? (MemberSet)EmptyMemberSet.get_Instance() : (setOwners == null ? SingleMemberSet.instantiate(memberFirstOwner) : setOwners);
    }

    public MemberSet getBackupOwners(Binary binKey) {
        return this.getBackupOwners(this.getKeyBucket(binKey));
    }

    public String getBackupScheme() {
        return this.__m_BackupScheme;
    }

    public int getBackupType() {
        return this.__m_BackupType;
    }

    public XmlElement getBucketConfig(int iBucket) {
        return (XmlElement)this.getServiceConfigMap().get(Base.makeInteger((int)iBucket));
    }

    public Enumeration getCacheNames() {
        ObservableMap mapConfig = this.getServiceConfigMap();
        while (true) {
            try {
                return new FilterEnumerator(mapConfig.keySet().iterator(), (Filter)new ClassFilter(DistributedCache.__sm1()));
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    public String getDescription() {
        if (this.isAcceptingClients()) {
            if (this.isLocalStorageEnabled()) {
                StringBuffer sb = new StringBuffer("LocalStorage=enabled");
                sb.append(", PartitionCount=").append(this.getPartitionCount()).append(", BackupCount=").append(this.getBackupCount()).append(", AssignedPartitions=").append(this.calculateThisOwnership(true));
                if (this.getBackupCount() > 0) {
                    sb.append(", BackupPartitions=").append(this.calculateThisOwnership(false));
                }
                return sb.toString();
            }
            return "LocalStorage=disabled";
        }
        return "Not initialized";
    }

    public int getDistributionAggressiveness() {
        return this.__m_DistributionAggressiveness;
    }

    public long getDistributionNextMillis() {
        return this.__m_DistributionNextMillis;
    }

    public int getDistributionRepeatMillis() {
        return this.__m_DistributionRepeatMillis;
    }

    public KeyAssociator getKeyAssociator() {
        return this.__m_KeyAssociator;
    }

    public int getKeyBucket(Binary binKey) {
        if (binKey == null) {
            return 0;
        }
        if (ExternalizableHelper.isIntDecorated((ReadBuffer)binKey)) {
            return ExternalizableHelper.extractIntDecoration((ReadBuffer)binKey);
        }
        long lHash = (long)binKey.hashCode() & 0xFFFFFFFFL;
        return (int)(lHash % (long)this.getPartitionCount());
    }

    public Member getKeyOwner(Object oKey) {
        Binary binKey = (Binary)this.getBackingMapContext().getKeyToInternalConverter().convert(oKey);
        return this.getPrimaryOwner(binKey);
    }

    public KeyPartitioningStrategy getKeyPartitioningStrategy() {
        return this.__m_KeyPartitioningStrategy;
    }

    public int getLeaseGranularity() {
        return this.__m_LeaseGranularity;
    }

    public long getLockingNextMillis() {
        return this.__m_LockingNextMillis;
    }

    private String getMsgCAE() {
        return this.__m_MsgCAE;
    }

    public MemberSet getOthersMemberSet() {
        ActualMemberSet setOthers = new ActualMemberSet();
        setOthers.addAll((Collection)this.getServiceMemberSet());
        setOthers.remove(this.getThisMember());
        return setOthers;
    }

    public int getOwnershipInProgress() {
        return this.__m_OwnershipInProgress;
    }

    public PartitionAssignmentStrategy getPartitionAssignmentStrategy() {
        return this.__m_PartitionAssignmentStrategy;
    }

    public ThreadGate[] getPartitionControl() {
        return this.__m_PartitionControl;
    }

    public int getPartitionCount() {
        return this.__m_PartitionCount;
    }

    public PartitionListener getPartitionListener() {
        return this.__m_PartitionListener;
    }

    public Map getPendingEventInfo() {
        return this.__m_PendingEventInfo;
    }

    public com.tangosol.coherence.component.net.Member getPrimaryOwner(int iBucket) {
        int nMember = this.getStorageAssignments()[iBucket][0];
        return nMember == 0 ? null : this.getServiceMemberSet().getMember(nMember);
    }

    public com.tangosol.coherence.component.net.Member getPrimaryOwner(Binary binKey) {
        return this.getPrimaryOwner(this.getKeyBucket(binKey));
    }

    public int getPrimaryTransfer() {
        return this.__m_PrimaryTransfer;
    }

    public Map getReferencesBinaryMap() {
        return this.__m_ReferencesBinaryMap;
    }

    public Map getReferencesViewMap() {
        return this.__m_ReferencesViewMap;
    }

    public String getServiceType() {
        return "DistributedCache";
    }

    public String getServiceVersion() {
        return "3.2";
    }

    public long getStandardLeaseMillis() {
        return this.__m_StandardLeaseMillis;
    }

    public DistributedCache$Storage getStorage(long lCacheId) {
        return (DistributedCache$Storage)this.getStorageArray().get(lCacheId);
    }

    public LongArray getStorageArray() {
        return this.__m_StorageArray;
    }

    public int[][] getStorageAssignments() {
        return this.__m_StorageAssignments;
    }

    public String[] getStorageAttribute() {
        return this.__m_StorageAttribute;
    }

    public String getStorageAttribute(int i) {
        return this.getStorageAttribute()[i];
    }

    public Set getStorageEnabledMembers() {
        return this.getStorageMemberSet();
    }

    public Set getStorageLeavingMembers(Set setStorage) {
        LiteSet setLeaving = new LiteSet();
        ServiceMemberSet setService = this.getServiceMemberSet();
        if (setStorage == null) {
            setStorage = this.getStorageMemberSet();
        }
        Iterator iter = setStorage.iterator();
        while (iter.hasNext()) {
            com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
            if (!setService.isServiceLeaving(member.getId())) continue;
            setLeaving.add((Object)member);
        }
        return setLeaving;
    }

    public MemberSet getStorageMemberSet() {
        ActualMemberSet setStorage = new ActualMemberSet();
        if (this.getServiceState() != Service.SERVICE_STOPPED) {
            Iterator iter = this.getServiceMemberSet().iterator();
            while (iter.hasNext()) {
                com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
                if (!this.isLocalStorageEnabled(member)) continue;
                setStorage.add(member);
            }
        }
        return setStorage;
    }

    public com.tangosol.coherence.component.net.Member getStorageOldestMember() {
        MemberSet setStorage = this.getStorageMemberSet();
        ServiceMemberSet setService = this.getServiceMemberSet();
        com.tangosol.coherence.component.net.Member memberAnchor = null;
        Iterator iter = setStorage.iterator();
        while (iter.hasNext()) {
            long ldtJoinedAnchor;
            com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
            if (memberAnchor == null) {
                memberAnchor = member;
                continue;
            }
            long ldtJoined = setService.getServiceJoined(member.getId());
            if (!(ldtJoined < (ldtJoinedAnchor = setService.getServiceJoined(memberAnchor.getId())))) continue;
            memberAnchor = member;
        }
        return memberAnchor;
    }

    public MemberSet getStorageOtherMemberSet(MemberSet setStorage) {
        DependentMemberSet setOthers = new DependentMemberSet();
        setOthers.setBaseSet(setStorage == null ? this.getStorageMemberSet() : setStorage);
        setOthers.addAll();
        setOthers.remove(this.getThisMember());
        return setOthers;
    }

    public int getTransferCount() {
        return this.__m_TransferCount;
    }

    protected List getTransferList() {
        return this.__m_TransferList;
    }

    public int getTransferThreshold() {
        return this.__m_TransferThreshold;
    }

    public PartitionSet getTransitionalPartitions() {
        return this.__m_TransitionalPartitions;
    }

    public long getWaitMillis() {
        long cWait1 = super.getWaitMillis();
        long ldtNow = Base.getSafeTimeMillis();
        long cWait2 = Math.max(1L, Math.min(this.getDistributionNextMillis() - ldtNow, this.getLockingNextMillis() - ldtNow));
        return cWait1 <= 0L ? cWait2 : Math.min(cWait1, cWait2);
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/DistributedCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new DistributedCache();
    }

    private final Component get_Module() {
        return this;
    }

    protected NamedCache instantiateBinaryMap(String sName, long lCacheId) {
        DistributedCache$BinaryMap mapBinary = (DistributedCache$BinaryMap)this._newChild("BinaryMap");
        mapBinary.setCacheId(lCacheId);
        mapBinary.setCacheName(sName);
        return mapBinary;
    }

    public DistributedCache$ConverterFromBinary instantiateFromBinaryConverter(ClassLoader loader) {
        DistributedCache$ConverterFromBinary conv = (DistributedCache$ConverterFromBinary)this._newChild("ConverterFromBinary");
        conv.setClassLoader(loader == null ? this.getContextClassLoader() : loader);
        return conv;
    }

    public IdempotentContext instantiateRequestContext() {
        return new IdempotentContext();
    }

    public boolean isBackupOwner(int iBucket) {
        return this.isBackupOwner(iBucket, this.getThisMember().getId());
    }

    public boolean isBackupOwner(int iBucket, int nMember) {
        int[] aiBucketOwner = this.getStorageAssignments()[iBucket];
        int iBackup = 1;
        int cBackups = this.getBackupCount();
        while (iBackup <= cBackups) {
            if (aiBucketOwner[iBackup] == nMember) {
                return true;
            }
            ++iBackup;
        }
        return false;
    }

    public boolean isBackupOwner(Binary binKey) {
        return this.isBackupOwner(this.getKeyBucket(binKey));
    }

    public boolean isBucketVulnerable(int iBucket) {
        com.tangosol.coherence.component.net.Member memberPrime;
        if (this.getBackupCount() > 0 && (memberPrime = this.getPrimaryOwner(iBucket)) != null) {
            Iterator iter = this.getBackupOwners(iBucket).iterator();
            while (iter.hasNext()) {
                com.tangosol.coherence.component.net.Member memberBackup = (com.tangosol.coherence.component.net.Member)iter.next();
                if (!(memberPrime.getMachineId() != memberBackup.getMachineId())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDistributionInProgress() {
        return this.__m_DistributionInProgress;
    }

    public boolean isDistributionSynchronized() {
        return this.__m_DistributionSynchronized;
    }

    public boolean isLocalStorageEnabled() {
        return this.__m_LocalStorageEnabled;
    }

    public boolean isLocalStorageEnabled(com.tangosol.coherence.component.net.Member member) {
        Boolean FEnabled = (Boolean)this.getServiceMemberSet().getMemberConfigMap(member.getId()).get("storage-enabled");
        return !(FEnabled != null) ? false : FEnabled;
    }

    public boolean isPrimaryOwner(int iBucket) {
        return this.getStorageAssignments()[iBucket][0] == this.getThisMember().getId();
    }

    public boolean isPrimaryOwner(Binary binKey) {
        return this.isPrimaryOwner(this.getKeyBucket(binKey));
    }

    public boolean isTransferVulnerable(int iBucket, int iStorage, com.tangosol.coherence.component.net.Member memberTo) {
        Component._assert(memberTo != null);
        if (this.getBackupCount() > 0) {
            int nMachineTo = memberTo.getMachineId();
            MemberSet setStorage = this.getBackupOwners(iBucket);
            switch (setStorage.size()) {
                case 0: {
                    return true;
                }
                case 1: {
                    if (iStorage > 0) {
                        com.tangosol.coherence.component.net.Member memberPrimary = this.getThisMember();
                        return memberPrimary.getMachineId() == nMachineTo;
                    }
                    com.tangosol.coherence.component.net.Member memberBackup = (com.tangosol.coherence.component.net.Member)setStorage.iterator().next();
                    return memberBackup.getMachineId() == nMachineTo;
                }
            }
            if (iStorage > 0) {
                setStorage.add(this.getThisMember());
                setStorage.remove(this.getStorageAssignments()[iBucket][iStorage]);
            }
            Iterator iter = setStorage.iterator();
            while (iter.hasNext()) {
                com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
                if (!(member.getMachineId() != nMachineTo)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isVulnerabilityAvoidable(MemberSet setStorage) {
        int cMembers = setStorage.size();
        int cBackups = this.getBackupCount();
        if (cMembers <= 1 ? true : cBackups == 0) {
            return false;
        }
        HashMap<Integer, Integer> mapCount = new HashMap<Integer, Integer>();
        Iterator iter = setStorage.iterator();
        while (iter.hasNext()) {
            com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
            Integer IMachine = Base.makeInteger((int)member.getMachineId());
            Integer ICount = (Integer)mapCount.get(IMachine);
            int nCount = ICount == null ? 1 : ICount + 1;
            if (nCount * 2 > cMembers) {
                return false;
            }
            mapCount.put(IMachine, Base.makeInteger((int)nCount));
        }
        return true;
    }

    protected void lockAll(DistributedCache$Storage storage) {
        if (this.getDaemonPool().isStarted()) {
            ThreadGate[] aGate = this.getPartitionControl();
            int iBucket = 0;
            int c = aGate.length;
            while (iBucket < c) {
                aGate[iBucket].enter(-1L);
                ++iBucket;
            }
            storage.getResourceControlMap().lock(ConcurrentMap.LOCK_ALL, -1L);
        }
    }

    protected boolean lockBucket(int iBucket, long lWait) {
        if (this.getDaemonPool().isStarted()) {
            ThreadGate gate = this.getPartitionControl()[iBucket];
            return gate.close(lWait);
        }
        return true;
    }

    protected boolean lockKey(Binary binKey, DistributedCache$Storage storage, boolean fEnter) {
        if (this.getDaemonPool().isStarted()) {
            int iBucket = this.getKeyBucket(binKey);
            ThreadGate gate = null;
            boolean fEntered = true;
            if (fEnter) {
                gate = this.enterBucket(iBucket);
                fEntered = gate != null;
            }
            if (!fEntered ? false : this.isPrimaryOwner(iBucket)) {
                storage.getResourceControlMap().lock((Object)binKey, -1L);
                return true;
            }
            if (gate != null) {
                gate.exit();
            }
            return false;
        }
        return this.isPrimaryOwner(binKey);
    }

    protected void lockSynthetic(DistributedCache$Storage storage) {
        if (this.getDaemonPool().isStarted()) {
            storage.getResourceControlMap().lock((Object)storage, -1L);
        }
    }

    protected void moveBucket(int iBucket, boolean fToBackup) {
        LongArray aStorage;
        LongArray longArray = aStorage = this.getStorageArray();
        synchronized (longArray) {
            LongArray.Iterator iterStore = aStorage.iterator();
            while (iterStore.hasNext()) {
                DistributedCache$Storage storage = (DistributedCache$Storage)iterStore.next();
                if (!storage.isValid()) continue;
                storage.moveBucket(iBucket, fToBackup);
            }
        }
    }

    public void onAggregateAllRequest(DistributedCache$AggregateAllRequest msgRequest) {
        DistributedCache$PartialValueResponse msgResponse = (DistributedCache$PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(msgRequest);
        Set setKeys = msgRequest.getKeySet();
        Throwable exception = this.ensureSupport(msgRequest, "InvocableMap");
        if (!(exception == null) ? false : this.isLocalStorageEnabled()) {
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            InvocableMap.EntryAggregator agent = msgRequest.getAggregator();
            HashSet<DistributedCache$Storage$BinaryEntry> setEntries = new HashSet<DistributedCache$Storage$BinaryEntry>();
            DistributedCache$PinningIterator pinner = this.createPinningIterator(setKeys);
            try {
                try {
                    while (pinner.hasNext()) {
                        Binary binKey = (Binary)pinner.next();
                        DistributedCache$Storage$BinaryEntry entry = storage.instantiateBinaryEntry(binKey, null, true);
                        entry.ensureDeferredRead();
                        setEntries.add(entry);
                    }
                    Object oResult = agent.aggregate(setEntries);
                    msgResponse.setResult(this.getBackingMapContext().getValueToInternalConverter().convert(oResult));
                    msgResponse.setRejectPartitions(pinner.getRejectedPartitions());
                }
                catch (Throwable e) {
                    exception = e;
                }
                Object var12_13 = null;
                this.unpinBuckets(pinner.getPinnedPartitions());
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                this.unpinBuckets(pinner.getPinnedPartitions());
                throw throwable;
            }
        }
        if (exception == null) {
            msgResponse.setRejectPartitions(this.calculatePartitionSet(setKeys));
        }
        if (exception != null) {
            msgResponse.setResult(this.tagException(exception));
        }
        this.post(msgResponse);
    }

    public void onAggregateFilterRequest(DistributedCache$AggregateFilterRequest msgRequest) {
        DistributedCache$PartialValueResponse msgResponse = (DistributedCache$PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(msgRequest);
        PartitionSet partMask = msgRequest.getRequestMask();
        Throwable exception = this.ensureSupport(msgRequest, "InvocableMap");
        if (!(exception == null) ? false : this.isLocalStorageEnabled()) {
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            Filter filter = msgRequest.getFilter();
            InvocableMap.EntryAggregator agent = msgRequest.getAggregator();
            PartitionSet partReject = this.pinOwnedBuckets(partMask);
            try {
                try {
                    Object[] aEntry = null;
                    try {
                        aEntry = storage.query(filter, DistributedCache$Storage.QUERY_AGGREGATE, partMask);
                    }
                    catch (ConcurrentModificationException cme) {
                        Component._trace(String.valueOf("Excessive concurrent updates while querying:\n") + Component.getStackTrace(cme) + "\nIgnoring exception and forcing a storage lock for " + storage.getCacheName(), 5);
                        this.lockAll(storage);
                        try {
                            aEntry = storage.query(filter, DistributedCache$Storage.QUERY_AGGREGATE, partMask);
                        }
                        finally {
                            Object var14_17 = null;
                            this.unlockAll(storage);
                        }
                    }
                    if (aEntry != null) {
                        int cEntries = aEntry.length;
                        int cMatch = 0;
                        int i = 0;
                        while (i < cEntries) {
                            DistributedCache$Storage$BinaryEntry entry = (DistributedCache$Storage$BinaryEntry)aEntry[i];
                            if (partMask.contains(this.getKeyBucket(entry.getBinaryKey()))) {
                                entry.enableKeyConversion();
                                if (cMatch < i) {
                                    aEntry[cMatch] = entry;
                                }
                                ++cMatch;
                            }
                            ++i;
                        }
                        if (cMatch < cEntries) {
                            Object[] ao = new Object[cMatch];
                            System.arraycopy(aEntry, 0, ao, 0, cMatch);
                            aEntry = ao;
                        }
                        Object oResult = agent.aggregate((Set)new ImmutableArrayList(aEntry));
                        msgResponse.setResult(this.getBackingMapContext().getValueToInternalConverter().convert(oResult));
                        msgResponse.setRejectPartitions(partReject);
                    }
                }
                catch (Throwable e) {
                    exception = e;
                }
                Object var12_15 = null;
                this.unpinBuckets(partMask);
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                this.unpinBuckets(partMask);
                throw throwable;
            }
        }
        if (exception == null) {
            msgResponse.setRejectPartitions(partMask);
        }
        if (exception != null) {
            msgResponse.setResult(this.tagException(exception));
        }
        this.post(msgResponse);
    }

    public void onBucketConfigUpdate(MapEvent event) {
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        int nMemberThis = this.getThisMember().getId();
        int cBackups = this.getBackupCount();
        String[] asAttr = this.getStorageAttribute();
        int iBucket = (Integer)event.getKey();
        XmlElement xmlBucket = (XmlElement)event.getNewValue();
        int[] aiBucketOwner = this.getStorageAssignments()[iBucket];
        boolean fPrimeOwner = this.isPrimaryOwner(iBucket);
        boolean fBackupOwner = this.isBackupOwner(iBucket);
        boolean fRepublish = false;
        int iStore = 0;
        while (iStore < 1 + cBackups) {
            int nMemberCur = aiBucketOwner[iStore];
            int nMemberNew = xmlBucket.getAttribute(asAttr[iStore]).getInt();
            if (fPrimeOwner) {
                if (nMemberCur != nMemberNew) {
                    Component._trace(String.valueOf("Obsolete partition info; restoring ") + (iStore == 0 ? "primary" : "backup") + " owner for partition " + iBucket + " from member " + nMemberNew + " to " + nMemberCur, 4);
                    fRepublish = true;
                    xmlBucket.addAttribute(asAttr[iStore]).setInt(nMemberCur);
                }
            } else {
                if (!(iStore == 0) ? false : nMemberNew == nMemberThis) {
                    Component._trace(String.valueOf("Rejecting obsolete ownership update for partition ") + iBucket + "[" + nMemberCur + "]", 4);
                    if (!(nMemberCur == 0)) break;
                    fRepublish = true;
                    xmlBucket.addAttribute(asAttr[0]).setInt(0);
                    break;
                }
                if (!(!(nMemberNew > 0) ? false : ((MemberSet)setMembers).getMember(nMemberNew) == null)) {
                    this.assignBucketOwner(iBucket, iStore, nMemberNew);
                    if (!(iStore == 0) ? false : this.isLocalStorageEnabled()) {
                        this.getTransitionalPartitions().remove(iBucket);
                        if (!(nMemberNew == 0) ? false : nMemberCur != 0) {
                            this.setDistributionNextMillis(Base.getSafeTimeMillis());
                        }
                    }
                }
            }
            ++iStore;
        }
        if (fRepublish) {
            this.putBucketConfig(iBucket, xmlBucket);
        }
        if (!fBackupOwner ? false : this.isBackupOwner(iBucket) ^ true) {
            this.releaseBucket(iBucket, false);
        }
    }

    public void onClearRequest(DistributedCache$ClearRequest msgRequest) {
        DistributedCache$PartialValueResponse msgResponse = (DistributedCache$PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(msgRequest);
        PartitionSet partMask = msgRequest.getRequestMask();
        boolean fRespond = true;
        if (this.isLocalStorageEnabled()) {
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            PartitionSet partReject = this.pinOwnedBuckets(partMask);
            int cBackups = this.getBackupCount();
            boolean fLock = this.getDaemonPool().isStarted();
            try {
                if (fLock) {
                    storage.getResourceControlMap().lock(ConcurrentMap.LOCK_ALL, -1L);
                }
                try {
                    Set setKeys = storage.clear(partMask);
                    if (!(setKeys.isEmpty() ^ true) ? false : cBackups > 0) {
                        HashSet setPolls;
                        HashSet hashSet = setPolls = new HashSet();
                        synchronized (hashSet) {
                            int iBackup = 1;
                            while (iBackup <= cBackups) {
                                this.sendBackupRemoveRequest(lCacheId, iBackup, setKeys.iterator(), msgResponse, setPolls);
                                ++iBackup;
                            }
                            fRespond = setPolls.isEmpty();
                        }
                    }
                    msgResponse.setRejectPartitions(partReject);
                }
                finally {
                    Object var12_13 = null;
                    if (fLock) {
                        storage.getResourceControlMap().unlock(ConcurrentMap.LOCK_ALL);
                    }
                }
            }
            catch (Throwable e) {
                msgResponse.setResult(this.tagException(e));
            }
            this.unpinBuckets(partMask);
        } else {
            msgResponse.setRejectPartitions(partMask);
        }
        if (fRespond) {
            this.post(msgResponse);
        }
    }

    public void onContainsAllRequest(DistributedCache$ContainsAllRequest msgRequest) {
        DistributedCache$PartialValueResponse msgResponse = (DistributedCache$PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(msgRequest);
        msgResponse.setResult(Boolean.TRUE);
        Set setKeys = msgRequest.getKeySet();
        if (this.isLocalStorageEnabled()) {
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            DistributedCache$PinningIterator pinner = this.createPinningIterator(setKeys);
            try {
                try {
                    Map mapPrime = storage.getResourceMap();
                    boolean fContains = true;
                    while (pinner.hasNext()) {
                        if (!(mapPrime.containsKey(pinner.next()) ^ true)) continue;
                        fContains = false;
                        break;
                    }
                    msgResponse.setResult(fContains);
                    msgResponse.setRejectPartitions(pinner.getRejectedPartitions());
                }
                catch (Throwable e) {
                    msgResponse.setResult(this.tagException(e));
                }
                Object var9_11 = null;
                this.unpinBuckets(pinner.getPinnedPartitions());
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                this.unpinBuckets(pinner.getPinnedPartitions());
                throw throwable;
            }
        }
        msgResponse.setRejectPartitions(this.calculatePartitionSet(setKeys));
        this.post(msgResponse);
    }

    public void onContainsKeyRequest(DistributedCache$ContainsKeyRequest msgRequest) {
        DistributedCache$Response msgResponse;
        block7: {
            msgResponse = (DistributedCache$Response)this.instantiateMessage("Response");
            msgResponse.respondTo(msgRequest);
            if (this.isLocalStorageEnabled() ^ true) {
                Component._assert(this.getServiceState() >= Service.SERVICE_STOPPING);
                msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
                this.post(msgResponse);
                return;
            }
            Binary binKey = msgRequest.getKey();
            DistributedCache$Storage storage = this.ensureStorage(msgRequest.getCacheId());
            try {
                if (this.lockKey(binKey, storage, true)) {
                    try {
                        boolean fContains = storage.getResourceMap().containsKey(binKey);
                        msgResponse.setValue(fContains);
                        break block7;
                    }
                    finally {
                        Object var6_8 = null;
                        this.unlockKey(binKey, storage, true);
                    }
                }
                msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
            }
            catch (Throwable e) {
                msgResponse.setResult(DistributedCacheResponse.RESULT_FAILURE);
                msgResponse.setValue(this.tagException(e));
            }
        }
        this.post(msgResponse);
    }

    public void onContainsValueRequest(DistributedCache$ContainsValueRequest msgRequest) {
        DistributedCache$PartialValueResponse msgResponse = (DistributedCache$PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(msgRequest);
        PartitionSet partMask = msgRequest.getRequestMask();
        if (this.isLocalStorageEnabled()) {
            long lCacheId = msgRequest.getCacheId();
            Binary binValue = msgRequest.getValue();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            PartitionSet partReject = this.pinOwnedBuckets(partMask);
            try {
                try {
                    boolean fContains = storage.getResourceMap().containsValue(binValue);
                    msgResponse.setResult(fContains);
                    msgResponse.setRejectPartitions(partReject);
                }
                catch (Throwable e) {
                    msgResponse.setResult(this.tagException(e));
                }
                Object var10_11 = null;
                this.unpinBuckets(partMask);
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.unpinBuckets(partMask);
                throw throwable;
            }
        }
        msgResponse.setRejectPartitions(partMask);
        this.post(msgResponse);
    }

    public void onDistributionRequest(DistributedCache$DistributionRequest msgRequest) {
        if (this.checkDeferredDistribution() ^ true) {
            int cOverload;
            int cBucketsThis = this.calculateThisOwnership(true);
            if (this.getServiceState() == Service.SERVICE_STOPPING) {
                cOverload = cBucketsThis;
            } else {
                MemberSet setStorage = this.getStorageMemberSet();
                Set setLeaving = this.getStorageLeavingMembers(setStorage);
                int cBucketsTotal = this.getPartitionCount();
                int cMembers = Math.max(1, setStorage.size() - setLeaving.size());
                int cFairShare = cBucketsTotal / cMembers;
                cOverload = cBucketsThis - cFairShare;
            }
            if (cOverload > 0) {
                int cBuckets = Math.min(msgRequest.getBucketsCount(), cOverload);
                msgRequest.setBucketsCount(cBuckets);
                if (this.transferPrimary(msgRequest)) {
                    return;
                }
            }
        }
        DistributedCache$Response msgResponse = (DistributedCache$Response)this.instantiateMessage("Response");
        msgResponse.respondTo(msgRequest);
        this.post(msgResponse);
    }

    public void onDistributionRequestCompleted() {
        this.setDistributionInProgress(false);
        this.setDistributionNextMillis(Base.getSafeTimeMillis() + (long)(this.getDistributionRepeatMillis() / this.getDistributionAggressiveness()));
        this.getTransferList().clear();
    }

    protected void onEnter() {
        try {
            new CoherenceApplicationEdition();
        }
        catch (Exception e) {
            this.setMsgCAE(e.getMessage());
        }
        this.getThisMemberConfigMap().put("storage-enabled", Boolean.FALSE);
        super.onEnter();
    }

    protected void onExit() {
        super.onExit();
        this.getServiceConfigMap().removeMapListener((MapListener)((DistributedCache$ConfigListener)this._findChild("ConfigListener")));
        this.releaseAllCache();
        this.releaseAllStorage();
    }

    public void onGetAllRequest(DistributedCache$GetAllRequest msgRequest) {
        DistributedCache$PartialMapResponse msgResponse = (DistributedCache$PartialMapResponse)this.instantiateMessage("PartialMapResponse");
        msgResponse.respondTo(msgRequest);
        Set setKeys = msgRequest.getKeySet();
        if (this.isLocalStorageEnabled()) {
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            int cKeys = setKeys.size();
            Binary[] abinKey = new Binary[cKeys];
            Binary[] abinVal = new Binary[cKeys];
            Map mapPrime = storage.getResourceMap();
            int cEntries = 0;
            DistributedCache$PinningIterator pinner = this.createPinningIterator(setKeys);
            while (pinner.hasNext()) {
                Binary binKey = (Binary)pinner.next();
                try {
                    Object var15_16;
                    block8: {
                        if (!this.lockKey(binKey, storage, false)) continue;
                        try {
                            Binary binValue = (Binary)mapPrime.get(binKey);
                            if (!(binValue != null)) break block8;
                            abinKey[cEntries] = binKey;
                            abinVal[cEntries] = binValue;
                            ++cEntries;
                        }
                        catch (Throwable binValue) {
                            var15_16 = null;
                            this.unlockKey(binKey, storage, false);
                            throw binValue;
                        }
                    }
                    var15_16 = null;
                    this.unlockKey(binKey, storage, false);
                }
                catch (Throwable e) {
                    msgResponse.setException(this.tagException(e));
                    cEntries = -1;
                    break;
                }
            }
            this.unpinBuckets(pinner.getPinnedPartitions());
            if (cEntries >= 0) {
                msgResponse.setSize(cEntries);
                msgResponse.setKey(abinKey);
                msgResponse.setValue(abinVal);
                msgResponse.setRejectPartitions(pinner.getRejectedPartitions());
            }
        } else {
            msgResponse.setRejectPartitions(this.calculatePartitionSet(setKeys));
        }
        this.post(msgResponse);
    }

    public void onGetRequest(DistributedCache$GetRequest msgRequest) {
        DistributedCache$Response msgResponse;
        block7: {
            msgResponse = (DistributedCache$Response)this.instantiateMessage("Response");
            msgResponse.respondTo(msgRequest);
            if (this.isLocalStorageEnabled() ^ true) {
                Component._assert(this.getServiceState() >= Service.SERVICE_STOPPING);
                msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
                this.post(msgResponse);
                return;
            }
            Binary binKey = msgRequest.getKey();
            DistributedCache$Storage storage = this.ensureStorage(msgRequest.getCacheId());
            try {
                if (this.lockKey(binKey, storage, true)) {
                    try {
                        msgResponse.setValue(storage.getResourceMap().get(binKey));
                        break block7;
                    }
                    finally {
                        Object var6_5 = null;
                        this.unlockKey(binKey, storage, true);
                    }
                }
                msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
            }
            catch (Throwable e) {
                msgResponse.setResult(DistributedCacheResponse.RESULT_FAILURE);
                msgResponse.setValue(this.tagException(e));
            }
        }
        this.post(msgResponse);
    }

    public void onIndexRequest(DistributedCache$IndexRequest msgRequest) {
        DistributedCache$Response msgResponse = (DistributedCache$Response)this.instantiateMessage("Response");
        msgResponse.respondTo(msgRequest);
        Throwable exception = msgRequest.getReadException();
        if (!(exception == null) ? false : this.isLocalStorageEnabled()) {
            ValueExtractor extractor = msgRequest.getExtractor();
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            this.lockAll(storage);
            try {
                try {
                    if (msgRequest.isAdd()) {
                        storage.addIndex(extractor, msgRequest.isOrdered(), msgRequest.getComparator());
                    } else {
                        storage.removeIndex(extractor);
                    }
                }
                catch (Throwable e) {
                    exception = e;
                }
                Object var9_9 = null;
                this.unlockAll(storage);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.unlockAll(storage);
                throw throwable;
            }
        }
        if (exception != null) {
            msgResponse.setResult(DistributedCacheResponse.RESULT_FAILURE);
            msgResponse.setValue(this.tagException(exception));
        }
        this.post(msgResponse);
    }

    public void onInvokeAllRequest(DistributedCache$InvokeAllRequest$InvokeJob job) {
        DistributedCache$PartialMapResponse msgResponse = (DistributedCache$PartialMapResponse)job.getResponse();
        Set setPending = job.getPendingJobs();
        int iBucket = job.getBucket();
        Component._assert(Thread.currentThread() != this.getThread());
        ThreadGate gate = this.enterBucket(iBucket);
        if (gate != null) {
            if (!this.isLocalStorageEnabled() ? false : this.isPrimaryOwner(iBucket)) {
                long lCacheId = job.getCacheId();
                Set setKeys = job.getKeySet();
                InvocableMap.EntryProcessor agent = job.getProcessor();
                int iEntry = job.getResultIndex();
                Binary[] abinKey = msgResponse.getKey();
                Binary[] abinVal = msgResponse.getValue();
                DistributedCache$Storage storage = this.ensureStorage(lCacheId);
                int cBackups = this.getBackupCount();
                HashMap<Binary, Binary> mapUpdate = null;
                HashSet<Binary> setRemove = null;
                Iterator iter = setKeys.iterator();
                while (iter.hasNext()) {
                    Binary binKey = (Binary)iter.next();
                    try {
                        Object var20_23;
                        block22: {
                            this.lockKey(binKey, storage, false);
                            try {
                                DistributedCache$Storage$BinaryEntry entry = storage.instantiateBinaryEntry(binKey, null, false);
                                DistributedCache$Storage$EntryStatus status = storage.invoke(entry, agent);
                                Component._assert(abinKey[iEntry] == null);
                                abinKey[iEntry] = binKey;
                                abinVal[iEntry] = status.getResult();
                                ++iEntry;
                                if (!(cBackups > 0)) break block22;
                                if (status.isValueUpdated()) {
                                    if (mapUpdate == null) {
                                        mapUpdate = new HashMap<Binary, Binary>();
                                    }
                                    mapUpdate.put(binKey, status.getNewValue());
                                    break block22;
                                }
                                if (!status.isValueRemoved()) break block22;
                                if (setRemove == null) {
                                    setRemove = new HashSet<Binary>();
                                }
                                setRemove.add(binKey);
                            }
                            catch (Throwable entry) {
                                var20_23 = null;
                                this.unlockKey(binKey, storage, false);
                                throw entry;
                            }
                        }
                        var20_23 = null;
                        this.unlockKey(binKey, storage, false);
                    }
                    catch (Throwable e) {
                        msgResponse.setException(this.tagException(e));
                        break;
                    }
                }
                if (!(cBackups > 0) ? false : (mapUpdate != null ? true : setRemove != null)) {
                    Set set = setPending;
                    synchronized (set) {
                        int iBackup = 1;
                        while (iBackup <= cBackups) {
                            if (mapUpdate != null) {
                                this.sendBackupUpdateRequest(lCacheId, iBackup, mapUpdate.entrySet().iterator(), msgResponse, setPending);
                            }
                            if (setRemove != null) {
                                this.sendBackupRemoveRequest(lCacheId, iBackup, setRemove.iterator(), msgResponse, setPending);
                            }
                            ++iBackup;
                        }
                    }
                }
            } else {
                msgResponse.rejectPartition(iBucket);
            }
            gate.exit();
        }
        Set set = setPending;
        synchronized (set) {
            boolean fExists = setPending.remove(job);
            Component._assert(fExists);
            if (setPending.isEmpty()) {
                this.post(msgResponse);
            }
        }
    }

    public void onInvokeAllRequest(DistributedCache$InvokeAllRequest msgRequest) {
        DistributedCache$PartialMapResponse msgResponse = (DistributedCache$PartialMapResponse)this.instantiateMessage("PartialMapResponse");
        msgResponse.respondTo(msgRequest);
        boolean fRespond = true;
        Set setKeys = msgRequest.getKeySet();
        Throwable exception = this.ensureSupport(msgRequest, "InvocableMap");
        if (!(exception == null) ? false : this.isLocalStorageEnabled()) {
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            InvocableMap.EntryProcessor agent = msgRequest.getProcessor();
            int cBackups = this.getBackupCount();
            Component._assert(this.getDaemonPool().isStarted() ^ true);
            int cKeys = setKeys.size();
            Binary[] abinKey = new Binary[cKeys];
            Binary[] abinVal = new Binary[cKeys];
            int cEntries = 0;
            HashMap<Binary, Binary> mapUpdate = null;
            HashSet<Binary> setRemove = null;
            DistributedCache$PinningIterator pinner = this.createPinningIterator(setKeys);
            while (pinner.hasNext()) {
                Binary binKey = (Binary)pinner.next();
                try {
                    DistributedCache$Storage$BinaryEntry entry = storage.instantiateBinaryEntry(binKey, null, false);
                    DistributedCache$Storage$EntryStatus status = storage.invoke(entry, agent);
                    abinKey[cEntries] = binKey;
                    abinVal[cEntries] = status.getResult();
                    ++cEntries;
                    if (!(cBackups > 0)) continue;
                    if (status.isValueUpdated()) {
                        if (mapUpdate == null) {
                            mapUpdate = new HashMap<Binary, Binary>();
                        }
                        mapUpdate.put(binKey, status.getNewValue());
                        continue;
                    }
                    if (!status.isValueRemoved()) continue;
                    if (setRemove == null) {
                        setRemove = new HashSet<Binary>();
                    }
                    setRemove.add(binKey);
                }
                catch (Throwable e) {
                    exception = e;
                    cEntries = -1;
                    break;
                }
            }
            this.unpinBuckets(pinner.getPinnedPartitions());
            if (cEntries >= 0) {
                msgResponse.setSize(cEntries);
                msgResponse.setKey(abinKey);
                msgResponse.setValue(abinVal);
                msgResponse.setRejectPartitions(pinner.getRejectedPartitions());
            }
            if (!(cBackups > 0) ? false : (mapUpdate != null ? true : setRemove != null)) {
                HashSet setPolls = new HashSet();
                int iBackup = 1;
                while (iBackup <= cBackups) {
                    if (mapUpdate != null) {
                        this.sendBackupUpdateRequest(lCacheId, iBackup, mapUpdate.entrySet().iterator(), msgResponse, setPolls);
                    }
                    if (setRemove != null) {
                        this.sendBackupRemoveRequest(lCacheId, iBackup, setRemove.iterator(), msgResponse, setPolls);
                    }
                    ++iBackup;
                }
                fRespond = setPolls.isEmpty();
            }
        } else if (exception == null) {
            msgResponse.setRejectPartitions(this.calculatePartitionSet(setKeys));
        }
        if (exception != null) {
            msgResponse.setException(this.tagException(exception));
        }
        if (fRespond) {
            this.post(msgResponse);
        }
    }

    public void onInvokeFilterRequest(DistributedCache$InvokeFilterRequest msgRequest) {
        DistributedCache$QueryResponse msgResponse = (DistributedCache$QueryResponse)this.instantiateMessage("QueryResponse");
        msgResponse.respondTo(msgRequest);
        PartitionSet partMask = msgRequest.getRequestMask();
        Throwable exception = this.ensureSupport(msgRequest, "InvocableMap");
        boolean fRespond = true;
        if (!(exception == null) ? false : this.isLocalStorageEnabled()) {
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            Filter filter = msgRequest.getFilter();
            InvocableMap.EntryProcessor agent = msgRequest.getProcessor();
            PartitionSet partReject = this.pinOwnedBuckets(partMask);
            Object[] aEntry = null;
            try {
                aEntry = storage.query(filter, DistributedCache$Storage.QUERY_INVOKE, partMask);
            }
            catch (ConcurrentModificationException cme) {
                Component._trace(String.valueOf("Excessive concurrent updates while querying:\n") + Component.getStackTrace(cme) + "\nIgnoring exception and forcing a storage lock for " + storage.getCacheName(), 5);
                this.lockAll(storage);
                try {
                    try {
                        aEntry = storage.query(filter, DistributedCache$Storage.QUERY_INVOKE, partMask);
                    }
                    catch (Throwable e) {
                        exception = e;
                    }
                    Object var15_19 = null;
                    this.unlockAll(storage);
                }
                catch (Throwable e) {
                    Object var15_20 = null;
                    this.unlockAll(storage);
                    throw e;
                }
            }
            catch (Throwable e) {
                exception = e;
            }
            if (aEntry != null) {
                int cBackups = this.getBackupCount();
                int cHits = aEntry.length;
                int cResults = 0;
                HashMap<Binary, Binary> mapUpdate = null;
                HashSet<Binary> setRemove = null;
                int i = 0;
                while (i < cHits) {
                    block31: {
                        DistributedCache$Storage$BinaryEntry entry = (DistributedCache$Storage$BinaryEntry)aEntry[i];
                        Binary binKey = entry.getBinaryKey();
                        try {
                            Object var22_33;
                            block32: {
                                if (this.lockKey(binKey, storage, false) ^ true) {
                                    Component._trace(String.valueOf("Failed to lock pinned key: ") + binKey + "; partition " + this.getKeyBucket(binKey) + "; pinned " + partMask, 1);
                                    break block31;
                                }
                                try {
                                    entry.enableKeyConversion();
                                    DistributedCache$Storage$EntryStatus status = storage.invoke(entry, agent);
                                    aEntry[cResults++] = new SimpleMapEntry((Object)binKey, (Object)status.getResult());
                                    if (!(cBackups > 0)) break block32;
                                    if (status.isValueUpdated()) {
                                        if (mapUpdate == null) {
                                            mapUpdate = new HashMap<Binary, Binary>();
                                        }
                                        mapUpdate.put(binKey, status.getNewValue());
                                        break block32;
                                    }
                                    if (!status.isValueRemoved()) break block32;
                                    if (setRemove == null) {
                                        setRemove = new HashSet<Binary>();
                                    }
                                    setRemove.add(binKey);
                                }
                                catch (Throwable status) {
                                    var22_33 = null;
                                    this.unlockKey(binKey, storage, false);
                                    throw status;
                                }
                            }
                            var22_33 = null;
                            this.unlockKey(binKey, storage, false);
                        }
                        catch (Throwable e) {
                            exception = e;
                            aEntry = null;
                            break;
                        }
                    }
                    ++i;
                }
                this.unpinBuckets(partMask);
                if (aEntry != null) {
                    if (cResults < cHits) {
                        Object[] ao = new Object[cResults];
                        System.arraycopy(aEntry, 0, ao, 0, cResults);
                        aEntry = ao;
                    }
                    msgResponse.setResult(aEntry);
                }
                if (!(cBackups > 0) ? false : (mapUpdate != null ? true : setRemove != null)) {
                    HashSet setPolls;
                    HashSet hashSet = setPolls = new HashSet();
                    synchronized (hashSet) {
                        int iBackup = 1;
                        while (iBackup <= cBackups) {
                            if (mapUpdate != null) {
                                this.sendBackupUpdateRequest(lCacheId, iBackup, mapUpdate.entrySet().iterator(), msgResponse, setPolls);
                            }
                            if (setRemove != null) {
                                this.sendBackupRemoveRequest(lCacheId, iBackup, setRemove.iterator(), msgResponse, setPolls);
                            }
                            ++iBackup;
                        }
                        fRespond = setPolls.isEmpty();
                    }
                }
                msgResponse.setRejectPartitions(partReject);
                msgResponse.setResult(aEntry);
            }
        } else if (exception == null) {
            msgResponse.setRejectPartitions(partMask);
        }
        if (exception != null) {
            msgResponse.setException(this.tagException(exception));
        }
        if (fRespond) {
            this.post(msgResponse);
        }
    }

    public void onInvokeRequest(DistributedCache$InvokeRequest msgRequest) {
        Throwable exception;
        DistributedCache$Response msgResponse;
        block15: {
            msgResponse = (DistributedCache$Response)this.instantiateMessage("Response");
            msgResponse.respondTo(msgRequest);
            if (this.isLocalStorageEnabled() ^ true) {
                Component._assert(this.getServiceState() >= Service.SERVICE_STOPPING);
                msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
                this.post(msgResponse);
                return;
            }
            IdempotentContext ctx = (IdempotentContext)msgRequest.getRequestContext();
            this.unregisterRequestInfoRange(-1L, ctx.getOldestPendingSUID());
            long lSUID = ctx.getRequestSUID();
            Object oResult = this.getPendingRequestInfo().get(lSUID);
            if (oResult instanceof Binary) {
                msgResponse.setValue(oResult);
                this.post(msgResponse);
                return;
            }
            exception = this.ensureSupport(null, "InvocableMap");
            if (exception == null) {
                exception = msgRequest.getException();
            }
            if (exception == null) {
                Binary binKey = msgRequest.getKey();
                InvocableMap.EntryProcessor agent = msgRequest.getProcessor();
                long lCacheId = msgRequest.getCacheId();
                DistributedCache$Storage storage = this.ensureStorage(lCacheId);
                try {
                    if (this.lockKey(binKey, storage, true)) {
                        try {
                            DistributedCache$Storage$BinaryEntry entry = storage.instantiateBinaryEntry(binKey, null, false);
                            DistributedCache$Storage$EntryStatus status = storage.invoke(entry, agent);
                            oResult = status.getResult();
                            msgResponse.setValue(oResult);
                            this.registerRequestInfo(lSUID, oResult);
                            if (this.getBackupCount() > 0) {
                                boolean fDeferResponse = false;
                                msgResponse.setRequestContext(this.createSimpleResponseContext(ctx, (Binary)oResult));
                                if (status.isValueUpdated()) {
                                    fDeferResponse = this.sendBackupUpdateRequest(lCacheId, binKey, status.getNewValue(), msgResponse);
                                } else if (status.isValueRemoved()) {
                                    fDeferResponse = this.sendBackupRemoveRequest(lCacheId, binKey, msgResponse);
                                }
                                if (fDeferResponse) {
                                    Object var16_16 = null;
                                    this.unlockKey(binKey, storage, true);
                                    return;
                                }
                            }
                            Object var16_17 = null;
                            this.unlockKey(binKey, storage, true);
                            break block15;
                        }
                        catch (Throwable entry) {
                            Object var16_18 = null;
                            this.unlockKey(binKey, storage, true);
                            throw entry;
                        }
                    }
                    msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
                }
                catch (Throwable e) {
                    exception = e;
                }
            }
        }
        if (exception != null) {
            msgResponse.setResult(DistributedCacheResponse.RESULT_FAILURE);
            msgResponse.setValue(this.tagException(exception));
        }
        this.post(msgResponse);
    }

    public void onKeyIteratorRequest(DistributedCache$KeyIteratorRequest msgRequest) {
        DistributedCache$QueryResponse msgResponse = (DistributedCache$QueryResponse)this.instantiateMessage("QueryResponse");
        msgResponse.respondTo(msgRequest);
        msgResponse.setKeysOnly(true);
        PartitionSet partMask = msgRequest.getRequestMask();
        if (this.isLocalStorageEnabled()) {
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            PartitionSet partReject = this.pinOwnedBuckets(partMask);
            try {
                try {
                    Object[] abinKey = storage.query(null, DistributedCache$Storage.QUERY_KEYS, partMask);
                    msgResponse.setResult(abinKey);
                    msgResponse.setRejectPartitions(partReject);
                }
                catch (Throwable e) {
                    msgResponse.setException(this.tagException(e));
                }
                Object var9_10 = null;
                this.unpinBuckets(partMask);
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.unpinBuckets(partMask);
                throw throwable;
            }
        }
        msgResponse.setResult(new Binary[0]);
        msgResponse.setRejectPartitions(partMask);
        this.post(msgResponse);
    }

    public void onKeyListenerRequest(DistributedCache$KeyListenerRequest msgRequest) {
        DistributedCache$Response msgResponse;
        block16: {
            msgResponse = (DistributedCache$Response)this.instantiateMessage("Response");
            msgResponse.respondTo(msgRequest);
            if (this.isLocalStorageEnabled() ^ true) {
                Component._assert(this.getServiceState() >= Service.SERVICE_STOPPING);
                msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
                this.post(msgResponse);
                return;
            }
            Binary binKey = msgRequest.getKey();
            boolean fAdd = msgRequest.isAdd();
            boolean fLite = msgRequest.isLite();
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            if (msgRequest.isPrimary()) {
                try {
                    if (this.lockKey(binKey, storage, true)) {
                        try {
                            MemberSet setBackup;
                            com.tangosol.coherence.component.net.Member member = msgRequest.getFromMember();
                            if (fAdd) {
                                storage.addKeyListener(member, binKey, fLite, true);
                            } else {
                                storage.removeKeyListener(member, binKey, true);
                            }
                            if (this.getBackupCount() > 0 && (setBackup = this.getBackupOwners(binKey)).isEmpty() ^ true) {
                                DistributedCache$KeyListenerRequest msg = (DistributedCache$KeyListenerRequest)this.instantiateMessage("KeyListenerRequest");
                                msg.setCacheId(lCacheId);
                                msg.setKey(binKey);
                                msg.setAdd(fAdd);
                                msg.setLite(fLite);
                                msg.setMemberId(member.getId());
                                msg.setPrimary(false);
                                msg.setPrimaryResponse(msgResponse);
                                msg.setToMemberSet(setBackup);
                                this.post(msg);
                                Object var12_14 = null;
                                this.unlockKey(binKey, storage, true);
                                return;
                            }
                            Object var12_15 = null;
                            this.unlockKey(binKey, storage, true);
                            break block16;
                        }
                        catch (Throwable member) {
                            Object var12_16 = null;
                            this.unlockKey(binKey, storage, true);
                            throw member;
                        }
                    }
                    msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
                }
                catch (Throwable e) {
                    msgResponse.setResult(DistributedCacheResponse.RESULT_FAILURE);
                    msgResponse.setValue(this.tagException(e));
                }
            } else if (this.isBackupOwner(binKey)) {
                com.tangosol.coherence.component.net.Member member = this.getServiceMemberSet().getMember(msgRequest.getMemberId());
                if (member != null) {
                    if (fAdd) {
                        storage.addKeyListener(member, binKey, fLite, false);
                    } else {
                        storage.removeKeyListener(member, binKey, false);
                    }
                }
            } else {
                msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
            }
        }
        this.post(msgResponse);
    }

    public void onListenerRequest(DistributedCache$ListenerRequest msgRequest) {
        DistributedCache$Response msgResponse = (DistributedCache$Response)this.instantiateMessage("Response");
        msgResponse.respondTo(msgRequest);
        IOException exception = msgRequest.getReadException();
        if (!(exception == null) ? false : this.isLocalStorageEnabled()) {
            long lCacheId = msgRequest.getCacheId();
            Filter filter = msgRequest.getFilter();
            long lFilterId = msgRequest.getFilterId();
            com.tangosol.coherence.component.net.Member member = msgRequest.getFromMember();
            if (msgRequest.isAdd()) {
                this.ensureStorage(lCacheId).addListener(member, filter, lFilterId, msgRequest.isLite());
            } else {
                DistributedCache$Storage storage = this.getStorage(lCacheId);
                if (storage != null) {
                    storage.removeListener(member, filter, lFilterId);
                }
            }
        }
        if (exception != null) {
            msgResponse.setResult(DistributedCacheResponse.RESULT_FAILURE);
            msgResponse.setValue(this.tagException(exception));
        }
        this.post(msgResponse);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onLockRequest(DistributedCache$LockRequest msgRequest) {
        DistributedCache$Response msgResponse;
        block16: {
            msgResponse = (DistributedCache$Response)this.instantiateMessage("Response");
            msgResponse.respondTo(msgRequest);
            if (this.isLocalStorageEnabled() ^ true) {
                Component._assert(this.getServiceState() >= Service.SERVICE_STOPPING);
                msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
                this.post(msgResponse);
                return;
            }
            Binary binKey = msgRequest.getKey();
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            if (msgRequest.isPrimary()) {
                try {
                    if (this.lockKey(binKey, storage, true)) {
                        block14: {
                            block15: {
                                Lease lease = msgRequest.toLease();
                                try {
                                    long lVariance;
                                    if (storage.lock(lease)) {
                                        MemberSet setBackup;
                                        msgResponse.setValue(Boolean.TRUE);
                                        if (this.getBackupCount() > 0 && (setBackup = this.getBackupOwners(binKey)).isEmpty() ^ true) {
                                            DistributedCache$LockRequest msg = (DistributedCache$LockRequest)this.instantiateMessage("LockRequest");
                                            msg.setCacheId(lCacheId);
                                            msg.fromLease(lease);
                                            msg.setPrimary(false);
                                            msg.setPrimaryResponse(msgResponse);
                                            msg.setToMemberSet(setBackup);
                                            this.post(msg);
                                            Object var14_12 = null;
                                            this.unlockKey(binKey, storage, true);
                                            return;
                                        }
                                        break block14;
                                    }
                                    long lWaitTimeout = msgRequest.getLeaseWaitTimeout();
                                    long lTime = this.getClusterTime();
                                    if (lTime + (lVariance = (long)this.getClusterTimeVariance()) < lWaitTimeout) {
                                        storage.getPendingLockRequest().add(msgRequest);
                                        if (lWaitTimeout != Long.MAX_VALUE) {
                                            this.scheduleLockEvaluation(lWaitTimeout - lTime);
                                        }
                                        break block15;
                                    }
                                    msgResponse.setValue(Boolean.FALSE);
                                    break block14;
                                }
                                catch (Throwable throwable) {
                                    Object var14_15 = null;
                                    this.unlockKey(binKey, storage, true);
                                    throw throwable;
                                }
                            }
                            Object var14_13 = null;
                            this.unlockKey(binKey, storage, true);
                            return;
                        }
                        Object var14_14 = null;
                        this.unlockKey(binKey, storage, true);
                        break block16;
                    }
                    msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
                }
                catch (Throwable e) {
                    msgResponse.setResult(DistributedCacheResponse.RESULT_FAILURE);
                    msgResponse.setValue(this.tagException(e));
                }
            } else if (this.isBackupOwner(binKey)) {
                storage.getBackupLeaseMap().put(binKey, msgRequest.toLease());
            } else {
                msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
            }
        }
        this.post(msgResponse);
    }

    public void onMapEvent(DistributedCache$MapEvent msgEvent) {
        DistributedCache$BinaryMap mapBinary = null;
        String sCacheName = msgEvent.getCacheName();
        if (sCacheName != null) {
            mapBinary = (DistributedCache$BinaryMap)this.getReferencesBinaryMap().get(sCacheName);
        } else {
            long lCacheId = msgEvent.getCacheId();
            try {
                Iterator iter = this.getReferencesBinaryMap().values().iterator();
                while (iter.hasNext()) {
                    mapBinary = (DistributedCache$BinaryMap)iter.next();
                    if (!(mapBinary.getCacheId() == lCacheId)) {
                        continue;
                    }
                    break;
                }
            }
            catch (ConcurrentModificationException e) {
                // empty catch block
            }
        }
        if (mapBinary != null) {
            mapBinary.dispatch(msgEvent);
        }
    }

    protected void onNotify() {
        super.onNotify();
        if (this.isExiting() ^ true) {
            long lTime = Base.getSafeTimeMillis();
            if (lTime >= this.getDistributionNextMillis()) {
                if (this.isAcceptingOthers()) {
                    this.checkDistribution();
                } else if (this.isRunning()) {
                    if (this.isAcceptingClients()) {
                        this.ensureKnownStorage();
                    } else {
                        this.validateBucketConfig();
                    }
                }
            }
            if (lTime >= this.getLockingNextMillis()) {
                this.evaluateLockRequests();
            }
        }
    }

    public void onNotifyServiceJoined(com.tangosol.coherence.component.net.Member member) {
        block17: {
            Iterator iter;
            if (!this.isAcceptingClients()) break block17;
            if (this.isLocalStorageEnabled()) {
                this.setDistributionNextMillis(Base.getSafeTimeMillis() + (long)this.getDistributionRepeatMillis());
            }
            Object[] aMap = this.getReferencesBinaryMap().values().toArray();
            int i = 0;
            int c = aMap.length;
            while (i < c) {
                block15: {
                    MapListenerSupport support;
                    DistributedCache$BinaryMap mapBinary = (DistributedCache$BinaryMap)aMap[i];
                    MapListenerSupport mapListenerSupport = support = mapBinary.getListenerSupport();
                    synchronized (mapListenerSupport) {
                        if (support.isEmpty()) {
                            iter = null;
                            break block15;
                        }
                        iter = support.getFilterSet().iterator();
                        while (iter.hasNext()) {
                            Filter filter = (Filter)iter.next();
                            DistributedCache$ListenerRequest msg = (DistributedCache$ListenerRequest)this.instantiateMessage("ListenerRequest");
                            msg.setCacheId(mapBinary.getCacheId());
                            msg.setAdd(true);
                            msg.setFilter(filter);
                            msg.setFilterId(mapBinary.getFilterId(filter));
                            msg.setLite(support.containsStandardListeners(filter) ^ true);
                            msg.addToMember(member);
                            this.post(msg);
                        }
                    }
                }
                ++i;
            }
            if (this.getThisMember() == this.getStorageOldestMember()) {
                LongArray aStorage;
                LongArray longArray = aStorage = this.getStorageArray();
                synchronized (longArray) {
                    LongArray.Iterator iterStore = aStorage.iterator();
                    while (iterStore.hasNext()) {
                        Object var8_11;
                        DistributedCache$Storage storage;
                        block16: {
                            storage = (DistributedCache$Storage)iterStore.next();
                            this.lockSynthetic(storage);
                            try {
                                Map mapIndex = storage.getIndexMap();
                                if (!(!(mapIndex != null) ? false : mapIndex.isEmpty() ^ true)) break block16;
                                iter = mapIndex.entrySet().iterator();
                                while (iter.hasNext()) {
                                    Map.Entry entry = (Map.Entry)iter.next();
                                    ValueExtractor extractor = (ValueExtractor)entry.getKey();
                                    DistributedCache$Storage$MapIndex index = (DistributedCache$Storage$MapIndex)entry.getValue();
                                    DistributedCache$IndexRequest msg = (DistributedCache$IndexRequest)this.instantiateMessage("IndexRequest");
                                    msg.setCacheId(storage.getCacheId());
                                    msg.setAdd(true);
                                    msg.setExtractor(extractor);
                                    msg.setOrdered(index.isOrdered());
                                    msg.setComparator(index.getComparator());
                                    msg.addToMember(member);
                                    this.post(msg);
                                }
                            }
                            catch (Throwable throwable) {
                                var8_11 = null;
                                this.unlockSynthetic(storage);
                                throw throwable;
                            }
                        }
                        var8_11 = null;
                        this.unlockSynthetic(storage);
                    }
                }
            }
        }
    }

    public void onNotifyServiceLeaving(com.tangosol.coherence.component.net.Member member) {
        if (!this.isAcceptingClients() ? false : (this.getServiceState() == Service.SERVICE_STOPPING ? true : this.isLocalStorageEnabled())) {
            this.setDistributionNextMillis(0L);
        }
    }

    public void onNotifyServiceLeft(com.tangosol.coherence.component.net.Member member) {
        if (!this.isAcceptingClients() ? false : this.getServiceState() != Service.SERVICE_STOPPING) {
            boolean fLocalStorage = this.isLocalStorageEnabled();
            MemberSet setStorage = this.getStorageMemberSet();
            if (setStorage.isEmpty()) {
                this.resetBucketConfig();
            } else {
                this.validateBucketAssignments(setStorage);
                if (fLocalStorage) {
                    this.setDistributionNextMillis(0L);
                }
            }
            if (fLocalStorage) {
                this.validateStorages(member);
            }
        }
        int nMember = member.getId();
        this.unregisterRequestInfoRange(Service.getBaseSUID(nMember), Service.getBaseSUID(nMember + 1));
    }

    public void onNotifyShutdown() {
        this.setServiceState(Service.SERVICE_STOPPING);
        if (this.isLocalStorageEnabled() ^ true ? true : this.getStorageOtherMemberSet(null).isEmpty()) {
            this.stop();
        } else {
            this.setLocalStorageEnabled(false);
        }
    }

    public void onOwnershipRequest(DistributedCache$OwnershipRequest msgRequest) {
        this.publishTransitionalOwnership();
        DistributedCache$Response msgResponse = (DistributedCache$Response)this.instantiateMessage("Response");
        msgResponse.respondTo(msgRequest);
        if (!this.getStorageLeavingMembers(null).isEmpty() ? false : this.getTransferCount() == 0) {
            if (msgRequest.isRestore()) {
                if (this.getBackupCount() > 0) {
                    this.restoreOrphans();
                }
            } else {
                int[][] aaiBucketOwnerThat = msgRequest.getRequestAssignments();
                if (aaiBucketOwnerThat != null) {
                    this.calculateOwnershipConflicts(msgRequest.getFromMember().getId(), aaiBucketOwnerThat, msgRequest.getRequestCount(), null);
                }
            }
            msgResponse.setValue(this.getStorageAssignments());
        } else {
            Component._trace("Unable to determine the ownership", 4);
            msgResponse.setValue(null);
        }
        this.post(msgResponse);
    }

    public void onOwnershipRequestCompleted(int cConflicts, boolean fRestore) {
        int cDelay = -1;
        if (cConflicts == 0) {
            if (this.getServiceState() == Service.SERVICE_STARTED) {
                Component._assert(this.getThisMember() == this.getStorageOldestMember());
                if (fRestore) {
                    this.assignOrphans();
                    cDelay = 0;
                } else {
                    DistributedCache$OwnershipRequest msg = (DistributedCache$OwnershipRequest)this.instantiateMessage("OwnershipRequest");
                    msg.setToMemberSet(this.getStorageMemberSet());
                    msg.setRestore(true);
                    this.post(msg);
                }
            }
        } else {
            cDelay = 500;
        }
        if (cDelay >= 0) {
            this.setOwnershipInProgress(cConflicts <= 0 ? 0 : -this.getOwnershipInProgress());
            this.setDistributionNextMillis(Base.getSafeTimeMillis() + (long)cDelay);
        }
    }

    public void onPutAllRequest(DistributedCache$PutAllRequest$PutJob job) {
        DistributedCache$PartialValueResponse msgResponse = (DistributedCache$PartialValueResponse)job.getResponse();
        Set setPending = job.getPendingJobs();
        int iBucket = job.getBucket();
        Component._assert(Thread.currentThread() != this.getThread());
        ThreadGate gate = this.enterBucket(iBucket);
        if (gate != null) {
            if (!this.isLocalStorageEnabled() ? false : this.isPrimaryOwner(iBucket)) {
                long lCacheId = job.getCacheId();
                DistributedCache$Storage storage = this.ensureStorage(lCacheId);
                Map map = job.getMap();
                int cBackups = this.getBackupCount();
                boolean fEvicted = false;
                Iterator iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    Binary binKey = (Binary)entry.getKey();
                    try {
                        this.lockKey(binKey, storage, false);
                        try {
                            DistributedCache$Storage$EntryStatus status = storage.put(binKey, (Binary)entry.getValue(), 0L, true);
                            Binary binValue = status.getNewValue();
                            if (binValue == null) {
                                if (status.getOldValue() == null) {
                                    iter.remove();
                                } else {
                                    fEvicted = true;
                                }
                            }
                            entry.setValue(binValue);
                        }
                        finally {
                            Object var16_19 = null;
                            this.unlockKey(binKey, storage, false);
                        }
                    }
                    catch (Throwable e) {
                        msgResponse.setResult(this.tagException(e));
                        if (!(cBackups > 0)) break;
                        this.clearIterator(iter);
                        break;
                    }
                }
                if (!(cBackups > 0) ? false : map.isEmpty() ^ true) {
                    Set set = setPending;
                    synchronized (set) {
                        Iterator iter2;
                        int iBackup = 1;
                        while (iBackup <= cBackups) {
                            iter2 = map.entrySet().iterator();
                            if (fEvicted) {
                                iter2 = this.createWrapperIterator(iter2, true);
                            }
                            this.sendBackupUpdateRequest(lCacheId, iBackup, iter2, msgResponse, setPending);
                            ++iBackup;
                        }
                        if (fEvicted) {
                            iBackup = 1;
                            while (iBackup <= cBackups) {
                                iter2 = this.createWrapperIterator(map.entrySet().iterator(), false);
                                this.sendBackupRemoveRequest(lCacheId, iBackup, iter2, msgResponse, setPending);
                                ++iBackup;
                            }
                        }
                    }
                }
            } else {
                msgResponse.rejectPartition(iBucket);
            }
            gate.exit();
        }
        Set set = setPending;
        synchronized (set) {
            boolean fExists = setPending.remove(job);
            Component._assert(fExists);
            if (setPending.isEmpty()) {
                this.post(msgResponse);
            }
        }
    }

    public void onPutAllRequest(DistributedCache$PutAllRequest msgRequest) {
        DistributedCache$PartialValueResponse msgResponse = (DistributedCache$PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(msgRequest);
        boolean fRespond = true;
        Map map = msgRequest.getMap();
        if (this.isLocalStorageEnabled()) {
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            int cBackups = this.getBackupCount();
            if (msgRequest.getStore() == 0) {
                Component._assert(this.getDaemonPool().isStarted() ^ true);
                DistributedCache$PinningIterator pinner = this.createPinningIterator(map.entrySet());
                boolean fEvicted = false;
                while (pinner.hasNext()) {
                    Map.Entry entry = (Map.Entry)pinner.next();
                    try {
                        DistributedCache$Storage$EntryStatus status = storage.put((Binary)entry.getKey(), (Binary)entry.getValue(), 0L, true);
                        Binary binValue = status.getNewValue();
                        if (binValue == null) {
                            if (status.getOldValue() == null) {
                                pinner.remove();
                            } else {
                                fEvicted = true;
                            }
                        }
                        entry.setValue(binValue);
                    }
                    catch (Throwable e) {
                        msgResponse.setResult(this.tagException(e));
                        if (!(cBackups > 0)) break;
                        this.clearIterator(pinner);
                        break;
                    }
                }
                this.unpinBuckets(pinner.getPinnedPartitions());
                msgResponse.setRejectPartitions(pinner.getRejectedPartitions());
                if (!(cBackups > 0) ? false : pinner.isEmpty() ^ true) {
                    Iterator iter;
                    HashSet setPolls = new HashSet();
                    int iBackup = 1;
                    while (iBackup <= cBackups) {
                        pinner.reset();
                        iter = fEvicted ? this.createWrapperIterator(pinner, true) : pinner;
                        this.sendBackupUpdateRequest(lCacheId, iBackup, iter, msgResponse, setPolls);
                        ++iBackup;
                    }
                    if (fEvicted) {
                        iBackup = 1;
                        while (iBackup <= cBackups) {
                            pinner.reset();
                            iter = this.createWrapperIterator(pinner, false);
                            this.sendBackupRemoveRequest(lCacheId, iBackup, iter, msgResponse, setPolls);
                            ++iBackup;
                        }
                    }
                    fRespond = setPolls.isEmpty();
                }
            } else {
                PartitionSet partReject = this.retainBackupPartitions(map.keySet());
                storage.getBackupMap().putAll(map);
                msgResponse.setRejectPartitions(partReject);
            }
        } else {
            msgResponse.setRejectPartitions(this.calculatePartitionSet(map.keySet()));
        }
        if (fRespond) {
            this.post(msgResponse);
        }
    }

    public void onPutRequest(DistributedCache$PutRequest msgRequest) {
        DistributedCache$Response msgResponse;
        block17: {
            msgResponse = (DistributedCache$Response)this.instantiateMessage("Response");
            msgResponse.respondTo(msgRequest);
            if (this.isLocalStorageEnabled() ^ true) {
                Component._assert(this.getServiceState() >= Service.SERVICE_STOPPING);
                msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
                this.post(msgResponse);
                return;
            }
            Binary binKey = msgRequest.getKey();
            Binary binValue = msgRequest.getValue();
            long lCacheId = msgRequest.getCacheId();
            boolean fReturn = msgRequest.isReturnRequired();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            if (msgRequest.isPrimary()) {
                try {
                    if (this.lockKey(binKey, storage, true)) {
                        try {
                            DistributedCache$Storage$EntryStatus status = storage.put(binKey, binValue, msgRequest.getExpiryDelay(), fReturn ^ true);
                            if (fReturn) {
                                msgResponse.setValue(status.getOldValue());
                            }
                            if (this.getBackupCount() > 0) {
                                binValue = status.getNewValue();
                                boolean fDeferResponse = binValue == null ? (status.getOldValue() == null ? false : this.sendBackupRemoveRequest(lCacheId, binKey, msgResponse)) : this.sendBackupUpdateRequest(lCacheId, binKey, binValue, msgResponse);
                                if (fDeferResponse) {
                                    Object var11_14 = null;
                                    this.unlockKey(binKey, storage, true);
                                    return;
                                }
                            }
                            Object var11_15 = null;
                            this.unlockKey(binKey, storage, true);
                            break block17;
                        }
                        catch (Throwable status) {
                            Object var11_16 = null;
                            this.unlockKey(binKey, storage, true);
                            throw status;
                        }
                    }
                    msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
                }
                catch (Throwable e) {
                    msgResponse.setResult(DistributedCacheResponse.RESULT_FAILURE);
                    msgResponse.setValue(this.tagException(e));
                }
            } else if (this.isBackupOwner(binKey)) {
                Map mapBackup = storage.getBackupMap();
                if (ExternalizableHelper.getDecoration((Binary)binValue, (int)ExternalizableHelper.DECO_VALUE).equals((Object)DistributedCache$Storage.BINARY_EXISTS)) {
                    Binary[] abinDecor = ExternalizableHelper.getDecorations((Binary)binValue);
                    binValue = (Binary)mapBackup.get(binKey);
                    if (binValue == null) {
                        Component._trace(String.valueOf("Backup is missing an entry for key=") + binKey, 1);
                        binValue = ExternalizableHelper.toBinary(null);
                    }
                    Binary binary = binValue = abinDecor.length == 0 ? ExternalizableHelper.getUndecorated((Binary)binValue) : ExternalizableHelper.decorate((Binary)binValue, (Binary[])abinDecor);
                }
                if (storage.isPreferPutAllBackup()) {
                    mapBackup.putAll(Collections.singletonMap(binKey, binValue));
                } else {
                    mapBackup.put(binKey, binValue);
                }
                this.registerResponse(msgRequest.getRequestContext());
            } else {
                msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
            }
        }
        this.post(msgResponse);
    }

    public void onQueryRequest(DistributedCache$QueryRequest msgRequest) {
        DistributedCache$QueryResponse msgResponse = (DistributedCache$QueryResponse)this.instantiateMessage("QueryResponse");
        msgResponse.respondTo(msgRequest);
        PartitionSet partMask = msgRequest.getRequestMask();
        Throwable exception = this.ensureSupport(msgRequest, "QUeryMap");
        if (!(exception == null) ? false : this.isLocalStorageEnabled()) {
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            Filter filter = msgRequest.getFilter();
            boolean fKeySet = msgRequest.isKeysOnly();
            PartitionSet partReject = this.pinOwnedBuckets(partMask);
            try {
                try {
                    Object oCookie;
                    Object[] aoResult;
                    try {
                        aoResult = storage.query(filter, fKeySet ? DistributedCache$Storage.QUERY_KEYS : DistributedCache$Storage.QUERY_ENTRIES, partMask);
                    }
                    catch (ConcurrentModificationException e) {
                        Component._trace(String.valueOf("Excessive concurrent updates while querying:\n") + Component.getStackTrace(e) + "\nIgnoring exception and forcing a storage lock for " + storage.getCacheName(), 5);
                        this.lockAll(storage);
                        try {
                            aoResult = storage.query(filter, fKeySet ? DistributedCache$Storage.QUERY_KEYS : DistributedCache$Storage.QUERY_ENTRIES, partMask);
                        }
                        finally {
                            Object var14_18 = null;
                            this.unlockAll(storage);
                        }
                    }
                    if (fKeySet ^ true) {
                        int i = 0;
                        int c = aoResult.length;
                        while (i < c) {
                            ((DistributedCache$Storage$BinaryEntry)aoResult[i]).disableConversion();
                            ++i;
                        }
                    }
                    msgResponse.setKeysOnly(fKeySet);
                    msgResponse.setResult(aoResult);
                    msgResponse.setRejectPartitions(partReject);
                    if (filter instanceof LimitFilter && (oCookie = ((LimitFilter)filter).getCookie()) instanceof Integer) {
                        msgResponse.setAvailable((Integer)oCookie);
                    }
                }
                catch (Throwable e) {
                    exception = e;
                }
                Object var12_16 = null;
                this.unpinBuckets(partMask);
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                this.unpinBuckets(partMask);
                throw throwable;
            }
        }
        if (exception == null) {
            msgResponse.setRejectPartitions(partMask);
        }
        if (exception != null) {
            msgResponse.setException(this.tagException(exception));
        }
        this.post(msgResponse);
    }

    public void onRemoveAllRequest(DistributedCache$RemoveAllRequest$RemoveJob job) {
        DistributedCache$PartialValueResponse msgResponse = (DistributedCache$PartialValueResponse)job.getResponse();
        Set setPending = job.getPendingJobs();
        int iBucket = job.getBucket();
        Component._assert(Thread.currentThread() != this.getThread());
        ThreadGate gate = this.enterBucket(iBucket);
        if (gate != null) {
            if (!this.isLocalStorageEnabled() ? false : this.isPrimaryOwner(iBucket)) {
                Object object;
                long lCacheId = job.getCacheId();
                DistributedCache$Storage storage = this.ensureStorage(lCacheId);
                Set setKeys = job.getSet();
                int cBackups = this.getBackupCount();
                boolean fRemoved = false;
                Iterator iter = setKeys.iterator();
                while (iter.hasNext()) {
                    DistributedCache$PartialValueResponse distributedCache$PartialValueResponse;
                    Binary binKey = (Binary)iter.next();
                    try {
                        this.lockKey(binKey, storage, false);
                        try {
                            fRemoved |= storage.remove(binKey, true) != null;
                        }
                        finally {
                            distributedCache$PartialValueResponse = null;
                            this.unlockKey(binKey, storage, false);
                        }
                    }
                    catch (Throwable e) {
                        distributedCache$PartialValueResponse = msgResponse;
                        synchronized (distributedCache$PartialValueResponse) {
                            msgResponse.setResult(this.tagException(e));
                        }
                        if (cBackups > 0) {
                            this.clearIterator(iter);
                        }
                        fRemoved = false;
                        break;
                    }
                }
                if (fRemoved) {
                    object = msgResponse;
                    synchronized (object) {
                        if (msgResponse.getResult() instanceof Throwable ^ true) {
                            msgResponse.setResult(DistributedCache$Storage.BINARY_EXISTS);
                        }
                    }
                }
                if (!(cBackups > 0) ? false : setKeys.isEmpty() ^ true) {
                    object = setPending;
                    synchronized (object) {
                        int iBackup = 1;
                        while (iBackup <= cBackups) {
                            this.sendBackupRemoveRequest(lCacheId, iBackup, setKeys.iterator(), msgResponse, setPending);
                            ++iBackup;
                        }
                    }
                }
            } else {
                msgResponse.rejectPartition(iBucket);
            }
            gate.exit();
        }
        Set set = setPending;
        synchronized (set) {
            boolean fExists = setPending.remove(job);
            Component._assert(fExists);
            if (setPending.isEmpty()) {
                this.post(msgResponse);
            }
        }
    }

    public void onRemoveAllRequest(DistributedCache$RemoveAllRequest msgRequest) {
        DistributedCache$PartialValueResponse msgResponse = (DistributedCache$PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(msgRequest);
        boolean fRespond = true;
        Set setKeys = msgRequest.getKeySet();
        if (this.isLocalStorageEnabled()) {
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            int cBackups = this.getBackupCount();
            if (msgRequest.getStore() == 0) {
                Component._assert(this.getDaemonPool().isStarted() ^ true);
                boolean fRemoved = false;
                DistributedCache$PinningIterator pinner = this.createPinningIterator(setKeys);
                while (pinner.hasNext()) {
                    Binary binKey = (Binary)pinner.next();
                    try {
                        fRemoved |= storage.remove(binKey, true) != null;
                    }
                    catch (Throwable e) {
                        msgResponse.setResult(this.tagException(e));
                        if (cBackups > 0) {
                            this.clearIterator(pinner);
                        }
                        fRemoved = false;
                        break;
                    }
                }
                this.unpinBuckets(pinner.getPinnedPartitions());
                if (fRemoved) {
                    msgResponse.setResult(DistributedCache$Storage.BINARY_EXISTS);
                }
                msgResponse.setRejectPartitions(pinner.getRejectedPartitions());
                if (!(cBackups > 0) ? false : pinner.isEmpty() ^ true) {
                    HashSet setPolls = new HashSet();
                    int iBackup = 1;
                    while (iBackup <= cBackups) {
                        pinner.reset();
                        this.sendBackupRemoveRequest(lCacheId, iBackup, pinner, msgResponse, setPolls);
                        ++iBackup;
                    }
                    fRespond = setPolls.isEmpty();
                }
            } else {
                PartitionSet partReject = this.retainBackupPartitions(setKeys);
                storage.getBackupMap().keySet().removeAll(setKeys);
                msgResponse.setRejectPartitions(partReject);
            }
        } else {
            msgResponse.setRejectPartitions(this.calculatePartitionSet(setKeys));
        }
        if (fRespond) {
            this.post(msgResponse);
        }
    }

    public void onRemoveRequest(DistributedCache$RemoveRequest msgRequest) {
        DistributedCache$Response msgResponse;
        block11: {
            msgResponse = (DistributedCache$Response)this.instantiateMessage("Response");
            msgResponse.respondTo(msgRequest);
            if (this.isLocalStorageEnabled() ^ true) {
                Component._assert(this.getServiceState() >= Service.SERVICE_STOPPING);
                msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
                this.post(msgResponse);
                return;
            }
            Binary binKey = msgRequest.getKey();
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            if (msgRequest.isPrimary()) {
                try {
                    if (this.lockKey(binKey, storage, true)) {
                        try {
                            Binary binValue = storage.remove(binKey, msgRequest.isReturnRequired() ^ true);
                            msgResponse.setValue(binValue);
                            if (!(this.getBackupCount() > 0) ? false : this.sendBackupRemoveRequest(lCacheId, binKey, msgResponse)) {
                                Object var8_9 = null;
                                this.unlockKey(binKey, storage, true);
                                return;
                            }
                            Object var8_10 = null;
                            this.unlockKey(binKey, storage, true);
                            break block11;
                        }
                        catch (Throwable binValue) {
                            Object var8_11 = null;
                            this.unlockKey(binKey, storage, true);
                            throw binValue;
                        }
                    }
                    msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
                }
                catch (Throwable e) {
                    msgResponse.setResult(DistributedCacheResponse.RESULT_FAILURE);
                    msgResponse.setValue(this.tagException(e));
                }
            } else if (this.isBackupOwner(binKey)) {
                storage.getBackupMap().keySet().remove(binKey);
                this.registerResponse(msgRequest.getRequestContext());
            } else {
                msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
            }
        }
        this.post(msgResponse);
    }

    public void onServiceStarted() {
        int cBackups;
        int cBuckets;
        KeyAssociator associator = this.getKeyAssociator();
        KeyPartitioningStrategy partitioning = this.getKeyPartitioningStrategy();
        String sAssociator = associator == null ? "none" : associator.getClass().getName();
        String sPartitioning = partitioning == null ? "none" : partitioning.getClass().getName();
        boolean fSenior = this.getThisMember() == this.getServiceOldestMember();
        Character oConfigKey = new Character('$');
        ObservableMap mapConfig = this.getServiceConfigMap();
        XmlElement xmlConfig = fSenior ? null : (XmlElement)mapConfig.get(oConfigKey);
        if (xmlConfig == null) {
            if (fSenior ^ true) {
                throw new IllegalStateException(String.valueOf("Missing ServiceConfigMap from senior=") + this.getServiceOldestMember().getId());
            }
            cBuckets = this.getPartitionCount();
            cBackups = this.getBackupCount();
            xmlConfig = new SimpleElement("config");
            xmlConfig.addAttribute("partition-count").setInt(cBuckets);
            xmlConfig.addAttribute("redundancy-count").setInt(cBackups);
            xmlConfig.addAttribute("key-associator").setString(sAssociator);
            xmlConfig.addAttribute("key-partitioning").setString(sPartitioning);
            mapConfig.put(oConfigKey, xmlConfig);
        } else {
            String sAssociatorOther = xmlConfig.getSafeAttribute("key-associator").getString();
            if (sAssociatorOther.equals(sAssociator) ^ true) {
                Component._trace(String.valueOf("Incompatible KeyAssociator implementations: ") + "this node is configured to use " + sAssociator + ", but the service senior is using " + sAssociatorOther + "; stopping the service.", 1);
                this.stop();
                return;
            }
            String sPartitioningOther = xmlConfig.getAttribute("key-partitioning").getString();
            if (sPartitioning.equals(sPartitioningOther) ^ true) {
                Component._trace(String.valueOf("Incompatible KeyPartitioningStrategy implementations: ") + "this node is configured to use " + sPartitioning + ", but the service senior is using " + sPartitioningOther + "; stopping the service.", 1);
                this.stop();
                return;
            }
            cBuckets = xmlConfig.getAttribute("partition-count").getInt();
            if (cBuckets != this.getPartitionCount()) {
                Component._trace(String.valueOf("This node is configured with a 'partition-count' value of ") + this.getPartitionCount() + ", but the service senior is using a value of " + cBuckets + "\"; overriding the local configuration.", 2);
                this.setPartitionCount(cBuckets);
            }
            if ((cBackups = xmlConfig.getAttribute("redundancy-count").getInt()) != this.getBackupCount()) {
                Component._trace(String.valueOf("This node is configured with a 'backup-count' value of ") + this.getBackupCount() + ", but the service senior is using a value of " + cBackups + "\"; overriding the local configuration.", 2);
                this.setBackupCount(cBackups);
            }
        }
        if (fSenior) {
            this.resetBucketConfig();
        } else {
            this.setStorageAssignments(new int[cBuckets][1 + cBackups]);
        }
        DistributedCache$BackingMapContext context = (DistributedCache$BackingMapContext)this._newChild("BackingMapContext");
        this.setBackingMapContext(context);
        DistributedCache$ConverterKeyToBinary convKeyDown = (DistributedCache$ConverterKeyToBinary)this._newChild("ConverterKeyToBinary");
        context.setKeyToBinaryConverter(convKeyDown);
        BackingMapManager manager = this.getBackingMapManager();
        if (manager != null) {
            context.setManager(manager);
        }
        if (associator != null) {
            associator.init((PartitionedService)this);
        }
        if (partitioning == null) {
            this.setKeyPartitioningStrategy(convKeyDown);
        } else {
            partitioning.init((PartitionedService)this);
        }
        if (this.isLocalStorageEnabled()) {
            DaemonPool pool = this.getDaemonPool();
            if (pool.getDaemonCount() > 0) {
                ThreadGate[] agate = new ThreadGate[cBuckets];
                int iBucket = 0;
                while (iBucket < cBuckets) {
                    agate[iBucket] = new ThreadGate();
                    ++iBucket;
                }
                this.setPartitionControl(agate);
                pool.setThreadGroup(new ThreadGroup(this.getServiceName()));
                pool.start();
            }
            this.setTransitionalPartitions(new PartitionSet(cBuckets));
        }
        mapConfig.addMapListener((MapListener)((DistributedCache$ConfigListener)this._findChild("ConfigListener")));
        this.validateBucketConfig();
    }

    protected void onServiceStopping() {
        this.releaseAllCache();
    }

    public void onSizeRequest(DistributedCache$SizeRequest msgRequest) {
        DistributedCache$PartialValueResponse msgResponse = (DistributedCache$PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(msgRequest);
        PartitionSet partMask = msgRequest.getRequestMask();
        if (this.isLocalStorageEnabled()) {
            com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            PartitionSet partReject = this.pinOwnedBuckets(partMask);
            try {
                try {
                    int cSize = -1;
                    if (!(!(!(partReject == null) ? false : this.getTransferCount() == 0) ? false : this.getPrimaryTransfer() < 0) ? false : partMask.equals((Object)this.calculatePartitionSet(memberThis, 0))) {
                        cSize = storage.getResourceMap().size();
                        if (partMask.equals((Object)this.calculatePartitionSet(memberThis, 0)) ^ true) {
                            cSize = -1;
                        }
                    }
                    if (cSize < 0) {
                        cSize = storage.query(null, DistributedCache$Storage.QUERY_KEYS, partMask).length;
                    }
                    msgResponse.setResult(Base.makeInteger((int)cSize));
                    msgResponse.setRejectPartitions(partReject);
                }
                catch (Throwable e) {
                    msgResponse.setResult(this.tagException(e));
                }
                Object var10_11 = null;
                this.unpinBuckets(partMask);
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.unpinBuckets(partMask);
                throw throwable;
            }
        }
        msgResponse.setRejectPartitions(partMask);
        this.post(msgResponse);
    }

    public void onTransferRequest(DistributedCache$TransferRequest msgRequest) {
        Component._assert(this.isDistributionInProgress() ? true : msgRequest.getStore() > 0);
        DistributedCache$Response msgResponse = (DistributedCache$Response)this.instantiateMessage("Response");
        msgResponse.respondTo(msgRequest);
        int iBucket = msgRequest.getBucket();
        XmlElement xmlBucket = null;
        boolean fLocked = false;
        if (!this.isAcceptingClients() ? false : this.isLocalStorageEnabled()) {
            int iStore = msgRequest.getStore();
            boolean fLast = msgRequest.isLastCache();
            if (iStore == 0) {
                this.getTransferList().add(msgRequest);
                if (fLast) {
                    int nMemberSender = msgRequest.getFromMember().getId();
                    if (this.isPrimaryOwner(iBucket)) {
                        Component._trace(String.valueOf("Request to transfer already owned primary partition ") + iBucket + " from member " + nMemberSender, 1);
                    } else {
                        fLocked = this.lockBucket(iBucket, 200L);
                        if (fLocked ^ true) {
                            Component._trace(String.valueOf("Failed to obtain a lock for an un-owned partition ") + iBucket, 4);
                        }
                    }
                    xmlBucket = this.assignPrimaryBucket(iBucket);
                    int[] aiBucketOwner = this.getStorageAssignments()[iBucket];
                    int iResponse = DistributedCache$TransferRequest.RESPONSE_RELEASE;
                    int iBackup = 1;
                    int cBackups = this.getBackupCount();
                    while (iBackup <= cBackups) {
                        if (aiBucketOwner[iBackup] == nMemberSender) {
                            iResponse = iBackup;
                            break;
                        }
                        ++iBackup;
                    }
                    msgResponse.setValue(Base.makeInteger((int)iResponse));
                } else {
                    msgResponse.setValue(Base.makeInteger((int)DistributedCache$TransferRequest.RESPONSE_INCOMPLETE));
                }
            } else {
                DistributedCache$Storage storage = this.ensureStorage(msgRequest.getCacheId());
                storage.insertBackupTransfer(msgRequest.getResource());
                storage.insertLeaseTransfer(msgRequest.getLease(), false);
                storage.insertListenerTransfer(msgRequest.getListener(), false);
                msgResponse.setValue(Base.makeInteger((int)DistributedCache$TransferRequest.RESPONSE_RELEASE));
            }
        } else {
            msgResponse.setValue(Base.makeInteger((int)DistributedCache$TransferRequest.RESPONSE_REJECT));
        }
        this.post(msgResponse);
        if (xmlBucket != null) {
            this.putBucketConfig(iBucket, xmlBucket);
            this.setPrimaryTransfer(iBucket);
            try {
                Iterator iter = this.getTransferList().iterator();
                while (iter.hasNext()) {
                    DistributedCache$TransferRequest msgTransfer = (DistributedCache$TransferRequest)iter.next();
                    DistributedCache$Storage storage = this.ensureStorage(msgTransfer.getCacheId());
                    storage.insertPrimaryTransfer(msgTransfer.getResource());
                    storage.insertLeaseTransfer(msgTransfer.getLease(), true);
                    storage.insertListenerTransfer(msgTransfer.getListener(), true);
                    iter.remove();
                }
            }
            finally {
                Object var7_11 = null;
                this.setPrimaryTransfer(-1);
                if (fLocked) {
                    this.unlockBucket(iBucket);
                }
            }
        }
    }

    public void onTransferRequestCompleted(DistributedCache$TransferRequest msgRequest, int iResult) {
        if (this.getServiceState() == Service.SERVICE_STOPPED) {
            return;
        }
        int iBucket = msgRequest.getBucket();
        int iStore = msgRequest.getStore();
        int[] aiBucketOwner = this.getStorageAssignments()[iBucket];
        int nMemberThis = this.getThisMember().getId();
        if (iStore == 0) {
            if (iResult == DistributedCache$TransferRequest.RESPONSE_REJECT) {
                if (aiBucketOwner[0] != nMemberThis) {
                    Component._trace(String.valueOf("Failed primary transfer for partition ") + iBucket + " to member " + msgRequest.getToMemberSet().getFirstId() + "; reclaiming the ownership from: " + aiBucketOwner[0], 4);
                    this.assignBucketOwner(iBucket, 0, nMemberThis);
                    this.unlockBucket(iBucket);
                    this.publishBucketOwnership(iBucket, 0, nMemberThis);
                    this.getTransitionalPartitions().remove(iBucket);
                }
            } else if (msgRequest.isLastCache()) {
                Component._assert(aiBucketOwner[0] != nMemberThis);
                if (iResult == DistributedCache$TransferRequest.RESPONSE_RELEASE) {
                    this.releaseBucket(iBucket, true);
                } else {
                    Component._assert(iResult > 0);
                    this.moveBucket(iBucket, true);
                    aiBucketOwner[iResult] = nMemberThis;
                }
                this.unlockBucket(iBucket);
            }
        } else if (aiBucketOwner[0] == nMemberThis) {
            if (iResult == DistributedCache$TransferRequest.RESPONSE_REJECT) {
                XmlElement xmlBucket = this.getBucketConfig(iBucket);
                int nBackupOwner = xmlBucket.getAttribute(this.getStorageAttribute(iStore)).getInt();
                if (aiBucketOwner[iStore] != nBackupOwner) {
                    Component._trace(String.valueOf("Failed backup transfer for partition ") + iBucket + " to member " + msgRequest.getToMemberSet().getFirstId() + "; restoring owner from: " + aiBucketOwner[iStore] + " to: " + nBackupOwner, 4);
                    aiBucketOwner[iStore] = nBackupOwner;
                }
            } else if (msgRequest.isLastCache()) {
                int nBackupOwner;
                aiBucketOwner[iStore] = nBackupOwner = msgRequest.getToMemberSet().getFirstId();
                this.publishBucketOwnership(iBucket, iStore, nBackupOwner);
            }
        } else {
            Component._trace(String.valueOf("Partition ") + iBucket + " ownership was transferred to member " + aiBucketOwner[0] + " without consent:\n" + this.getBucketConfig(iBucket), 1);
        }
        int cTransfer = this.getTransferCount() - 1;
        this.setTransferCount(cTransfer);
        if (cTransfer == 0) {
            this.setDistributionNextMillis(Base.getSafeTimeMillis() + (long)(iStore * (this.getDistributionRepeatMillis() / this.getDistributionAggressiveness())));
        }
    }

    public void onUnlockRequest(DistributedCache$UnlockRequest msgRequest) {
        DistributedCache$Response msgResponse;
        block14: {
            msgResponse = (DistributedCache$Response)this.instantiateMessage("Response");
            msgResponse.respondTo(msgRequest);
            if (this.isLocalStorageEnabled() ^ true) {
                Component._assert(this.getServiceState() >= Service.SERVICE_STOPPING);
                msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
                this.post(msgResponse);
                return;
            }
            Binary binKey = msgRequest.getKey();
            long lCacheId = msgRequest.getCacheId();
            DistributedCache$Storage storage = this.ensureStorage(lCacheId);
            if (msgRequest.isPrimary()) {
                try {
                    if (this.lockKey(binKey, storage, true)) {
                        Object var9_10;
                        block13: {
                            try {
                                Lease lease = msgRequest.toLease();
                                if (storage.unlock(lease)) {
                                    MemberSet setBackup;
                                    boolean fDeferResponse = false;
                                    msgResponse.setValue(Boolean.TRUE);
                                    if (this.getBackupCount() > 0 && (setBackup = this.getBackupOwners(binKey)).isEmpty() ^ true) {
                                        DistributedCache$UnlockRequest msg = (DistributedCache$UnlockRequest)this.instantiateMessage("UnlockRequest");
                                        msg.setCacheId(lCacheId);
                                        msg.fromLease(lease);
                                        msg.setPrimary(false);
                                        msg.setPrimaryResponse(msgResponse);
                                        msg.setToMemberSet(setBackup);
                                        this.post(msg);
                                        fDeferResponse = true;
                                    }
                                    storage.firePendingLocks(binKey);
                                    if (fDeferResponse) {
                                        var9_10 = null;
                                        this.unlockKey(binKey, storage, true);
                                        return;
                                    }
                                    break block13;
                                }
                                msgResponse.setValue(Boolean.FALSE);
                            }
                            catch (Throwable lease) {
                                Object var9_11 = null;
                                this.unlockKey(binKey, storage, true);
                                throw lease;
                            }
                        }
                        var9_10 = null;
                        this.unlockKey(binKey, storage, true);
                        break block14;
                    }
                    msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
                }
                catch (Throwable e) {
                    msgResponse.setResult(DistributedCacheResponse.RESULT_FAILURE);
                    msgResponse.setValue(this.tagException(e));
                }
            } else if (this.isBackupOwner(binKey)) {
                storage.getBackupLeaseMap().remove(binKey);
            } else {
                msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
            }
        }
        this.post(msgResponse);
    }

    protected PartitionSet pinOwnedBuckets(PartitionSet partitions) {
        boolean fConcurrent = this.getDaemonPool().isStarted();
        PartitionSet partsOther = null;
        int iBucket = partitions.next(0);
        while (iBucket >= 0) {
            ThreadGate gate = null;
            boolean fEntered = true;
            if (fConcurrent) {
                gate = this.enterBucket(iBucket);
                fEntered = gate != null;
            }
            if (fEntered ^ true ? true : this.isPrimaryOwner(iBucket) ^ true) {
                if (partsOther == null) {
                    partsOther = new PartitionSet(this.getPartitionCount());
                }
                partsOther.add(iBucket);
                partitions.remove(iBucket);
                if (gate != null) {
                    gate.exit();
                }
            }
            iBucket = partitions.next(iBucket + 1);
        }
        return partsOther;
    }

    public void publishBucketOwnership(int iBucket, int iStore, int nOwner) {
        XmlElement xmlBucket = this.getBucketConfig(iBucket);
        xmlBucket.addAttribute(this.getStorageAttribute(iStore)).setInt(nOwner);
        this.putBucketConfig(iBucket, xmlBucket);
    }

    public void publishTransitionalOwnership() {
        int[][] aaiBucketOwner = this.getStorageAssignments();
        int nThisMember = this.getThisMember().getId();
        PartitionSet partsTransit = this.getTransitionalPartitions();
        int iBucket = partsTransit.next(0);
        while (iBucket >= 0) {
            int nOwner = aaiBucketOwner[iBucket][0];
            if (nOwner == nThisMember ? true : nOwner == 0) {
                Component._trace(String.valueOf("Re-publishing the ownership for partition ") + iBucket + " (" + nOwner + ')', 4);
                this.publishBucketOwnership(iBucket, 0, nOwner);
                partsTransit.remove(iBucket);
            }
            iBucket = partsTransit.next(iBucket + 1);
        }
    }

    public void putBucketConfig(int iBucket, XmlElement xmlBucket) {
        int nOwner = this.getStorageAssignments()[iBucket][0];
        Component._assert(nOwner == 0 ? true : nOwner == this.getThisMember().getId());
        this.getServiceConfigMap().put(Base.makeInteger((int)iBucket), xmlBucket);
    }

    public static List randomize(Set set) {
        ArrayList list = new ArrayList();
        int cnt = 0;
        Random rnd = Base.getRandom();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Object oNext = iter.next();
            if (cnt++ == 0) {
                list.add(oNext);
                continue;
            }
            list.add(rnd.nextInt(cnt), oNext);
        }
        return list;
    }

    protected void registerResponse(Object oCtx) {
        if (oCtx instanceof DistributedCache$SimpleResponseContext) {
            DistributedCache$SimpleResponseContext context = (DistributedCache$SimpleResponseContext)oCtx;
            this.unregisterRequestInfoRange(-1L, context.getOldestPendingSUID());
            this.registerRequestInfo(context.getRequestSUID(), context.getResult());
        }
    }

    protected void releaseAllCache() {
        DistributedCache distributedCache = this;
        synchronized (distributedCache) {
            Map mapByName = this.getReferencesViewMap();
            Iterator iterName = this.getReferencesViewMap().values().iterator();
            while (iterName.hasNext()) {
                Map mapByLoader = (Map)iterName.next();
                Iterator iterLoader = mapByLoader.values().iterator();
                while (iterLoader.hasNext()) {
                    DistributedCache$ViewMap mapCache = (DistributedCache$ViewMap)iterLoader.next();
                    mapCache.invalidate();
                }
                mapByLoader.clear();
            }
            mapByName.clear();
            this.getReferencesBinaryMap().clear();
        }
    }

    protected void releaseAllStorage() {
        this.setStorageAssignments(new int[this.getPartitionCount()][1 + this.getBackupCount()]);
        while (true) {
            try {
                LongArray.Iterator iter = this.getStorageArray().iterator();
                while (iter.hasNext()) {
                    DistributedCache$Storage storage = (DistributedCache$Storage)iter.next();
                    storage.invalidate();
                    iter.remove();
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    protected void releaseBucket(int iBucket, boolean fPrimary) {
        LongArray aStorage;
        LongArray longArray = aStorage = this.getStorageArray();
        synchronized (longArray) {
            LongArray.Iterator iterStore = aStorage.iterator();
            while (iterStore.hasNext()) {
                DistributedCache$Storage storage = (DistributedCache$Storage)iterStore.next();
                if (!storage.isValid()) continue;
                storage.releaseBucket(iBucket, fPrimary);
            }
        }
    }

    public void releaseCache(NamedCache cache) {
        if (cache.getCacheService() != this) {
            throw new IllegalArgumentException(String.valueOf("The cache to release is not owned by this service: ") + this);
        }
        DistributedCache$ViewMap mapCache = (DistributedCache$ViewMap)cache;
        if (mapCache.isActive()) {
            DistributedCache distributedCache = this;
            synchronized (distributedCache) {
                Map mapByName = this.getReferencesViewMap();
                Map mapByLoader = (Map)mapByName.get(cache.getCacheName());
                if (mapByLoader != null) {
                    mapByLoader.remove(mapCache.getClassLoader());
                }
            }
            mapCache.invalidate();
        }
    }

    public String reportBucketContent(int iBucket) {
        StringBuffer sb = new StringBuffer();
        try {
            LongArray.Iterator iterStore = this.getStorageArray().iterator();
            while (iterStore.hasNext()) {
                DistributedCache$Storage storage = (DistributedCache$Storage)iterStore.next();
                if (storage.isValid() ^ true) continue;
                sb.append('\n').append(storage.getCacheName()).append('{');
                Iterator iterKey = storage.getResourceMap().keySet().iterator();
                while (iterKey.hasNext()) {
                    Binary binKey = (Binary)iterKey.next();
                    if (!(this.getKeyBucket(binKey) == iBucket)) continue;
                    try {
                        sb.append(Message.readObject(new DataInputStream(binKey.getInputStream()), this.getContextClassLoader()));
                    }
                    catch (IOException e) {
                        sb.append(e);
                    }
                    sb.append(", ");
                }
                sb.append('}');
            }
        }
        catch (ConcurrentModificationException e) {
            // empty catch block
        }
        if (this.getDaemonPool().isStarted()) {
            ThreadGate gate = this.getPartitionControl()[iBucket];
            sb.append('\n').append(gate);
        }
        return sb.length() == 0 ? "" : sb.substring(1);
    }

    public String reportBucketOwnership(int iBucket) {
        StringBuffer sb = new StringBuffer(String.valueOf("Partition ") + iBucket + ": ");
        int[] aiBucketOwner = this.getStorageAssignments()[iBucket];
        XmlElement xmlBucket = this.getBucketConfig(iBucket);
        int iStore = 0;
        int c = 1 + this.getBackupCount();
        while (iStore < c) {
            String sAttr = this.getStorageAttribute(iStore);
            int nOwnerLocal = aiBucketOwner[iStore];
            int nOwnerGlobal = xmlBucket.getAttribute(sAttr).getInt();
            if (iStore == 0) {
                sb.append("owner=");
            } else {
                sb.append(", backup[").append(iStore).append("]=");
            }
            sb.append(nOwnerLocal);
            if (nOwnerLocal != nOwnerGlobal) {
                sb.append("?global=").append(nOwnerGlobal);
            }
            ++iStore;
        }
        return sb.toString();
    }

    public String reportOwnership(int nMember, boolean fVerbose) {
        StringBuffer sb = new StringBuffer();
        int[][] aaiBucketOwner = this.getStorageAssignments();
        int cBuckets = aaiBucketOwner.length;
        int cBackups = this.getBackupCount();
        ObservableMap mapConfig = this.getServiceConfigMap();
        int iStore = 0;
        while (iStore < 1 + cBackups) {
            if (iStore == 0) {
                sb.append("Primary[]");
            } else {
                sb.append("\nBackup[").append(iStore).append("]");
            }
            StringBuffer sbStore = new StringBuffer();
            int cDigits = cBuckets > 9999 ? 5 : (cBuckets > 999 ? 4 : 3);
            String sAttr = this.getStorageAttribute(iStore);
            int cOwned = 0;
            int iBucket = 0;
            while (iBucket < cBuckets) {
                int nOwnerLocal = aaiBucketOwner[iBucket][iStore];
                XmlElement xmlBucket = (XmlElement)mapConfig.get(Base.makeInteger((int)iBucket));
                int nOwnerGlobal = xmlBucket.getAttribute(sAttr).getInt();
                if (nOwnerLocal == nMember ? true : nOwnerGlobal == nMember) {
                    if (fVerbose) {
                        sbStore.append(',').append(this.isBucketVulnerable(iBucket) ? (char)' ' : '+').append(Base.toDecString((int)iBucket, (int)cDigits));
                        if (nOwnerLocal != nOwnerGlobal) {
                            if (nOwnerLocal != nMember) {
                                sbStore.append("?local=").append(nOwnerLocal);
                            } else {
                                sbStore.append("?global=").append(nOwnerGlobal);
                            }
                        }
                    }
                    ++cOwned;
                }
                ++iBucket;
            }
            sb.append('#').append(Base.toDecString((int)cOwned, (int)cDigits));
            if (!(cOwned > 0) ? false : fVerbose) {
                sb.append(':').append(sbStore.substring(1));
            }
            ++iStore;
        }
        return sb.toString();
    }

    public String reportOwnership(boolean fVerbose) {
        int cBuckets = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        MemberSet setStorage = this.getStorageMemberSet();
        int cMembers = setStorage.size();
        if (cMembers == 0) {
            return "Storage not configured";
        }
        int cFairShare = Math.min(cBuckets / cMembers + 1, cBuckets);
        int nError = cMembers * cFairShare - cBuckets;
        int[] acPrimary = this.calculateOwnership(setStorage, true);
        int[] acBackup = this.calculateOwnership(setStorage, false);
        StringBuffer sb = new StringBuffer();
        sb.append("Fair share=").append(cFairShare).append(", deviation=").append(nError);
        if (cBackups > 1) {
            cFairShare = Math.min(cBuckets * cBackups / cMembers + 1, cBuckets);
            nError = cMembers * cFairShare - cBuckets * cBackups;
            sb.append(", backup fair share=").append(cFairShare).append(", backup deviation=").append(nError);
        }
        Iterator iter = setStorage.iterator();
        while (iter.hasNext()) {
            com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
            int nMember = member.getId();
            sb.append("\n*** Member: ");
            if (nMember < 10) {
                sb.append(' ');
            }
            sb.append(nMember).append(" total=").append(acPrimary[nMember] + acBackup[nMember]).append(" (primary=").append(acPrimary[nMember]).append(", backup=").append(acBackup[nMember]).append(")\n").append(this.reportOwnership(nMember, fVerbose)).append('\n');
        }
        sb.append("\n*** Orphans:\n").append(this.reportOwnership(0, fVerbose)).append('\n');
        if (this.getDaemonPool().isStarted()) {
            boolean fOpen = true;
            ThreadGate[] agate = this.getPartitionControl();
            int i = 0;
            int c = agate.length;
            while (i < c) {
                ThreadGate gate = agate[i];
                if (gate.getStatus() != ThreadGate.GATE_OPEN) {
                    if (fOpen) {
                        fOpen = false;
                        sb.append("\n*** Closed Gates:\n");
                    }
                    sb.append(i).append('=').append(gate).append('\n');
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public String reportVulnerability(int nMember, boolean fVerbose) {
        if (this.getBackupCount() == 0) {
            return "No backup";
        }
        StringBuffer sbEndangered = new StringBuffer();
        StringBuffer sbVulnerable = new StringBuffer();
        int cEndangered = 0;
        int cVulnerable = 0;
        int iBucket = 0;
        int cBuckets = this.getPartitionCount();
        while (iBucket < cBuckets) {
            if (this.getPrimaryOwner(iBucket).getId() == nMember) {
                if (this.getBackupOwners(iBucket).isEmpty()) {
                    sbEndangered.append(',').append(iBucket);
                    ++cEndangered;
                } else if (this.isBucketVulnerable(iBucket)) {
                    sbVulnerable.append(',').append(iBucket);
                    ++cVulnerable;
                }
            }
            ++iBucket;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("*** Endangered partitions: (").append(cEndangered).append(") ");
        if (!fVerbose ? false : sbEndangered.length() > 0) {
            sb.append(sbEndangered.substring(1));
        }
        sb.append("\n*** Vulnerable partitions: (").append(cVulnerable).append(") ");
        if (!fVerbose ? false : sbVulnerable.length() > 0) {
            sb.append(sbVulnerable.substring(1));
        }
        return sb.toString();
    }

    public String reportVulnerability(boolean fVerbose) {
        if (this.getBackupCount() == 0) {
            return "No backup";
        }
        StringBuffer sbEndangered = new StringBuffer();
        StringBuffer sbVulnerable = new StringBuffer();
        int cEndangered = 0;
        int cVulnerable = 0;
        int iBucket = 0;
        int cBuckets = this.getPartitionCount();
        while (iBucket < cBuckets) {
            if (this.getPrimaryOwner(iBucket) == null ? true : this.getBackupOwners(iBucket).isEmpty()) {
                sbEndangered.append(',').append(iBucket);
                ++cEndangered;
            } else if (this.isBucketVulnerable(iBucket)) {
                sbVulnerable.append(',').append(iBucket);
                ++cVulnerable;
            }
            ++iBucket;
        }
        StringBuffer sb = new StringBuffer();
        if (cVulnerable > 0) {
            sb.append("Vulnerability is ").append(this.isVulnerabilityAvoidable(this.getStorageMemberSet()) ? "avoidable" : "unavoidable");
        }
        sb.append("\n*** Endangered partitions: (").append(cEndangered).append(") ");
        if (!fVerbose ? false : sbEndangered.length() > 0) {
            sb.append(sbEndangered.substring(1));
        }
        sb.append("\n*** Vulnerable partitions: (").append(cVulnerable).append(") ");
        if (!fVerbose ? false : sbVulnerable.length() > 0) {
            sb.append(sbVulnerable.substring(1));
        }
        return sb.toString();
    }

    protected void resetBucketConfig() {
        int nThisMember = this.getThisMember().getId();
        int cBuckets = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        boolean fLocalStorage = this.isLocalStorageEnabled();
        String[] asAttrName = this.getStorageAttribute();
        int[][] aaiBucketOwner = new int[cBuckets][1 + cBackups];
        HashMap<Integer, XmlElement> mapUpdates = new HashMap<Integer, XmlElement>();
        int iBucket = 0;
        while (iBucket < cBuckets) {
            int[] aiBucketOwner = aaiBucketOwner[iBucket];
            XmlElement xmlBucket = this.getBucketConfig(iBucket);
            if (xmlBucket == null) {
                xmlBucket = new SimpleElement("bucket");
            }
            int iStore = 0;
            while (iStore < 1 + cBackups) {
                int nOwner;
                aiBucketOwner[iStore] = nOwner = (!fLocalStorage ? false : iStore == 0) ? nThisMember : 0;
                String sAttr = asAttrName[iStore];
                if (xmlBucket.getSafeAttribute(sAttr).getInt(-1) != nOwner) {
                    xmlBucket.addAttribute(sAttr).setInt(nOwner);
                    mapUpdates.put(Base.makeInteger((int)iBucket), xmlBucket);
                }
                ++iStore;
            }
            ++iBucket;
        }
        this.setStorageAssignments(aaiBucketOwner);
        if (mapUpdates.isEmpty() ^ true) {
            this.getServiceConfigMap().putAll(mapUpdates);
        }
    }

    protected void restoreOrphans() {
        int nMemberThis = this.getThisMember().getId();
        int[][] aaiBucketOwner = this.getStorageAssignments();
        int cBackups = this.getBackupCount();
        StringBuffer sb = new StringBuffer();
        int cRestored = 0;
        int iBucket = 0;
        int cBuckets = aaiBucketOwner.length;
        while (iBucket < cBuckets) {
            int[] aiBucketOwner = aaiBucketOwner[iBucket];
            if (aiBucketOwner[0] == 0) {
                int iBackup = 1;
                while (iBackup <= cBackups) {
                    int nBackupOwner = aiBucketOwner[iBackup];
                    if (nBackupOwner == nMemberThis) {
                        boolean fLocked = this.lockBucket(iBucket, 200L);
                        if (fLocked ^ true) {
                            Component._trace(String.valueOf("Data recovery procedure failed to obtain a partition lock: ") + iBucket, 4);
                        }
                        try {
                            this.moveBucket(iBucket, false);
                        }
                        finally {
                            Object var13_14 = null;
                            if (fLocked) {
                                this.unlockBucket(iBucket);
                            }
                        }
                        XmlElement xmlBucket = this.assignPrimaryBucket(iBucket);
                        this.putBucketConfig(iBucket, xmlBucket);
                        ++cRestored;
                        sb.append(iBucket).append(", ");
                    } else if (nBackupOwner != 0) break;
                    ++iBackup;
                }
            }
            ++iBucket;
        }
        if (cRestored > 0) {
            Component._trace(String.valueOf("Restored from backup ") + cRestored + " partitions", 3);
            Component._trace(sb.toString(), 4);
        }
    }

    protected PartitionSet retainBackupPartitions(Set setKeys) {
        PartitionSet partReject = null;
        Iterator iter = setKeys.iterator();
        while (iter.hasNext()) {
            Binary binKey = (Binary)iter.next();
            if (!(this.isBackupOwner(binKey) ^ true)) continue;
            if (partReject == null) {
                partReject = new PartitionSet(this.getPartitionCount());
            }
            partReject.add(this.getKeyBucket(binKey));
            iter.remove();
        }
        return partReject;
    }

    protected synchronized void scheduleLockEvaluation(long cMillis) {
        long lNext = cMillis == Long.MAX_VALUE ? cMillis : Base.getSafeTimeMillis() + cMillis;
        this.setLockingNextMillis(Math.min(this.getLockingNextMillis(), lNext));
    }

    public void sendBackupRemoveRequest(long lCacheId, int iStore, Iterator iterKeys, DistributedPartialResponse msgResponse, Set setPolls) {
        Component._assert(iStore > 0);
        HashMap mapByOwner = new HashMap();
        this.splitKeysByOwner(iterKeys, iStore, mapByOwner);
        int cMsgs = mapByOwner.size();
        Message[] aMsg = new Message[cMsgs];
        Iterator iter = mapByOwner.entrySet().iterator();
        int iMsg = 0;
        while (iMsg < cMsgs) {
            Map.Entry entry = (Map.Entry)iter.next();
            com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)entry.getKey();
            Set setMember = (Set)entry.getValue();
            DistributedCache$RemoveAllRequest msg = (DistributedCache$RemoveAllRequest)this.instantiateMessage("RemoveAllRequest");
            msg.setCacheId(lCacheId);
            msg.setKeySet(setMember);
            msg.setStore(iStore);
            msg.setPrimaryResponse(msgResponse);
            msg.setPendingPolls(setPolls);
            msg.setToMemberSet(SingleMemberSet.instantiate(member));
            setPolls.add(msg.ensureRequestPoll());
            aMsg[iMsg] = msg;
            ++iMsg;
        }
        iMsg = 0;
        while (iMsg < cMsgs) {
            this.post(aMsg[iMsg]);
            ++iMsg;
        }
    }

    public boolean sendBackupRemoveRequest(long lCacheId, Binary binKey, DistributedCache$Response msgResponse) {
        MemberSet setBackup = this.getBackupOwners(binKey);
        if (setBackup.isEmpty()) {
            return false;
        }
        DistributedCache$RemoveRequest msg = (DistributedCache$RemoveRequest)this.instantiateMessage("RemoveRequest");
        msg.setCacheId(lCacheId);
        msg.setKey(binKey);
        msg.setPrimary(false);
        msg.setPrimaryResponse(msgResponse);
        msg.setToMemberSet(setBackup);
        if (msgResponse != null) {
            msg.setRequestContext(msgResponse.getRequestContext());
        }
        this.post(msg);
        return true;
    }

    public void sendBackupUpdateRequest(long lCacheId, int iStore, Iterator iterEntries, DistributedPartialResponse msgResponse, Set setPolls) {
        Component._assert(iStore > 0);
        HashMap mapByOwner = new HashMap();
        this.splitEntriesByOwner(iterEntries, iStore, mapByOwner);
        int cMsgs = mapByOwner.size();
        Message[] aMsg = new Message[cMsgs];
        Iterator iter = mapByOwner.entrySet().iterator();
        int iMsg = 0;
        while (iMsg < cMsgs) {
            Map.Entry entry = (Map.Entry)iter.next();
            com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)entry.getKey();
            Map mapMember = (Map)entry.getValue();
            DistributedCache$PutAllRequest msg = (DistributedCache$PutAllRequest)this.instantiateMessage("PutAllRequest");
            msg.setCacheId(lCacheId);
            msg.setMap(mapMember);
            msg.setStore(iStore);
            msg.setPrimaryResponse(msgResponse);
            msg.setPendingPolls(setPolls);
            msg.setToMemberSet(SingleMemberSet.instantiate(member));
            setPolls.add(msg.ensureRequestPoll());
            aMsg[iMsg] = msg;
            ++iMsg;
        }
        iMsg = 0;
        while (iMsg < cMsgs) {
            this.post(aMsg[iMsg]);
            ++iMsg;
        }
    }

    public boolean sendBackupUpdateRequest(long lCacheId, Binary binKey, Binary binValue, DistributedCache$Response msgResponse) {
        MemberSet setBackup = this.getBackupOwners(binKey);
        if (setBackup.isEmpty()) {
            return false;
        }
        DistributedCache$PutRequest msg = (DistributedCache$PutRequest)this.instantiateMessage("PutRequest");
        msg.setCacheId(lCacheId);
        msg.setKey(binKey);
        msg.setValue(binValue);
        msg.setPrimary(false);
        msg.setPrimaryResponse(msgResponse);
        msg.setToMemberSet(setBackup);
        if (msgResponse != null) {
            msg.setRequestContext(msgResponse.getRequestContext());
        }
        this.post(msg);
        return true;
    }

    protected void setBackingMapContext(DistributedCache$BackingMapContext ctx) {
        this.__m_BackingMapContext = ctx;
    }

    public synchronized void setBackingMapManager(BackingMapManager manager) {
        if (this.isRunning()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_BackingMapManager = manager;
    }

    protected void setBackupClass(Class clz) {
        this.__m_BackupClass = clz;
    }

    protected void setBackupCount(int cBackups) {
        Component._assert(this.isAcceptingClients() ^ true, "The backup count is immutable once the service has started");
        String[] asAttrName = new String[1 + cBackups];
        int iStore = 0;
        while (iStore < 1 + cBackups) {
            asAttrName[iStore] = String.valueOf("storage-") + iStore;
            ++iStore;
        }
        this.setStorageAttribute(asAttrName);
        this.__m_BackupCount = cBackups;
    }

    protected void setBackupDir(File dir) {
        this.__m_BackupDir = dir;
    }

    protected void setBackupInitSize(int nSize) {
        this.__m_BackupInitSize = nSize;
    }

    protected void setBackupMaxSize(int nSize) {
        this.__m_BackupMaxSize = nSize;
    }

    protected void setBackupScheme(String sScheme) {
        this.__m_BackupScheme = sScheme;
    }

    protected void setBackupType(int nType) {
        Component._assert(this.isAcceptingClients() ^ true, "The backup type is immutable once the service has started");
        this.__m_BackupType = nType;
    }

    public void setDistributionAggressiveness(int iFactor) {
        this.__m_DistributionAggressiveness = Math.max(iFactor, 1);
    }

    protected void setDistributionInProgress(boolean fProgress) {
        this.__m_DistributionInProgress = fProgress;
    }

    public void setDistributionNextMillis(long ltMillis) {
        this.__m_DistributionNextMillis = ltMillis;
    }

    public void setDistributionRepeatMillis(int cMillis) {
        this.__m_DistributionRepeatMillis = cMillis;
    }

    protected void setDistributionSynchronized(boolean fSync) {
        this.__m_DistributionSynchronized = fSync;
    }

    protected void setKeyAssociator(KeyAssociator associator) {
        if (this.isAcceptingClients()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_KeyAssociator = associator;
    }

    protected void setKeyPartitioningStrategy(KeyPartitioningStrategy strategy) {
        if (this.isAcceptingClients()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_KeyPartitioningStrategy = strategy;
    }

    protected void setLeaseGranularity(int nHeldBy) {
        this.__m_LeaseGranularity = nHeldBy;
    }

    protected void setLocalStorageEnabled(boolean fEnabled) {
        this.__m_LocalStorageEnabled = fEnabled;
    }

    public void setLockingNextMillis(long ltMillis) {
        this.__m_LockingNextMillis = ltMillis;
    }

    private void setMsgCAE(String sMsg) {
        this.__m_MsgCAE = sMsg;
    }

    public void setOwnershipInProgress(int c) {
        this.__m_OwnershipInProgress = c;
    }

    protected void setPartitionAssignmentStrategy(PartitionAssignmentStrategy strategy) {
        if (this.isAcceptingClients()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_PartitionAssignmentStrategy = strategy;
    }

    protected void setPartitionControl(ThreadGate[] aGate) {
        this.__m_PartitionControl = aGate;
    }

    protected void setPartitionCount(int cBuckets) {
        Component._assert(this.isAcceptingClients() ^ true, "The partition count is immutable once the service has started");
        this.__m_PartitionCount = cBuckets;
    }

    protected void setPartitionListener(PartitionListener listener) {
        this.__m_PartitionListener = listener;
    }

    protected void setPendingEventInfo(Map map) {
        this.__m_PendingEventInfo = map;
    }

    protected void setPrimaryTransfer(int iBucket) {
        this.__m_PrimaryTransfer = iBucket;
    }

    protected void setReferencesBinaryMap(Map map) {
        this.__m_ReferencesBinaryMap = map;
    }

    protected void setReferencesViewMap(Map map) {
        this.__m_ReferencesViewMap = map;
    }

    protected void setStandardLeaseMillis(long cMillis) {
        this.__m_StandardLeaseMillis = Math.max(0L, cMillis);
    }

    protected void setStorageArray(LongArray aStorage) {
        this.__m_StorageArray = aStorage;
    }

    protected void setStorageAssignments(int[][] aai) {
        this.__m_StorageAssignments = aai;
    }

    private void setStorageAttribute(int i, String sAttribute) {
        this.getStorageAttribute()[i] = sAttribute;
    }

    private void setStorageAttribute(String[] asAttribute) {
        this.__m_StorageAttribute = asAttribute;
    }

    protected void setTransferCount(int cTransfer) {
        this.__m_TransferCount = cTransfer;
    }

    protected void setTransferList(List list) {
        this.__m_TransferList = list;
    }

    protected void setTransferThreshold(int cbThreshold) {
        this.__m_TransferThreshold = cbThreshold;
    }

    protected void setTransitionalPartitions(PartitionSet parts) {
        this.__m_TransitionalPartitions = parts;
    }

    public void shutdown() {
        if (this.getThread() != Thread.currentThread()) {
            long ldtTimeout = Base.getSafeTimeMillis() + 5000L;
            while (!(!this.isStarted() ? false : this.isAcceptingOthers() ^ true) ? false : this.getServiceState() < Service.SERVICE_STOPPED) {
                Thread.yield();
                if (!(Base.getSafeTimeMillis() > ldtTimeout)) continue;
                Component._trace(String.valueOf("Timeout during shutdown; stopping service ") + this, 2);
                this.stop();
                return;
            }
        }
        super.shutdown();
    }

    protected List sortMembers(MemberSet setOthers, int[] acBuckets) {
        Object[] aMember = (com.tangosol.coherence.component.net.Member[])setOthers.toArray();
        int cOthers = aMember.length;
        if (cOthers > 1) {
            Random rand = Base.getRandom();
            TreeMap<Integer, Object> mapSorted = new TreeMap<Integer, Object>();
            int nMachineThis = this.getThisMember().getMachineId();
            int i = 0;
            while (i < cOthers) {
                Object member = aMember[i];
                int nId = ((com.tangosol.coherence.component.net.Member)member).getId();
                if (nId < acBuckets.length) {
                    int nM = ((com.tangosol.coherence.component.net.Member)member).getMachineId() == nMachineThis ? 0x40000000 : 0;
                    int nB = acBuckets[nId] << 8;
                    int nR = rand.nextInt(256);
                    mapSorted.put(new Integer(nM + nB + nR), member);
                }
                ++i;
            }
            return new ImmutableArrayList(mapSorted.values());
        }
        return new ImmutableArrayList(aMember);
    }

    public PartitionSet splitByOwner(PartitionSet partitions, int iStore, Map mapByOwner) {
        PartitionSet partOrphan = null;
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        int cBuckets = this.getPartitionCount();
        int[][] aaiBucketOwner = this.getStorageAssignments();
        int iBucket = partitions.next(0);
        while (iBucket >= 0) {
            int nOwner = aaiBucketOwner[iBucket][iStore];
            com.tangosol.coherence.component.net.Member member = (!(nOwner > 0) ? false : setMembers.isServiceLeaving(nOwner) ^ true) ? setMembers.getMember(nOwner) : null;
            if (member == null) {
                if (partOrphan == null) {
                    partOrphan = new PartitionSet(cBuckets);
                }
                partOrphan.add(iBucket);
            } else {
                PartitionSet partMember = (PartitionSet)mapByOwner.get(member);
                if (partMember == null) {
                    partMember = new PartitionSet(cBuckets);
                    mapByOwner.put(member, partMember);
                }
                partMember.add(iBucket);
            }
            iBucket = partitions.next(iBucket + 1);
        }
        return partOrphan;
    }

    public Map splitEntriesByOwner(Iterator iterEntries, int iStore, Map mapByOwner) {
        HashMap mapOrphan = null;
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        int[][] aaiBucketOwner = this.getStorageAssignments();
        while (iterEntries.hasNext()) {
            Map.Entry entry = (Map.Entry)iterEntries.next();
            Binary binKey = (Binary)entry.getKey();
            int nOwner = aaiBucketOwner[this.getKeyBucket(binKey)][iStore];
            com.tangosol.coherence.component.net.Member member = (!(nOwner > 0) ? false : setMembers.isServiceLeaving(nOwner) ^ true) ? setMembers.getMember(nOwner) : null;
            if (member == null) {
                if (mapOrphan == null) {
                    mapOrphan = new HashMap();
                }
                mapOrphan.put(binKey, entry.getValue());
                continue;
            }
            HashMap mapMember = (HashMap)mapByOwner.get(member);
            if (mapMember == null) {
                mapMember = new HashMap();
                mapByOwner.put(member, mapMember);
            }
            mapMember.put(binKey, entry.getValue());
        }
        return mapOrphan;
    }

    public Set splitKeysByOwner(Iterator iterKeys, int iStore, Map mapByOwner) {
        HashSet<Binary> setOrphan = null;
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        int[][] aaiBucketOwner = this.getStorageAssignments();
        while (iterKeys.hasNext()) {
            Binary binKey = (Binary)iterKeys.next();
            int iBucket = this.getKeyBucket(binKey);
            int nOwner = aaiBucketOwner[iBucket][iStore];
            com.tangosol.coherence.component.net.Member member = (!(nOwner > 0) ? false : setMembers.isServiceLeaving(nOwner) ^ true) ? setMembers.getMember(nOwner) : null;
            if (member == null) {
                if (setOrphan == null) {
                    setOrphan = new HashSet<Binary>();
                }
                setOrphan.add(binKey);
                continue;
            }
            HashSet<Binary> setMember = (HashSet<Binary>)mapByOwner.get(member);
            if (setMember == null) {
                setMember = new HashSet<Binary>();
                mapByOwner.put(member, setMember);
            }
            setMember.add(binKey);
        }
        return setOrphan;
    }

    protected boolean syncBucketAssignment(int iBucket, int iStore) {
        int nOwnerGlobal;
        XmlElement xmlBucket = this.getBucketConfig(iBucket);
        if (xmlBucket == null) {
            throw new IllegalStateException(String.valueOf("Missing the ownership data for partition ") + iBucket);
        }
        int nOwnerLocal = this.getStorageAssignments()[iBucket][iStore];
        if (nOwnerLocal != (nOwnerGlobal = xmlBucket.getAttribute(this.getStorageAttribute()[iStore]).getInt())) {
            int nThisMember = this.getThisMember().getId();
            if (nOwnerLocal == nThisMember ? true : nOwnerGlobal == nThisMember) {
                return false;
            }
            if (this.getServiceMemberSet().contains(nOwnerGlobal) ^ true) {
                nOwnerGlobal = 0;
            }
            this.assignBucketOwner(iBucket, iStore, nOwnerGlobal);
            Component._trace(String.valueOf("The ") + (iStore == 0 ? "primary" : "backup") + " ownership for partition " + iBucket + " has been reset from " + nOwnerLocal + " to " + nOwnerGlobal, 4);
        }
        return true;
    }

    protected int transferBucket(DistributedCache$DistributionRequest msgRequest, com.tangosol.coherence.component.net.Member member, int iBucket, int iStore, int cbTransfer, boolean fLastBucket) {
        LongArray aStorage;
        LongArray longArray = aStorage = this.getStorageArray();
        synchronized (longArray) {
            int cbThreshold = this.getTransferThreshold();
            DistributedCache$TransferRequest msgTransfer = null;
            LongArray.Iterator iterStore = aStorage.iterator();
            while (iterStore.hasNext()) {
                DistributedCache$Storage storage = (DistributedCache$Storage)iterStore.next();
                if (storage.isValid() ^ true) continue;
                ArrayList<Map.Entry> listResource = new ArrayList<Map.Entry>();
                int cbResource = 0;
                Map mapPrime = storage.getResourceMap();
                while (mapPrime.isEmpty() ^ true) {
                    try {
                        Iterator iterResource = mapPrime.entrySet().iterator();
                        while (iterResource.hasNext()) {
                            Map.Entry entry = (Map.Entry)iterResource.next();
                            Binary binKey = (Binary)entry.getKey();
                            if (!(this.getKeyBucket(binKey) == iBucket)) continue;
                            Binary binValue = (Binary)entry.getValue();
                            if (binKey == null ? true : binValue == null) {
                                Component._trace(String.valueOf("Skipping an empty entry during transfer: key=") + binKey + ", value=" + binValue, 3);
                                continue;
                            }
                            cbResource += binKey.length() + binValue.length();
                            listResource.add(entry);
                        }
                        break;
                    }
                    catch (ConcurrentModificationException e) {
                        listResource.clear();
                        cbResource = 0;
                    }
                }
                ArrayList<Lease> listLease = new ArrayList<Lease>();
                int cbLease = 0;
                Map mapLease = storage.getLeaseMap();
                while (mapLease.isEmpty() ^ true) {
                    try {
                        Iterator iterLease = mapLease.values().iterator();
                        while (iterLease.hasNext()) {
                            Lease lease = (Lease)iterLease.next();
                            Binary binKey = (Binary)lease.getResourceKey();
                            if (!(this.getKeyBucket(binKey) == iBucket)) continue;
                            cbLease += binKey.length() + 28;
                            listLease.add(lease);
                        }
                        break;
                    }
                    catch (ConcurrentModificationException e) {
                        listLease.clear();
                        cbLease = 0;
                    }
                }
                ArrayList<Map.Entry> listListen = new ArrayList<Map.Entry>();
                int cbListen = 0;
                Map mapListen = storage.getKeyListenerMap();
                while (!(mapListen != null) ? false : mapListen.isEmpty() ^ true) {
                    try {
                        Iterator iterListener = mapListen.entrySet().iterator();
                        while (iterListener.hasNext()) {
                            Map.Entry entry = (Map.Entry)iterListener.next();
                            Binary binKey = (Binary)entry.getKey();
                            if (!(this.getKeyBucket(binKey) == iBucket)) continue;
                            cbListen += binKey.length() + ((Map)entry.getValue()).size() * 8;
                            listListen.add(entry);
                        }
                        break;
                    }
                    catch (ConcurrentModificationException e) {
                        listListen.clear();
                        cbListen = 0;
                    }
                }
                if (!(cbResource + cbLease + cbListen > 0)) continue;
                fLastBucket |= (cbTransfer += cbResource + cbLease + cbListen) > cbThreshold;
                if (msgTransfer != null) {
                    msgTransfer.setLastCache(false);
                    this.setTransferCount(this.getTransferCount() + 1);
                    this.post(msgTransfer);
                }
                msgTransfer = (DistributedCache$TransferRequest)this.instantiateMessage("TransferRequest");
                if (msgRequest == null) {
                    msgTransfer.addToMember(member);
                } else {
                    msgTransfer.respondTo(msgRequest);
                }
                msgTransfer.setBucket(iBucket);
                msgTransfer.setLastBucket(fLastBucket);
                msgTransfer.setStore(iStore);
                msgTransfer.setCacheId(storage.getCacheId());
                msgTransfer.setResource(listResource.toArray(new Map.Entry[listResource.size()]));
                msgTransfer.setLease(listLease.toArray(new Lease[listLease.size()]));
                msgTransfer.setListener(listListen.toArray(new Map.Entry[listListen.size()]));
            }
            if (msgTransfer == null) {
                fLastBucket |= ++cbTransfer > cbThreshold;
                msgTransfer = (DistributedCache$TransferRequest)this.instantiateMessage("TransferRequest");
                if (msgRequest == null) {
                    msgTransfer.addToMember(member);
                } else {
                    msgTransfer.respondTo(msgRequest);
                }
                msgTransfer.setBucket(iBucket);
                msgTransfer.setLastBucket(fLastBucket);
                msgTransfer.setStore(iStore);
                msgTransfer.setCacheId(-1);
                msgTransfer.setResource(new Map.Entry[0]);
                msgTransfer.setLease(new Lease[0]);
                msgTransfer.setListener(new Map.Entry[0]);
            }
            msgTransfer.setLastCache(true);
            this.setTransferCount(this.getTransferCount() + 1);
            this.post(msgTransfer);
            int n = cbTransfer;
            Object var12_13 = null;
            return n;
        }
    }

    protected boolean transferPrimary(DistributedCache$DistributionRequest msgRequest) {
        int cDirty;
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        int nMemberThis = memberThis.getId();
        com.tangosol.coherence.component.net.Member memberRequest = msgRequest.getFromMember();
        int nMemberRequest = memberRequest.getId();
        int cBackups = this.getBackupCount();
        int cRequest = msgRequest.getBucketsCount();
        int[] aiTransfer = new int[cRequest];
        boolean fStrong = memberThis.getMachineId() != memberRequest.getMachineId();
        int cTransfer = 0;
        int iPass = fStrong ? 1 : 3;
        do {
            int[] aiBucket = iPass == 1 ? this.collectVulnerableBuckets() : this.collectOwnedBuckets();
            cDirty = 0;
            int cBuckets = aiBucket.length;
            int i = 0;
            while (!(i < cBuckets) ? false : cTransfer < cRequest) {
                boolean fTransfer;
                int iBucket = aiBucket[i];
                switch (iPass) {
                    case 1: {
                        fTransfer = true;
                        break;
                    }
                    case 2: {
                        fTransfer = this.isTransferVulnerable(iBucket, 0, memberRequest) ^ true;
                        break;
                    }
                    case 3: {
                        fTransfer = this.isBackupOwner(iBucket, nMemberRequest) ^ true;
                        break;
                    }
                    case 4: {
                        fTransfer = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (fTransfer) {
                    if (this.lockBucket(iBucket, 0L)) {
                        aiTransfer[cTransfer++] = iBucket;
                    } else {
                        ++cDirty;
                    }
                }
                ++i;
            }
            if (!(cTransfer > 0)) continue;
            Component._trace(String.valueOf(iPass) + "> Transferring " + cTransfer + " out of " + cBuckets + (iPass == 1 ? " vulnerable" : " primary") + " partitions to member " + nMemberRequest + " requesting " + cRequest, 5);
            break;
        } while (!(cDirty > 0) && ++iPass <= 4);
        if (cTransfer > 0) {
            int cbTransfer = 0;
            int cbThreshold = this.getTransferThreshold();
            int iTransfer = 0;
            while (iTransfer < cTransfer) {
                int iBucket = aiTransfer[iTransfer];
                this.assignBucketOwner(iBucket, 0, nMemberRequest);
                this.getTransitionalPartitions().add(iBucket);
                cbTransfer = this.transferBucket(msgRequest, null, iBucket, 0, cbTransfer, iTransfer == cTransfer - 1);
                if (!(cbTransfer > cbThreshold) ? false : iTransfer < cTransfer - 1) {
                    Component._trace(String.valueOf("Limiting primary transfer to ") + cbTransfer / 1024 + "KB (" + (iTransfer + 1) + " partitions)", 4);
                    while (++iTransfer < cTransfer) {
                        iBucket = aiTransfer[iTransfer];
                        this.unlockBucket(iBucket);
                    }
                }
                ++iTransfer;
            }
            return true;
        }
        return false;
    }

    protected void unlockAll(DistributedCache$Storage storage) {
        if (this.getDaemonPool().isStarted()) {
            storage.getResourceControlMap().unlock(ConcurrentMap.LOCK_ALL);
            ThreadGate[] aGate = this.getPartitionControl();
            int iBucket = 0;
            int c = aGate.length;
            while (iBucket < c) {
                aGate[iBucket].exit();
                ++iBucket;
            }
        }
    }

    protected void unlockBucket(int iBucket) {
        if (this.getDaemonPool().isStarted()) {
            ThreadGate gate = this.getPartitionControl()[iBucket];
            gate.open();
        }
    }

    protected void unlockKey(Binary binKey, DistributedCache$Storage storage, boolean fExit) {
        if (this.getDaemonPool().isStarted()) {
            storage.getResourceControlMap().unlock((Object)binKey);
            if (fExit) {
                this.getPartitionControl()[this.getKeyBucket(binKey)].exit();
            }
        }
    }

    protected void unlockSynthetic(DistributedCache$Storage storage) {
        if (this.getDaemonPool().isStarted()) {
            storage.getResourceControlMap().unlock((Object)storage);
        }
    }

    protected void unpinBuckets(PartitionSet partitions) {
        if (this.getDaemonPool().isStarted()) {
            ThreadGate[] aGate = this.getPartitionControl();
            int iBucket = partitions.next(0);
            while (iBucket >= 0) {
                aGate[iBucket].exit();
                iBucket = partitions.next(iBucket + 1);
            }
        }
    }

    protected void validateBucketAssignments(MemberSet setOthers) {
        int nMemberThis = this.getThisMember().getId();
        int cBuckets = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        ObservableMap mapConfig = this.getServiceConfigMap();
        String[] asAttr = this.getStorageAttribute();
        int[][] aaiBucketOwner = this.getStorageAssignments();
        boolean fModified = false;
        int iBucket = 0;
        while (iBucket < cBuckets) {
            int[] aiBucketOwner = aaiBucketOwner[iBucket];
            int iStore = 0;
            while (iStore < 1 + cBackups) {
                int nOwner = aiBucketOwner[iStore];
                if (!(!(nOwner > 0) ? false : nOwner != nMemberThis) ? false : setOthers.contains(nOwner) ^ true) {
                    if (fModified ^ true) {
                        aaiBucketOwner = (int[][])aaiBucketOwner.clone();
                        fModified = true;
                    }
                    aiBucketOwner = (int[])aiBucketOwner.clone();
                    aiBucketOwner[iStore] = 0;
                    aaiBucketOwner[iBucket] = aiBucketOwner;
                    XmlElement xmlBucket = (XmlElement)mapConfig.get(Base.makeInteger((int)iBucket));
                    xmlBucket.addAttribute(asAttr[iStore]).setInt(0);
                }
                ++iStore;
            }
            ++iBucket;
        }
        if (fModified) {
            this.setStorageAssignments(aaiBucketOwner);
        }
    }

    protected void validateBucketConfig() {
        int nThisMember = this.getThisMember().getId();
        int nSeniorMember = this.getServiceOldestMember().getId();
        MemberSet setMembers = this.getStorageMemberSet();
        int[][] aaiBucketOwner = this.getStorageAssignments();
        int cBuckets = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        String[] asAttrName = this.getStorageAttribute();
        boolean fValid = true;
        int iBucket = 0;
        while (!(iBucket < cBuckets) ? false : fValid) {
            XmlElement xmlBucket = this.getBucketConfig(iBucket);
            if (xmlBucket == null) {
                throw new IllegalStateException(String.valueOf("Missing the ownership data for partition ") + iBucket);
            }
            int[] aiBucketOwner = aaiBucketOwner[iBucket];
            int iStore = 0;
            while (iStore < 1 + cBackups) {
                int nOwner = xmlBucket.getAttribute(asAttrName[iStore]).getInt();
                if (!(nOwner == nThisMember) ? false : nThisMember != nSeniorMember) {
                    Component._trace(String.valueOf("Waiting for ownership update from member ") + nSeniorMember + " for partition " + iBucket + '\n' + xmlBucket, 3);
                    fValid = false;
                    break;
                }
                aiBucketOwner[iStore] = (nOwner == nThisMember ? true : (!(nOwner > 0) ? false : setMembers.contains(nOwner))) ? nOwner : 0;
                ++iStore;
            }
            ++iBucket;
        }
        if (fValid) {
            boolean fLocalStorage = this.isLocalStorageEnabled();
            this.getThisMemberConfigMap().put("storage-enabled", fLocalStorage);
            this.setAcceptingClients(true);
            if (fLocalStorage) {
                this.setDistributionNextMillis(0L);
            } else {
                this.setDistributionNextMillis(Long.MAX_VALUE);
                this.setAcceptingOthers(true);
            }
        } else {
            long lTimeout;
            long lStart = this.getStartTimestamp();
            long lCurrent = Base.getSafeTimeMillis();
            if (lCurrent > lStart + (lTimeout = (long)((Cluster)this.getCluster()).getPublisher().getResendTimeout())) {
                Component._trace("Failed to synchronize the ownership data; stopping the service", 1);
                this.stop();
            } else {
                this.setDistributionNextMillis(lCurrent + (long)this.getDistributionRepeatMillis());
            }
        }
    }

    protected void validateStorages(com.tangosol.coherence.component.net.Member memberLeft) {
        LongArray aStorage;
        LongArray longArray = aStorage = this.getStorageArray();
        synchronized (longArray) {
            LongArray.Iterator iterStore = aStorage.iterator();
            while (iterStore.hasNext()) {
                DistributedCache$Storage storage = (DistributedCache$Storage)iterStore.next();
                if (!storage.isValid()) continue;
                storage.validateLocks();
                storage.validateListeners();
            }
        }
    }

    public void waitAcceptingClients() {
        super.waitAcceptingClients();
    }
}

