/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.util.Collections;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$DispatchMemberEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$MemberConfigListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$MemberConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$MemberConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$MemberConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyMemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyMemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyMessageReceipt;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyPollClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyServiceAnnounced;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyServiceLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyShutdown;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyStartup;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$PollArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ProtocolContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigMap;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigSync;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.SimpleCache$BackingMapManagerContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.SimpleCache$ConverterFromInternal;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.SimpleCache$ConverterToInternal;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.SimpleCache$NotifyServiceJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.SimpleCache$ResourceRemove;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.SimpleCache$ResourceRemoveAll;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.SimpleCache$ResourceUpdate;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.util.Binary;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Converter;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class SimpleCache
extends Service
implements CacheService,
NamedCache {
    private transient BackingMapManager __m_BackingMapManager;
    private transient Converter __m_ConverterFromInternal;
    private transient Converter __m_ConverterToInternal;
    private transient MapListenerSupport __m_ListenerSupport;
    private transient Map __m_ResourceMap;
    private static ListMap __mapChildren;

    static {
        SimpleCache.__initStatic();
    }

    public SimpleCache() {
        this(null, null, true);
    }

    public SimpleCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAcceptingClients(false);
            this.setAcceptingOthers(false);
            this.setDaemonState(0);
            this.setResourceMap((Map)new SafeHashMap());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this._addChild(new Service$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Service$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Service$MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Service$PollArray("PollArray", this, true), "PollArray");
        this._addChild(new Service$ServiceConfigMap("ServiceConfigMap", this, true), "ServiceConfigMap");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"BackingMapManagerContext", (Object)SimpleCache$BackingMapManagerContext.get_CLASS());
        Object object2 = __mapChildren.put((Object)"ConverterFromInternal", (Object)SimpleCache$ConverterFromInternal.get_CLASS());
        Object object3 = __mapChildren.put((Object)"ConverterToInternal", (Object)SimpleCache$ConverterToInternal.get_CLASS());
        Object object4 = __mapChildren.put((Object)"DispatchMemberEvent", (Object)Service$DispatchMemberEvent.get_CLASS());
        Object object5 = __mapChildren.put((Object)"MemberConfigRequest", (Object)Service$MemberConfigRequest.get_CLASS());
        Object object6 = __mapChildren.put((Object)"MemberConfigResponse", (Object)Service$MemberConfigResponse.get_CLASS());
        Object object7 = __mapChildren.put((Object)"MemberConfigUpdate", (Object)Service$MemberConfigUpdate.get_CLASS());
        Object object8 = __mapChildren.put((Object)"NotifyMemberJoined", (Object)Service$NotifyMemberJoined.get_CLASS());
        Object object9 = __mapChildren.put((Object)"NotifyMemberLeaving", (Object)Service$NotifyMemberLeaving.get_CLASS());
        Object object10 = __mapChildren.put((Object)"NotifyMemberLeft", (Object)Service$NotifyMemberLeft.get_CLASS());
        Object object11 = __mapChildren.put((Object)"NotifyMessageReceipt", (Object)Service$NotifyMessageReceipt.get_CLASS());
        Object object12 = __mapChildren.put((Object)"NotifyPollClosed", (Object)Service$NotifyPollClosed.get_CLASS());
        Object object13 = __mapChildren.put((Object)"NotifyServiceAnnounced", (Object)Service$NotifyServiceAnnounced.get_CLASS());
        Object object14 = __mapChildren.put((Object)"NotifyServiceJoined", (Object)SimpleCache$NotifyServiceJoined.get_CLASS());
        Object object15 = __mapChildren.put((Object)"NotifyServiceLeaving", (Object)Service$NotifyServiceLeaving.get_CLASS());
        Object object16 = __mapChildren.put((Object)"NotifyServiceLeft", (Object)Service$NotifyServiceLeft.get_CLASS());
        Object object17 = __mapChildren.put((Object)"NotifyShutdown", (Object)Service$NotifyShutdown.get_CLASS());
        Object object18 = __mapChildren.put((Object)"NotifyStartup", (Object)Service$NotifyStartup.get_CLASS());
        Object object19 = __mapChildren.put((Object)"ProtocolContext", (Object)Service$ProtocolContext.get_CLASS());
        Object object20 = __mapChildren.put((Object)"Queue", (Object)QueueProcessor$Queue.get_CLASS());
        Object object21 = __mapChildren.put((Object)"ResourceRemove", (Object)SimpleCache$ResourceRemove.get_CLASS());
        Object object22 = __mapChildren.put((Object)"ResourceRemoveAll", (Object)SimpleCache$ResourceRemoveAll.get_CLASS());
        Object object23 = __mapChildren.put((Object)"ResourceUpdate", (Object)SimpleCache$ResourceUpdate.get_CLASS());
        Object object24 = __mapChildren.put((Object)"ServiceConfigRequest", (Object)Service$ServiceConfigRequest.get_CLASS());
        Object object25 = __mapChildren.put((Object)"ServiceConfigResponse", (Object)Service$ServiceConfigResponse.get_CLASS());
        Object object26 = __mapChildren.put((Object)"ServiceConfigSync", (Object)Service$ServiceConfigSync.get_CLASS());
        Object object27 = __mapChildren.put((Object)"ServiceConfigUpdate", (Object)Service$ServiceConfigUpdate.get_CLASS());
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        throw new UnsupportedOperationException();
    }

    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, null, false);
    }

    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support == null) {
            support = new MapListenerSupport();
            this.setListenerSupport(support);
        }
        support.addListener(listener, filter, fLite);
    }

    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support == null) {
            support = new MapListenerSupport();
            this.setListenerSupport(support);
        }
        support.addListener(listener, oKey, fLite);
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        return this.aggregate(this.keySet(filter), agent);
    }

    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        return agent.aggregate(InvocableMapHelper.makeEntrySet((Map)((Object)this), (Collection)collKeys, (boolean)true));
    }

    protected void checkStatus() {
        if (this.getServiceState() != Service.SERVICE_STARTED) {
            throw new IllegalStateException(String.valueOf("Service is not running: ") + this);
        }
        if (this.isActive() ^ true) {
            throw new IllegalStateException(String.valueOf("Map has been invalidated:\n") + this);
        }
    }

    public void clear() {
        this.checkStatus();
        this.getResourceMap().clear();
        SimpleCache$ResourceRemoveAll msg = (SimpleCache$ResourceRemoveAll)this.instantiateMessage("ResourceRemoveAll");
        msg.setToMemberSet(this.getOthersMemberSet());
        this.send(msg);
    }

    public boolean containsKey(Object oKey) {
        this.checkStatus();
        return this.getResourceMap().containsKey(oKey);
    }

    public boolean containsValue(Object oValue) {
        this.checkStatus();
        return this.getResourceMap().containsValue(oValue);
    }

    public void destroy() {
        this.clear();
        try {
            Thread.sleep(500);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.shutdown();
    }

    public void destroyCache(NamedCache map) {
        Component._assert(map == this);
        this.destroy();
    }

    public void doResourceRemove(Object oKey) {
        Map map = this.getResourceMap();
        if (map.containsKey(oKey)) {
            MapListenerSupport support;
            Object oValueOld = map.remove(oKey);
            if (this.isActive() && (support = this.getListenerSupport()) != null) {
                MapEvent event = new MapEvent((ObservableMap)this, MapEvent.ENTRY_DELETED, oKey, oValueOld, null);
                event = MapListenerSupport.convertEvent((MapEvent)event, (ObservableMap)this, null, (Converter)this.getConverterFromInternal());
                support.fireEvent(event, true);
            }
        }
    }

    public void doResourceRemoveAll() {
        this.getResourceMap().clear();
    }

    public void doResourceUpdate(Object oKey, Object oValue) {
        MapListenerSupport support;
        Map map = this.getResourceMap();
        boolean fUpdate = map.containsKey(oKey);
        Object oValueOld = map.put(oKey, oValue);
        if (this.isActive() && (support = this.getListenerSupport()) != null) {
            MapEvent event = new MapEvent((ObservableMap)this, fUpdate ? MapEvent.ENTRY_UPDATED : MapEvent.ENTRY_INSERTED, oKey, oValueOld, oValue);
            event = MapListenerSupport.convertEvent((MapEvent)event, (ObservableMap)this, null, (Converter)this.getConverterFromInternal());
            support.fireEvent(event, true);
        }
    }

    public void doWelcome(Member member) {
        if (this.getThisMember() == this.getServiceOldestMember()) {
            Enumeration enumeration = this.getResourceKeys();
            while (enumeration.hasMoreElements()) {
                Object oKey = enumeration.nextElement();
                SimpleCache$ResourceUpdate msg = (SimpleCache$ResourceUpdate)this.instantiateMessage("ResourceUpdate");
                msg.addToMember(member);
                msg.setLease(Lease.instantiate(-1, oKey, this));
                msg.setResource(this.getResourceMap().get(oKey));
                this.send(msg);
            }
        }
    }

    public synchronized NamedCache ensureCache(String sName, ClassLoader loader) {
        if (sName.equals(this.getServiceName())) {
            BackingMapManager manager = this.getBackingMapManager();
            if (manager != null) {
                Map map = manager.instantiateBackingMap(sName);
                if (map == null) {
                    throw new RuntimeException(String.valueOf("BackingMapManager returned \"null\" for map ") + sName);
                }
                map.putAll(this.getResourceMap());
                this.setResourceMap(map);
            }
            if (loader == null && (loader = this.getContextClassLoader()) == null) {
                loader = this.getClass().getClassLoader();
                Component._assert(loader != null, "ClassLoader must be specified");
            }
            if (loader != this.getContextClassLoader()) {
                this.releaseClassLoader();
                this.setContextClassLoader(loader);
            }
            return this;
        }
        throw new UnsupportedOperationException("Only one cache per service is allowed");
    }

    public Set entrySet() {
        this.checkStatus();
        return java.util.Collections.unmodifiableSet(this.getResourceMap().entrySet());
    }

    public Set entrySet(Filter filter) {
        return InvocableMapHelper.query((Map)((Object)this), (Filter)filter, (boolean)true, (boolean)false, null);
    }

    public Set entrySet(Filter filter, Comparator comparator) {
        return InvocableMapHelper.query((Map)((Object)this), (Filter)filter, (boolean)true, (boolean)true, (Comparator)comparator);
    }

    public Object get(Object oKey) {
        this.checkStatus();
        Map mapResource = this.getResourceMap();
        Object oResource = mapResource.get(oKey);
        if (oResource instanceof Binary) {
            Binary binValue = (Binary)oResource;
            try {
                oResource = this.getConverterFromInternal().convert((Object)binValue);
            }
            catch (WrapperException e) {
                throw new WrapperException(e.getOriginalException(), String.valueOf("CacheName=") + this.getCacheName() + ", Key=" + oKey);
            }
            Map map = mapResource;
            synchronized (map) {
                if (binValue == mapResource.get(oKey)) {
                    mapResource.put(oKey, oResource);
                }
            }
        }
        return oResource;
    }

    public Map getAll(Collection colKeys) {
        HashMap mapResult = new HashMap(colKeys.size());
        Iterator iter = colKeys.iterator();
        while (iter.hasNext()) {
            Object oKey = iter.next();
            Object oVal = this.get(oKey);
            if (!(oVal != null ? true : this.containsKey(oKey))) continue;
            mapResult.put(oKey, oVal);
        }
        return mapResult;
    }

    public BackingMapManager getBackingMapManager() {
        return this.__m_BackingMapManager;
    }

    public String getCacheName() {
        return this.getServiceName();
    }

    public Enumeration getCacheNames() {
        return new SimpleEnumerator((Object[])new String[]{this.getServiceName()});
    }

    public CacheService getCacheService() {
        return this;
    }

    public Converter getConverterFromInternal() {
        Converter conv = this.__m_ConverterFromInternal;
        if (conv == null) {
            SimpleCache simpleCache = this;
            synchronized (simpleCache) {
                conv = this.__m_ConverterFromInternal;
                if (conv == null) {
                    conv = this.instantiateConverterFromInternal(this.getContextClassLoader());
                    this.setConverterFromInternal(conv);
                }
            }
        }
        return conv;
    }

    public Converter getConverterToInternal() {
        Converter conv = this.__m_ConverterToInternal;
        if (conv == null) {
            SimpleCache simpleCache = this;
            synchronized (simpleCache) {
                conv = this.__m_ConverterToInternal;
                if (conv == null) {
                    conv = this.instantiateConverterToInternal();
                    this.setConverterToInternal(conv);
                }
            }
        }
        return conv;
    }

    public MapListenerSupport getListenerSupport() {
        return this.__m_ListenerSupport;
    }

    public Enumeration getResourceKeys() {
        return new SimpleEnumerator(this.getResourceMap().keySet().toArray());
    }

    public Map getResourceMap() {
        return this.__m_ResourceMap;
    }

    public String getServiceType() {
        return "SimpleCache";
    }

    public String getServiceVersion() {
        return "2.5";
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/SimpleCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new SimpleCache();
    }

    private final Component get_Module() {
        return this;
    }

    protected Converter instantiateConverterFromInternal(ClassLoader loader) {
        SimpleCache$ConverterFromInternal conv = (SimpleCache$ConverterFromInternal)this._newChild("ConverterFromInternal");
        conv.setClassLoader(loader == null ? this.getContextClassLoader() : loader);
        return conv;
    }

    protected Converter instantiateConverterToInternal() {
        return (SimpleCache$ConverterToInternal)this._newChild("ConverterToInternal");
    }

    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        return InvocableMapHelper.invokeLocked((ConcurrentMap)this, (InvocableMap.Entry)InvocableMapHelper.makeEntry((Map)((Object)this), (Object)oKey), (InvocableMap.EntryProcessor)agent);
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        return this.invokeAll(this.keySet(filter), agent);
    }

    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        return InvocableMapHelper.invokeAllLocked((ConcurrentMap)this, (Set)InvocableMapHelper.makeEntrySet((Map)((Object)this), (Collection)collKeys, (boolean)false), (InvocableMap.EntryProcessor)agent);
    }

    public boolean isActive() {
        return this.getContextClassLoader() != null;
    }

    public boolean isEmpty() {
        this.checkStatus();
        return this.getResourceMap().isEmpty();
    }

    public Set keySet() {
        this.checkStatus();
        return java.util.Collections.unmodifiableSet(this.getResourceMap().keySet());
    }

    public Set keySet(Filter filter) {
        return InvocableMapHelper.query((Map)((Object)this), (Filter)filter, (boolean)false, (boolean)false, null);
    }

    public boolean lock(Object oKey) {
        return this.lock(oKey, 0);
    }

    public boolean lock(Object oKey, long cWait) {
        throw new UnsupportedOperationException();
    }

    public void onServiceStarted() {
        BackingMapManager manager = this.getBackingMapManager();
        if (manager != null) {
            SimpleCache$BackingMapManagerContext ctx = (SimpleCache$BackingMapManagerContext)this._newChild("BackingMapManagerContext");
            ctx.setManager(manager);
            manager.init((BackingMapManagerContext)ctx);
        }
        super.onServiceStarted();
    }

    public Object put(Object oKey, Object oValue) {
        return this.put(oKey, oValue, 0L);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        this.checkStatus();
        if (!(oValue != null) ? false : oValue instanceof Serializable ^ true) {
            throw new IllegalArgumentException(String.valueOf("Resource is not serializable: ") + "Key=" + oKey + ", Value=" + oValue);
        }
        Object oValueOld = this.get(oKey);
        Map map = this.getResourceMap();
        if (map instanceof CacheMap) {
            ((CacheMap)map).put(oKey, oValue, cMillis);
        } else if (cMillis <= (long)0) {
            map.put(oKey, oValue);
        } else {
            throw new UnsupportedOperationException(String.valueOf("Class \"") + map.getClass().getName() + "\" does not implement CacheMap interface");
        }
        SimpleCache$ResourceUpdate msg = (SimpleCache$ResourceUpdate)this.instantiateMessage("ResourceUpdate");
        msg.setToMemberSet(this.getOthersMemberSet());
        msg.setLease(Lease.instantiate(-1, oKey, this));
        msg.setResource(oValue);
        this.send(msg);
        return oValueOld;
    }

    public void putAll(Map map) {
        Collections.putAll((Map)((Object)this), map);
    }

    public void release() {
        this.shutdown();
    }

    public void releaseCache(NamedCache map) {
        Component._assert(map == this);
        this.release();
    }

    protected void releaseClassLoader() {
        ClassLoader loader = this.getContextClassLoader();
        if (loader != null) {
            this.setContextClassLoader(null);
            Map map = this.getResourceMap();
            Iterator iter = this.keySet().iterator();
            while (iter.hasNext()) {
                Object oKey = iter.next();
                Object oValue = map.get(oKey);
                try {
                    Object oInternal = this.getConverterToInternal().convert(oValue);
                    if (!(oInternal != oValue)) continue;
                    oValue = oInternal;
                    map.put(oKey, oValue);
                }
                catch (WrapperException e) {
                    throw new WrapperException(e.getOriginalException(), String.valueOf("CacheName=") + this.getCacheName() + ", Key=" + oKey);
                }
            }
        }
    }

    public Object remove(Object oKey) {
        this.checkStatus();
        Object oValue = this.get(oKey);
        this.getResourceMap().remove(oKey);
        SimpleCache$ResourceRemove msg = (SimpleCache$ResourceRemove)this.instantiateMessage("ResourceRemove");
        msg.setToMemberSet(this.getOthersMemberSet());
        msg.setLease(Lease.instantiate(-1, oKey, this));
        this.send(msg);
        return oValue;
    }

    public void removeIndex(ValueExtractor extractor) {
        throw new UnsupportedOperationException();
    }

    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, null);
    }

    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support != null) {
            support.removeListener(listener, filter);
            if (support.isEmpty()) {
                this.setListenerSupport(null);
            }
        }
    }

    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support != null) {
            support.removeListener(listener, oKey);
            if (support.isEmpty()) {
                this.setListenerSupport(null);
            }
        }
    }

    public void setBackingMapManager(BackingMapManager manager) {
        this.__m_BackingMapManager = manager;
    }

    protected void setConverterFromInternal(Converter conv) {
        this.__m_ConverterFromInternal = conv;
    }

    protected void setConverterToInternal(Converter pConverterToInternal) {
        this.__m_ConverterToInternal = pConverterToInternal;
    }

    protected void setListenerSupport(MapListenerSupport support) {
        this.__m_ListenerSupport = support;
    }

    protected void setResourceMap(Map map) {
        this.__m_ResourceMap = map;
    }

    public int size() {
        this.checkStatus();
        return this.getResourceMap().size();
    }

    public synchronized void stop() {
        super.stop();
        this.setContextClassLoader(null);
        this.setResourceMap(java.util.Collections.EMPTY_MAP);
    }

    public boolean unlock(Object oKey) {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        this.checkStatus();
        return java.util.Collections.unmodifiableCollection(this.getResourceMap().values());
    }
}

