/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.queue;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.Queue$Iterator;
import com.tangosol.util.AtomicCounter;
import com.tangosol.util.ListMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.WrapperException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConcurrentQueue
extends Queue {
    public static final int FLUSH_AUTO = 1;
    public static final int FLUSH_EXPLICIT = 2;
    public static final int FLUSH_PENDING = 0;
    private transient AtomicCounter __m_AtomicFlushState;
    private transient int __m_BatchSize;
    private AtomicCounter __m_ElementCounter;
    private Object __m_Notifier;
    private long __m_StatsEmptied;
    private long __m_StatsFlushed;
    private static ListMap __mapChildren;

    static {
        ConcurrentQueue.__initStatic();
    }

    public ConcurrentQueue() {
        this(null, null, true);
    }

    public ConcurrentQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBatchSize(1);
            this.setElementList((List)new RecyclingLinkedList());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Iterator", (Object)Queue$Iterator.get_CLASS());
    }

    public boolean add(Object oElement) {
        if (oElement == null) {
            throw new IllegalArgumentException("The ConcurrentQueue does not support null values.");
        }
        this.getElementList().add(oElement);
        this.onAddElement();
        return true;
    }

    public boolean addHead(Object oElement) {
        if (oElement == null) {
            throw new IllegalArgumentException("The ConcurrentQueue does not support null values.");
        }
        this.getElementList().add(0, oElement);
        this.onAddElement();
        return true;
    }

    protected void checkFlush(int cElements) {
        if (this.getNotifier() != null) {
            int nFlushState;
            if (cElements == 1) {
                nFlushState = FLUSH_PENDING;
                this.updateFlushState(nFlushState);
            } else {
                nFlushState = this.getFlushState();
            }
            switch (nFlushState) {
                case 0: {
                    if (!(cElements % this.getBatchSize() == 0)) break;
                    this.flush(true);
                    break;
                }
                case 2: {
                    this.updateFlushStateConditionally(FLUSH_EXPLICIT, FLUSH_AUTO);
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    public void flush() {
        this.flush(false);
    }

    protected void flush(boolean fAuto) {
        Object oNotifier;
        if (this.updateFlushState(fAuto ? FLUSH_AUTO : FLUSH_EXPLICIT) == FLUSH_PENDING && (oNotifier = this.getNotifier()) != null) {
            Object object = oNotifier;
            synchronized (object) {
                this.setStatsFlushed(this.getStatsFlushed() + 1L);
                oNotifier.notifyAll();
            }
        }
    }

    protected AtomicCounter getAtomicFlushState() {
        return this.__m_AtomicFlushState;
    }

    public int getBatchSize() {
        return this.__m_BatchSize;
    }

    public AtomicCounter getElementCounter() {
        return this.__m_ElementCounter;
    }

    public int getFlushState() {
        return (int)this.getAtomicFlushState().getCount();
    }

    public Object getNotifier() {
        return this.__m_Notifier;
    }

    public long getStatsEmptied() {
        return this.__m_StatsEmptied;
    }

    public long getStatsFlushed() {
        return this.__m_StatsFlushed;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/queue/ConcurrentQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ConcurrentQueue();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFlushPending() {
        return this.getFlushState() == FLUSH_PENDING;
    }

    public Iterator iterator() {
        throw new UnsupportedOperationException();
    }

    protected void onAddElement() {
        this.checkFlush((int)this.getElementCounter().increment());
    }

    protected void onEmpty() {
        this.setStatsEmptied(this.getStatsEmptied() + 1L);
    }

    public void onInit() {
        this.setElementCounter(AtomicCounter.newAtomicCounter());
        this.setAtomicFlushState(AtomicCounter.newAtomicCounter((long)FLUSH_PENDING));
        this.setNotifier(this);
        super.onInit();
    }

    public Object peekNoWait() {
        try {
            return this.isEmpty() ? null : this.getElementList().get(0);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Object remove() {
        Object o;
        while (!((o = this.removeNoWait()) != null)) {
            this.waitForEntry(0L);
        }
        return o;
    }

    /*
     * WARNING - void declaration
     */
    public Object removeNoWait() {
        AtomicCounter counter = this.getElementCounter();
        if (counter.getCount() == 0L) {
            return null;
        }
        try {
            void e;
            Object oEntry = this.getElementList().remove(0);
            if (counter.decrement() == 0L) {
                this.onEmpty();
            }
            return e;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    protected void setAtomicFlushState(AtomicCounter atomicState) {
        Component._assert(this.getAtomicFlushState() == null);
        this.__m_AtomicFlushState = atomicState;
    }

    public void setBatchSize(int cBatch) {
        if (cBatch > 0) {
            this.__m_BatchSize = cBatch;
        }
    }

    protected void setElementCounter(AtomicCounter counter) {
        this.__m_ElementCounter = counter;
    }

    public void setNotifier(Object oNotifier) {
        this.__m_Notifier = oNotifier;
    }

    protected void setStatsEmptied(long cEmptied) {
        this.__m_StatsEmptied = cEmptied;
    }

    protected void setStatsFlushed(long cFlush) {
        this.__m_StatsFlushed = cFlush;
    }

    public int size() {
        return (int)this.getElementCounter().getCount();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append(" size=").append(this.size()).append(", emptied=").append(this.getStatsEmptied()).append(", flushed=").append(this.getStatsFlushed()).append(", first=").append(this.peekNoWait());
        return sb.toString();
    }

    protected int updateFlushState(int nState) {
        return (int)this.getAtomicFlushState().setCount((long)nState);
    }

    protected boolean updateFlushStateConditionally(int nStateAssumed, int nStateNew) {
        return this.getAtomicFlushState().setCount((long)nStateAssumed, (long)nStateNew);
    }

    public void waitForEntry(long cMillis) {
        if (this.isEmpty()) {
            try {
                Object oNotifier = this.getNotifier();
                if (oNotifier == null) {
                    throw new UnsupportedOperationException("blocking remove without a notifier");
                }
                Object object = oNotifier;
                synchronized (object) {
                    if (this.isEmpty()) {
                        oNotifier.wait(cMillis);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WrapperException((Throwable)e);
            }
        }
    }
}

