/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.windowedArray;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.coherence.component.util.windowedArray.ConcurrentWindowedArray$PlaceHolder;
import com.tangosol.util.AtomicCounter;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import java.util.Map;

public abstract class ConcurrentWindowedArray
extends WindowedArray {
    private volatile long __m_AssumedFirstIndex;
    private AtomicCounter __m_AtomicLastIndex;
    private transient long __m_LockOffset;
    private ConcurrentWindowedArray$PlaceHolder[] __m_RecentPlaceHolders;
    private long __m_StatsGetsOptimistic;
    private long __m_StatsPlaceHolderAllocations;
    private long __m_StatsWaits;
    private AtomicCounter __m_WaitingThreadCount;
    private static ListMap __mapChildren;

    static {
        ConcurrentWindowedArray.__initStatic();
    }

    public ConcurrentWindowedArray(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"PlaceHolder", (Object)ConcurrentWindowedArray$PlaceHolder.get_CLASS());
    }

    public long add(Object o) {
        long iVirtual = this.getAtomicLastIndex().increment();
        this.setInternal(iVirtual, o);
        return iVirtual;
    }

    protected void assignIndexToValue(long lVirtual, Object o) {
    }

    protected void ensureLastIndexMinimum(long lVirtual) {
        long lvLast;
        AtomicCounter atomicLast = this.getAtomicLastIndex();
        while (!((lvLast = atomicLast.getCount()) >= lVirtual ? true : atomicLast.setCount(lvLast, lVirtual))) {
        }
    }

    public String formatStats() {
        StringBuffer sb = new StringBuffer(super.formatStats());
        sb.append(", optimistic gets=").append(this.getStatsGetsOptimistic()).append(", place holder allocations=").append(this.getStatsPlaceHolderAllocations()).append(", waits=").append(this.getStatsWaits()).append(", waiting threads=").append(this.getWaitingThreadCount().getCount());
        return sb.toString();
    }

    public Object get(long lVirtual) {
        Object oValue;
        Object[] aoStore = this.getStableStore();
        int iActual = (int)(lVirtual % (long)aoStore.length);
        Object object = this.getIndexLock(lVirtual);
        synchronized (object) {
            oValue = aoStore[iActual];
        }
        return (!(this.safeRetrieveIndexFromValue(oValue, iActual) == lVirtual) ? false : oValue instanceof ConcurrentWindowedArray$PlaceHolder ^ true) ? oValue : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(long lVirtual, long cMillis) throws InterruptedException {
        long ldtTimeout = cMillis > 0L ? System.currentTimeMillis() + cMillis : 0L;
        while (true) {
            Object oLock;
            Object[] aoStore = this.getStableStore();
            int iActual = (int)(lVirtual % (long)aoStore.length);
            Object object = oLock = this.getIndexLock(lVirtual);
            synchronized (object) {
                boolean bl;
                Object oValue = aoStore[iActual];
                long lvFound = this.safeRetrieveIndexFromValue(oValue, iActual);
                if (lvFound > lVirtual) return null;
                boolean bl2 = false;
                if (bl2) {
                    return null;
                }
                if (!(lvFound < lVirtual ? true : oValue instanceof ConcurrentWindowedArray$PlaceHolder)) return oValue;
                if (cMillis == 0L) return null;
                boolean bl3 = false;
                if (bl3) {
                    return null;
                }
                long cMillisLeft = this.waitIndex(oLock, ldtTimeout);
                if (!(cMillis > 0L)) {
                    bl = false;
                } else {
                    if (cMillisLeft <= 0L) return null;
                    boolean bl4 = false;
                    if (bl4) {
                        return null;
                    }
                    if (cMillisLeft > cMillis) return null;
                    bl = false;
                }
                if (bl) {
                    return null;
                }
            }
        }
    }

    public int getAll(long[] alIndex, int cEntries, Object[] aoResult) {
        Object[] aoStore = this.getStableStore();
        int cCapacity = aoStore.length;
        int cFound = 0;
        int iReq = 0;
        while (iReq < cEntries) {
            Object oValue;
            long lVirtual = alIndex[iReq];
            int iActual = (int)(lVirtual % (long)cCapacity);
            Object object = this.getIndexLock(lVirtual);
            synchronized (object) {
                oValue = aoStore[iActual];
            }
            if (!(this.safeRetrieveIndexFromValue(oValue, iActual) == lVirtual) ? false : oValue instanceof ConcurrentWindowedArray$PlaceHolder ^ true) {
                ++cFound;
                aoResult[iReq] = oValue;
            } else {
                aoResult[iReq] = null;
            }
            ++iReq;
        }
        return cFound;
    }

    protected long getAssumedFirstIndex() {
        return this.__m_AssumedFirstIndex;
    }

    protected AtomicCounter getAtomicLastIndex() {
        return this.__m_AtomicLastIndex;
    }

    public long getFirstIndex() {
        long lvAssumed = this.getAssumedFirstIndex();
        Object[] aoStore = this.getStableStore();
        int cCapacity = aoStore.length;
        long lVirtual = lvAssumed;
        while (true) {
            int iActual;
            if (this.safeRetrieveIndexFromValue(aoStore[iActual = (int)(lVirtual % (long)cCapacity)], iActual) <= lVirtual) {
                Object object = this.getIndexLock(lVirtual);
                synchronized (object) {
                    long lvFound = this.safeRetrieveIndexFromValue(aoStore[iActual], iActual);
                    if (lvFound == lVirtual) {
                        if (lVirtual != lvAssumed) {
                            this.setAssumedFirstIndex(lVirtual);
                        }
                        long l = lVirtual;
                        Object var13_9 = null;
                        return l;
                    }
                    if (lvFound < lVirtual) {
                        throw new IllegalStateException(String.valueOf(lvFound) + ", " + lVirtual);
                    }
                }
            }
            ++lVirtual;
        }
    }

    protected Object getIndexLock(long lVirtual) {
        return Base.getCommonMonitor((long)(this.getLockOffset() + lVirtual));
    }

    public long getLastIndex() {
        return this.getAtomicLastIndex().getCount();
    }

    protected long getLockOffset() {
        return this.__m_LockOffset;
    }

    protected Object getPlaceHolder(long lOffset) {
        ConcurrentWindowedArray$PlaceHolder[] aHolders = this.getRecentPlaceHolders();
        int iOldest = 0;
        long lOldestOffset = Long.MAX_VALUE;
        int i = 0;
        int c = aHolders.length;
        while (i < c) {
            ConcurrentWindowedArray$PlaceHolder holder = aHolders[i];
            if (holder == null) {
                lOldestOffset = -1L;
                iOldest = i;
            } else {
                long lFoundOffset = holder.getVirtualOffset();
                if (lFoundOffset == lOffset) {
                    return holder;
                }
                if (lFoundOffset < lOldestOffset) {
                    lOldestOffset = lOffset;
                    iOldest = i;
                }
            }
            ++i;
        }
        if (lOffset < 0L) {
            throw new IllegalStateException();
        }
        ConcurrentWindowedArray$PlaceHolder holder = new ConcurrentWindowedArray$PlaceHolder();
        holder.setVirtualOffset(lOffset);
        aHolders[iOldest] = holder;
        this.setStatsPlaceHolderAllocations(this.getStatsPlaceHolderAllocations() + 1L);
        return holder;
    }

    protected ConcurrentWindowedArray$PlaceHolder[] getRecentPlaceHolders() {
        return this.__m_RecentPlaceHolders;
    }

    protected Object[] getStableStore() {
        Object[] aoStore = this.getStore();
        if (aoStore == null) {
            ConcurrentWindowedArray concurrentWindowedArray = this;
            synchronized (concurrentWindowedArray) {
                aoStore = this.getStore();
            }
            Component._assert(aoStore != null);
        }
        return aoStore;
    }

    public long getStatsGetsOptimistic() {
        return this.__m_StatsGetsOptimistic;
    }

    public long getStatsPlaceHolderAllocations() {
        return this.__m_StatsPlaceHolderAllocations;
    }

    public long getStatsWaits() {
        return this.__m_StatsWaits;
    }

    protected AtomicCounter getWaitingThreadCount() {
        return this.__m_WaitingThreadCount;
    }

    public int getWindowSize() {
        return (int)(this.getLastIndex() - this.getFirstIndex() + (long)1);
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/windowedArray/ConcurrentWindowedArray".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    protected void grow(long lVirtual) {
        Object[] aoStore = this.getStore();
        long lvFirst = this.getFirstIndex();
        int cOldCapacity = aoStore.length;
        int cNewCapacity = this.checkCapacity(Math.max(cOldCapacity * 2, (int)(lVirtual - lvFirst) + 3));
        try {
            this.setStore(null);
            long lvLast = this.getLastIndex();
            int cReqCapacity = (int)(lvLast - lvFirst) + 1;
            if (cReqCapacity > cNewCapacity) {
                if (cReqCapacity > this.getMaximumCapacity()) {
                    throw new IndexOutOfBoundsException(String.valueOf(this.get_Name()) + " has exceeded max capacity");
                }
                cNewCapacity = cReqCapacity;
            }
            Object[] aoNew = new Object[cNewCapacity];
            int iaNewFirst = (int)(lvFirst % (long)cNewCapacity);
            long lNewOffset = lvFirst - (long)iaNewFirst;
            Object oFree = this.getPlaceHolder(lNewOffset);
            int iActual = iaNewFirst;
            while (iActual < cNewCapacity) {
                aoNew[iActual] = oFree;
                ++iActual;
            }
            oFree = this.getPlaceHolder(lNewOffset + (long)cNewCapacity);
            iActual = 0;
            while (iActual < iaNewFirst) {
                aoNew[iActual] = oFree;
                ++iActual;
            }
            long lvNext = lvFirst;
            while (lvNext <= lvLast) {
                Object oOld;
                int iaOld = (int)(lvNext % (long)cOldCapacity);
                Object object = this.getIndexLock(lvNext);
                synchronized (object) {
                    oOld = aoStore[iaOld];
                }
                long lvFound = this.safeRetrieveIndexFromValue(oOld, iaOld);
                int iaNew = (int)(lvNext % (long)cNewCapacity);
                if (!(lvFound == lvNext) ? false : oOld instanceof ConcurrentWindowedArray$PlaceHolder ^ true) {
                    aoNew[iaNew] = oOld;
                } else if (lvFound > lvNext) {
                    aoNew[iaNew] = this.getPlaceHolder(lvNext + (long)cNewCapacity - (long)iaNew);
                }
                ++lvNext;
            }
            aoStore = aoNew;
        }
        finally {
            Object var9_20 = null;
            this.setStore(aoStore);
            this.setStatsExpansions(this.getStatsExpansions() + 1);
        }
    }

    public boolean isRemoved(long lVirtual) {
        int iActual;
        Object[] aoStore = this.getStableStore();
        Object oValue = aoStore[iActual = (int)(lVirtual % (long)aoStore.length)];
        if (this.safeRetrieveIndexFromValue(oValue, iActual) > lVirtual) {
            return true;
        }
        Object object = this.getIndexLock(lVirtual);
        synchronized (object) {
            oValue = aoStore[iActual];
        }
        return this.safeRetrieveIndexFromValue(oValue, iActual) > lVirtual;
    }

    public void onInit() {
        this.setAtomicLastIndex(AtomicCounter.newAtomicCounter((long)-1L));
        this.setWaitingThreadCount(AtomicCounter.newAtomicCounter((long)0L));
        this.setLockOffset(System.identityHashCode(this));
        this.setRecentPlaceHolders(new ConcurrentWindowedArray$PlaceHolder[3]);
        super.onInit();
        Object[] aoStore = this.getStore();
        Object oFree = this.getPlaceHolder(0L);
        int i = 0;
        int c = aoStore.length;
        while (i < c) {
            aoStore[i] = oFree;
            ++i;
        }
        this.setStore(aoStore);
    }

    public Object optimisticGet(long lVirtual) {
        int iActual;
        Object oValue;
        Object[] aoStore = this.getStore();
        if (aoStore != null && (!(this.safeRetrieveIndexFromValue(oValue = aoStore[iActual = (int)(lVirtual % (long)aoStore.length)], iActual) == lVirtual) ? false : oValue instanceof ConcurrentWindowedArray$PlaceHolder ^ true)) {
            this.setStatsGetsOptimistic(this.getStatsGetsOptimistic() + 1L);
            return oValue;
        }
        return null;
    }

    public Object remove(long lVirtual) {
        if (lVirtual > this.getLastIndex()) {
            throw new IndexOutOfBoundsException("cannot remove beyond the window");
        }
        try {
            return this.removeInternal(lVirtual, 0L, false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object removeInternal(long lVirtual, long cMillis, boolean fSafe) throws InterruptedException {
        Object[] aoStore;
        Object oLock;
        if (lVirtual < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf("negative index is illegal: ") + lVirtual);
        }
        Object oResult = null;
        int cCapacity = 0;
        boolean fBlocking = cMillis != 0L;
        long ldtTimeout = cMillis > 0L ? System.currentTimeMillis() + cMillis : 0L;
        int iActual = 0;
        if (!fBlocking ? false : fSafe ^ true) {
            throw new IllegalArgumentException("Blocking remove cannot remove nulls");
        }
        while (true) {
            block25: {
                Object object = oLock = this.getIndexLock(lVirtual);
                synchronized (object) {
                    block24: {
                        block23: {
                            aoStore = this.getStore();
                            if (aoStore != null) {
                                cCapacity = aoStore.length;
                                iActual = (int)(lVirtual % (long)cCapacity);
                                oResult = aoStore[iActual];
                                long lvFound = this.safeRetrieveIndexFromValue(oResult, iActual);
                                if (lvFound > lVirtual) return null;
                                boolean bl = false;
                                if (bl) {
                                    return null;
                                }
                                if (lvFound < lVirtual ? true : (!fSafe ? false : oResult instanceof ConcurrentWindowedArray$PlaceHolder)) {
                                    if (fBlocking) {
                                        boolean bl2;
                                        long cMillisLeft = this.waitIndex(oLock, ldtTimeout);
                                        if (!(cMillis >= 0L)) {
                                            bl2 = false;
                                        } else {
                                            if (cMillisLeft <= 0L) return null;
                                            boolean bl3 = false;
                                            if (bl3) {
                                                return null;
                                            }
                                            if (cMillisLeft > cMillis) return null;
                                            bl2 = false;
                                        }
                                        if (bl2) {
                                            return null;
                                        }
                                        break block23;
                                    } else {
                                        if (!fSafe) throw new IndexOutOfBoundsException("cannot remove beyond the window");
                                        return null;
                                    }
                                }
                                aoStore[iActual] = this.getPlaceHolder(lVirtual - (long)iActual + (long)cCapacity);
                                if (this.getWaitingThreadCount().getCount() > 0L) {
                                    oLock.notifyAll();
                                }
                                break block24;
                            }
                        }
                        break block25;
                    }
                    Object var20_20 = null;
                    break;
                }
            }
            if (!(aoStore == null)) continue;
            this.getStableStore();
        }
        oLock = this.getIndexLock(lVirtual + (long)cCapacity);
        synchronized (oLock) {
        }
        if (lVirtual == this.getAssumedFirstIndex()) {
            long lvFirst = lVirtual + 1L;
            while (true) {
                if (this.safeRetrieveIndexFromValue(aoStore[iActual = (int)(lvFirst % (long)cCapacity)], iActual) <= lvFirst) {
                    this.setAssumedFirstIndex(lvFirst);
                    break;
                }
                ++lvFirst;
            }
        }
        if (oResult instanceof ConcurrentWindowedArray$PlaceHolder) {
            return null;
        }
        Object object = oResult;
        return object;
    }

    protected long retrieveIndexFromValue(Object o) {
        return 0L;
    }

    public Object safeRemove(long lVirtual) {
        try {
            return this.removeInternal(lVirtual, 0L, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    public Object safeRemove(long lVirtual, long cMillis) throws InterruptedException {
        return this.removeInternal(lVirtual, cMillis, true);
    }

    protected long safeRetrieveIndexFromValue(Object o, int iActual) {
        return o instanceof ConcurrentWindowedArray$PlaceHolder ? ((ConcurrentWindowedArray$PlaceHolder)o).getVirtualIndex(iActual) : this.retrieveIndexFromValue(o);
    }

    public Object set(long lVirtual, Object o) {
        if (lVirtual < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf("negative index is illegal: ") + lVirtual);
        }
        this.ensureLastIndexMinimum(lVirtual);
        return this.setInternal(lVirtual, o);
    }

    protected void setAssumedFirstIndex(long i) {
        this.__m_AssumedFirstIndex = i;
    }

    protected void setAtomicLastIndex(AtomicCounter counter) {
        this.__m_AtomicLastIndex = counter;
    }

    protected void setFirstIndex(long lVirtual) {
        throw new UnsupportedOperationException();
    }

    protected Object setInternal(long lVirtual, Object o) {
        while (true) {
            Object[] aoStore;
            Object oLock;
            long lvFound = 0L;
            int iActual = 0;
            Object object = oLock = this.getIndexLock(lVirtual);
            synchronized (object) {
                Object oOld;
                aoStore = this.getStore();
                if (aoStore != null && (lvFound = this.safeRetrieveIndexFromValue(oOld = aoStore[iActual = (int)(lVirtual % (long)aoStore.length)], iActual)) == lVirtual) {
                    if (o == null) {
                        o = this.getPlaceHolder(lVirtual - (long)iActual);
                    } else {
                        this.assignIndexToValue(lVirtual, o);
                    }
                    aoStore[iActual] = o;
                    if (this.getWaitingThreadCount().getCount() > 0L) {
                        oLock.notifyAll();
                    }
                    Object object2 = oOld;
                    Object var12_11 = null;
                    return object2;
                }
            }
            if (aoStore == null) {
                this.getStableStore();
                continue;
            }
            if (lvFound > lVirtual) {
                int iaFound = (int)(lvFound % (long)aoStore.length);
                if (iaFound == iActual) {
                    throw new IndexOutOfBoundsException(String.valueOf("index ") + lVirtual + " has already been removed and cannot be reset");
                }
                throw new IllegalStateException(String.valueOf("found unexpected value at virtual index ") + lvFound + " actual " + iaFound + " capacity " + aoStore.length);
            }
            object = this;
            synchronized (object) {
                if (this.getStore() == aoStore) {
                    this.grow(lVirtual);
                }
            }
        }
    }

    protected void setLockOffset(long lOffset) {
        this.__m_LockOffset = lOffset;
    }

    protected void setRecentPlaceHolders(ConcurrentWindowedArray$PlaceHolder[] aPlaceHolder) {
        this.__m_RecentPlaceHolders = aPlaceHolder;
    }

    public void setStatsGetsOptimistic(long pStatsGetsOptimistic) {
        this.__m_StatsGetsOptimistic = pStatsGetsOptimistic;
    }

    protected void setStatsPlaceHolderAllocations(long cHolders) {
        this.__m_StatsPlaceHolderAllocations = cHolders;
    }

    protected void setStatsWaits(long cWaits) {
        this.__m_StatsWaits = cWaits;
    }

    protected void setWaitingThreadCount(AtomicCounter counter) {
        this.__m_WaitingThreadCount = counter;
    }

    protected int translateIndex(long lVirtual) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long waitIndex(Object oLock, long ldtTimeout) throws InterruptedException {
        long l;
        AtomicCounter waiting;
        block6: {
            long l2;
            block5: {
                long l3;
                block4: {
                    waiting = this.getWaitingThreadCount();
                    waiting.increment();
                    this.setStatsWaits(this.getStatsWaits() + 1L);
                    try {
                        if (ldtTimeout > 0L) {
                            long cWaitMillis = ldtTimeout - System.currentTimeMillis();
                            if (cWaitMillis > 0L) {
                                oLock.wait(Math.min(1000L, cWaitMillis));
                                l3 = ldtTimeout - System.currentTimeMillis();
                                Object var9_9 = null;
                                break block4;
                            }
                            l2 = cWaitMillis;
                            break block5;
                        }
                        oLock.wait();
                        l = Long.MAX_VALUE;
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        waiting.decrement();
                        throw throwable;
                    }
                }
                waiting.decrement();
                return l3;
            }
            Object var9_10 = null;
            waiting.decrement();
            return l2;
        }
        Object var9_11 = null;
        waiting.decrement();
        return l;
    }
}

