/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import org.aspectj.weaver.Member;
import org.aspectj.weaver.patterns.AndAnnotationTypePattern;
import org.aspectj.weaver.patterns.AndPointcut;
import org.aspectj.weaver.patterns.AndTypePattern;
import org.aspectj.weaver.patterns.AnnotationPatternList;
import org.aspectj.weaver.patterns.AnnotationPointcut;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.AnyAnnotationTypePattern;
import org.aspectj.weaver.patterns.AnyTypePattern;
import org.aspectj.weaver.patterns.AnyWithAnnotationTypePattern;
import org.aspectj.weaver.patterns.ArgsAnnotationPointcut;
import org.aspectj.weaver.patterns.ArgsPointcut;
import org.aspectj.weaver.patterns.BindingAnnotationTypePattern;
import org.aspectj.weaver.patterns.BindingTypePattern;
import org.aspectj.weaver.patterns.CflowPointcut;
import org.aspectj.weaver.patterns.ConcreteCflowPointcut;
import org.aspectj.weaver.patterns.DeclareAnnotation;
import org.aspectj.weaver.patterns.DeclareErrorOrWarning;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.DeclarePrecedence;
import org.aspectj.weaver.patterns.DeclareSoft;
import org.aspectj.weaver.patterns.EllipsisAnnotationTypePattern;
import org.aspectj.weaver.patterns.EllipsisTypePattern;
import org.aspectj.weaver.patterns.ExactAnnotationTypePattern;
import org.aspectj.weaver.patterns.ExactTypePattern;
import org.aspectj.weaver.patterns.HandlerPointcut;
import org.aspectj.weaver.patterns.HasMemberTypePattern;
import org.aspectj.weaver.patterns.IfPointcut;
import org.aspectj.weaver.patterns.KindedPointcut;
import org.aspectj.weaver.patterns.ModifiersPattern;
import org.aspectj.weaver.patterns.NamePattern;
import org.aspectj.weaver.patterns.NoTypePattern;
import org.aspectj.weaver.patterns.NotAnnotationTypePattern;
import org.aspectj.weaver.patterns.NotPointcut;
import org.aspectj.weaver.patterns.NotTypePattern;
import org.aspectj.weaver.patterns.OrAnnotationTypePattern;
import org.aspectj.weaver.patterns.OrPointcut;
import org.aspectj.weaver.patterns.OrTypePattern;
import org.aspectj.weaver.patterns.ParserException;
import org.aspectj.weaver.patterns.PatternNode;
import org.aspectj.weaver.patterns.PatternParser;
import org.aspectj.weaver.patterns.PerCflow;
import org.aspectj.weaver.patterns.PerFromSuper;
import org.aspectj.weaver.patterns.PerObject;
import org.aspectj.weaver.patterns.PerSingleton;
import org.aspectj.weaver.patterns.PerTypeWithin;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.ReferencePointcut;
import org.aspectj.weaver.patterns.SignaturePattern;
import org.aspectj.weaver.patterns.ThisOrTargetAnnotationPointcut;
import org.aspectj.weaver.patterns.ThisOrTargetPointcut;
import org.aspectj.weaver.patterns.ThrowsPattern;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;
import org.aspectj.weaver.patterns.TypeVariablePattern;
import org.aspectj.weaver.patterns.TypeVariablePatternList;
import org.aspectj.weaver.patterns.WildAnnotationTypePattern;
import org.aspectj.weaver.patterns.WildTypePattern;
import org.aspectj.weaver.patterns.WithinAnnotationPointcut;
import org.aspectj.weaver.patterns.WithinCodeAnnotationPointcut;
import org.aspectj.weaver.patterns.WithinPointcut;
import org.aspectj.weaver.patterns.WithincodePointcut;

public interface PatternNodeVisitor {
    public Object visit(AndAnnotationTypePattern var1, Object var2);

    public Object visit(AnyAnnotationTypePattern var1, Object var2);

    public Object visit(EllipsisAnnotationTypePattern var1, Object var2);

    public Object visit(ExactAnnotationTypePattern var1, Object var2);

    public Object visit(BindingAnnotationTypePattern var1, Object var2);

    public Object visit(NotAnnotationTypePattern var1, Object var2);

    public Object visit(OrAnnotationTypePattern var1, Object var2);

    public Object visit(WildAnnotationTypePattern var1, Object var2);

    public Object visit(AnnotationPatternList var1, Object var2);

    public Object visit(AndTypePattern var1, Object var2);

    public Object visit(AnyTypePattern var1, Object var2);

    public Object visit(AnyWithAnnotationTypePattern var1, Object var2);

    public Object visit(EllipsisTypePattern var1, Object var2);

    public Object visit(ExactTypePattern var1, Object var2);

    public Object visit(BindingTypePattern var1, Object var2);

    public Object visit(NotTypePattern var1, Object var2);

    public Object visit(NoTypePattern var1, Object var2);

    public Object visit(OrTypePattern var1, Object var2);

    public Object visit(WildTypePattern var1, Object var2);

    public Object visit(TypePatternList var1, Object var2);

    public Object visit(HasMemberTypePattern var1, Object var2);

    public Object visit(AndPointcut var1, Object var2);

    public Object visit(CflowPointcut var1, Object var2);

    public Object visit(ConcreteCflowPointcut var1, Object var2);

    public Object visit(HandlerPointcut var1, Object var2);

    public Object visit(IfPointcut var1, Object var2);

    public Object visit(KindedPointcut var1, Object var2);

    public Object visit(Pointcut.MatchesNothingPointcut var1, Object var2);

    public Object visit(AnnotationPointcut var1, Object var2);

    public Object visit(ArgsAnnotationPointcut var1, Object var2);

    public Object visit(ArgsPointcut var1, Object var2);

    public Object visit(ThisOrTargetAnnotationPointcut var1, Object var2);

    public Object visit(ThisOrTargetPointcut var1, Object var2);

    public Object visit(WithinAnnotationPointcut var1, Object var2);

    public Object visit(WithinCodeAnnotationPointcut var1, Object var2);

    public Object visit(NotPointcut var1, Object var2);

    public Object visit(OrPointcut var1, Object var2);

    public Object visit(ReferencePointcut var1, Object var2);

    public Object visit(WithinPointcut var1, Object var2);

    public Object visit(WithincodePointcut var1, Object var2);

    public Object visit(PerCflow var1, Object var2);

    public Object visit(PerFromSuper var1, Object var2);

    public Object visit(PerObject var1, Object var2);

    public Object visit(PerSingleton var1, Object var2);

    public Object visit(PerTypeWithin var1, Object var2);

    public Object visit(DeclareAnnotation var1, Object var2);

    public Object visit(DeclareErrorOrWarning var1, Object var2);

    public Object visit(DeclareParents var1, Object var2);

    public Object visit(DeclarePrecedence var1, Object var2);

    public Object visit(DeclareSoft var1, Object var2);

    public Object visit(ModifiersPattern var1, Object var2);

    public Object visit(NamePattern var1, Object var2);

    public Object visit(SignaturePattern var1, Object var2);

    public Object visit(ThrowsPattern var1, Object var2);

    public Object visit(TypeVariablePattern var1, Object var2);

    public Object visit(TypeVariablePatternList var1, Object var2);

    public Object visit(PatternNode var1, Object var2);

    public static class DumpPointcutVisitor
    implements PatternNodeVisitor {
        private StringBuffer sb = new StringBuffer();
        private boolean inThrowsForbidden = false;

        public String get() {
            return this.sb.toString();
        }

        private void append(Object o) {
            this.sb.append(o.toString());
        }

        private void append(char c) {
            this.sb.append(c);
        }

        public Object visit(PatternNode node, Object data) {
            System.err.println("Should implement: " + node.getClass());
            return null;
        }

        public Object visit(AnyTypePattern node, Object data) {
            this.append('*');
            return null;
        }

        public Object visit(NoTypePattern node, Object data) {
            this.append(node.toString());
            return null;
        }

        public Object visit(EllipsisTypePattern node, Object data) {
            this.append(node.toString());
            return null;
        }

        public Object visit(AnyWithAnnotationTypePattern node, Object data) {
            node.annotationPattern.accept(this, data);
            this.append(" *");
            return null;
        }

        public Object visit(AnyAnnotationTypePattern node, Object data) {
            this.append('*');
            return null;
        }

        public Object visit(EllipsisAnnotationTypePattern node, Object data) {
            this.append("..");
            return null;
        }

        public Object visit(AndAnnotationTypePattern node, Object data) {
            node.getLeft().accept(this, data);
            this.append(' ');
            node.getRight().accept(this, data);
            return null;
        }

        public Object visit(AndPointcut node, Object data) {
            this.append('(');
            node.getLeft().accept(this, data);
            this.append(" && ");
            node.getRight().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(AndTypePattern node, Object data) {
            this.append('(');
            node.getLeft().accept(this, data);
            this.append(" && ");
            node.getRight().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(AnnotationPatternList node, Object data) {
            AnnotationTypePattern[] annotations = node.getAnnotationPatterns();
            for (int i = 0; i < annotations.length; ++i) {
                if (i > 0) {
                    this.append(", ");
                }
                annotations[i].accept(this, data);
            }
            return null;
        }

        public Object visit(AnnotationPointcut node, Object data) {
            this.append("@annotation(");
            node.getAnnotationTypePattern().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(ArgsAnnotationPointcut node, Object data) {
            this.append("@args(");
            node.getArguments().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(ArgsPointcut node, Object data) {
            this.append("args(");
            node.getArguments().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(BindingAnnotationTypePattern node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(BindingTypePattern node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(CflowPointcut node, Object data) {
            this.append(node.isCflowBelow() ? "cflowbelow(" : "cflow(");
            node.getEntry().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(ExactAnnotationTypePattern node, Object data) {
            this.append(node.getAnnotationType().getName());
            return null;
        }

        public Object visit(ExactTypePattern node, Object data) {
            if (node.getAnnotationPattern() != AnnotationTypePattern.ANY) {
                this.append('(');
                node.getAnnotationPattern().accept(this, data);
                this.append(' ');
            }
            String typeString = node.getType().toString();
            if (node.isVarArgs()) {
                typeString = typeString.substring(0, typeString.lastIndexOf(91));
            }
            this.append(typeString);
            if (node.isIncludeSubtypes()) {
                this.append('+');
            }
            if (node.isVarArgs()) {
                this.append("...");
            }
            if (node.getAnnotationPattern() != AnnotationTypePattern.ANY) {
                this.append(')');
            }
            return null;
        }

        public Object visit(KindedPointcut node, Object data) {
            this.append(node.getKind().getSimpleName());
            this.append('(');
            node.getSignature().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(ModifiersPattern node, Object data) {
            this.append(node.toString());
            return null;
        }

        public Object visit(NamePattern node, Object data) {
            this.append(node.toString());
            return null;
        }

        public Object visit(NotAnnotationTypePattern node, Object data) {
            this.append("!");
            node.getNegatedPattern().accept(this, data);
            return null;
        }

        public Object visit(NotPointcut node, Object data) {
            this.append("!(");
            node.getNegatedPointcut().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(NotTypePattern node, Object data) {
            this.append("!(");
            node.getNegatedPattern().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(OrAnnotationTypePattern node, Object data) {
            this.append('(');
            node.getLeft().accept(this, data);
            this.append(" || ");
            node.getRight().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(OrPointcut node, Object data) {
            this.append('(');
            node.getLeft().accept(this, data);
            this.append(" || ");
            node.getRight().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(OrTypePattern node, Object data) {
            this.append('(');
            node.getLeft().accept(this, data);
            this.append(" || ");
            node.getRight().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(ReferencePointcut node, Object data) {
            this.append(node.toString());
            return null;
        }

        public Object visit(SignaturePattern node, Object data) {
            if (node.getAnnotationPattern() != AnnotationTypePattern.ANY) {
                node.getAnnotationPattern().accept(this, data);
                this.append(' ');
            }
            if (node.getModifiers() != ModifiersPattern.ANY) {
                node.getModifiers().accept(this, data);
                this.append(' ');
            }
            if (node.getKind() == Member.STATIC_INITIALIZATION) {
                node.getDeclaringType().accept(this, data);
            } else if (node.getKind() == Member.HANDLER) {
                this.append("handler(");
                node.getParameterTypes().get(0).accept(this, data);
                this.append(')');
            } else {
                if (node.getKind() != Member.CONSTRUCTOR) {
                    node.getReturnType().accept(this, data);
                    this.append(' ');
                }
                if (node.getDeclaringType() != TypePattern.ANY) {
                    node.getDeclaringType().accept(this, data);
                    this.append('.');
                }
                if (node.getKind() == Member.CONSTRUCTOR) {
                    this.append("new");
                } else {
                    node.getName().accept(this, data);
                }
                if (node.getKind() == Member.METHOD || node.getKind() == Member.CONSTRUCTOR) {
                    this.append('(');
                    node.getParameterTypes().accept(this, data);
                    this.append(')');
                }
                if (node.getThrowsPattern() != null) {
                    this.append(' ');
                    node.getThrowsPattern().accept(this, data);
                }
            }
            return null;
        }

        public Object visit(ThisOrTargetAnnotationPointcut node, Object data) {
            this.append(node.isThis() ? "@this(" : "@target(");
            node.getAnnotationTypePattern().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(ThisOrTargetPointcut node, Object data) {
            this.append(node.isThis() ? "this(" : "target(");
            node.getType().accept(this, data);
            this.append(')');
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object visit(ThrowsPattern node, Object data) {
            if (node == ThrowsPattern.ANY) {
                return null;
            }
            this.append("throws ");
            node.getRequired().accept(this, data);
            if (node.getForbidden().size() > 0) {
                try {
                    this.inThrowsForbidden = true;
                    node.getForbidden().accept(this, data);
                }
                finally {
                    this.inThrowsForbidden = false;
                }
            }
            return null;
        }

        public Object visit(TypePatternList node, Object data) {
            if (node.getTypePatterns().length == 0) {
                return null;
            }
            TypePattern[] typePatterns = node.getTypePatterns();
            for (int i = 0; i < typePatterns.length; ++i) {
                TypePattern typePattern = typePatterns[i];
                if (i > 0) {
                    this.append(", ");
                }
                if (this.inThrowsForbidden) {
                    this.append('!');
                }
                typePattern.accept(this, data);
            }
            return null;
        }

        public Object visit(WildAnnotationTypePattern node, Object data) {
            this.append("@(");
            node.getTypePattern().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(WildTypePattern node, Object data) {
            if (node.getAnnotationPattern() != AnnotationTypePattern.ANY) {
                this.append('(');
                node.getAnnotationPattern().accept(this, data);
                this.append(' ');
            }
            NamePattern[] namePatterns = node.getNamePatterns();
            for (int i = 0; i < namePatterns.length; ++i) {
                if (namePatterns[i] == null) {
                    this.append('.');
                    continue;
                }
                if (i > 0) {
                    this.append('.');
                }
                namePatterns[i].accept(this, data);
            }
            if (node.isIncludeSubtypes()) {
                this.append('+');
            }
            if (node.isVarArgs()) {
                this.append("...");
            }
            if (node.getAnnotationPattern() != AnnotationTypePattern.ANY) {
                this.append(')');
            }
            return null;
        }

        public Object visit(WithinAnnotationPointcut node, Object data) {
            this.append("@within(");
            node.getAnnotationTypePattern().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(WithinCodeAnnotationPointcut node, Object data) {
            this.append("@withincode(");
            node.getAnnotationTypePattern().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(WithinPointcut node, Object data) {
            this.append("within(");
            node.getTypePattern().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(WithincodePointcut node, Object data) {
            this.append("withincode(");
            node.getSignature().accept(this, data);
            this.append(')');
            return null;
        }

        public Object visit(Pointcut.MatchesNothingPointcut node, Object data) {
            this.append("");
            return null;
        }

        public Object visit(PerCflow node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(PerFromSuper node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(PerObject node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(PerSingleton node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(PerTypeWithin node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(DeclareAnnotation node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(DeclareErrorOrWarning node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(DeclareParents node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(DeclarePrecedence node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(DeclareSoft node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(ConcreteCflowPointcut node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(HandlerPointcut node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(IfPointcut node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(TypeVariablePattern node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(TypeVariablePatternList node, Object data) {
            this.append(node);
            return null;
        }

        public Object visit(HasMemberTypePattern node, Object data) {
            this.append(node);
            return null;
        }

        public static void check(String s) {
            DumpPointcutVisitor.check(Pointcut.fromString(s), false);
        }

        public static void check(PatternNode pc, boolean isTypePattern) {
            DumpPointcutVisitor v1 = new DumpPointcutVisitor();
            pc.accept(v1, null);
            DumpPointcutVisitor v2 = new DumpPointcutVisitor();
            PatternNode pc2 = isTypePattern ? new PatternParser(v1.get()).parseTypePattern() : Pointcut.fromString(v1.get());
            pc2.accept(v2, null);
            if (!v1.get().equals(v2.get())) {
                throw new ParserException("Unstable back parsing for '" + pc + "', got '" + v1.get() + "' and '" + v2.get() + "'", null);
            }
        }

        public static void main(String[] args) throws Throwable {
            String[] s = new String[]{"(if(true) && set(int BaseApp.i))"};
            for (int i = 0; i < s.length; ++i) {
                DumpPointcutVisitor.check(s[i]);
            }
        }
    }
}

