/*
 * Decompiled with CFR 0.152.
 */
package bucket.test;

import com.atlassian.spring.container.ContainerContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.spring.container.SpringTestContainerContext;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.TestCase;
import net.sf.hibernate.SessionFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public abstract class AbstractSpringPersistenceTest
extends TestCase {
    private Connection placeHolderConnection;
    protected ApplicationContext context;
    protected SessionFactory sessionFactory;
    protected PlatformTransactionManager transactionManager;
    protected TransactionStatus transactionStatus;
    protected DefaultTransactionDefinition transactionDefinition;

    public AbstractSpringPersistenceTest() {
    }

    public AbstractSpringPersistenceTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Class.forName("org.hsqldb.jdbcDriver");
        this.placeHolderConnection = DriverManager.getConnection("jdbc:hsqldb:.", "sa", "");
        this.context = this.setupSpringContext();
        ContainerManager.getInstance().setContainerContext((ContainerContext)new SpringTestContainerContext(this.context));
        this.sessionFactory = (SessionFactory)this.context.getBean("sessionFactory");
        this.transactionManager = (PlatformTransactionManager)this.context.getBean("transactionManager");
        this.transactionDefinition = new DefaultTransactionDefinition(0);
        this.transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)this.transactionDefinition);
    }

    protected ApplicationContext setupSpringContext() {
        return new ClassPathXmlApplicationContext("/testBucketApplicationContext.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            this.transactionManager.commit(this.transactionStatus);
            this.sessionFactory.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.shutdownDatabase();
            this.closePlaceholder();
            ContainerManager.resetInstance();
            this.placeHolderConnection = null;
            this.context = null;
            this.sessionFactory = null;
            this.transactionManager = null;
            this.transactionStatus = null;
            this.transactionDefinition = null;
            super.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownDatabase() {
        try {
            Statement stmt = null;
            try {
                stmt = this.placeHolderConnection.createStatement();
                stmt.execute("SHUTDOWN COMPACT");
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void closePlaceholder() {
        try {
            this.placeHolderConnection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void commitAndRefreshTransaction() {
        this.transactionManager.commit(this.transactionStatus);
        this.transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)this.transactionDefinition);
    }
}

