/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate;

import bucket.core.persistence.ObjectDao;
import com.atlassian.bonnie.Indexer;
import com.atlassian.bonnie.Searchable;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.core.exception.InfrastructureException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.ReplicationMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Logger;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public abstract class HibernateObjectDao
extends HibernateDaoSupport
implements ObjectDao {
    protected static final Logger log = Logger.getLogger((Class)HibernateObjectDao.class);
    private Indexer indexer;

    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    protected EntityObject getByClassId(final long id) {
        EntityObject obj = (EntityObject)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.get(HibernateObjectDao.this.getPersistentClass(), (Serializable)new Long(id));
            }
        });
        return obj;
    }

    public List findAll() {
        return this.findAllSorted(null);
    }

    public List findAllSorted(String sortField) {
        String query = "FROM " + this.getPersistentClass().getName() + " result";
        if (sortField != null) {
            query = query + " ORDER BY LOWER(result." + sortField + ")";
        }
        final String finalQuery = query;
        List result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(finalQuery);
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateObjectDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    public void save(EntityObject objectToSave) {
        this.updateModificationData(objectToSave);
        this.saveRaw(objectToSave);
    }

    protected void updateModificationData(EntityObject objectToSave) {
        Date date = objectToSave.getCurrentDate();
        objectToSave.setLastModificationDate(date);
        if (objectToSave.getCreationDate() == null) {
            objectToSave.setCreationDate(date);
        }
    }

    public void saveRaw(EntityObject objectToSave) {
        this.getHibernateTemplate().saveOrUpdate((Object)objectToSave);
        this.reIndex(objectToSave);
    }

    public void remove(EntityObject objectToRemove) {
        try {
            this.getHibernateTemplate().delete((Object)objectToRemove);
            this.unIndex(objectToRemove, true);
        }
        catch (Exception e) {
            log.error((Object)"remove error!", (Throwable)e);
            throw new InfrastructureException((Throwable)e);
        }
    }

    public void refresh(final EntityObject objectToRefresh) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.refresh((Object)objectToRefresh);
                return null;
            }
        });
    }

    public void replicate(final Object objectToReplicate) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.replicate(objectToReplicate, ReplicationMode.OVERWRITE);
                return null;
            }
        });
    }

    protected void index(EntityObject objectToSave) {
        try {
            if (this.indexer != null && objectToSave instanceof Searchable) {
                this.indexer.index((Searchable)objectToSave);
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to index object: " + objectToSave + " -- " + e.getMessage()), (Throwable)e);
        }
    }

    protected void reIndex(EntityObject objectToSave) {
        try {
            if (this.indexer != null && objectToSave instanceof Searchable) {
                this.indexer.reIndex((Searchable)objectToSave);
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to reIndex object: " + objectToSave + " -- " + e.getMessage()), (Throwable)e);
        }
    }

    protected void unIndex(EntityObject objectToSave, boolean unindexDependents) {
        try {
            if (this.indexer != null && objectToSave instanceof Searchable) {
                if (unindexDependents) {
                    Iterator it = ((Searchable)objectToSave).getSearchableDependants().iterator();
                    while (it.hasNext()) {
                        this.unIndex((EntityObject)it.next(), true);
                    }
                }
                this.indexer.unIndex((Searchable)objectToSave);
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to index object: " + objectToSave + " -- " + e.getMessage()), (Throwable)e);
        }
    }

    protected List findNamedQuery(String queryName) {
        return this.findNamedQuery(queryName, false);
    }

    protected List findNamedQuery(String queryName, boolean cacheable) {
        return this.findNamedQueryStringParam(queryName, null, null, cacheable);
    }

    protected List findNamedQuery(String queryName, boolean cacheable, int maxResultCount) {
        return this.findNamedQueryStringParam(queryName, null, null, cacheable, maxResultCount);
    }

    protected List findNamedQueryStringParam(String queryName, String paramName, Object paramValue) {
        return this.findNamedQueryStringParam(queryName, paramName, paramValue, false);
    }

    protected List findNamedQueryStringParam(String queryName, String paramName, Object paramValue, boolean cacheable) {
        return this.findNamedQueryStringParams(queryName, paramName, paramValue, null, null, cacheable);
    }

    protected List findNamedQueryStringParam(String queryName, String paramName, Object paramValue, boolean cacheable, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, paramName, paramValue, null, null, cacheable, maxResultCount);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value) {
        return this.findNamedQueryStringParams(queryName, paramName, paramValue, param2Name, param2Value, false);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, boolean cacheable) {
        return this.findNamedQueryStringParams(queryName, paramName, paramValue, param2Name, param2Value, null, null, cacheable, -1);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, boolean cacheable, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, paramName, paramValue, param2Name, param2Value, null, null, cacheable, maxResultCount);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value) {
        return this.findNamedQueryStringParams(queryName, paramName, paramValue, param2Name, param2Value, param3Name, param3Value, null, null);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, boolean cacheable) {
        return this.findNamedQueryStringParams(queryName, paramName, paramValue, param2Name, param2Value, param3Name, param3Value, cacheable, -1);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, boolean cacheable, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, paramName, paramValue, param2Name, param2Value, param3Name, param3Value, null, null, cacheable, maxResultCount);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, String param4Name, Object param4Value) {
        return this.findNamedQueryStringParams(queryName, paramName, paramValue, param2Name, param2Value, param3Name, param3Value, param4Name, param4Value, false);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, String param4Name, Object param4Value, boolean cacheable) {
        return this.findNamedQueryStringParams(queryName, paramName, paramValue, param2Name, param2Value, param3Name, param3Value, param4Name, param4Value, cacheable, -1);
    }

    protected List findNamedQueryStringParams(final String queryName, final String paramName, final Object paramValue, final String param2Name, final Object param2Value, final String param3Name, final Object param3Value, final String param4Name, final Object param4Value, final boolean cacheable, final int maxResultCount) {
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                if (cacheable) {
                    queryObject.setCacheable(true);
                }
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateObjectDao.this.getSessionFactory());
                if (paramName != null) {
                    queryObject.setParameter(paramName, paramValue);
                }
                if (param2Name != null) {
                    queryObject.setParameter(param2Name, param2Value);
                }
                if (param3Name != null) {
                    queryObject.setParameter(param3Name, param3Value);
                }
                if (param4Name != null) {
                    queryObject.setParameter(param4Name, param4Value);
                }
                if (maxResultCount != -1) {
                    queryObject.setMaxResults(maxResultCount);
                }
                return queryObject.list();
            }
        });
    }

    protected Object findSingleObject(List results) {
        EntityObject result = null;
        if (results != null && results.size() == 1) {
            return results.get(0);
        }
        if (results != null && results.size() > 1) {
            log.error((Object)("Uh oh - found more than one object when single object requested: " + results));
            result = (EntityObject)results.get(0);
            Iterator iterator = results.iterator();
            while (iterator.hasNext()) {
                EntityObject entity = (EntityObject)iterator.next();
                if (entity.getId() >= result.getId()) continue;
                result = entity;
            }
        }
        return result;
    }
}

