/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.quartz;

import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Category;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;

public class QuartzUtil {
    private static final Category log = Category.getInstance((Class)QuartzUtil.class);

    public static boolean isJobExecuting(JobExecutionContext context) {
        try {
            JobDetailComparator c = new JobDetailComparator();
            List executingJobs = context.getScheduler().getCurrentlyExecutingJobs();
            for (int i = 0; i < executingJobs.size(); ++i) {
                JobExecutionContext executingContext = (JobExecutionContext)executingJobs.get(i);
                if (executingContext == context || c.compare(context.getJobDetail(), executingContext.getJobDetail()) != 0) continue;
                return true;
            }
            return false;
        }
        catch (SchedulerException e) {
            log.warn((Object)"Failed to determine if quartz job was already executing.", (Throwable)e);
            return false;
        }
    }

    private static class JobDetailComparator
    implements Comparator {
        private JobDetailComparator() {
        }

        public int compare(Object o1, Object o2) {
            JobDetail a = (JobDetail)o1;
            JobDetail b = (JobDetail)o2;
            int groupComparison = a.getGroup().compareTo(b.getGroup());
            if (groupComparison != 0) {
                return groupComparison;
            }
            return a.getName().compareTo(b.getName());
        }
    }
}

