/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.util;

import com.atlassian.seraph.util.PathMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class CachedPathMapper
extends PathMapper {
    private Map cacheMap;
    private Map cacheAllMap;

    public CachedPathMapper(Map cacheMap, Map cacheAllMap) {
        this.cacheMap = Collections.synchronizedMap(cacheMap);
        this.cacheAllMap = Collections.synchronizedMap(cacheAllMap);
    }

    public String get(String path) {
        String result = (String)this.cacheMap.get(path);
        if (result != null) {
            return result;
        }
        result = super.get(path);
        this.cacheMap.put(path, result);
        return result;
    }

    public Collection getAll(String path) {
        Collection result = (Collection)this.cacheAllMap.get(path);
        if (result != null) {
            return result;
        }
        result = super.getAll(path);
        this.cacheAllMap.put(path, result);
        return result;
    }

    public void put(String key, String pattern) {
        this.cacheMap.remove(key);
        this.cacheAllMap.remove(key);
        super.put(key, pattern);
    }
}

