/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PathMapper
implements Serializable {
    private Map mappings = new HashMap();
    private List complexPaths = new ArrayList();
    static String[] DEFAULT_KEYS = new String[]{"/", "*", "/*"};

    public void put(String key, String pattern) {
        if (pattern == null) {
            this.removeMappingsForKey(key);
            return;
        }
        this.mappings.put(pattern, key);
        if (pattern.indexOf(63) > -1 || pattern.indexOf("*") > -1 && pattern.length() > 1) {
            this.complexPaths.add(pattern);
        }
    }

    private void removeMappingsForKey(String key) {
        Iterator it = this.mappings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!entry.getValue().equals(key)) continue;
            this.complexPaths.remove(entry.getKey());
            it.remove();
        }
    }

    public String get(String path) {
        String mapped;
        if (path == null) {
            path = "/";
        }
        if ((mapped = PathMapper.findKey(path, this.mappings, this.complexPaths)) == null) {
            return null;
        }
        return (String)this.mappings.get(mapped);
    }

    public Collection getAll(String path) {
        String mapped;
        if (path == null) {
            path = "/";
        }
        ArrayList matches = new ArrayList();
        String exactKey = PathMapper.findExactKey(path, this.mappings);
        if (exactKey != null) {
            matches.add(this.mappings.get(exactKey));
        }
        Iterator iterator = PathMapper.findComplexKeys(path, this.complexPaths).iterator();
        while (iterator.hasNext()) {
            mapped = (String)iterator.next();
            matches.add(this.mappings.get(mapped));
        }
        iterator = PathMapper.findDefaultKeys(this.mappings).iterator();
        while (iterator.hasNext()) {
            mapped = (String)iterator.next();
            matches.add(this.mappings.get(mapped));
        }
        return matches;
    }

    private static String findKey(String path, Map mappings, List keys) {
        String result = PathMapper.findExactKey(path, mappings);
        if (result == null) {
            result = PathMapper.findComplexKey(path, keys);
        }
        if (result == null) {
            result = PathMapper.findDefaultKey(mappings);
        }
        return result;
    }

    private static String findExactKey(String path, Map mappings) {
        if (mappings.containsKey(path)) {
            return path;
        }
        return null;
    }

    private static String findComplexKey(String path, List complexPaths) {
        int size = complexPaths.size();
        for (int i = 0; i < size; ++i) {
            String key = (String)complexPaths.get(i);
            if (!PathMapper.match(key, path, false)) continue;
            return key;
        }
        return null;
    }

    private static Collection findComplexKeys(String path, List complexPaths) {
        int size = complexPaths.size();
        ArrayList<String> matches = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            String key = (String)complexPaths.get(i);
            if (!PathMapper.match(key, path, false)) continue;
            matches.add(key);
        }
        return matches;
    }

    private static String findDefaultKey(Map mappings) {
        for (int i = 0; i < DEFAULT_KEYS.length; ++i) {
            if (!mappings.containsKey(DEFAULT_KEYS[i])) continue;
            return DEFAULT_KEYS[i];
        }
        return null;
    }

    private static Collection findDefaultKeys(Map mappings) {
        ArrayList<String> matches = new ArrayList<String>();
        for (int i = 0; i < DEFAULT_KEYS.length; ++i) {
            if (!mappings.containsKey(DEFAULT_KEYS[i])) continue;
            matches.add(DEFAULT_KEYS[i]);
        }
        return matches;
    }

    private static boolean match(String pattern, String str, boolean isCaseSensitive) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?') continue;
                if (isCaseSensitive && ch2 != strArr[i]) {
                    return false;
                }
                if (isCaseSensitive || Character.toUpperCase(ch2) == Character.toUpperCase(strArr[i])) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?') {
                if (isCaseSensitive && ch != strArr[strIdxStart]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                    return false;
                }
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?') {
                if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                    return false;
                }
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && (isCaseSensitive && ch != strArr[strIdxStart + i3 + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i3 + j]))) continue block8;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Mappings:\n");
        Iterator<Object> iterator = this.mappings.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            sb.append(key + "=" + (String)this.mappings.get(key) + "\n");
        }
        sb.append("Complex Paths:\n");
        iterator = this.complexPaths.iterator();
        while (iterator.hasNext()) {
            String path = (String)iterator.next();
            sb.append(path + "\n");
        }
        return sb.toString();
    }
}

