/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.TransactionFactory;
import org.ofbiz.core.entity.transaction.DBCPConnectionFactory;
import org.ofbiz.core.util.Debug;
import org.w3c.dom.Element;

public class ConnectionFactory {
    public static final String module = (class$org$ofbiz$core$entity$ConnectionFactory == null ? (class$org$ofbiz$core$entity$ConnectionFactory = ConnectionFactory.class$("org.ofbiz.core.entity.ConnectionFactory")) : class$org$ofbiz$core$entity$ConnectionFactory).getName();
    static /* synthetic */ Class class$org$ofbiz$core$entity$ConnectionFactory;

    public static Connection getConnection(String helperName) throws SQLException, GenericEntityException {
        Connection con = TransactionFactory.getConnection(helperName);
        if (con == null) {
            Debug.logError((String)("******* ERROR: No database connection found for helperName \"" + helperName + "\""), (String)module);
        }
        return con;
    }

    public static Connection tryGenericConnectionSources(String helperName, Element inlineJdbcElement) throws SQLException, GenericEntityException {
        try {
            Connection con = DBCPConnectionFactory.getConnection(helperName, inlineJdbcElement);
            if (con != null) {
                return con;
            }
        }
        catch (Exception ex) {
            Debug.logError((Throwable)ex, (String)"There was an error getting a DBCP datasource.");
        }
        String driverClassName = inlineJdbcElement.getAttribute("jdbc-driver");
        if (driverClassName != null && driverClassName.length() > 0) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                loader.loadClass(driverClassName);
            }
            catch (ClassNotFoundException cnfe) {
                Debug.logWarning((String)("Could not find JDBC driver class named " + driverClassName + ".\n"));
                Debug.logWarning((Throwable)cnfe);
                return null;
            }
            return DriverManager.getConnection(inlineJdbcElement.getAttribute("jdbc-uri"), inlineJdbcElement.getAttribute("jdbc-username"), inlineJdbcElement.getAttribute("jdbc-password"));
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

