/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericResultSetClosedException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.jdbc.SQLProcessor;
import org.ofbiz.core.entity.jdbc.SqlJdbcUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelFieldTypeReader;
import org.ofbiz.core.util.GeneralRuntimeException;

public class EntityListIterator
implements ListIterator {
    protected SQLProcessor sqlp;
    protected ResultSet resultSet;
    protected ModelEntity modelEntity;
    protected List selectFields;
    protected ModelFieldTypeReader modelFieldTypeReader;
    protected boolean closed = false;
    protected boolean haveMadeValue = false;
    protected GenericDelegator delegator = null;

    public EntityListIterator(SQLProcessor sqlp, ModelEntity modelEntity, List selectFields, ModelFieldTypeReader modelFieldTypeReader) {
        this.sqlp = sqlp;
        this.resultSet = sqlp.getResultSet();
        this.modelEntity = modelEntity;
        this.selectFields = selectFields;
        this.modelFieldTypeReader = modelFieldTypeReader;
    }

    public void setDelegator(GenericDelegator delegator) {
        this.delegator = delegator;
    }

    public void afterLast() throws GenericEntityException {
        try {
            this.resultSet.afterLast();
        }
        catch (SQLException e) {
            throw new GenericEntityException("Error setting the cursor to afterLast", e);
        }
    }

    public void beforeFirst() throws GenericEntityException {
        try {
            this.resultSet.beforeFirst();
        }
        catch (SQLException e) {
            throw new GenericEntityException("Error setting the cursor to beforeFirst", e);
        }
    }

    public boolean last() throws GenericEntityException {
        try {
            return this.resultSet.last();
        }
        catch (SQLException e) {
            throw new GenericEntityException("Error setting the cursor to last", e);
        }
    }

    public boolean first() throws GenericEntityException {
        try {
            return this.resultSet.first();
        }
        catch (SQLException e) {
            throw new GenericEntityException("Error setting the cursor to first", e);
        }
    }

    public void close() throws GenericEntityException {
        if (this.closed) {
            throw new GenericResultSetClosedException("This EntityListIterator has been closed, this operation cannot be performed");
        }
        this.sqlp.close();
        this.closed = true;
    }

    public GenericValue currentGenericValue() throws GenericEntityException {
        if (this.closed) {
            throw new GenericResultSetClosedException("This EntityListIterator has been closed, this operation cannot be performed");
        }
        GenericValue value = new GenericValue(this.modelEntity);
        for (int j = 0; j < this.selectFields.size(); ++j) {
            ModelField curField = (ModelField)this.selectFields.get(j);
            SqlJdbcUtil.getValue(this.resultSet, j + 1, curField, value, this.modelFieldTypeReader);
        }
        value.modified = false;
        value.copyOriginalDbValues();
        value.setDelegator(this.delegator);
        this.haveMadeValue = true;
        return value;
    }

    public int currentIndex() throws GenericEntityException {
        if (this.closed) {
            throw new GenericResultSetClosedException("This EntityListIterator has been closed, this operation cannot be performed");
        }
        try {
            return this.resultSet.getRow();
        }
        catch (SQLException e) {
            throw new GenericEntityException("Error getting the current index", e);
        }
    }

    public boolean absolute(int rowNum) throws GenericEntityException {
        if (this.closed) {
            throw new GenericResultSetClosedException("This EntityListIterator has been closed, this operation cannot be performed");
        }
        try {
            return this.resultSet.absolute(rowNum);
        }
        catch (SQLException e) {
            throw new GenericEntityException("Error setting the absolute index to " + rowNum, e);
        }
    }

    public boolean hasNext() {
        try {
            if (this.resultSet.isLast() || this.resultSet.isAfterLast()) {
                return false;
            }
            return this.haveMadeValue || this.resultSet.isBeforeFirst() || this.resultSet.isFirst();
        }
        catch (SQLException e) {
            throw new GeneralRuntimeException("Error while checking to see if this is the last result", (Throwable)e);
        }
    }

    public boolean hasPrevious() {
        try {
            if (this.resultSet.isFirst() || this.resultSet.isBeforeFirst()) {
                return false;
            }
            return this.haveMadeValue || this.resultSet.isAfterLast() || this.resultSet.isLast();
        }
        catch (SQLException e) {
            throw new GeneralRuntimeException("Error while checking to see if this is the first result", (Throwable)e);
        }
    }

    public Object next() {
        try {
            if (this.resultSet.next()) {
                return this.currentGenericValue();
            }
            return null;
        }
        catch (SQLException e) {
            throw new GeneralRuntimeException("Error getting the next result", (Throwable)e);
        }
        catch (GenericEntityException e) {
            throw new GeneralRuntimeException("Error creating GenericValue", (Throwable)((Object)e));
        }
    }

    public int nextIndex() {
        try {
            return this.currentIndex() + 1;
        }
        catch (GenericEntityException e) {
            throw new GeneralRuntimeException(e.getNonNestedMessage(), e.getNested());
        }
    }

    public Object previous() {
        try {
            if (this.resultSet.previous()) {
                return this.currentGenericValue();
            }
            return null;
        }
        catch (SQLException e) {
            throw new GeneralRuntimeException("Error getting the previous result", (Throwable)e);
        }
        catch (GenericEntityException e) {
            throw new GeneralRuntimeException("Error creating GenericValue", (Throwable)((Object)e));
        }
    }

    public int previousIndex() {
        try {
            return this.currentIndex() - 1;
        }
        catch (GenericEntityException e) {
            throw new GeneralRuntimeException("Error getting the current index", (Throwable)((Object)e));
        }
    }

    public void setFetchSize(int rows) throws GenericEntityException {
        try {
            this.resultSet.setFetchSize(rows);
        }
        catch (SQLException e) {
            throw new GenericEntityException("Error getting the next result", e);
        }
    }

    public List getCompleteList() throws GenericEntityException {
        try {
            if (this.haveMadeValue && !this.resultSet.isBeforeFirst()) {
                this.resultSet.beforeFirst();
            }
            LinkedList<Object> list = new LinkedList<Object>();
            Object nextValue = null;
            while ((nextValue = this.next()) != null) {
                list.add(nextValue);
            }
            return list;
        }
        catch (SQLException e) {
            throw new GeneralRuntimeException("Error getting results", (Throwable)e);
        }
        catch (GeneralRuntimeException e) {
            throw new GenericEntityException(e.getNonNestedMessage(), e.getNested());
        }
    }

    public List getPartialList(int start, int number) throws GenericEntityException {
        try {
            if (number == 0) {
                return new ArrayList();
            }
            ArrayList<Object> list = new ArrayList<Object>(number);
            if (!this.resultSet.absolute(start)) {
                throw new GenericEntityException("Could not move to the start position of " + start + ", there are probably not that many results for this find.");
            }
            list.add(this.currentGenericValue());
            Object nextValue = null;
            for (int numRetreived = 1; number > numRetreived && (nextValue = this.next()) != null; ++numRetreived) {
                list.add(nextValue);
            }
            return list;
        }
        catch (SQLException e) {
            throw new GeneralRuntimeException("Error getting results", (Throwable)e);
        }
        catch (GeneralRuntimeException e) {
            throw new GenericEntityException(e.getNonNestedMessage(), e.getNested());
        }
    }

    public void add(Object obj) {
        throw new GeneralRuntimeException("CursorListIterator currently only supports read-only access");
    }

    public void remove() {
        throw new GeneralRuntimeException("CursorListIterator currently only supports read-only access");
    }

    public void set(Object obj) {
        throw new GeneralRuntimeException("CursorListIterator currently only supports read-only access");
    }
}

