/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.util.UtilDateTime;
import org.ofbiz.core.util.UtilMisc;
import org.ofbiz.core.util.UtilValidate;

public class EntityUtil {
    public static GenericValue getFirst(List values) {
        if (values != null && values.size() > 0) {
            return (GenericValue)values.iterator().next();
        }
        return null;
    }

    public static GenericValue getOnly(List values) {
        if (values != null) {
            if (values.size() <= 0) {
                return null;
            }
            if (values.size() == 1) {
                return (GenericValue)values.iterator().next();
            }
            throw new IllegalArgumentException("Passed List had more than one value.");
        }
        return null;
    }

    public static List filterByDate(List datedValues) {
        return EntityUtil.filterByDate(datedValues, UtilDateTime.nowTimestamp(), "fromDate", "thruDate", true);
    }

    public static List filterByDate(List datedValues, boolean allAreSame) {
        return EntityUtil.filterByDate(datedValues, UtilDateTime.nowTimestamp(), "fromDate", "thruDate", allAreSame);
    }

    public static List filterByDate(List datedValues, Date moment) {
        return EntityUtil.filterByDate(datedValues, new Timestamp(moment.getTime()), "fromDate", "thruDate", true);
    }

    public static List filterByDate(List datedValues, Timestamp moment) {
        return EntityUtil.filterByDate(datedValues, moment, "fromDate", "thruDate", true);
    }

    public static List filterByDate(List datedValues, Timestamp moment, String fromDateName, String thruDateName, boolean allAreSame) {
        if (datedValues == null) {
            return null;
        }
        if (moment == null) {
            return datedValues;
        }
        if (fromDateName == null) {
            throw new IllegalArgumentException("You must specify the name of the fromDate field to use this method");
        }
        if (thruDateName == null) {
            throw new IllegalArgumentException("You must specify the name of the thruDate field to use this method");
        }
        LinkedList<GenericValue> result = new LinkedList<GenericValue>();
        Iterator iter = datedValues.iterator();
        if (allAreSame) {
            Timestamp thruDate;
            Timestamp fromDate;
            GenericValue datedValue;
            ModelField fromDateField = null;
            ModelField thruDateField = null;
            if (iter.hasNext()) {
                datedValue = (GenericValue)iter.next();
                fromDateField = datedValue.getModelEntity().getField(fromDateName);
                if (fromDateField == null) {
                    throw new IllegalArgumentException("\"" + fromDateName + "\" is not a field of " + datedValue.getEntityName());
                }
                thruDateField = datedValue.getModelEntity().getField(thruDateName);
                if (fromDateField == null) {
                    throw new IllegalArgumentException("\"" + thruDateName + "\" is not a field of " + datedValue.getEntityName());
                }
                fromDate = (Timestamp)datedValue.dangerousGetNoCheckButFast(fromDateField);
                thruDate = (Timestamp)datedValue.dangerousGetNoCheckButFast(thruDateField);
                if ((thruDate == null || thruDate.after(moment)) && (fromDate == null || fromDate.before(moment))) {
                    result.add(datedValue);
                }
            }
            while (iter.hasNext()) {
                datedValue = (GenericValue)iter.next();
                fromDate = (Timestamp)datedValue.dangerousGetNoCheckButFast(fromDateField);
                thruDate = (Timestamp)datedValue.dangerousGetNoCheckButFast(thruDateField);
                if (thruDate != null && !thruDate.after(moment) || fromDate != null && !fromDate.before(moment)) continue;
                result.add(datedValue);
            }
        } else {
            while (iter.hasNext()) {
                GenericValue datedValue = (GenericValue)iter.next();
                Timestamp fromDate = datedValue.getTimestamp(fromDateName);
                Timestamp thruDate = datedValue.getTimestamp(thruDateName);
                if (thruDate != null && !thruDate.after(moment) || fromDate != null && !fromDate.before(moment)) continue;
                result.add(datedValue);
            }
        }
        return result;
    }

    public static List filterByAnd(List values, Map fields) {
        if (values == null) {
            return null;
        }
        ArrayList<GenericValue> result = null;
        if (fields == null || fields.size() == 0) {
            result = new ArrayList<GenericValue>(values);
        } else {
            result = new ArrayList(values.size());
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                GenericValue value = (GenericValue)iter.next();
                if (!value.matchesFields(fields)) continue;
                result.add(value);
            }
        }
        return result;
    }

    public static List filterByAnd(List values, List exprs) {
        if (values == null) {
            return null;
        }
        if (exprs == null || exprs.size() == 0) {
            return values;
        }
        ArrayList<GenericValue> result = new ArrayList<GenericValue>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            GenericValue value = (GenericValue)iter.next();
            Iterator exprIter = exprs.iterator();
            boolean include = true;
            while (exprIter.hasNext()) {
                EntityExpr expr = (EntityExpr)exprIter.next();
                Object lhs = value.get((String)expr.getLhs());
                Object rhs = expr.getRhs();
                int operatorId = expr.getOperator().getId();
                switch (operatorId) {
                    case 1: {
                        if (lhs == null) {
                            if (rhs == null) break;
                            include = false;
                            break;
                        }
                        if (lhs.equals(rhs)) break;
                        include = false;
                        break;
                    }
                    case 2: {
                        if (lhs == null) {
                            if (rhs != null) break;
                            include = false;
                            break;
                        }
                        if (!lhs.equals(rhs)) break;
                        include = false;
                        break;
                    }
                    case 4: {
                        if (lhs == null) {
                            if (rhs != null) break;
                            include = false;
                            break;
                        }
                        if (((Comparable)lhs).compareTo(rhs) > 0) break;
                        include = false;
                        break;
                    }
                    case 6: {
                        if (lhs == null) {
                            if (rhs == null) break;
                            include = false;
                            break;
                        }
                        if (((Comparable)lhs).compareTo(rhs) >= 0) break;
                        include = false;
                        break;
                    }
                    case 3: {
                        if (lhs == null) {
                            if (rhs != null) break;
                            include = false;
                            break;
                        }
                        if (((Comparable)lhs).compareTo(rhs) < 0) break;
                        include = false;
                        break;
                    }
                    case 5: {
                        if (lhs == null) {
                            if (rhs == null) break;
                            include = false;
                            break;
                        }
                        if (((Comparable)lhs).compareTo(rhs) <= 0) break;
                        include = false;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("The " + expr.getOperator().getCode() + " with id " + expr.getOperator().getId() + " operator is not yet supported by filterByAnd");
                    }
                }
                if (include) continue;
                break;
            }
            if (!include) continue;
            result.add(value);
        }
        return result;
    }

    public static List orderBy(List values, List orderBy) {
        if (values == null) {
            return null;
        }
        if (values.size() == 0) {
            return UtilMisc.toList((Collection)values);
        }
        ArrayList result = new ArrayList(values);
        Collections.sort(result, new OrderByComparator(orderBy));
        return result;
    }

    public static List getRelated(String relationName, List values) throws GenericEntityException {
        if (values == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            result.addAll(((GenericValue)iter.next()).getRelated(relationName));
        }
        return result;
    }

    public static List getRelatedCache(String relationName, List values) throws GenericEntityException {
        if (values == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            result.addAll(((GenericValue)iter.next()).getRelatedCache(relationName));
        }
        return result;
    }

    public static List getRelatedByAnd(String relationName, Map fields, List values) throws GenericEntityException {
        if (values == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            result.addAll(((GenericValue)iter.next()).getRelatedByAnd(relationName, fields));
        }
        return result;
    }

    static class OrderByComparator
    implements Comparator {
        private String field;
        private ModelField modelField = null;
        private boolean descending;
        private Comparator next = null;

        OrderByComparator(List orderBy) {
            this(orderBy, 0);
        }

        private OrderByComparator(List orderBy, int startIndex) {
            if (orderBy == null) {
                throw new IllegalArgumentException("orderBy may not be empty");
            }
            if (startIndex >= orderBy.size()) {
                throw new IllegalArgumentException("startIndex may not be greater than or equal to orderBy size");
            }
            String fieldAndDirection = (String)orderBy.get(startIndex);
            String upper = fieldAndDirection.trim().toUpperCase();
            if (upper.endsWith(" DESC")) {
                this.descending = true;
                this.field = fieldAndDirection.substring(0, fieldAndDirection.length() - 5);
            } else if (upper.endsWith(" ASC")) {
                this.descending = false;
                this.field = fieldAndDirection.substring(0, fieldAndDirection.length() - 4);
            } else {
                this.descending = false;
                this.field = fieldAndDirection;
            }
            if (startIndex + 1 < orderBy.size()) {
                this.next = new OrderByComparator(orderBy, startIndex + 1);
            }
        }

        public int compare(Object obj, Object obj1) {
            int result = this.compareAsc((GenericEntity)obj, (GenericEntity)obj1);
            if (this.descending && result != 0) {
                result = -result;
            }
            if (result == 0 && this.next != null) {
                return this.next.compare(obj, obj1);
            }
            return result;
        }

        private int compareAsc(GenericEntity obj, GenericEntity obj2) {
            if (this.modelField == null) {
                this.modelField = obj.getModelEntity().getField(this.field);
                if (this.modelField == null) {
                    throw new IllegalArgumentException("The field " + this.field + " could not be found in the entity " + obj.getEntityName());
                }
            }
            Object value = obj.dangerousGetNoCheckButFast(this.modelField);
            Object value2 = obj2.dangerousGetNoCheckButFast(this.modelField);
            if (value == null) {
                return value2 == null ? 0 : 1;
            }
            if (value2 == null) {
                return value == null ? 0 : -1;
            }
            int result = ((Comparable)value).compareTo(value2);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof OrderByComparator) {
                OrderByComparator that = (OrderByComparator)obj;
                return this.field.equals(that.field) && this.descending == that.descending && UtilValidate.areEqual((Object)this.next, (Object)that.next);
            }
            return false;
        }
    }
}

