/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericTransactionException;
import org.ofbiz.core.entity.TransactionFactory;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.util.Debug;

public class SequenceUtil {
    public static final String module = (class$org$ofbiz$core$entity$SequenceUtil == null ? (class$org$ofbiz$core$entity$SequenceUtil = SequenceUtil.class$("org.ofbiz.core.entity.SequenceUtil")) : class$org$ofbiz$core$entity$SequenceUtil).getName();
    Map sequences = new Hashtable();
    String helperName;
    ModelEntity seqEntity;
    String tableName;
    String nameColName;
    String idColName;
    static /* synthetic */ Class class$org$ofbiz$core$entity$SequenceUtil;

    private SequenceUtil() {
    }

    public SequenceUtil(String helperName, ModelEntity seqEntity, String nameFieldName, String idFieldName) {
        this.helperName = helperName;
        this.seqEntity = seqEntity;
        if (seqEntity == null) {
            throw new IllegalArgumentException("The sequence model entity was null but is required.");
        }
        this.tableName = seqEntity.getTableName(helperName);
        ModelField nameField = seqEntity.getField(nameFieldName);
        if (nameField == null) {
            throw new IllegalArgumentException("Could not find the field definition for the sequence name field " + nameFieldName);
        }
        this.nameColName = nameField.getColName();
        ModelField idField = seqEntity.getField(idFieldName);
        if (idField == null) {
            throw new IllegalArgumentException("Could not find the field definition for the sequence id field " + idFieldName);
        }
        this.idColName = idField.getColName();
    }

    public Long getNextSeqId(String seqName) {
        SequenceBank bank = (SequenceBank)this.sequences.get(seqName);
        if (bank == null) {
            bank = new SequenceBank(seqName, this);
            this.sequences.put(seqName, bank);
        }
        return bank.getNextSeqId();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SequenceBank {
        public static final long bankSize = 10L;
        public static final long startSeqId = 10000L;
        public static final int minWaitNanos = 500000;
        public static final int maxWaitNanos = 1000000;
        public static final int maxTries = 5;
        long curSeqId;
        long maxSeqId;
        String seqName;
        SequenceUtil parentUtil;

        public SequenceBank(String seqName, SequenceUtil parentUtil) {
            this.seqName = seqName;
            this.parentUtil = parentUtil;
            this.curSeqId = 0L;
            this.maxSeqId = 0L;
            this.fillBank();
        }

        public synchronized Long getNextSeqId() {
            if (this.curSeqId < this.maxSeqId) {
                Long retSeqId = new Long(this.curSeqId);
                ++this.curSeqId;
                return retSeqId;
            }
            this.fillBank();
            if (this.curSeqId < this.maxSeqId) {
                Long retSeqId = new Long(this.curSeqId);
                ++this.curSeqId;
                return retSeqId;
            }
            Debug.logError((String)"[SequenceUtil.SequenceBank.getNextSeqId] Fill bank failed, returning null", (String)module);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected synchronized void fillBank() {
            block66: {
                if (this.curSeqId < this.maxSeqId) {
                    return;
                }
                val1 = 0L;
                val2 = 0L;
                manualTX = true;
                suspendedTransaction = null;
                transactionManager = null;
                try {
                    if (TransactionUtil.getStatus() != 0) break block66;
                    manualTX = false;
                    try {
                        transactionManager = TransactionFactory.getTransactionManager();
                        if (transactionManager != null) {
                            suspendedTransaction = transactionManager.suspend();
                            manualTX = true;
                        }
                    }
                    catch (SystemException e) {
                        Debug.logError((Throwable)e, (String)"System Error suspending transaction in sequence util");
                    }
                }
                catch (GenericTransactionException e) {
                    Debug.logWarning((String)("[SequenceUtil.SequenceBank.fillBank] Exception was thrown trying to check transaction status: " + e.toString()), (String)SequenceUtil.module);
                }
            }
            connection = null;
            stmt = null;
            rs = null;
            try {
                connection = ConnectionFactory.getConnection(this.parentUtil.helperName);
            }
            catch (SQLException sqle) {
                Debug.logWarning((String)"[SequenceUtil.SequenceBank.fillBank]: Unable to esablish a connection with the database... Error was:", (String)SequenceUtil.module);
                Debug.logWarning((String)sqle.getMessage(), (String)SequenceUtil.module);
            }
            catch (GenericEntityException e) {
                Debug.logWarning((String)"[SequenceUtil.SequenceBank.fillBank]: Unable to esablish a connection with the database... Error was:", (String)SequenceUtil.module);
                Debug.logWarning((String)e.getMessage(), (String)SequenceUtil.module);
            }
            sql = null;
            try {
                block70: {
                    block73: {
                        block74: {
                            block68: {
                                block72: {
                                    block71: {
                                        block67: {
                                            try {
                                                connection.setAutoCommit(false);
                                            }
                                            catch (SQLException sqle) {
                                                manualTX = false;
                                            }
                                            stmt = connection.createStatement();
                                            numTries = 0;
lbl47:
                                            // 3 sources

                                            while (val1 + 10L != val2) {
                                                if (Debug.verboseOn()) {
                                                    Debug.logVerbose((String)("[SequenceUtil.SequenceBank.fillBank] Trying to get a bank of sequenced ids for " + this.seqName + "; start of loop val1=" + val1 + ", val2=" + val2 + ", bankSize=" + 10L), (String)SequenceUtil.module);
                                                }
                                                if ((rs = stmt.executeQuery(sql = "SELECT " + this.parentUtil.idColName + " FROM " + this.parentUtil.tableName + " WHERE " + this.parentUtil.nameColName + "='" + this.seqName + "'")).next()) {
                                                    val1 = rs.getInt(this.parentUtil.idColName);
                                                    try {
                                                        if (rs != null) {
                                                            rs.close();
                                                        }
                                                        break block67;
                                                    }
                                                    catch (SQLException sqle) {
                                                        Debug.logWarning((Throwable)sqle, (String)"Error closing result set in sequence util");
                                                    }
                                                    break block67;
                                                }
                                                Debug.logWarning((String)("[SequenceUtil.SequenceBank.fillBank] first select failed: trying to add row, result set was empty for sequence: " + this.seqName), (String)SequenceUtil.module);
                                                try {
                                                    if (rs != null) {
                                                        rs.close();
                                                    }
                                                }
                                                catch (SQLException sqle) {
                                                    Debug.logWarning((Throwable)sqle, (String)"Error closing result set in sequence util");
                                                }
                                                if (stmt.executeUpdate(sql = "INSERT INTO " + this.parentUtil.tableName + " (" + this.parentUtil.nameColName + ", " + this.parentUtil.idColName + ") VALUES ('" + this.seqName + "', " + 10000L + ")") > 0) continue;
                                                var16_26 = null;
                                                ** GOTO lbl161
                                            }
                                            break block70;
                                        }
                                        if (stmt.executeUpdate(sql = "UPDATE " + this.parentUtil.tableName + " SET " + this.parentUtil.idColName + "=" + this.parentUtil.idColName + "+" + 10L + " WHERE " + this.parentUtil.nameColName + "='" + this.seqName + "'") > 0) break block71;
                                        Debug.logWarning((String)("[SequenceUtil.SequenceBank.fillBank] update failed, no rows changes for seqName: " + this.seqName), (String)SequenceUtil.module);
                                        ** GOTO lbl175
                                    }
                                    if (manualTX) {
                                        connection.commit();
                                    }
                                    if (!(rs = stmt.executeQuery(sql = "SELECT " + this.parentUtil.idColName + " FROM " + this.parentUtil.tableName + " WHERE " + this.parentUtil.nameColName + "='" + this.seqName + "'")).next()) break block72;
                                    val2 = rs.getInt(this.parentUtil.idColName);
                                    try {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                        break block68;
                                    }
                                    catch (SQLException sqle) {
                                        Debug.logWarning((Throwable)sqle, (String)"Error closing result set in sequence util");
                                    }
                                    break block68;
                                }
                                Debug.logWarning((String)("[SequenceUtil.SequenceBank.fillBank] second select failed: aborting, result set was empty for sequence: " + this.seqName), (String)SequenceUtil.module);
                                try {
                                    if (rs != null) {
                                        rs.close();
                                    }
                                    ** GOTO lbl190
                                }
                                catch (SQLException sqle) {
                                    Debug.logWarning((Throwable)sqle, (String)"Error closing result set in sequence util");
                                }
                                ** GOTO lbl190
                            }
                            if (manualTX) {
                                connection.commit();
                            }
                            if (val1 + 10L == val2) break block73;
                            if (numTries < 5) break block74;
                            Debug.logError((String)"[SequenceUtil.SequenceBank.fillBank] maxTries (5) reached, giving up.", (String)SequenceUtil.module);
                            ** GOTO lbl205
                        }
                        waitTime = new Double(Math.random() * 500000.0).intValue() + 500000;
                        try {
                            this.wait(0L, waitTime);
                        }
                        catch (Exception e) {
                            Debug.logWarning((Throwable)e, (String)"Error waiting in sequence util");
                        }
                    }
                    ++numTries;
                    ** GOTO lbl47
                }
                this.curSeqId = val1;
                this.maxSeqId = val2;
                if (Debug.verboseOn()) {
                    Debug.logVerbose((String)("[SequenceUtil.SequenceBank.fillBank] Successfully got a bank of sequenced ids for " + this.seqName + "; curSeqId=" + this.curSeqId + ", maxSeqId=" + this.maxSeqId + ", bankSize=" + 10L), (String)SequenceUtil.module);
                }
                ** GOTO lbl220
            }
            catch (SQLException sqle) {
                Debug.logWarning((String)("[SequenceUtil.SequenceBank.fillBank] SQL Exception while executing the following:\n" + sql + "\nError was:"), (String)SequenceUtil.module);
                Debug.logWarning((String)sqle.getMessage(), (String)SequenceUtil.module);
                var16_31 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sqle) {
                    Debug.logWarning((Throwable)sqle, (String)"Error closing statement in sequence util");
                }
                try {
                    if (connection == null) return;
                    connection.close();
                    return;
                }
                catch (SQLException sqle) {
                    Debug.logWarning((Throwable)sqle, (String)"Error closing connection in sequence util");
                }
                return;
            }
            {
                block80: {
                    block79: {
                        block78: {
                            block77: {
                                block76: {
                                    catch (Throwable var15_40) {
                                        block75: {
                                            var16_32 = null;
                                            ** try [egrp 11[TRYBLOCK] [22 : 1147->1162)] { 
lbl148:
                                            // 1 sources

                                            if (stmt != null) {
                                                stmt.close();
                                            }
                                            break block75;
lbl151:
                                            // 1 sources

                                            catch (SQLException sqle) {
                                                Debug.logWarning((Throwable)sqle, (String)"Error closing statement in sequence util");
                                            }
                                        }
                                        ** try [egrp 12[TRYBLOCK] [23 : 1171->1186)] { 
lbl155:
                                        // 1 sources

                                        if (connection == null) throw var15_40;
                                        connection.close();
                                        throw var15_40;
lbl158:
                                        // 1 sources

                                        catch (SQLException sqle) {
                                            Debug.logWarning((Throwable)sqle, (String)"Error closing connection in sequence util");
                                        }
                                        throw var15_40;
                                    }
lbl161:
                                    // 1 sources

                                    ** try [egrp 11[TRYBLOCK] [22 : 1147->1162)] { 
lbl162:
                                    // 1 sources

                                    if (stmt != null) {
                                        stmt.close();
                                    }
                                    break block76;
lbl165:
                                    // 1 sources

                                    catch (SQLException sqle) {
                                        Debug.logWarning((Throwable)sqle, (String)"Error closing statement in sequence util");
                                    }
                                }
                                try {}
                                catch (SQLException sqle) {
                                    Debug.logWarning((Throwable)sqle, (String)"Error closing connection in sequence util");
                                    return;
                                }
                                if (connection == null) return;
                                connection.close();
                                return;
lbl175:
                                // 1 sources

                                var16_27 = null;
                                ** try [egrp 11[TRYBLOCK] [22 : 1147->1162)] { 
lbl177:
                                // 1 sources

                                if (stmt != null) {
                                    stmt.close();
                                }
                                break block77;
lbl180:
                                // 1 sources

                                catch (SQLException sqle) {
                                    Debug.logWarning((Throwable)sqle, (String)"Error closing statement in sequence util");
                                }
                            }
                            ** try [egrp 12[TRYBLOCK] [23 : 1171->1186)] { 
lbl184:
                            // 1 sources

                            if (connection == null) return;
                            connection.close();
                            return;
lbl187:
                            // 1 sources

                            catch (SQLException sqle) {
                                Debug.logWarning((Throwable)sqle, (String)"Error closing connection in sequence util");
                            }
                            return;
lbl190:
                            // 3 sources

                            var16_28 = null;
                            ** try [egrp 11[TRYBLOCK] [22 : 1147->1162)] { 
lbl192:
                            // 1 sources

                            if (stmt != null) {
                                stmt.close();
                            }
                            break block78;
lbl195:
                            // 1 sources

                            catch (SQLException sqle) {
                                Debug.logWarning((Throwable)sqle, (String)"Error closing statement in sequence util");
                            }
                        }
                        try {}
                        catch (SQLException sqle) {
                            Debug.logWarning((Throwable)sqle, (String)"Error closing connection in sequence util");
                            return;
                        }
                        if (connection == null) return;
                        connection.close();
                        return;
lbl205:
                        // 1 sources

                        var16_29 = null;
                        ** try [egrp 11[TRYBLOCK] [22 : 1147->1162)] { 
lbl207:
                        // 1 sources

                        if (stmt != null) {
                            stmt.close();
                        }
                        break block79;
lbl210:
                        // 1 sources

                        catch (SQLException sqle) {
                            Debug.logWarning((Throwable)sqle, (String)"Error closing statement in sequence util");
                        }
                    }
                    ** try [egrp 12[TRYBLOCK] [23 : 1171->1186)] { 
lbl214:
                    // 1 sources

                    if (connection == null) return;
                    connection.close();
                    return;
lbl217:
                    // 1 sources

                    catch (SQLException sqle) {
                        Debug.logWarning((Throwable)sqle, (String)"Error closing connection in sequence util");
                    }
                    return;
lbl220:
                    // 1 sources

                    var16_30 = null;
                    ** try [egrp 11[TRYBLOCK] [22 : 1147->1162)] { 
lbl222:
                    // 1 sources

                    if (stmt != null) {
                        stmt.close();
                    }
                    break block80;
lbl225:
                    // 1 sources

                    catch (SQLException sqle) {
                        Debug.logWarning((Throwable)sqle, (String)"Error closing statement in sequence util");
                    }
                }
                ** try [egrp 12[TRYBLOCK] [23 : 1171->1186)] { 
lbl229:
                // 1 sources

                if (connection != null) {
                    connection.close();
                }
lbl233:
                // 1 sources

                catch (SQLException sqle) {}
                Debug.logWarning((Throwable)sqle, (String)"Error closing connection in sequence util");
            }
            if (suspendedTransaction == null) return;
            try {
                if (transactionManager == null) {
                    transactionManager = TransactionFactory.getTransactionManager();
                }
                if (transactionManager == null) return;
                transactionManager.resume(suspendedTransaction);
                return;
            }
            catch (InvalidTransactionException e) {
                Debug.logError((Throwable)e, (String)"InvalidTransaction Error resuming suspended transaction in sequence util");
                return;
            }
            catch (IllegalStateException e) {
                Debug.logError((Throwable)e, (String)"IllegalState Error resuming suspended transaction in sequence util");
                return;
            }
            catch (SystemException e) {
                Debug.logError((Throwable)e, (String)"System Error resuming suspended transaction in sequence util");
            }
        }
    }
}

