/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.transaction.JNDIConnectionDetails;
import org.ofbiz.core.entity.transaction.TransactionFactoryInterface;
import org.ofbiz.core.entity.util.ClassLoaderUtils;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.GeneralException;
import org.ofbiz.core.util.JNDIContextFactory;
import org.w3c.dom.Element;

public class JNDIAutomaticFactory
implements TransactionFactoryInterface {
    public static final String module = (class$org$ofbiz$core$entity$transaction$JNDIAutomaticFactory == null ? (class$org$ofbiz$core$entity$transaction$JNDIAutomaticFactory = JNDIAutomaticFactory.class$("org.ofbiz.core.entity.transaction.JNDIAutomaticFactory")) : class$org$ofbiz$core$entity$transaction$JNDIAutomaticFactory).getName();
    static TransactionManager transactionManager = null;
    static UserTransaction userTransaction = null;
    protected static Map dsCache = new HashMap();
    protected static final Properties CONFIGURATION = new Properties();
    protected static final String AUTO_CONFIGURE_TRANS_MGR;
    protected static final String[] TRANSMGR_NAME_GUESS;
    protected static final String[] USR_TRANSMGR_NAME_GUESS;
    protected static final String AUTO_CONFIGURE_JNDI_PREFIX;
    protected static final String[] JNDI_PREFIX_GUESSES;
    protected static JNDIConnectionDetails conDetails;
    protected static final String LIST_DELIMITER = ",";
    static /* synthetic */ Class class$org$ofbiz$core$entity$transaction$JNDIAutomaticFactory;
    static /* synthetic */ Class class$org$ofbiz$core$entity$transaction$JNDIFactory;
    static /* synthetic */ Class class$org$ofbiz$core$entity$ConnectionFactory;

    private static String getNonNullProperty(String propertyKey, String defaultValue) {
        String fieldValue = CONFIGURATION.getProperty(propertyKey);
        if (fieldValue != null) {
            return fieldValue;
        }
        Debug.logError((String)(propertyKey + " not set in the ofbiz-database.properties file. Using default value: " + defaultValue));
        return defaultValue;
    }

    static String[] parseList(String str) {
        ArrayList<String> list = new ArrayList<String>();
        int currentPosition = 0;
        int nextDelimiter = str.indexOf(LIST_DELIMITER, currentPosition);
        while (nextDelimiter >= currentPosition) {
            list.add(str.substring(currentPosition, nextDelimiter));
            currentPosition = nextDelimiter + LIST_DELIMITER.length();
            nextDelimiter = str.indexOf(LIST_DELIMITER, currentPosition);
        }
        list.add(str.substring(currentPosition));
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionManager getTransactionManager() {
        if (transactionManager == null) {
            Class clazz = class$org$ofbiz$core$entity$transaction$JNDIFactory == null ? (class$org$ofbiz$core$entity$transaction$JNDIFactory = JNDIAutomaticFactory.class$("org.ofbiz.core.entity.transaction.JNDIFactory")) : class$org$ofbiz$core$entity$transaction$JNDIFactory;
            synchronized (clazz) {
                if (transactionManager == null) {
                    try {
                        String jndiName = EntityConfigUtil.getTxFactoryTxMgrJndiName();
                        String jndiServerName = EntityConfigUtil.getTxFactoryTxMgrJndiServerName();
                        if (jndiName != null && jndiName.length() > 0) {
                            String[] guessList = new String[]{jndiName};
                            if (AUTO_CONFIGURE_TRANS_MGR.equals(jndiName)) {
                                guessList = TRANSMGR_NAME_GUESS;
                            }
                            transactionManager = (TransactionManager)this.retrieveJNDIObject(jndiServerName, guessList);
                        }
                    }
                    catch (GeneralException e) {
                        Debug.logError((Throwable)e);
                        transactionManager = null;
                    }
                }
            }
        }
        return transactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserTransaction getUserTransaction() {
        if (userTransaction == null) {
            Class clazz = class$org$ofbiz$core$entity$transaction$JNDIFactory == null ? (class$org$ofbiz$core$entity$transaction$JNDIFactory = JNDIAutomaticFactory.class$("org.ofbiz.core.entity.transaction.JNDIFactory")) : class$org$ofbiz$core$entity$transaction$JNDIFactory;
            synchronized (clazz) {
                if (userTransaction == null) {
                    try {
                        String jndiName = EntityConfigUtil.getTxFactoryUserTxJndiName();
                        String jndiServerName = EntityConfigUtil.getTxFactoryUserTxJndiServerName();
                        if (jndiName != null && jndiName.length() > 0) {
                            String[] guessList = new String[]{jndiName};
                            if (AUTO_CONFIGURE_TRANS_MGR.equals(jndiName)) {
                                guessList = USR_TRANSMGR_NAME_GUESS;
                            }
                            userTransaction = (UserTransaction)this.retrieveJNDIObject(jndiServerName, guessList);
                        }
                    }
                    catch (GeneralException e) {
                        Debug.logError((Throwable)e);
                        transactionManager = null;
                    }
                }
            }
        }
        return userTransaction;
    }

    private Object retrieveJNDIObject(String jndiServerName, String[] jndiNameGuesses) throws GeneralException {
        for (int i = 0; i < jndiNameGuesses.length; ++i) {
            String jndiNameGuess = jndiNameGuesses[i];
            try {
                Object jndiObject;
                InitialContext ic = JNDIContextFactory.getInitialContext((String)jndiServerName);
                if (ic == null || (jndiObject = ic.lookup(jndiNameGuess)) == null) continue;
                Debug.logInfo((String)("JNDI Object found using the look-up name " + jndiNameGuess), (String)module);
                return jndiObject;
            }
            catch (NamingException ne) {
                Debug.logInfo((String)("JNDI Object not found using the look-up name " + jndiNameGuess + " in JNDI."), (String)module);
            }
        }
        Debug.logWarning((String)("JNDI Object could not be found in " + this.arrayToString(jndiNameGuesses)), (String)module);
        return null;
    }

    private String arrayToString(String[] arr) {
        StringBuffer buff = new StringBuffer();
        buff.append("{");
        if (arr != null) {
            for (int i = 0; i < arr.length - 1; ++i) {
                buff.append(arr[i] + LIST_DELIMITER);
            }
            buff.append(arr[arr.length - 1]);
        }
        buff.append("}");
        return buff.toString();
    }

    public String getTxMgrName() {
        return "jndi";
    }

    public Connection getConnection(String helperName) throws SQLException, GenericEntityException {
        EntityConfigUtil.DatasourceInfo datasourceInfo = EntityConfigUtil.getDatasourceInfo(helperName);
        Connection con = null;
        if (datasourceInfo.jndiJdbcElement != null) {
            if (!conDetails.detailsSet()) {
                Element jndiJdbcElement = datasourceInfo.jndiJdbcElement;
                String jndiName = jndiJdbcElement.getAttribute("jndi-name");
                boolean guessJndiName = jndiName.startsWith(AUTO_CONFIGURE_JNDI_PREFIX);
                conDetails.setServerName(jndiJdbcElement.getAttribute("jndi-server-name"));
                if (guessJndiName) {
                    String jndiSuffix = jndiName.substring(AUTO_CONFIGURE_JNDI_PREFIX.length());
                    for (int i = 0; i < JNDI_PREFIX_GUESSES.length; ++i) {
                        String jndiPrefixGuess = JNDI_PREFIX_GUESSES[i];
                        con = JNDIAutomaticFactory.getJndiConnection(jndiPrefixGuess + jndiSuffix, conDetails.getServerName());
                        if (con != null) {
                            conDetails.setConnectionName(jndiPrefixGuess + jndiSuffix);
                            Debug.logInfo((String)("Found connection using the JNDI name '" + jndiPrefixGuess + jndiSuffix + "'"), (String)module);
                            break;
                        }
                        Debug.logInfo((String)("Failed to find connection using the JNDI name '" + jndiPrefixGuess + jndiSuffix + "'"), (String)module);
                    }
                } else {
                    conDetails.setConnectionName(jndiName);
                }
            }
            if (con == null) {
                con = JNDIAutomaticFactory.getJndiConnection(conDetails.getConnectionName(), conDetails.getServerName());
            }
            if (con != null) {
                return con;
            }
        } else {
            Debug.logError((String)("JNDI loaded is the configured transaction manager but no jndi-jdbc element was specified in the " + helperName + " datasource. Please check your configuration; will try other sources"));
        }
        if (datasourceInfo.inlineJdbcElement != null) {
            return ConnectionFactory.tryGenericConnectionSources(helperName, datasourceInfo.inlineJdbcElement);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getJndiConnection(String jndiName, String jndiServerName) throws SQLException, GenericEntityException {
        Object ds = dsCache.get(jndiName);
        if (ds != null) {
            if (ds instanceof XADataSource) {
                XADataSource xads = (XADataSource)ds;
                return TransactionUtil.enlistConnection(xads.getXAConnection());
            }
            DataSource nds = (DataSource)ds;
            return nds.getConnection();
        }
        Class clazz = class$org$ofbiz$core$entity$ConnectionFactory == null ? (class$org$ofbiz$core$entity$ConnectionFactory = JNDIAutomaticFactory.class$("org.ofbiz.core.entity.ConnectionFactory")) : class$org$ofbiz$core$entity$ConnectionFactory;
        synchronized (clazz) {
            ds = dsCache.get(jndiName);
            if (ds != null) {
                if (ds instanceof XADataSource) {
                    XADataSource xads = (XADataSource)ds;
                    return TransactionUtil.enlistConnection(xads.getXAConnection());
                }
                DataSource nds = (DataSource)ds;
                return nds.getConnection();
            }
            try {
                InitialContext ic;
                if (Debug.infoOn()) {
                    Debug.logInfo((String)("Doing JNDI lookup for name " + jndiName), (String)module);
                }
                if ((ic = JNDIContextFactory.getInitialContext((String)jndiServerName)) != null) {
                    ds = ic.lookup(jndiName);
                } else {
                    Debug.logWarning((String)("Initial Context returned was NULL for server name " + jndiServerName), (String)module);
                }
                if (ds != null) {
                    Connection con;
                    if (Debug.verboseOn()) {
                        Debug.logVerbose((String)"Got a Datasource object.", (String)module);
                    }
                    dsCache.put(jndiName, ds);
                    if (ds instanceof XADataSource) {
                        if (Debug.infoOn()) {
                            Debug.logInfo((String)("Got XADataSource for name " + jndiName), (String)module);
                        }
                        XADataSource xads = (XADataSource)ds;
                        XAConnection xac = xads.getXAConnection();
                        con = TransactionUtil.enlistConnection(xac);
                    } else {
                        if (Debug.infoOn()) {
                            Debug.logInfo((String)("Got DataSource for name " + jndiName), (String)module);
                        }
                        DataSource nds = (DataSource)ds;
                        con = nds.getConnection();
                    }
                    return con;
                }
                Debug.logError((String)"Datasource returned was NULL.", (String)module);
            }
            catch (NamingException ne) {
            }
            catch (GenericConfigException gce) {
                throw new GenericEntityException("Problems with the JNDI configuration.", gce.getNested());
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            CONFIGURATION.load(ClassLoaderUtils.getResourceAsStream("ofbiz-database.properties", class$org$ofbiz$core$entity$transaction$JNDIFactory == null ? (class$org$ofbiz$core$entity$transaction$JNDIFactory = JNDIAutomaticFactory.class$("org.ofbiz.core.entity.transaction.JNDIFactory")) : class$org$ofbiz$core$entity$transaction$JNDIFactory));
        }
        catch (Exception e) {
            Debug.logError((String)"Unable to find ofbiz-database.properties file. Using default values for ofbiz configuration.");
        }
        AUTO_CONFIGURE_TRANS_MGR = JNDIAutomaticFactory.getNonNullProperty("transactionManager.autoConfigure", "${auto-jndi-name}");
        TRANSMGR_NAME_GUESS = JNDIAutomaticFactory.parseList(JNDIAutomaticFactory.getNonNullProperty("transactionManager.guess", "java:comp/UserTransaction,java:comp/env/UserTransaction"));
        USR_TRANSMGR_NAME_GUESS = JNDIAutomaticFactory.parseList(JNDIAutomaticFactory.getNonNullProperty("usrTransactionManager.guess", "java:comp/UserTransaction,java:comp/env/UserTransaction"));
        AUTO_CONFIGURE_JNDI_PREFIX = JNDIAutomaticFactory.getNonNullProperty("jndiPrefix.autoConfigure", "${auto-server-prefix}");
        JNDI_PREFIX_GUESSES = JNDIAutomaticFactory.parseList(JNDIAutomaticFactory.getNonNullProperty("jndiPrefix.guess", "jdbc/,java:comp/env/jdbc/,"));
        conDetails = new JNDIConnectionDetails();
    }
}

