/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.AccessFlags;
import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.DeprecatedAttribute;
import com.tangosol.dev.assembler.DoubleConstant;
import com.tangosol.dev.assembler.Field;
import com.tangosol.dev.assembler.FieldConstant;
import com.tangosol.dev.assembler.FloatConstant;
import com.tangosol.dev.assembler.InnerClassesAttribute;
import com.tangosol.dev.assembler.IntConstant;
import com.tangosol.dev.assembler.LongConstant;
import com.tangosol.dev.assembler.Method;
import com.tangosol.dev.assembler.MethodConstant;
import com.tangosol.dev.assembler.SourceFileAttribute;
import com.tangosol.dev.assembler.SyntheticAttribute;
import com.tangosol.dev.assembler.UtfConstant;
import com.tangosol.dev.assembler.VMStructure;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.util.StringTable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;

public class ClassFile
extends VMStructure
implements Constants {
    private static final String CLASS = "ClassFile";
    private static final int ACC_CLASS = 1055;
    private static final int ACC_INTERFACE = 1;
    private boolean m_fModified;
    private boolean m_fLoaded;
    private byte[] m_abClazz;
    private ConstantPool m_pool;
    private ClassConstant m_clzName;
    private ClassConstant m_clzSuper;
    private AccessFlags m_flags;
    private StringTable m_tblInterface;
    private StringTable m_tblField;
    private StringTable m_tblMethod;
    private StringTable m_tblAttribute;
    private final StringTable[] CONTAINED_TABLE = new StringTable[3];

    public ClassFile(String sThis, String sSuper, boolean fInterface) {
        this.init();
        this.setLoaded(true);
        this.setName(sThis);
        this.setSuper(sSuper);
        this.setInterface(fInterface);
        this.setSynchronized(true);
    }

    public ClassFile(byte[] abClazz) {
        this.setBytes(abClazz);
    }

    public ClassFile(DataInput stream) throws IOException {
        this.load(stream);
    }

    public void load(DataInput stream) throws IOException {
        int MAX = 8192;
        byte[] abBuf = new byte[8192];
        ByteArrayOutputStream streamRaw = new ByteArrayOutputStream(8192);
        int of = 0;
        try {
            while (true) {
                byte b = stream.readByte();
                abBuf[of++] = b;
                if (of != 8192) continue;
                streamRaw.write(abBuf, 0, 8192);
                of = 0;
            }
        }
        catch (EOFException e) {
            if (of > 0) {
                streamRaw.write(abBuf, 0, of);
            }
            this.setBytes(streamRaw.toByteArray());
            return;
        }
    }

    public void save(DataOutput stream) throws IOException {
        stream.write(this.getBytes());
    }

    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        int i;
        int i2;
        int nCookie = stream.readInt();
        if (nCookie != -889275714) {
            throw new IOException("ClassFile.disassemble:  Class cookie not found!");
        }
        int nMinor = stream.readUnsignedShort();
        int nMajor = stream.readUnsignedShort();
        if (nMajor < 45 || nMajor == 45 && nMinor < 0 || nMajor > 48 || nMajor == 48 && nMinor > 0) {
            throw new IOException("ClassFile.disassemble:  Version (" + nMajor + '.' + nMinor + ") not supported!");
        }
        pool.disassemble(stream, pool);
        this.m_pool = pool;
        this.m_flags.disassemble(stream, pool);
        this.m_clzName = (ClassConstant)pool.getConstant(stream.readUnsignedShort());
        this.m_clzSuper = (ClassConstant)pool.getConstant(stream.readUnsignedShort());
        this.m_tblInterface.clear();
        int c = stream.readUnsignedShort();
        for (i2 = 0; i2 < c; ++i2) {
            ClassConstant clz = (ClassConstant)pool.getConstant(stream.readUnsignedShort());
            this.m_tblInterface.put(clz.getValue(), clz);
        }
        this.m_tblField.clear();
        c = stream.readUnsignedShort();
        for (i2 = 0; i2 < c; ++i2) {
            Field field = new Field();
            field.disassemble(stream, pool);
            this.m_tblField.put(field.getIdentity(), field);
        }
        this.m_tblMethod.clear();
        c = stream.readUnsignedShort();
        String sClass = this.m_clzName.getValue();
        for (i = 0; i < c; ++i) {
            Method method = new Method(sClass);
            method.disassemble(stream, pool);
            this.m_tblMethod.put(method.getIdentity(), method);
        }
        this.m_tblAttribute.clear();
        c = stream.readUnsignedShort();
        for (i = 0; i < c; ++i) {
            Attribute attribute = Attribute.loadAttribute(this, stream, pool);
            this.m_tblAttribute.put(attribute.getIdentity(), attribute);
        }
        this.resetModified();
    }

    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_clzName);
        if (this.m_clzSuper != null) {
            pool.registerConstant(this.m_clzSuper);
        }
        Enumeration enmr = this.m_tblInterface.elements();
        while (enmr.hasMoreElements()) {
            pool.registerConstant((ClassConstant)enmr.nextElement());
        }
        StringTable[] atbl = this.CONTAINED_TABLE;
        for (int i = 0; i < atbl.length; ++i) {
            StringTable tbl = atbl[i];
            enmr = tbl.elements();
            while (enmr.hasMoreElements()) {
                ((VMStructure)enmr.nextElement()).preassemble(pool);
            }
        }
    }

    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeInt(-889275714);
        stream.writeShort(3);
        stream.writeShort(45);
        this.m_pool.assemble(stream, pool);
        this.m_flags.assemble(stream, pool);
        stream.writeShort(pool.findConstant(this.m_clzName));
        stream.writeShort(this.m_clzSuper == null ? 0 : pool.findConstant(this.m_clzSuper));
        stream.writeShort(this.m_tblInterface.getSize());
        Enumeration enmr = this.m_tblInterface.elements();
        while (enmr.hasMoreElements()) {
            ClassConstant clz = (ClassConstant)enmr.nextElement();
            stream.writeShort(pool.findConstant(clz));
        }
        StringTable[] atbl = this.CONTAINED_TABLE;
        for (int i = 0; i < atbl.length; ++i) {
            StringTable tbl = atbl[i];
            stream.writeShort(tbl.getSize());
            enmr = tbl.elements();
            while (enmr.hasMoreElements()) {
                ((VMStructure)enmr.nextElement()).assemble(stream, pool);
            }
        }
    }

    public String toString() {
        String sSuper;
        StringBuffer sb = new StringBuffer();
        boolean fInterface = this.isInterface();
        String sMod = this.m_flags.toString(fInterface ? 1 : 1055);
        if (sMod.length() > 0) {
            sb.append(sMod).append(' ');
        }
        sb.append(fInterface ? "interface " : "class ").append(this.m_clzName.getJavaName());
        ClassConstant clzSuper = this.m_clzSuper;
        if (clzSuper != null && !(sSuper = clzSuper.getValue()).equals("java/lang/Object")) {
            sb.append(" extends ").append(clzSuper.getJavaName());
        }
        if (!this.m_tblInterface.isEmpty()) {
            sb.append(fInterface ? " extends " : " implements ");
            Enumeration enmr = this.m_tblInterface.elements();
            boolean fTrailing = false;
            while (enmr.hasMoreElements()) {
                if (fTrailing) {
                    sb.append(", ");
                }
                sb.append(((ClassConstant)enmr.nextElement()).getJavaName());
                fTrailing = true;
            }
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassFile) {
            ClassFile that = (ClassFile)obj;
            if (this == that) {
                return true;
            }
            byte[] abThis = this.getBytes();
            byte[] abThat = that.getBytes();
            return Arrays.equals(abThis, abThat);
        }
        return false;
    }

    protected void init() {
        this.m_fModified = false;
        this.m_fLoaded = false;
        this.m_abClazz = null;
        this.m_clzName = null;
        this.m_clzSuper = null;
        this.m_pool = new ConstantPool();
        this.m_flags = new AccessFlags();
        this.m_tblInterface = new StringTable();
        this.m_tblField = new StringTable();
        this.m_tblMethod = new StringTable();
        this.m_tblAttribute = new StringTable();
        this.CONTAINED_TABLE[0] = this.m_tblField;
        this.CONTAINED_TABLE[1] = this.m_tblMethod;
        this.CONTAINED_TABLE[2] = this.m_tblAttribute;
    }

    public void relocate(String sPkg) {
        if (!sPkg.replace('.', '/').equals("_package/")) {
            this.resolve(new Relocator(sPkg));
        }
    }

    public void resolve(Resolver resolver) {
        byte[] ab = this.getBytes();
        if (this.isLoaded()) {
            this.init();
        }
        try {
            ByteArrayReadBuffer in = new ByteArrayReadBuffer(ab);
            ByteArrayOutputStream out = new ByteArrayOutputStream((int)((double)ab.length * 1.25));
            ReadBuffer.BufferInput streamIn = in.getBufferInput();
            DataOutputStream streamOut = new DataOutputStream(out);
            int ofStart = 8;
            streamIn.setOffset(ofStart);
            out.write(ab, 0, ofStart);
            int cConst = streamIn.readUnsignedShort();
            streamOut.writeShort(cConst);
            for (int i = 1; i < cConst; ++i) {
                Constant constant = null;
                int nTag = streamIn.readUnsignedByte();
                switch (nTag) {
                    case 1: {
                        constant = new UtfConstant();
                        break;
                    }
                    case 3: {
                        constant = new IntConstant();
                        break;
                    }
                    case 4: {
                        constant = new FloatConstant();
                        break;
                    }
                    case 5: {
                        constant = new LongConstant();
                        ++i;
                        break;
                    }
                    case 6: {
                        constant = new DoubleConstant();
                        ++i;
                        break;
                    }
                    case 7: 
                    case 8: {
                        streamOut.writeByte(nTag);
                        streamOut.writeShort(streamIn.readUnsignedShort());
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        streamOut.writeByte(nTag);
                        streamOut.writeShort(streamIn.readUnsignedShort());
                        streamOut.writeShort(streamIn.readUnsignedShort());
                        break;
                    }
                    default: {
                        throw new IOException("Invalid constant tag " + nTag);
                    }
                }
                if (constant == null) continue;
                constant.disassemble(streamIn, null);
                constant = resolver.resolve(constant);
                constant.assemble(streamOut, null);
            }
            int ofStop = streamIn.getOffset();
            out.write(ab, ofStop, ab.length - ofStop);
            ab = out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Illegal .class structure!\n" + e.toString());
        }
        this.setBytes(ab);
    }

    protected boolean isLoaded() {
        return this.m_fLoaded;
    }

    protected void setLoaded(boolean fLoaded) {
        this.m_fLoaded = fLoaded;
    }

    protected void ensureLoaded() {
        if (!this.m_fLoaded) {
            if (this.m_abClazz != null) {
                ByteArrayInputStream streamRaw = new ByteArrayInputStream(this.m_abClazz);
                DataInputStream stream = new DataInputStream(streamRaw);
                try {
                    this.disassemble(stream, this.m_pool);
                }
                catch (IOException e) {
                    throw ClassFile.ensureRuntimeException(e);
                }
            }
            this.m_fLoaded = true;
        }
    }

    public boolean isModified() {
        if (!this.m_fLoaded) {
            return this.m_fModified;
        }
        if (this.m_fModified || this.m_abClazz == null || this.m_pool.isModified()) {
            return true;
        }
        StringTable[] atbl = this.CONTAINED_TABLE;
        for (int i = 0; i < atbl.length; ++i) {
            Enumeration enmr = atbl[i].elements();
            while (enmr.hasMoreElements()) {
                if (!((VMStructure)enmr.nextElement()).isModified()) continue;
                return true;
            }
        }
        return false;
    }

    public void setModified(boolean fModified) {
        if (fModified) {
            this.m_fModified = fModified;
        } else {
            this.resetModified();
        }
    }

    protected void resetModified() {
        this.m_pool.resetModified();
        StringTable[] atbl = this.CONTAINED_TABLE;
        for (int i = 0; i < atbl.length; ++i) {
            Enumeration enmr = atbl[i].elements();
            while (enmr.hasMoreElements()) {
                ((VMStructure)enmr.nextElement()).resetModified();
            }
        }
        this.m_fModified = false;
    }

    public byte[] getBytes() {
        if (this.isModified()) {
            boolean fOptimize;
            ConstantPool pool = this.m_pool;
            boolean bl = fOptimize = !pool.isOrderImportant();
            if (fOptimize) {
                pool = new ConstantPool();
            }
            this.preassemble(pool);
            if (fOptimize) {
                pool.sort();
            }
            this.m_pool = pool;
            ByteArrayOutputStream streamRaw = new ByteArrayOutputStream(8192);
            DataOutputStream stream = new DataOutputStream(streamRaw);
            try {
                this.assemble(stream, pool);
            }
            catch (IOException e) {
                throw ClassFile.ensureRuntimeException(e);
            }
            this.m_abClazz = streamRaw.toByteArray();
            this.resetModified();
        }
        return this.m_abClazz;
    }

    public void setBytes(byte[] abClazz) {
        if (abClazz == null) {
            throw new IllegalArgumentException("ClassFile.setBytes: byte array is required");
        }
        this.init();
        this.m_abClazz = abClazz;
        this.setLoaded(false);
    }

    public String getName() {
        this.ensureLoaded();
        return this.m_clzName.getValue();
    }

    public void setName(String sName) {
        this.ensureLoaded();
        this.m_clzName = new ClassConstant(sName);
        this.setModified(true);
    }

    public ClassConstant getClassConstant() {
        this.ensureLoaded();
        return this.m_clzName;
    }

    public String getSuper() {
        this.ensureLoaded();
        return this.m_clzSuper == null ? (String)null : this.m_clzSuper.getValue();
    }

    public void setSuper(String sSuper) {
        this.ensureLoaded();
        this.m_clzSuper = sSuper == null ? (ClassConstant)null : new ClassConstant(sSuper);
        this.setModified(true);
    }

    public ClassConstant getSuperClassConstant() {
        this.ensureLoaded();
        return this.m_clzSuper;
    }

    public void addImplements(String sInterface) {
        this.ensureLoaded();
        this.m_tblInterface.put(sInterface.replace('.', '/'), new ClassConstant(sInterface));
        this.setModified(true);
    }

    public void removeImplements(String sInterface) {
        this.ensureLoaded();
        this.m_tblInterface.remove(sInterface.replace('.', '/'));
        this.setModified(true);
    }

    public Enumeration getImplements() {
        this.ensureLoaded();
        return this.m_tblInterface.keys();
    }

    public boolean isInterface() {
        this.ensureLoaded();
        return this.m_flags.isInterface();
    }

    public void setInterface(boolean fInterface) {
        this.ensureLoaded();
        this.m_flags.setInterface(fInterface);
        this.setModified(true);
    }

    public int getAccess() {
        this.ensureLoaded();
        return this.m_flags.getAccess();
    }

    public void setAccess(int nAccess) {
        this.ensureLoaded();
        this.m_flags.setAccess(nAccess);
        this.setModified(true);
    }

    public boolean isPublic() {
        this.ensureLoaded();
        return this.m_flags.isPublic();
    }

    public void setPublic() {
        this.ensureLoaded();
        this.m_flags.setPublic();
        this.setModified(true);
    }

    public boolean isProtected() {
        this.ensureLoaded();
        return this.m_flags.isProtected();
    }

    public void setProtected() {
        this.ensureLoaded();
        this.m_flags.setProtected();
        this.setModified(true);
    }

    public boolean isPackage() {
        this.ensureLoaded();
        return this.m_flags.isPackage();
    }

    public void setPackage() {
        this.ensureLoaded();
        this.m_flags.setPackage();
        this.setModified(true);
    }

    public boolean isPrivate() {
        this.ensureLoaded();
        return this.m_flags.isPrivate();
    }

    public void setPrivate() {
        this.ensureLoaded();
        this.m_flags.setPrivate();
        this.setModified(true);
    }

    public boolean isStatic() {
        this.ensureLoaded();
        return this.m_flags.isStatic();
    }

    public void setStatic(boolean fStatic) {
        this.ensureLoaded();
        this.m_flags.setStatic(fStatic);
        this.setModified(true);
    }

    public boolean isAbstract() {
        this.ensureLoaded();
        return this.m_flags.isAbstract();
    }

    public void setAbstract(boolean fAbstract) {
        this.ensureLoaded();
        this.m_flags.setAbstract(fAbstract);
        this.setModified(true);
    }

    public boolean isFinal() {
        this.ensureLoaded();
        return this.m_flags.isFinal();
    }

    public void setFinal(boolean fFinal) {
        this.ensureLoaded();
        this.m_flags.setFinal(fFinal);
        this.setModified(true);
    }

    public boolean isSynchronized() {
        this.ensureLoaded();
        return this.m_flags.isSynchronized();
    }

    public void setSynchronized(boolean fSynchronized) {
        this.ensureLoaded();
        this.m_flags.setSynchronized(fSynchronized);
        this.setModified(true);
    }

    public Field getField(String sName) {
        this.ensureLoaded();
        return (Field)this.m_tblField.get(sName);
    }

    public Field addField(String sName, String sType) {
        this.ensureLoaded();
        Field field = new Field(sName, sType);
        this.m_tblField.put(field.getIdentity(), field);
        this.setModified(true);
        return field;
    }

    public void removeField(String sName) {
        this.ensureLoaded();
        this.m_tblField.remove(sName);
        this.setModified(true);
    }

    public Enumeration getFields() {
        this.ensureLoaded();
        return this.m_tblField.elements();
    }

    public FieldConstant getFieldConstant(String sName) {
        Field field = this.getField(sName);
        return field == null ? null : new FieldConstant(this.getName(), sName, field.getType());
    }

    public Method getMethod(String sName, String sSig) {
        return this.getMethod(sName + sSig.replace('.', '/'));
    }

    public Method getMethod(String sSig) {
        this.ensureLoaded();
        return (Method)this.m_tblMethod.get(sSig);
    }

    public Method addMethod(String sSig) {
        int of = sSig.indexOf(40);
        return this.addMethod(sSig.substring(0, of), sSig.substring(of));
    }

    public Method addMethod(String sName, String sSig) {
        this.ensureLoaded();
        Method method = new Method(sName, sSig);
        this.m_tblMethod.put(method.getIdentity(), method);
        this.setModified(true);
        return method;
    }

    public void removeMethod(String sName, String sSig) {
        this.removeMethod(sName + sSig);
    }

    public void removeMethod(String sSig) {
        this.ensureLoaded();
        this.m_tblMethod.remove(sSig);
        this.setModified(true);
    }

    public Enumeration getMethods() {
        this.ensureLoaded();
        return this.m_tblMethod.elements();
    }

    public MethodConstant getMethodConstant(String sSig) {
        Method method = this.getMethod(sSig);
        return method == null ? null : new MethodConstant(this.getName(), method.getName(), method.getType());
    }

    public Attribute getAttribute(String sName) {
        this.ensureLoaded();
        return (Attribute)this.m_tblAttribute.get(sName);
    }

    public Attribute addAttribute(String sName) {
        this.ensureLoaded();
        Attribute attribute = null;
        attribute = sName.equals("SourceFile") ? new SourceFileAttribute(this) : (sName.equals("Deprecated") ? new DeprecatedAttribute(this) : (sName.equals("Synthetic") ? new SyntheticAttribute(this) : (sName.equals("InnerClasses") ? new InnerClassesAttribute(this) : new Attribute((VMStructure)this, sName))));
        this.m_tblAttribute.put(attribute.getIdentity(), attribute);
        this.setModified(true);
        return attribute;
    }

    public void removeAttribute(String sName) {
        this.ensureLoaded();
        this.m_tblAttribute.remove(sName);
        this.setModified(true);
    }

    public Enumeration getAttributes() {
        this.ensureLoaded();
        return this.m_tblAttribute.elements();
    }

    public boolean isDeprecated() {
        this.ensureLoaded();
        return this.m_tblAttribute.contains("Deprecated");
    }

    public void setDeprecated(boolean fDeprecated) {
        if (fDeprecated) {
            this.addAttribute("Deprecated");
        } else {
            this.removeAttribute("Deprecated");
        }
    }

    public boolean isSynthetic() {
        this.ensureLoaded();
        return this.m_tblAttribute.contains("Synthetic");
    }

    public void setSynthetic(boolean fSynthetic) {
        if (fSynthetic) {
            this.addAttribute("Synthetic");
        } else {
            this.removeAttribute("Synthetic");
        }
    }

    public static class Relocator
    implements Resolver {
        public static final String PACKAGE = "_package/";
        private String sPkg;

        public Relocator(String sPkg) {
            if (sPkg.length() > 0 && !(sPkg = sPkg.replace('.', '/')).endsWith("/")) {
                sPkg = sPkg + '/';
            }
            this.sPkg = sPkg;
        }

        public Constant resolve(Constant constOrig) {
            UtfConstant utf;
            String s;
            int of;
            if (constOrig instanceof UtfConstant && (of = (s = (utf = (UtfConstant)constOrig).getValue()).indexOf(PACKAGE)) >= 0) {
                while ((of = (s = s.substring(0, of) + this.sPkg + s.substring(of + PACKAGE.length())).indexOf(PACKAGE)) >= 0) {
                }
                return new UtfConstant(s);
            }
            return constOrig;
        }
    }

    public static interface Resolver {
        public Constant resolve(Constant var1);
    }
}

