/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.DoubleConstant;
import com.tangosol.dev.assembler.FieldConstant;
import com.tangosol.dev.assembler.FloatConstant;
import com.tangosol.dev.assembler.IntConstant;
import com.tangosol.dev.assembler.InterfaceConstant;
import com.tangosol.dev.assembler.LongConstant;
import com.tangosol.dev.assembler.MethodConstant;
import com.tangosol.dev.assembler.SignatureConstant;
import com.tangosol.dev.assembler.StringConstant;
import com.tangosol.dev.assembler.UtfConstant;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class Constant
extends VMStructure
implements Constants,
Comparable {
    private static final String CLASS = "Constant";
    private int m_nTag;
    protected transient int m_iLastKnownLocation;

    protected Constant(int nTag) {
        this.m_nTag = nTag;
    }

    protected static Constant loadConstant(DataInput stream, ConstantPool pool) throws IOException {
        int nTag = stream.readUnsignedByte();
        Constant constant = null;
        switch (nTag) {
            case 1: {
                constant = new UtfConstant();
                break;
            }
            case 3: {
                constant = new IntConstant();
                break;
            }
            case 4: {
                constant = new FloatConstant();
                break;
            }
            case 5: {
                constant = new LongConstant();
                break;
            }
            case 6: {
                constant = new DoubleConstant();
                break;
            }
            case 7: {
                constant = new ClassConstant();
                break;
            }
            case 8: {
                constant = new StringConstant();
                break;
            }
            case 9: {
                constant = new FieldConstant();
                break;
            }
            case 10: {
                constant = new MethodConstant();
                break;
            }
            case 11: {
                constant = new InterfaceConstant();
                break;
            }
            case 12: {
                constant = new SignatureConstant();
                break;
            }
            default: {
                throw new IOException("Invalid constant tag " + nTag);
            }
        }
        constant.disassemble(stream, pool);
        return constant;
    }

    public final int getTag() {
        return this.m_nTag;
    }

    protected final int getElementSize() {
        return CONSTANT_SIZE[this.m_nTag];
    }

    protected abstract void disassemble(DataInput var1, ConstantPool var2) throws IOException;

    protected void postdisassemble(ConstantPool pool) {
    }

    protected void preassemble(ConstantPool pool) {
    }

    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeByte(this.m_nTag);
    }

    public abstract int compareTo(Object var1);

    public abstract String toString();

    public abstract String format();

    public abstract boolean equals(Object var1);
}

