/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.VMStructure;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.NullFilter;
import com.tangosol.util.Tree;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ConstantPool
extends VMStructure
implements Constants {
    private Vector m_vectConst;
    private boolean m_fModified;
    private boolean m_fOrderImportant;
    private Tree[] m_atblConst;
    private static final Filter NULL_FILTER = NullFilter.getInstance();

    public ConstantPool() {
        this.init();
    }

    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        Constant constant;
        this.init();
        int cConst = stream.readUnsignedShort();
        for (int i = 1; i < cConst; i += constant.getElementSize()) {
            constant = Constant.loadConstant(stream, this);
            this.add(constant);
        }
        Enumeration enmr = this.m_vectConst.elements();
        while (enmr.hasMoreElements()) {
            Constant constant2 = (Constant)enmr.nextElement();
            if (constant2 == null) continue;
            constant2.postdisassemble(this);
        }
    }

    protected void preassemble(ConstantPool pool) {
        Enumeration enmr = this.constants();
        while (enmr.hasMoreElements()) {
            pool.registerConstant((Constant)enmr.nextElement());
        }
    }

    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(this.m_vectConst.size());
        Enumeration enmr = this.m_vectConst.elements();
        while (enmr.hasMoreElements()) {
            Constant constant = (Constant)enmr.nextElement();
            if (constant == null) continue;
            constant.assemble(stream, pool);
        }
    }

    public boolean isModified() {
        return this.m_fModified;
    }

    protected void resetModified() {
        this.m_fModified = false;
    }

    public String toString() {
        return "Constant Pool contains " + this.m_vectConst.size() + " elements";
    }

    public int registerConstant(Constant constant) {
        if (constant == null) {
            return 0;
        }
        int iConst = this.findConstant(constant);
        if (iConst < 1) {
            iConst = this.add(constant);
            constant.preassemble(this);
        }
        return iConst;
    }

    public int findConstant(Constant constant) {
        Constant constantFound;
        if (constant == null) {
            return 0;
        }
        this.ensureLookup();
        int iConst = constant.m_iLastKnownLocation;
        if (iConst > 0 && (constantFound = this.getConstant(iConst)) != null && constant.equals(constantFound)) {
            return iConst;
        }
        Integer index = (Integer)this.m_atblConst[constant.getTag()].get(constant);
        if (index != null) {
            constant.m_iLastKnownLocation = iConst = index.intValue();
            return iConst;
        }
        return -1;
    }

    public Constant getConstant(int iConst) {
        try {
            return (Constant)this.m_vectConst.get(iConst);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public Enumeration constants() {
        Object[] aconst = new Constant[this.m_vectConst.size()];
        this.m_vectConst.copyInto(aconst);
        return new FilterEnumerator(aconst, NULL_FILTER);
    }

    protected void sort() {
        ConstantPool.azzert(!this.isOrderImportant());
        this.ensureLookup();
        Tree[] atblConst = this.m_atblConst;
        this.init();
        int[] aiTag = CONSTANT_ORDER;
        int cTags = aiTag.length;
        for (int i = 0; i < cTags; ++i) {
            Enumeration enmr = atblConst[aiTag[i]].keys();
            while (enmr.hasMoreElements()) {
                this.add((Constant)enmr.nextElement());
            }
        }
    }

    public boolean isOrderImportant() {
        return this.m_fOrderImportant;
    }

    public void setOrderImportant(boolean fOrderImportant) {
        this.m_fOrderImportant = fOrderImportant;
    }

    protected void init() {
        this.m_vectConst = new Vector();
        this.m_vectConst.add(null);
        this.m_atblConst = null;
        this.m_fOrderImportant = false;
    }

    protected int add(Constant constant) {
        int iConst = this.m_vectConst.size();
        this.m_vectConst.add(constant);
        if (constant.getElementSize() > 1) {
            this.m_vectConst.add(null);
        }
        if (this.m_atblConst != null) {
            this.m_atblConst[constant.getTag()].put(constant, ConstantPool.makeInteger(iConst));
        }
        this.m_fModified = true;
        return iConst;
    }

    protected void ensureLookup() {
        if (this.m_atblConst == null) {
            int[] acElements = CONSTANT_SIZE;
            int cTags = acElements.length;
            Tree[] atblConst = new Tree[cTags];
            for (int i = 0; i < cTags; ++i) {
                if (acElements[i] <= 0) continue;
                atblConst[i] = new Tree();
            }
            Enumeration enmr = this.m_vectConst.elements();
            int i = 0;
            while (enmr.hasMoreElements()) {
                Constant constant = (Constant)enmr.nextElement();
                if (constant != null) {
                    atblConst[constant.getTag()].put(constant, ConstantPool.makeInteger(i));
                }
                ++i;
            }
            this.m_atblConst = atblConst;
        }
    }
}

