/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ConstantValueAttribute
extends Attribute
implements Constants {
    private static final String CLASS = "ConstantValueAttribute";
    private Constant m_constant;
    private boolean m_fModified;

    protected ConstantValueAttribute(VMStructure context) {
        super(context, "ConstantValue");
    }

    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        stream.readInt();
        this.m_constant = pool.getConstant(stream.readUnsignedShort());
    }

    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(super.getNameConstant());
        pool.registerConstant(this.m_constant);
    }

    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(pool.findConstant(super.getNameConstant()));
        stream.writeInt(2);
        stream.writeShort(pool.findConstant(this.m_constant));
    }

    public boolean isModified() {
        return this.m_fModified;
    }

    protected void resetModified() {
        this.m_fModified = false;
    }

    public String toString() {
        return super.getName() + '=' + this.m_constant.toString();
    }

    public boolean equals(Object obj) {
        try {
            ConstantValueAttribute that = (ConstantValueAttribute)obj;
            return this == that || this.getClass() == that.getClass() && this.m_constant.equals(that.m_constant);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public Constant getConstant() {
        return this.m_constant;
    }

    public void setConstant(Constant constant) {
        this.m_constant = constant;
        this.m_fModified = true;
    }
}

