/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ClassFile;
import com.tangosol.util.Base;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;

public class Disassembler
extends Base {
    public static void main(String[] asArgs) throws Throwable {
        try {
            if (asArgs.length != 1 || asArgs[0] == null) {
                Disassembler.showInstructions();
                return;
            }
            String sName = asArgs[0].trim();
            if (asArgs.length == 0) {
                Disassembler.showInstructions();
                return;
            }
            String sFile = sName.replace('.', '/').concat(".class");
            Disassembler.out();
            Disassembler.out("Loading resource: " + sFile);
            InputStream in = null;
            try {
                in = ClassLoader.getSystemResourceAsStream(sFile);
            }
            catch (Exception e) {
                Disassembler.out();
                Disassembler.err(e);
            }
            if (in == null) {
                Disassembler.out();
                Disassembler.out("Error: Could not load resource.");
                Disassembler.showInstructions();
                return;
            }
            Disassembler.out();
            Disassembler.out("Disassembling:");
            Disassembler.out();
            Disassembler.out(new ClassFile(new DataInputStream(in)));
            try {
                if (in.read() >= 0) {
                    Disassembler.out("WARNING!!!  Stream not exhausted!!!");
                }
            }
            catch (EOFException e) {}
        }
        catch (Throwable t) {
            Disassembler.out("Caught \"" + t + "\", stack trace:");
            Disassembler.out(t);
            Disassembler.out("(end stack trace)");
        }
    }

    public static void showInstructions() {
        Disassembler.out();
        Disassembler.out("Usage instructions:");
        Disassembler.out();
        Disassembler.out("    java " + Disassembler.class.getName() + " <classname>");
        Disassembler.out();
        Disassembler.out("(Where <classname> is the fully qualified Java class name.)");
        Disassembler.out();
    }
}

