/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.VMStructure;
import com.tangosol.util.StringTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;

public class ExceptionsAttribute
extends Attribute
implements Constants {
    private static final String CLASS = "ExceptionsAttribute";
    private StringTable m_tblException = new StringTable();
    private boolean m_fModified;

    protected ExceptionsAttribute(VMStructure context) {
        super(context, "Exceptions");
    }

    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        stream.readInt();
        int c = stream.readUnsignedShort();
        for (int i = 0; i < c; ++i) {
            ClassConstant clz = (ClassConstant)pool.getConstant(stream.readUnsignedShort());
            this.m_tblException.put(clz.getValue(), clz);
        }
    }

    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(super.getNameConstant());
        Enumeration enmr = this.m_tblException.elements();
        while (enmr.hasMoreElements()) {
            pool.registerConstant((ClassConstant)enmr.nextElement());
        }
    }

    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(pool.findConstant(super.getNameConstant()));
        stream.writeInt(2 + this.m_tblException.getSize() * 2);
        stream.writeShort(this.m_tblException.getSize());
        Enumeration enmr = this.m_tblException.elements();
        while (enmr.hasMoreElements()) {
            ClassConstant clz = (ClassConstant)enmr.nextElement();
            stream.writeShort(pool.findConstant(clz));
        }
    }

    public boolean isModified() {
        return this.m_fModified;
    }

    protected void resetModified() {
        this.m_fModified = false;
    }

    public String toString() {
        return "Exceptions:  " + this.m_tblException.toString();
    }

    public boolean equals(Object obj) {
        try {
            ExceptionsAttribute that = (ExceptionsAttribute)obj;
            return this == that || this.getClass() == that.getClass() && this.m_tblException.equals(that.m_tblException);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public void addException(String sClz) {
        this.m_tblException.put(sClz, new ClassConstant(sClz));
        this.m_fModified = true;
    }

    public void removeException(String sClz) {
        this.m_tblException.remove(sClz);
        this.m_fModified = true;
    }

    public Enumeration getExceptions() {
        return this.m_tblException.keys();
    }
}

