/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.FloatConstant;
import com.tangosol.dev.assembler.Op;
import java.io.DataOutput;
import java.io.IOException;

public class Fconst
extends Op
implements Constants {
    private static final String CLASS = "Fconst";
    private FloatConstant m_constant;

    public Fconst(float fl) {
        this(new FloatConstant(fl));
    }

    public Fconst(FloatConstant constant) {
        super(231);
        this.m_constant = constant;
        if (constant == null) {
            throw new IllegalArgumentException("Fconst:  Constant must not be null!");
        }
    }

    public String toString() {
        return Fconst.format(null, this.getName() + ' ' + this.m_constant.format(), null);
    }

    public String toJasm() {
        return this.getName() + ' ' + this.m_constant.format();
    }

    protected void preassemble(ConstantPool pool) {
        FloatConstant constant = this.m_constant;
        float n = constant.getValue();
        if (n != 0.0f && n != 1.0f && n != 2.0f) {
            pool.registerConstant(constant);
        }
    }

    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        FloatConstant constant = this.m_constant;
        float n = constant.getValue();
        if (n == 0.0f || n == 1.0f || n == 2.0f) {
            stream.writeByte(11 + (int)n);
        } else {
            int iConst = pool.findConstant(constant);
            if (iConst <= 255) {
                stream.writeByte(18);
                stream.writeByte(iConst);
            } else {
                stream.writeByte(19);
                stream.writeShort(iConst);
            }
        }
    }

    protected void calculateSize(ConstantPool pool) {
        FloatConstant constant = this.m_constant;
        float fl = constant.getValue();
        if (fl == 0.0f || fl == 1.0f || fl == 2.0f) {
            this.setSize(1);
        } else if (pool.findConstant(constant) <= 255) {
            this.setSize(2);
        } else {
            this.setSize(3);
        }
    }
}

