/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Catch;
import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.assembler.Try;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class GuardedSection
extends VMStructure
implements Constants {
    private static final String CLASS = "GuardedSection";
    private Try m_opTry;
    private Catch m_opCatch;
    private ClassConstant m_clzExcept;
    private Label m_opHandler;
    private int m_ofTry;
    private int m_ofCatch;
    private int m_ofHandler;

    protected GuardedSection() {
    }

    protected GuardedSection(Try opTry, Catch opCatch, ClassConstant clzExcept, Label opHandler) {
        this.m_opTry = opTry;
        this.m_opCatch = opCatch;
        this.m_clzExcept = clzExcept;
        this.m_opHandler = opHandler;
    }

    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_ofTry = stream.readUnsignedShort();
        this.m_ofCatch = stream.readUnsignedShort();
        this.m_ofHandler = stream.readUnsignedShort();
        this.m_clzExcept = (ClassConstant)pool.getConstant(stream.readUnsignedShort());
    }

    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_clzExcept);
    }

    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(this.m_opTry.getOffset());
        stream.writeShort(this.m_opCatch.getOffset());
        stream.writeShort(this.m_opHandler.getOffset());
        stream.writeShort(pool.findConstant(this.m_clzExcept));
    }

    public String toString() {
        int ofTry = this.m_ofTry;
        int ofCatch = this.m_ofCatch;
        int ofHandler = this.m_ofHandler;
        if (this.m_opTry != null) {
            ofTry = this.m_opTry.getOffset();
            ofCatch = this.m_opCatch.getOffset();
            ofHandler = this.m_opHandler.getOffset();
        }
        return "(GuardedSection)-> on " + (this.m_clzExcept == null ? "any" : this.m_clzExcept.toString()) + " in [" + ofTry + "," + ofCatch + ")" + " goto " + ofHandler;
    }

    public boolean equals(Object obj) {
        try {
            GuardedSection that = (GuardedSection)obj;
            return this == that || this.getClass() == that.getClass() && this.m_clzExcept.equals(that.m_clzExcept) && this.m_opTry.equals(that.m_opTry) && this.m_opCatch.equals(that.m_opCatch) && this.m_opHandler.equals(that.m_opHandler);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    protected int getTryOffset() {
        return this.m_ofTry;
    }

    public Try getTry() {
        return this.m_opTry;
    }

    protected void setTry(Try op) {
        this.m_opTry = op;
    }

    protected int getCatchOffset() {
        return this.m_ofCatch;
    }

    public Catch getCatch() {
        return this.m_opCatch;
    }

    protected void setCatch(Catch op) {
        this.m_opCatch = op;
    }

    public ClassConstant getException() {
        return this.m_clzExcept;
    }

    protected int getHandlerOffset() {
        return this.m_ofHandler;
    }

    public Label getHandler() {
        return this.m_opHandler;
    }

    protected void setHandler(Label label) {
        this.m_opHandler = label;
    }
}

