/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.InnerClass;
import com.tangosol.dev.assembler.VMStructure;
import com.tangosol.util.Tree;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;

public class InnerClassesAttribute
extends Attribute
implements Constants {
    private static final String CLASS = "InnerClassesAttribute";
    private Tree m_tblInner = new Tree();
    private boolean m_fModified;

    protected InnerClassesAttribute(VMStructure context) {
        super(context, "InnerClasses");
    }

    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        Tree tbl = this.m_tblInner;
        tbl.clear();
        stream.readInt();
        int c = stream.readUnsignedShort();
        for (int i = 0; i < c; ++i) {
            InnerClass inner = new InnerClass();
            inner.disassemble(stream, pool);
            tbl.put((Comparable)((Object)inner.getIdentity()), inner);
        }
    }

    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(super.getNameConstant());
        Enumeration enmr = this.m_tblInner.elements();
        while (enmr.hasMoreElements()) {
            ((InnerClass)enmr.nextElement()).preassemble(pool);
        }
    }

    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        Tree tbl = this.m_tblInner;
        int c = tbl.getSize();
        stream.writeShort(pool.findConstant(super.getNameConstant()));
        stream.writeInt(2 + c * 8);
        stream.writeShort(c);
        Enumeration enmr = this.m_tblInner.elements();
        while (enmr.hasMoreElements()) {
            ((InnerClass)enmr.nextElement()).assemble(stream, pool);
        }
    }

    public boolean isModified() {
        if (this.m_fModified) {
            return true;
        }
        Enumeration enmr = this.m_tblInner.elements();
        while (enmr.hasMoreElements()) {
            if (!((InnerClass)enmr.nextElement()).isModified()) continue;
            return true;
        }
        return false;
    }

    protected void resetModified() {
        Enumeration enmr = this.m_tblInner.elements();
        while (enmr.hasMoreElements()) {
            ((InnerClass)enmr.nextElement()).resetModified();
        }
        this.m_fModified = false;
    }

    public String toString() {
        return super.getName() + ' ' + this.m_tblInner.toString();
    }

    public boolean equals(Object obj) {
        try {
            InnerClassesAttribute that = (InnerClassesAttribute)obj;
            return this == that || this.getClass() == that.getClass() && this.m_tblInner.equals(that.m_tblInner);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public InnerClass getInnerClass(String sName) {
        return (InnerClass)this.m_tblInner.get((Comparable)((Object)sName));
    }

    public InnerClass addInnerClass(String sName) {
        InnerClass inner = new InnerClass(new ClassConstant(sName));
        this.m_tblInner.put((Comparable)((Object)inner.getIdentity()), inner);
        this.m_fModified = true;
        return inner;
    }

    public void removeInnerClass(String sName) {
        this.m_tblInner.remove((Comparable)((Object)sName));
        this.m_fModified = true;
    }

    public Enumeration getInnerClassNames() {
        return this.m_tblInner.keys();
    }

    public Enumeration getInnerClasses() {
        return this.m_tblInner.elements();
    }
}

