/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IntConstant
extends Constant
implements Constants {
    private static final String CLASS = "IntConstant";
    private int m_nVal;

    protected IntConstant() {
        super(3);
    }

    public IntConstant(int nVal) {
        this();
        this.m_nVal = nVal;
    }

    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_nVal = stream.readInt();
    }

    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        super.assemble(stream, pool);
        stream.writeInt(this.m_nVal);
    }

    public int compareTo(Object obj) {
        IntConstant that = (IntConstant)obj;
        int nThis = this.m_nVal;
        int nThat = that.m_nVal;
        return nThis < nThat ? -1 : (nThis > nThat ? 1 : 0);
    }

    public String toString() {
        return "(Int) " + this.m_nVal;
    }

    public String format() {
        return String.valueOf(this.m_nVal);
    }

    public boolean equals(Object obj) {
        try {
            IntConstant that = (IntConstant)obj;
            return this == that || this.getClass() == that.getClass() && this.m_nVal == that.m_nVal;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int getValue() {
        return this.m_nVal;
    }
}

