/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Jsr;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.Ret;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SimpleEnumerator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class Label
extends Op
implements Constants,
Comparable {
    private static final String CLASS = "Label";
    private String m_sName;
    private Label m_labelContext;
    private HashSet m_setVars;
    private boolean m_fVisited;
    private int m_iCtx = Integer.MIN_VALUE;
    private int m_iSlot = Integer.MIN_VALUE;
    private boolean m_fSub;
    private int m_iDepth = Integer.MIN_VALUE;
    private Ret m_ret;
    private int m_cwRetHeight = Integer.MIN_VALUE;
    private Set m_setCallers;

    public Label(String sName) {
        super(251);
        this.m_sName = sName;
    }

    public Label() {
        super(251);
    }

    protected boolean isDiscardable() {
        return false;
    }

    public String toString() {
        return Label.format(this.format(), null, null);
    }

    public String toJasm() {
        return null;
    }

    public String format() {
        String sName = this.m_sName;
        if (sName == null) {
            sName = String.valueOf(this.hashCode());
        }
        return sName;
    }

    public int compareTo(Object obj) {
        int nThat;
        Label that = (Label)obj;
        int nThis = this.getDepth();
        return nThis < (nThat = that.getDepth()) ? -1 : (nThis > nThat ? 1 : 0);
    }

    protected boolean isSubroutine() {
        return this.m_fSub;
    }

    protected int getDepth() {
        int iDepth = this.m_iDepth;
        if (iDepth == Integer.MIN_VALUE) {
            iDepth = 0;
            Enumeration enmr = this.getCallers();
            while (enmr.hasMoreElements()) {
                Jsr jsr = (Jsr)enmr.nextElement();
                int iNewDepth = jsr.getDepth();
                if (iNewDepth <= iDepth) continue;
                iDepth = iNewDepth;
            }
            this.m_iDepth = iDepth;
        }
        return iDepth;
    }

    protected Ret getRet() {
        return this.m_ret;
    }

    protected void setRet(Ret ret) {
        if (!this.m_fSub) {
            throw new IllegalStateException("Label.setRet:  RET without JSR!");
        }
        if (this.m_ret == null) {
            this.m_ret = ret;
        } else if (this.m_ret != ret) {
            throw new IllegalStateException("Label.setRet:  It is illegal to have multiple RET instructions for a JSR!");
        }
    }

    protected int getRetHeight() {
        return this.m_cwRetHeight;
    }

    protected void setRetHeight(int cw) {
        this.m_cwRetHeight = cw;
    }

    protected void addCaller(Jsr jsr) {
        if (!this.m_fSub) {
            this.m_fSub = true;
            this.m_setCallers = new HashSet();
        }
        this.m_setCallers.add(jsr);
        this.m_iDepth = Integer.MIN_VALUE;
    }

    protected Enumeration getCallers() {
        Set set = this.m_setCallers;
        if (set == null) {
            return NullImplementation.getEnumeration();
        }
        return new SimpleEnumerator(set.toArray());
    }

    protected int getContextIndex() {
        return this.m_iCtx;
    }

    protected void setContextIndex(int iCtx) {
        this.m_iCtx = iCtx;
    }

    protected int getFirstSlot() {
        return this.m_iSlot;
    }

    protected void setFirstSlot(int iSlot) {
        this.m_iSlot = iSlot;
    }

    protected Label getContext() {
        return this.m_labelContext;
    }

    protected void setContext(Label label) {
        this.m_labelContext = label;
    }

    protected HashSet getVariables() {
        return this.m_setVars;
    }

    protected void setVariables(HashSet setVars) {
        this.m_setVars = setVars;
    }

    protected boolean isVisited() {
        return this.m_fVisited;
    }

    protected void setVisited(boolean fVisited) {
        this.m_fVisited = fVisited;
    }
}

