/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.LongConstant;
import com.tangosol.dev.assembler.Op;
import java.io.DataOutput;
import java.io.IOException;

public class Lconst
extends Op
implements Constants {
    private static final String CLASS = "Lconst";
    private LongConstant m_constant;

    public Lconst(long l) {
        this(new LongConstant(l));
    }

    public Lconst(LongConstant constant) {
        super(230);
        this.m_constant = constant;
        if (constant == null) {
            throw new IllegalArgumentException("Lconst:  Constant must not be null!");
        }
    }

    public String toString() {
        return Lconst.format(null, this.getName() + ' ' + this.m_constant.format(), null);
    }

    public String toJasm() {
        return this.getName() + ' ' + this.m_constant.format();
    }

    protected void preassemble(ConstantPool pool) {
        LongConstant constant = this.m_constant;
        long n = constant.getValue();
        if (n != 0L && n != 1L) {
            pool.registerConstant(constant);
        }
    }

    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        LongConstant constant = this.m_constant;
        long n = constant.getValue();
        if (n == 0L || n == 1L) {
            stream.writeByte(9 + (int)n);
        } else {
            stream.writeByte(20);
            stream.writeShort(pool.findConstant(constant));
        }
    }

    protected void calculateSize(ConstantPool pool) {
        long n = this.m_constant.getValue();
        this.setSize(n == 0L || n == 1L ? 1 : 3);
    }
}

