/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Method;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.OpDeclare;
import com.tangosol.dev.assembler.UtfConstant;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class LocalVariableTableAttribute
extends Attribute
implements Constants {
    private static final String CLASS = "LocalVariableTableAttribute";
    private boolean m_fModified;
    private Range m_first;
    private Range m_last;
    private int m_count;

    protected LocalVariableTableAttribute(VMStructure context) {
        super(context, "LocalVariableTable");
    }

    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.clear();
        stream.readInt();
        int count = stream.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            Range range = new Range();
            range.disassemble(stream, pool);
            this.add(range);
        }
        this.resetModified();
    }

    protected void preassemble(ConstantPool pool) {
        super.preassemble(pool);
        for (Range range = this.m_first; range != null; range = range.getNext()) {
            range.preassemble(pool);
        }
    }

    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(pool.findConstant(super.getNameConstant()));
        stream.writeInt(2 + 10 * this.m_count);
        stream.writeShort(this.m_count);
        if (this.m_count > 0) {
            TreeSet<Range> set = new TreeSet<Range>();
            for (Range range = this.m_first; range != null; range = range.getNext()) {
                set.add(range);
            }
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                Range range = (Range)iter.next();
                range.assemble(stream, pool);
            }
        }
    }

    public boolean isModified() {
        return this.m_fModified;
    }

    protected void resetModified() {
        this.m_fModified = false;
    }

    public void clear() {
        this.m_first = null;
        this.m_last = null;
        this.m_fModified = true;
    }

    public boolean isEmpty() {
        return this.m_first == null;
    }

    protected void add(OpDeclare decl, Op opInit, Op opStop) {
        this.add(new Range(decl, opInit, opStop));
    }

    protected void add(Range range) {
        if (this.m_first == null) {
            this.m_first = range;
            this.m_last = range;
        } else {
            this.m_last.setNext(range);
            this.m_last = range;
        }
        ++this.m_count;
        this.m_fModified = true;
    }

    public Enumeration ranges() {
        return new Enumeration(){
            private Range cur;
            {
                this.cur = LocalVariableTableAttribute.this.m_first;
            }

            public boolean hasMoreElements() {
                return this.cur != null;
            }

            public Object nextElement() {
                if (this.cur == null) {
                    throw new NoSuchElementException();
                }
                Range range = this.cur;
                this.cur = range.getNext();
                return range;
            }
        };
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("LocalVariableTableAttribute for method ").append(((Method)((CodeAttribute)this.getContext()).getContext()).getIdentity());
        Enumeration enmr = this.ranges();
        while (enmr.hasMoreElements()) {
            sb.append("\n  ").append(enmr.nextElement());
        }
        return sb.toString();
    }

    public static class Range
    extends VMStructure
    implements Constants,
    Comparable {
        private static final String CLASS = "LocalVariableTableAttribute.Range";
        private OpDeclare m_decl;
        private Op m_opInit;
        private Op m_opStop;
        private int m_of;
        private int m_cb;
        private UtfConstant m_utfName;
        private UtfConstant m_utfType;
        private int m_iVar;
        private Range m_next;

        protected Range() {
        }

        protected Range(OpDeclare decl, Op opInit, Op opStop) {
            if (decl == null || opInit == null || opStop == null) {
                throw new IllegalArgumentException("LocalVariableTableAttribute.Range:  All parameters required!");
            }
            this.m_decl = decl;
            this.m_opInit = opInit;
            this.m_opStop = opStop;
            this.m_utfName = new UtfConstant(decl.getVariableName());
            this.m_utfType = new UtfConstant(decl.getSignature());
            if (this.m_utfName == null || this.m_utfType == null) {
                throw new IllegalArgumentException("LocalVariableTableAttribute.Range:  Variable is missing debug information!");
            }
        }

        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            this.m_of = stream.readUnsignedShort();
            this.m_cb = stream.readUnsignedShort();
            this.m_utfName = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
            this.m_utfType = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
            this.m_iVar = stream.readUnsignedShort();
        }

        protected void preassemble(ConstantPool pool) {
            pool.registerConstant(this.m_utfName);
            pool.registerConstant(this.m_utfType);
        }

        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            stream.writeShort(this.getOffset());
            stream.writeShort(this.getLength());
            stream.writeShort(pool.findConstant(this.m_utfName));
            stream.writeShort(pool.findConstant(this.m_utfType));
            stream.writeShort(this.getSlot());
        }

        protected int getOffset() {
            return this.m_opInit == null ? this.m_of : this.m_opInit.getOffset();
        }

        protected int getLength() {
            return this.m_opStop == null ? this.m_cb : this.m_opStop.getOffset() - this.m_opInit.getOffset();
        }

        protected Op getInit() {
            return this.m_opInit;
        }

        protected void setInit(Op op) {
            this.m_opInit = op;
        }

        protected Op getStop() {
            return this.m_opStop;
        }

        protected void setStop(Op op) {
            this.m_opStop = op;
        }

        public OpDeclare getVariable() {
            return this.m_decl;
        }

        public String getVariableName() {
            return this.m_utfName.getValue();
        }

        public String getSignature() {
            return this.m_utfType.getValue();
        }

        public int getSlot() {
            return this.m_decl == null ? this.m_iVar : this.m_decl.getSlot();
        }

        protected Range getNext() {
            return this.m_next;
        }

        protected void setNext(Range next) {
            this.m_next = next;
        }

        public int compareTo(Object o) {
            Range that = (Range)o;
            int nResult = this.getOffset() - that.getOffset();
            if (nResult == 0 && (nResult = that.getLength() - this.getLength()) == 0) {
                nResult = this.m_utfName.compareTo(that.m_utfName);
            }
            return nResult;
        }

        public String toString() {
            String sClass;
            Op opInit = this.getInit();
            Op opStop = this.getStop();
            StringBuffer sb = new StringBuffer();
            sb.append("offset=").append(this.getOffset()).append(", length=").append(this.getLength()).append(", slot=").append(this.getSlot());
            if (opInit != null) {
                sClass = opInit.getClass().getName();
                sb.append(", init=").append(opInit).append(" (").append(sClass.substring(sClass.lastIndexOf(46) + 1)).append(") @").append(opInit.getOffset());
            }
            if (opStop != null) {
                sClass = opStop.getClass().getName();
                sb.append(", stop=").append(opStop).append(" (").append(sClass.substring(sClass.lastIndexOf(46) + 1)).append(") @").append(opStop.getOffset());
            }
            sb.append(", var=").append(this.getVariable());
            return sb.toString();
        }
    }
}

