/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.AccessFlags;
import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.DeprecatedAttribute;
import com.tangosol.dev.assembler.ExceptionsAttribute;
import com.tangosol.dev.assembler.Field;
import com.tangosol.dev.assembler.LocalVariableTableAttribute;
import com.tangosol.dev.assembler.SyntheticAttribute;
import com.tangosol.dev.assembler.UtfConstant;
import com.tangosol.dev.assembler.VMStructure;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.StringTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class Method
extends VMStructure
implements Constants {
    private static final String CLASS = "Method";
    public static final int ACC_METHOD = 1343;
    private String m_sClass;
    private UtfConstant m_utfName;
    private UtfConstant m_utfSig;
    private AccessFlags m_flags = new AccessFlags();
    private StringTable m_tblAttribute = new StringTable();
    private boolean m_fModified;

    protected Method(String sClass) {
        this.m_sClass = sClass;
    }

    protected Method(String sName, String sSig) {
        this(new UtfConstant(sName), new UtfConstant(sSig.replace('.', '/')));
    }

    protected Method(UtfConstant constantName, UtfConstant constantSig) {
        if (constantName == null || constantSig == null) {
            throw new IllegalArgumentException("Method:  Values cannot be null!");
        }
        this.m_utfName = constantName;
        this.m_utfSig = constantSig;
    }

    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_flags.disassemble(stream, pool);
        this.m_utfName = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
        this.m_utfSig = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
        this.m_tblAttribute.clear();
        int cAttr = stream.readUnsignedShort();
        for (int i = 0; i < cAttr; ++i) {
            Attribute attr = Attribute.loadAttribute(this, stream, pool);
            this.m_tblAttribute.put(attr.getIdentity(), attr);
        }
    }

    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_utfName);
        pool.registerConstant(this.m_utfSig);
        this.m_flags.preassemble(pool);
        Enumeration enmr = this.m_tblAttribute.elements();
        while (enmr.hasMoreElements()) {
            Attribute attr = (Attribute)enmr.nextElement();
            try {
                attr.preassemble(pool);
            }
            catch (Throwable e) {
                if (attr.getName().equals("Code")) {
                    Method.out("Code pre-assembly error in:  " + this.toString());
                    ((CodeAttribute)attr).print();
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw (Error)e;
            }
        }
    }

    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        this.m_flags.assemble(stream, pool);
        stream.writeShort(pool.findConstant(this.m_utfName));
        stream.writeShort(pool.findConstant(this.m_utfSig));
        stream.writeShort(this.m_tblAttribute.getSize());
        Enumeration enmr = this.m_tblAttribute.elements();
        while (enmr.hasMoreElements()) {
            Attribute attr = (Attribute)enmr.nextElement();
            try {
                attr.assemble(stream, pool);
            }
            catch (Throwable e) {
                if (attr.getName().equals("Code")) {
                    Method.out("Code assembly error in:  " + this.toString());
                    ((CodeAttribute)attr).print();
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw (Error)e;
            }
        }
    }

    public String getIdentity() {
        return this.m_utfName.getValue() + this.m_utfSig.getValue();
    }

    public boolean isModified() {
        if (this.m_fModified || this.m_flags.isModified()) {
            return true;
        }
        Enumeration enmr = this.m_tblAttribute.elements();
        while (enmr.hasMoreElements()) {
            Attribute attr = (Attribute)enmr.nextElement();
            if (!attr.isModified()) continue;
            return true;
        }
        return false;
    }

    protected void resetModified() {
        this.m_flags.resetModified();
        Enumeration enmr = this.m_tblAttribute.elements();
        while (enmr.hasMoreElements()) {
            ((Attribute)enmr.nextElement()).resetModified();
        }
        this.m_fModified = false;
    }

    public int compareTo(Object obj) {
        Method that = (Method)obj;
        int nResult = this.m_utfName.compareTo(that.m_utfName);
        if (nResult == 0) {
            nResult = this.m_utfSig.compareTo(that.m_utfSig);
        }
        return nResult;
    }

    public String toString() {
        String sMods = this.m_flags.toString(1343);
        String sName = this.m_utfName.getValue();
        String[] asType = Method.toTypeStrings(this.m_utfSig.getValue());
        int cType = asType.length;
        StringBuffer sb = new StringBuffer();
        if (sMods.length() > 0) {
            sb.append(sMods).append(' ');
        }
        sb.append(asType[0]).append(' ').append(sName).append('(');
        for (int i = 1; i < cType; ++i) {
            if (i > 1) {
                sb.append(", ");
            }
            sb.append(asType[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        try {
            Method that = (Method)obj;
            return this == that || this.getClass() == that.getClass() && this.m_utfName.equals(that.m_utfName) && this.m_utfSig.equals(that.m_utfSig) && this.m_flags.equals(that.m_flags) && this.m_tblAttribute.equals(that.m_tblAttribute);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public static String[] toTypeStrings(String sSig) {
        String[] asType = Method.toTypes(sSig);
        int cTypes = asType.length;
        for (int i = 0; i < cTypes; ++i) {
            asType[i] = Field.toTypeString(asType[i]);
        }
        return asType;
    }

    public static String[] toTypes(String sSig) {
        char[] ach = sSig.toCharArray();
        if (ach[0] != '(') {
            throw new IllegalArgumentException("JVM Method Signature must start with '('");
        }
        Vector<String> vect = new Vector<String>();
        vect.addElement(null);
        int of = 1;
        while (ach[of] != ')') {
            int cch = Method.getTypeLength(ach, of);
            vect.addElement(new String(ach, of, cch));
            of += cch;
        }
        vect.setElementAt(new String(ach, ++of, ach.length - of), 0);
        Object[] asSig = new String[vect.size()];
        vect.copyInto(asSig);
        return asSig;
    }

    private static int getTypeLength(char[] ach, int of) {
        switch (ach[of]) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return 1;
            }
            case '[': {
                int cch = 1;
                while (Method.isDecimal(ach[++of])) {
                    ++cch;
                }
                return cch + Method.getTypeLength(ach, of);
            }
            case 'L': {
                int cch = 2;
                while (ach[++of] != ';') {
                    ++cch;
                }
                return cch;
            }
        }
        throw new IllegalArgumentException("JVM Type Signature cannot start with '" + ach[of] + "'");
    }

    public String getName() {
        return this.m_utfName.getValue();
    }

    public String getType() {
        return this.m_utfSig.getValue();
    }

    public String[] getTypes() {
        return Method.toTypes(this.m_utfSig.getValue());
    }

    public String[] getTypeStrings() {
        return Method.toTypeStrings(this.m_utfSig.getValue());
    }

    public String[] getNames() {
        LocalVariableTableAttribute vars;
        String[] as = this.getTypes();
        int c = as.length;
        CodeAttribute code = (CodeAttribute)this.m_tblAttribute.get("Code");
        if (code != null && (vars = (LocalVariableTableAttribute)code.getAttribute("LocalVariableTable")) != null) {
            int cwBase;
            int cwParams = cwBase = this.isStatic() ? 0 : 1;
            block6: for (int i = 1; i < c; ++i) {
                switch (as[i].charAt(0)) {
                    default: {
                        ++cwParams;
                        continue block6;
                    }
                    case 'D': 
                    case 'J': {
                        cwParams += 2;
                    }
                }
            }
            int[] aiSlotToParam = new int[cwParams];
            cwParams = cwBase;
            for (int i = 1; i < c; ++i) {
                aiSlotToParam[cwParams] = i;
                switch (as[i].charAt(0)) {
                    default: {
                        ++cwParams;
                        break;
                    }
                    case 'D': 
                    case 'J': {
                        cwParams += 2;
                    }
                }
                as[i] = null;
            }
            as[0] = null;
            Enumeration enmr = vars.ranges();
            while (enmr.hasMoreElements()) {
                int i;
                LocalVariableTableAttribute.Range range = (LocalVariableTableAttribute.Range)enmr.nextElement();
                if (range.getSlot() >= cwParams || (i = aiSlotToParam[range.getSlot()]) <= 0 || as[i] != null) continue;
                as[i] = range.getVariableName();
            }
            return as;
        }
        for (int i = 0; i < c; ++i) {
            as[i] = null;
        }
        return as;
    }

    public UtfConstant getNameConstant() {
        return this.m_utfName;
    }

    public UtfConstant getTypeConstant() {
        return this.m_utfSig;
    }

    public int getAccess() {
        return this.m_flags.getAccess();
    }

    public void setAccess(int nAccess) {
        this.m_flags.setAccess(nAccess);
    }

    public boolean isPublic() {
        return this.m_flags.isPublic();
    }

    public void setPublic() {
        this.m_flags.setPublic();
    }

    public boolean isProtected() {
        return this.m_flags.isProtected();
    }

    public void setProtected() {
        this.m_flags.setProtected();
    }

    public boolean isPackage() {
        return this.m_flags.isPackage();
    }

    public void setPackage() {
        this.m_flags.setPackage();
    }

    public boolean isPrivate() {
        return this.m_flags.isPrivate();
    }

    public void setPrivate() {
        this.m_flags.setPrivate();
    }

    public boolean isStatic() {
        return this.m_flags.isStatic();
    }

    public void setStatic(boolean fStatic) {
        this.m_flags.setStatic(fStatic);
    }

    public boolean isFinal() {
        return this.m_flags.isFinal();
    }

    public void setFinal(boolean fFinal) {
        this.m_flags.setFinal(fFinal);
    }

    public boolean isSynchronized() {
        return this.m_flags.isSynchronized();
    }

    public void setSynchronized(boolean fSynchronized) {
        this.m_flags.setSynchronized(fSynchronized);
    }

    public boolean isNative() {
        return this.m_flags.isNative();
    }

    public void setNative(boolean fNative) {
        this.m_flags.setNative(fNative);
    }

    public boolean isAbstract() {
        return this.m_flags.isAbstract();
    }

    public void setAbstract(boolean fAbstract) {
        this.m_flags.setAbstract(fAbstract);
    }

    public Attribute getAttribute(String sName) {
        return (Attribute)this.m_tblAttribute.get(sName);
    }

    public Attribute addAttribute(String sName) {
        Attribute attribute = null;
        attribute = sName.equals("Code") ? new CodeAttribute(this) : (sName.equals("Exceptions") ? new ExceptionsAttribute(this) : (sName.equals("Deprecated") ? new DeprecatedAttribute(this) : (sName.equals("Synthetic") ? new SyntheticAttribute(this) : new Attribute((VMStructure)this, sName))));
        this.m_tblAttribute.put(sName, attribute);
        this.m_fModified = true;
        return attribute;
    }

    public void removeAttribute(String sName) {
        this.m_tblAttribute.remove(sName);
        this.m_fModified = true;
    }

    public Enumeration getAttributes() {
        return this.m_tblAttribute.elements();
    }

    public CodeAttribute getCode() {
        CodeAttribute attr = (CodeAttribute)this.m_tblAttribute.get("Code");
        return attr == null ? (CodeAttribute)this.addAttribute("Code") : attr;
    }

    public boolean isDeprecated() {
        return this.m_tblAttribute.contains("Deprecated");
    }

    public void setDeprecated(boolean fDeprecated) {
        if (fDeprecated) {
            this.addAttribute("Deprecated");
        } else {
            this.removeAttribute("Deprecated");
        }
    }

    public boolean isSynthetic() {
        return this.m_tblAttribute.contains("Synthetic");
    }

    public void setSynthetic(boolean fSynthetic) {
        if (fSynthetic) {
            this.addAttribute("Synthetic");
        } else {
            this.removeAttribute("Synthetic");
        }
    }

    public void addException(String sClz) {
        ExceptionsAttribute attr = (ExceptionsAttribute)this.getAttribute("Exceptions");
        if (attr == null) {
            attr = (ExceptionsAttribute)this.addAttribute("Exceptions");
        }
        attr.addException(sClz);
    }

    public void removeException(String sClz) {
        ExceptionsAttribute attr = (ExceptionsAttribute)this.m_tblAttribute.get("Exceptions");
        if (attr != null) {
            attr.removeException(sClz);
        }
    }

    public Enumeration getExceptions() {
        ExceptionsAttribute attr = (ExceptionsAttribute)this.getAttribute("Exceptions");
        return attr == null ? NullImplementation.getEnumeration() : attr.getExceptions();
    }

    protected String getClassName() {
        return this.m_sClass;
    }
}

