/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.OpDeclare;
import com.tangosol.dev.assembler.OpVariable;
import java.io.DataOutput;
import java.io.IOException;

public abstract class OpStore
extends Op
implements Constants,
OpVariable {
    private static final String CLASS = "OpStore";
    private static final char[] TYPES = new char[]{'I', 'L', 'F', 'D', 'A', 'R'};
    private OpDeclare m_var;

    public OpStore(int iOp, OpDeclare var) {
        super(iOp);
        this.m_var = var;
        if (var == null) {
            throw new IllegalArgumentException("OpStore:  Variable must not be null!");
        }
    }

    public String toString() {
        return OpStore.format(null, this.getName() + ' ' + this.m_var.format(), null);
    }

    public String toJasm() {
        return this.getName() + ' ' + this.m_var.format();
    }

    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        int n = this.m_var.getSlot();
        int iOp = super.getValue();
        if (iOp == 242) {
            iOp = 58;
        }
        if (n <= 3) {
            stream.writeByte((iOp - 54) * 4 + 59 + n);
        } else if (n <= 255) {
            stream.writeByte(iOp);
            stream.writeByte(n);
        } else {
            stream.writeByte(196);
            stream.writeByte(iOp);
            stream.writeShort(n);
        }
    }

    protected void calculateSize(ConstantPool pool) {
        int n = this.m_var.getSlot();
        if (n <= 3) {
            this.setSize(1);
        } else if (n <= 255) {
            this.setSize(2);
        } else {
            this.setSize(4);
        }
    }

    public char getType() {
        int iOp = super.getValue();
        return iOp == 242 ? (char)'R' : TYPES[iOp - 54];
    }

    public OpDeclare getVariable() {
        return this.m_var;
    }
}

