/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.SignatureConstant;
import com.tangosol.dev.assembler.UtfConstant;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class RefConstant
extends Constant
implements Constants {
    private static final String CLASS = "RefConstant";
    private ClassConstant m_clz;
    private SignatureConstant m_sig;
    private int m_iRefClz;
    private int m_iRefSig;

    protected RefConstant(int nTag) {
        super(nTag);
    }

    protected RefConstant(int nTag, String sClass, String sName, String sType) {
        this(nTag, new ClassConstant(sClass), new SignatureConstant(sName, sType));
    }

    protected RefConstant(int nTag, ClassConstant constantClz, SignatureConstant constantSig) {
        this(nTag);
        if (constantClz == null || constantSig == null) {
            throw new IllegalArgumentException("RefConstant:  Values cannot be null!");
        }
        this.m_clz = constantClz;
        this.m_sig = constantSig;
    }

    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_iRefClz = stream.readUnsignedShort();
        this.m_iRefSig = stream.readUnsignedShort();
    }

    protected void postdisassemble(ConstantPool pool) {
        this.m_clz = (ClassConstant)pool.getConstant(this.m_iRefClz);
        this.m_sig = (SignatureConstant)pool.getConstant(this.m_iRefSig);
    }

    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_clz);
        pool.registerConstant(this.m_sig);
    }

    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        super.assemble(stream, pool);
        stream.writeShort(pool.findConstant(this.m_clz));
        stream.writeShort(pool.findConstant(this.m_sig));
    }

    public int compareTo(Object obj) {
        RefConstant that = (RefConstant)obj;
        int nResult = this.m_clz.compareTo(that.m_clz);
        if (nResult == 0) {
            nResult = this.m_sig.compareTo(that.m_sig);
        }
        return nResult;
    }

    public String toString() {
        return (this.m_clz == null ? "[" + this.m_iRefClz + ']' : this.m_clz.toString()) + ", " + (this.m_sig == null ? "[" + this.m_iRefSig + ']' : this.m_sig.toString());
    }

    public String format() {
        return this.m_clz.format() + '.' + this.m_sig.format();
    }

    public boolean equals(Object obj) {
        try {
            RefConstant that = (RefConstant)obj;
            return this == that || this.getClass() == that.getClass() && this.m_clz.equals(that.m_clz) && this.m_sig.equals(that.m_sig);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String getClassName() {
        return this.m_clz.getValue();
    }

    public String getName() {
        return this.m_sig.getName();
    }

    public String getType() {
        return this.m_sig.getType();
    }

    public ClassConstant getClassConstant() {
        return this.m_clz;
    }

    public SignatureConstant getSignatureConstant() {
        return this.m_sig;
    }

    public UtfConstant getNameConstant() {
        return this.m_sig.getNameConstant();
    }

    public UtfConstant getTypeConstant() {
        return this.m_sig.getTypeConstant();
    }
}

