/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.UtfConstant;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SourceFileAttribute
extends Attribute
implements Constants {
    private static final String CLASS = "SourceFileAttribute";
    private UtfConstant m_utf;
    private boolean m_fModified;

    protected SourceFileAttribute(VMStructure context) {
        super(context, "SourceFile");
    }

    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        stream.readInt();
        this.m_utf = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
    }

    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(super.getNameConstant());
        pool.registerConstant(this.m_utf);
    }

    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(pool.findConstant(super.getNameConstant()));
        stream.writeInt(2);
        stream.writeShort(pool.findConstant(this.m_utf));
    }

    public boolean isModified() {
        return this.m_fModified;
    }

    protected void resetModified() {
        this.m_fModified = false;
    }

    public String toString() {
        return super.getName() + '=' + this.m_utf.getValue();
    }

    public boolean equals(Object obj) {
        try {
            SourceFileAttribute that = (SourceFileAttribute)obj;
            return this == that || this.getClass() == that.getClass() && this.m_utf.equals(that.m_utf);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String getSourceFile() {
        return this.m_utf.getValue();
    }

    public void setSourceFile(String sName) {
        this.m_utf = new UtfConstant(sName);
        this.m_fModified = true;
    }

    public UtfConstant getSourceFileConstant() {
        return this.m_utf;
    }
}

