/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.UtfConstant;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StringConstant
extends Constant
implements Constants {
    private static final String CLASS = "StringConstant";
    private UtfConstant m_utf;
    private int m_iRef;

    protected StringConstant() {
        super(8);
    }

    public StringConstant(String sText) {
        this(new UtfConstant(sText));
    }

    public StringConstant(UtfConstant constant) {
        this();
        if (constant == null) {
            throw new IllegalArgumentException("StringConstant:  Value cannot be null!");
        }
        this.m_utf = constant;
    }

    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_iRef = stream.readUnsignedShort();
    }

    protected void postdisassemble(ConstantPool pool) {
        this.m_utf = (UtfConstant)pool.getConstant(this.m_iRef);
    }

    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_utf);
    }

    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        super.assemble(stream, pool);
        stream.writeShort(pool.findConstant(this.m_utf));
    }

    public int compareTo(Object obj) {
        StringConstant that = (StringConstant)obj;
        return this.m_utf.compareTo(that.m_utf);
    }

    public String toString() {
        return "(String)->" + (this.m_utf == null ? "[" + this.m_iRef + ']' : this.m_utf.toString());
    }

    public String format() {
        return StringConstant.toQuotedStringEscape(this.m_utf.format());
    }

    public boolean equals(Object obj) {
        try {
            StringConstant that = (StringConstant)obj;
            return this == that || this.getClass() == that.getClass() && this.m_utf.equals(that.m_utf);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String getValue() {
        return this.m_utf.getValue();
    }

    public UtfConstant getValueConstant() {
        return this.m_utf;
    }
}

