/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Case;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.assembler.OpSwitch;

public class Switch
extends OpSwitch
implements Constants {
    private static final String CLASS = "Switch";

    public Switch(Label label) {
        super(252, label);
    }

    protected int getSwitch() {
        int iOp = super.getSwitch();
        if (iOp == 252) {
            Case[] acase = this.getCases();
            int cCases = acase.length;
            if (cCases <= 1) {
                iOp = 171;
            } else {
                int iLow = acase[0].getCase();
                int iHigh = acase[cCases - 1].getCase();
                double dblRange = (double)iHigh - (double)iLow + 1.0;
                double dblSpread = dblRange / (double)cCases;
                iOp = dblSpread > 4.0 ? 171 : 170;
            }
        }
        return iOp;
    }
}

