/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler;

import com.tangosol.dev.compiler.ParsePosition;
import com.tangosol.dev.compiler.Script;
import java.io.EOFException;

public class SimpleScript
implements Script {
    protected char[] m_achScript;
    protected int m_ofCurrent;
    protected int m_iLine;
    protected int m_ofInLine;

    public SimpleScript() {
    }

    public SimpleScript(String sScript) {
        this.setScript(sScript);
    }

    protected SimpleScript(char[] achScript, int ofStart, int cLen) {
        char[] ach = new char[cLen];
        System.arraycopy(achScript, ofStart, ach, 0, cLen);
        this.m_achScript = ach;
    }

    public void setScript(String sScript) {
        if (this.m_achScript != null) {
            throw new IllegalStateException();
        }
        this.m_achScript = sScript.toCharArray();
    }

    public boolean hasMoreChars() {
        return this.m_ofCurrent < this.m_achScript.length;
    }

    public char nextChar() throws EOFException {
        char ch;
        char[] achScript = this.m_achScript;
        int cchScript = achScript.length;
        try {
            ch = achScript[this.m_ofCurrent++];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EOFException();
        }
        if (ch == '\n' || ch == '\r') {
            boolean bMore;
            boolean bl = bMore = this.m_ofCurrent < cchScript;
            if (ch == '\r' && bMore && achScript[this.m_ofCurrent] == '\n') {
                ++this.m_ofInLine;
            } else {
                this.m_ofInLine = 0;
                ++this.m_iLine;
            }
        } else {
            if (ch == '\u001a' && this.m_ofCurrent < cchScript) {
                --this.m_ofCurrent;
                throw new EOFException();
            }
            ++this.m_ofInLine;
        }
        return ch;
    }

    public void putBackChar() {
        char ch;
        if (this.m_ofCurrent <= 0) {
            throw new IllegalStateException();
        }
        if ((ch = this.m_achScript[--this.m_ofCurrent]) == '\n' || ch == '\r') {
            if (ch == '\r' && this.m_achScript[this.m_ofCurrent + 1] == '\n') {
                --this.m_ofInLine;
            } else {
                --this.m_iLine;
                this.m_ofInLine = 0;
                for (int of = this.m_ofCurrent - 1; of >= 0 && this.m_achScript[of] != '\r' && this.m_achScript[of] != '\n'; --of) {
                    ++this.m_ofInLine;
                }
            }
        } else {
            --this.m_ofInLine;
        }
    }

    public ParsePosition savePosition() {
        Position pos = new Position();
        pos.script = this;
        pos.ofCurrent = this.m_ofCurrent;
        pos.iLine = this.m_iLine;
        pos.ofInLine = this.m_ofInLine;
        return pos;
    }

    public void restorePosition(ParsePosition parsepos) {
        Position pos = (Position)parsepos;
        if (pos.script != this) {
            throw new IllegalArgumentException("Unknown ParsePosition object");
        }
        this.m_ofCurrent = pos.ofCurrent;
        this.m_iLine = pos.iLine;
        this.m_ofInLine = pos.ofInLine;
    }

    public int getLine() {
        return this.m_iLine;
    }

    public int getOffset() {
        return this.m_ofInLine;
    }

    public Script subScript(ParsePosition parsepos) {
        if (parsepos == null || !(parsepos instanceof Position)) {
            throw new IllegalArgumentException("Illegal ParsePosition object!");
        }
        Position pos = (Position)parsepos;
        if (pos.script != this) {
            throw new IllegalArgumentException("Invalid ParsePosition object!");
        }
        int of = pos.ofCurrent;
        int cch = this.m_ofCurrent - of;
        if (cch < 0) {
            throw new IllegalStateException("The starting offset is greater than the current offset");
        }
        return new SimpleScript(this.m_achScript, of, cch);
    }

    public String getText() {
        return this.toString();
    }

    public String toString() {
        return new String(this.m_achScript);
    }

    static class Position
    implements ParsePosition {
        Script script;
        int ofCurrent;
        int iLine;
        int ofInLine;

        Position() {
        }
    }
}

