/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Aastore;
import com.tangosol.dev.assembler.Anewarray;
import com.tangosol.dev.assembler.Bastore;
import com.tangosol.dev.assembler.Bnewarray;
import com.tangosol.dev.assembler.Castore;
import com.tangosol.dev.assembler.Cnewarray;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Dastore;
import com.tangosol.dev.assembler.Dnewarray;
import com.tangosol.dev.assembler.Dup;
import com.tangosol.dev.assembler.Fastore;
import com.tangosol.dev.assembler.Fnewarray;
import com.tangosol.dev.assembler.Iastore;
import com.tangosol.dev.assembler.Iconst;
import com.tangosol.dev.assembler.Inewarray;
import com.tangosol.dev.assembler.Lastore;
import com.tangosol.dev.assembler.Lnewarray;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.Sastore;
import com.tangosol.dev.assembler.Snewarray;
import com.tangosol.dev.assembler.Znewarray;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.Block;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class ArrayExpression
extends Expression {
    private static final String CLASS = "ArrayExpression";
    private static final DataType UNKNOWN = DataType.UNKNOWN;
    private static final DataType NULL = DataType.NULL;
    private Expression[] aexpr;

    public ArrayExpression(Block block, Token tokFirst, Token tokLast, Expression[] aexpr) {
        super(block, tokFirst, tokLast);
        this.aexpr = aexpr;
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        if (this.getType() == UNKNOWN) {
            this.logError(3, "JC-051", null, errlist);
            return this;
        }
        DataType dtElement = this.getElementType();
        char chType = dtElement.getTypeString().charAt(0);
        Expression[] aexpr = this.aexpr;
        int cexpr = aexpr.length;
        for (int i = 0; i < cexpr; ++i) {
            Expression expr = aexpr[i];
            if (expr instanceof ArrayExpression) {
                if (dtElement.isArray()) {
                    expr.setType(dtElement);
                } else {
                    this.logError(3, "JC-050", new String[]{dtElement.toString()}, errlist);
                    continue;
                }
            }
            if ((expr = (Expression)expr.precompile(ctx, setUVars, setFVars, mapThrown, errlist)).checkAssignable(ctx, dtElement, errlist)) {
                expr = expr.convertAssignable(ctx, dtElement);
            }
            aexpr[i] = expr;
        }
        this.aexpr = aexpr;
        return this;
    }

    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        DataType dtElement = this.getElementType();
        char chType = dtElement.getTypeString().charAt(0);
        Expression[] aexpr = this.aexpr;
        int cexpr = aexpr.length;
        code.add(new Iconst(cexpr));
        Op opNew = null;
        switch (chType) {
            case 'Z': {
                opNew = new Znewarray();
                break;
            }
            case 'B': {
                opNew = new Bnewarray();
                break;
            }
            case 'C': {
                opNew = new Cnewarray();
                break;
            }
            case 'S': {
                opNew = new Snewarray();
                break;
            }
            case 'I': {
                opNew = new Inewarray();
                break;
            }
            case 'J': {
                opNew = new Lnewarray();
                break;
            }
            case 'F': {
                opNew = new Fnewarray();
                break;
            }
            case 'D': {
                opNew = new Dnewarray();
                break;
            }
            case 'L': 
            case 'N': 
            case 'R': 
            case '[': {
                opNew = new Anewarray(dtElement.getClassConstant());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        code.add(opNew);
        boolean fDebug = ctx.isDebug();
        for (int i = 0; i < cexpr; ++i) {
            Expression expr = aexpr[i];
            boolean fNoOpt = fDebug || !expr.isConstant();
            Op opStore = null;
            switch (chType) {
                case 'Z': {
                    if (!fNoOpt && !((Boolean)expr.getValue()).booleanValue()) break;
                    opStore = new Bastore();
                    break;
                }
                case 'B': {
                    if (!fNoOpt && ((Number)expr.getValue()).byteValue() == 0) break;
                    opStore = new Bastore();
                    break;
                }
                case 'C': {
                    if (!fNoOpt && (char)((Number)expr.getValue()).intValue() == '\u0000') break;
                    opStore = new Castore();
                    break;
                }
                case 'S': {
                    if (!fNoOpt && ((Number)expr.getValue()).shortValue() == 0) break;
                    opStore = new Sastore();
                    break;
                }
                case 'I': {
                    if (!fNoOpt && ((Number)expr.getValue()).intValue() == 0) break;
                    opStore = new Iastore();
                    break;
                }
                case 'J': {
                    if (!fNoOpt && ((Number)expr.getValue()).longValue() == 0L) break;
                    opStore = new Lastore();
                    break;
                }
                case 'F': {
                    if (!fNoOpt && ((Number)expr.getValue()).floatValue() == 0.0f) break;
                    opStore = new Fastore();
                    break;
                }
                case 'D': {
                    if (!fNoOpt && ((Number)expr.getValue()).doubleValue() == 0.0) break;
                    opStore = new Dastore();
                    break;
                }
                case 'L': 
                case 'N': 
                case 'R': 
                case '[': {
                    if (!fNoOpt && expr.getValue() == null) break;
                    opStore = new Aastore();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (opStore == null) continue;
            code.add(new Dup());
            code.add(new Iconst(i));
            expr.compile(ctx, code, fReached, errlist);
            code.add(opStore);
        }
        return fReached;
    }

    public Expression[] getElements() {
        return this.aexpr;
    }

    public DataType getElementType() {
        return this.getType().getElementType();
    }

    public boolean isConstant() {
        Expression[] aexpr = this.aexpr;
        int cexpr = aexpr.length;
        for (int i = 0; i < cexpr; ++i) {
            if (aexpr[i].isConstant()) continue;
            return false;
        }
        return true;
    }

    public Object getValue() {
        Expression[] aexpr = this.aexpr;
        int cexpr = aexpr.length;
        Object[] aval = new Object[cexpr];
        for (int i = 0; i < cexpr; ++i) {
            aval[i] = aexpr[i].getValue();
        }
        return aval;
    }

    public void print(String sIndent) {
        ArrayExpression.out(sIndent + this.toString());
        Expression[] aexpr = this.aexpr;
        int cexpr = aexpr.length;
        for (int i = 0; i < cexpr; ++i) {
            ArrayExpression.out(sIndent + "  [" + i + "]");
            aexpr[i].print(sIndent + "    ");
        }
    }
}

