/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;

public abstract class BinaryExpression
extends Expression {
    private static final String CLASS = "BinaryExpression";
    private Expression left;
    private Token operator;
    private Expression right;

    protected BinaryExpression(Expression left, Token operator, Expression right) {
        super(left.getBlock(), left.getStartToken(), right.getEndToken());
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    public boolean isConstant() {
        return this.left.isConstant() && this.right.isConstant();
    }

    public void print(String sIndent) {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        BinaryExpression.out(sIndent + this.toString());
        sIndent = sIndent + "  ";
        BinaryExpression.out(sIndent + "Left:");
        left.print(sIndent + "  ");
        BinaryExpression.out(sIndent + "Operator:  " + this.operator.toString());
        BinaryExpression.out(sIndent + "Right:");
        right.print(sIndent + "  ");
    }

    public Expression getLeftExpression() {
        return this.left;
    }

    protected void setLeftExpression(Expression left) {
        this.left = left;
    }

    public Token getOperator() {
        return this.operator;
    }

    public Expression getRightExpression() {
        return this.right;
    }

    protected void setRightExpression(Expression right) {
        this.right = right;
    }
}

