/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Iconst;
import com.tangosol.dev.assembler.IntConstant;
import com.tangosol.dev.assembler.Ixor;
import com.tangosol.dev.assembler.Lconst;
import com.tangosol.dev.assembler.LongConstant;
import com.tangosol.dev.assembler.Lxor;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.UnaryExpression;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class BitNotExpression
extends UnaryExpression {
    private static final String CLASS = "BitNotExpression";
    private static final IntConstant ICONST_M1 = Constants.CONSTANT_ICONST_M1;
    private static final LongConstant LCONST_M1 = new LongConstant(-1L);

    public BitNotExpression(Token operator, Expression expr) {
        super(operator, expr);
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression expr = this.getExpression();
        if ((expr = (Expression)expr.precompile(ctx, setUVars, setFVars, mapThrown, errlist)).checkIntegral(errlist)) {
            expr = expr.promoteNumeric();
            this.setExpression(expr);
            this.setType(expr.getType());
        }
        return this;
    }

    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        boolean fLong;
        Expression expr = this.getExpression();
        boolean bl = fLong = expr.getType() == DataType.LONG;
        if (!ctx.isDebug() && expr.isConstant()) {
            if (fLong) {
                long l = ((Number)expr.getValue()).longValue();
                code.add(new Lconst(l ^ 0xFFFFFFFFFFFFFFFFL));
            } else {
                int i = ((Number)expr.getValue()).intValue();
                code.add(new Iconst(~i));
            }
        } else {
            expr.compile(ctx, code, fReached, errlist);
            if (fLong) {
                code.add(new Lconst(LCONST_M1));
                code.add(new Lxor());
            } else {
                code.add(new Iconst(ICONST_M1));
                code.add(new Ixor());
            }
        }
        return fReached;
    }

    public boolean isConstant() {
        return this.getExpression().isConstant();
    }

    public Object getValue() {
        boolean fLong;
        Expression expr = this.getExpression();
        boolean bl = fLong = expr.getType() == DataType.LONG;
        if (fLong) {
            long l = (Long)expr.getValue();
            return BitNotExpression.makeLong(l ^ 0xFFFFFFFFFFFFFFFFL);
        }
        int i = (Integer)expr.getValue();
        return BitNotExpression.makeInteger(~i);
    }
}

