/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Return;
import com.tangosol.dev.compiler.CompilerErrorInfo;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.MethodInfo;
import com.tangosol.dev.compiler.ParamInfo;
import com.tangosol.dev.compiler.SyntaxException;
import com.tangosol.dev.compiler.TypeInfo;
import com.tangosol.dev.compiler.java.AddExpression;
import com.tangosol.dev.compiler.java.AndExpression;
import com.tangosol.dev.compiler.java.ArrayAccessExpression;
import com.tangosol.dev.compiler.java.ArrayExpression;
import com.tangosol.dev.compiler.java.AssignExpression;
import com.tangosol.dev.compiler.java.BinaryExpression;
import com.tangosol.dev.compiler.java.BitAndExpression;
import com.tangosol.dev.compiler.java.BitNotExpression;
import com.tangosol.dev.compiler.java.BitOrExpression;
import com.tangosol.dev.compiler.java.BitXorExpression;
import com.tangosol.dev.compiler.java.Block;
import com.tangosol.dev.compiler.java.BooleanExpression;
import com.tangosol.dev.compiler.java.BreakStatement;
import com.tangosol.dev.compiler.java.CaseClause;
import com.tangosol.dev.compiler.java.CastAssignExpression;
import com.tangosol.dev.compiler.java.CastExpression;
import com.tangosol.dev.compiler.java.CatchClause;
import com.tangosol.dev.compiler.java.CharExpression;
import com.tangosol.dev.compiler.java.ClassExpression;
import com.tangosol.dev.compiler.java.ConditionalExpression;
import com.tangosol.dev.compiler.java.Constants;
import com.tangosol.dev.compiler.java.ContinueStatement;
import com.tangosol.dev.compiler.java.DeclarationStatement;
import com.tangosol.dev.compiler.java.DefaultClause;
import com.tangosol.dev.compiler.java.DimensionedExpression;
import com.tangosol.dev.compiler.java.DivideExpression;
import com.tangosol.dev.compiler.java.DoStatement;
import com.tangosol.dev.compiler.java.DoubleExpression;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.EmptyStatement;
import com.tangosol.dev.compiler.java.EqualExpression;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.ExpressionStatement;
import com.tangosol.dev.compiler.java.FieldAccessExpression;
import com.tangosol.dev.compiler.java.FinallyClause;
import com.tangosol.dev.compiler.java.FloatExpression;
import com.tangosol.dev.compiler.java.ForStatement;
import com.tangosol.dev.compiler.java.GreaterExpression;
import com.tangosol.dev.compiler.java.IfStatement;
import com.tangosol.dev.compiler.java.InstanceOfExpression;
import com.tangosol.dev.compiler.java.IntExpression;
import com.tangosol.dev.compiler.java.InvocationExpression;
import com.tangosol.dev.compiler.java.LabelStatement;
import com.tangosol.dev.compiler.java.LeftShiftExpression;
import com.tangosol.dev.compiler.java.LessExpression;
import com.tangosol.dev.compiler.java.LiteralToken;
import com.tangosol.dev.compiler.java.LongExpression;
import com.tangosol.dev.compiler.java.MinusExpression;
import com.tangosol.dev.compiler.java.ModuloExpression;
import com.tangosol.dev.compiler.java.MultiplyExpression;
import com.tangosol.dev.compiler.java.NameExpression;
import com.tangosol.dev.compiler.java.NewArrayExpression;
import com.tangosol.dev.compiler.java.NewClassExpression;
import com.tangosol.dev.compiler.java.NotEqualExpression;
import com.tangosol.dev.compiler.java.NotExpression;
import com.tangosol.dev.compiler.java.NotGreaterExpression;
import com.tangosol.dev.compiler.java.NotLessExpression;
import com.tangosol.dev.compiler.java.NullExpression;
import com.tangosol.dev.compiler.java.OrExpression;
import com.tangosol.dev.compiler.java.PlusExpression;
import com.tangosol.dev.compiler.java.PostDecExpression;
import com.tangosol.dev.compiler.java.PostIncExpression;
import com.tangosol.dev.compiler.java.PreDecExpression;
import com.tangosol.dev.compiler.java.PreIncExpression;
import com.tangosol.dev.compiler.java.ReturnStatement;
import com.tangosol.dev.compiler.java.RightShiftExpression;
import com.tangosol.dev.compiler.java.Statement;
import com.tangosol.dev.compiler.java.StatementBlock;
import com.tangosol.dev.compiler.java.StringExpression;
import com.tangosol.dev.compiler.java.SubtractExpression;
import com.tangosol.dev.compiler.java.SuperExpression;
import com.tangosol.dev.compiler.java.SwitchStatement;
import com.tangosol.dev.compiler.java.SynchronizedStatement;
import com.tangosol.dev.compiler.java.TargetStatement;
import com.tangosol.dev.compiler.java.ThisExpression;
import com.tangosol.dev.compiler.java.ThrowStatement;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.TokenConstants;
import com.tangosol.dev.compiler.java.Tokenizer;
import com.tangosol.dev.compiler.java.TryStatement;
import com.tangosol.dev.compiler.java.TypeExpression;
import com.tangosol.dev.compiler.java.UnsignedShiftExpression;
import com.tangosol.dev.compiler.java.WhileStatement;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.Base;
import com.tangosol.util.ErrorList;
import com.tangosol.util.NullImplementation;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Compiler
extends Base
implements com.tangosol.dev.compiler.Compiler,
Constants,
TokenConstants {
    private static final String CLASS = "Compiler";
    private static final Expression[] NO_EXPRESSIONS = new Expression[0];
    private static final boolean DEBUG = "JAVA".equals(System.getProperty("DEBUG"));
    protected ErrorList errlist;
    protected Tokenizer toker;
    protected Token token;
    protected HashMap tblImports = new HashMap();

    public void compile(Context ctx, String sScript, ErrorList errlist) throws CompilerException {
        if (ctx == null || sScript == null || errlist == null) {
            throw new IllegalArgumentException("Compiler.compile:  Parameters required!");
        }
        StatementBlock block = new StatementBlock();
        MethodInfo method = ctx.getMethodInfo();
        Compiler.azzert(method != null, "Failed to retrieve the context method");
        if (DEBUG) {
            Compiler.out();
            Compiler.printMethodInfo(method);
        }
        if (!method.isStatic()) {
            block.addStatement(this.createParameterDeclaration(block, true, method.getTypeInfo().getDataType(), "this"));
        }
        int cParams = method.getParamCount();
        for (int i = 0; i < cParams; ++i) {
            ParamInfo param = method.getParamInfo(i);
            block.addStatement(this.createParameterDeclaration(block, param.isFinal(), param.getDataType(), param.getName()));
        }
        this.errlist = errlist;
        this.toker = new Tokenizer(sScript, errlist);
        this.token = this.next();
        this.parseCompilationUnit(block);
        if (DEBUG) {
            block.print();
        }
        if (errlist.isSevere()) {
            throw new CompilerException();
        }
        this.checkImports(ctx);
        if (errlist.isSevere()) {
            throw new CompilerException();
        }
        DualSet setUVars = new DualSet(NullImplementation.getSet());
        DualSet setFVars = new DualSet(NullImplementation.getSet());
        HashMap mapThrown = new HashMap();
        ((Element)block).precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        if (!mapThrown.isEmpty()) {
            Enumeration enmr = method.exceptionTypes();
            while (enmr.hasMoreElements()) {
                Expression.catchException(ctx, (DataType)enmr.nextElement(), mapThrown);
                if (!mapThrown.isEmpty()) continue;
            }
        }
        if (!mapThrown.isEmpty()) {
            Iterator iterThrown = mapThrown.entrySet().iterator();
            while (iterThrown.hasNext()) {
                Map.Entry entry = iterThrown.next();
                DataType dtThrown = (DataType)entry.getKey();
                Iterator iterExpr = ((Set)entry.getValue()).iterator();
                while (iterExpr.hasNext()) {
                    Expression expr = (Expression)iterExpr.next();
                    expr.logError(3, "JC-016", new String[]{dtThrown.getClassName()}, errlist);
                }
            }
        }
        if (errlist.isSevere()) {
            throw new CompilerException();
        }
        CodeAttribute code = ctx.getCode();
        if (block.compile(ctx, code, true, errlist)) {
            if (method.getDataType() == DataType.VOID) {
                code.add(new Return());
            } else {
                this.logError(3, "JC-005", null, block.getEndLine(), block.getEndOffset(), 0);
            }
        }
        if (DEBUG) {
            code.print();
            Compiler.out();
        }
        if (errlist.isSevere()) {
            throw new CompilerException();
        }
    }

    protected void parseCompilationUnit(Block block) throws CompilerException {
        this.parseImportDeclarations();
        this.parseBlockStatements(block);
        if (this.token != null && this.token.id == 53 && this.token.length == 0) {
            block.setEndToken(this.token);
        } else {
            this.logError(3, "JC-073", null, this.token.getLine(), this.token.getOffset(), 0);
        }
    }

    protected void parseImportDeclarations() throws CompilerException {
        block6: while (this.peek(24) != null) {
            try {
                Token tokName = null;
                String sFull = null;
                StringBuffer sb = new StringBuffer();
                boolean fFirst = true;
                do {
                    if (fFirst) {
                        fFirst = false;
                    } else {
                        sb.append('.');
                    }
                    tokName = this.match(105);
                    sb.append(tokName.getText());
                } while (this.peek(58) != null);
                sFull = sb.toString();
                if (this.peek(2) != null) {
                    tokName = this.match(105);
                }
                this.match(56);
                this.tblImports.put(tokName, sFull);
            }
            catch (SyntaxException e) {
                while (true) {
                    switch (this.token.id) {
                        case 56: {
                            this.next();
                        }
                        case 4: 
                        case 6: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 17: 
                        case 20: 
                        case 22: 
                        case 24: 
                        case 35: 
                        case 40: 
                        case 41: 
                        case 43: 
                        case 46: 
                        case 49: 
                        case 53: {
                            continue block6;
                        }
                    }
                    this.next();
                }
            }
        }
    }

    protected Block parseBlock(Statement outer) throws CompilerException {
        StatementBlock block = new StatementBlock(outer, this.token);
        if (this.token.id == 52) {
            this.match(52);
            this.parseBlockStatements(block);
            block.setEndToken(this.match(53));
        } else {
            this.logError(3, "JC-017", new String[]{"{"}, this.token.getLine(), this.token.getOffset(), 0);
            block.addStatement(this.parseStatement(block));
        }
        return block;
    }

    protected void parseBlockStatements(Block block) throws CompilerException {
        while (this.token.id != 53) {
            try {
                block.addStatement(this.parseStatement(block));
            }
            catch (SyntaxException e) {
                this.expurgateStatement();
            }
        }
    }

    protected Statement parseStatement(Statement outer) throws CompilerException {
        Block block = outer instanceof Block ? (Block)outer : outer.getBlock();
        switch (this.token.id) {
            case 56: {
                return new EmptyStatement(outer, this.current());
            }
            case 52: {
                return this.parseBlock(outer);
            }
            case 46: {
                Statement clause;
                TryStatement stmt = new TryStatement(outer, this.current());
                stmt.setInnerStatement(this.parseBlock(stmt));
                Statement last = null;
                boolean fNoClauses = true;
                while (this.token.id == 7) {
                    clause = new CatchClause(stmt, this.current());
                    this.match(50);
                    DeclarationStatement stmtDecl = this.parseDeclaration(clause);
                    stmtDecl.setParameter(true);
                    ((Block)clause).addStatement(stmtDecl);
                    this.match(51);
                    ((Block)clause).addStatement(this.parseBlock(clause));
                    if (fNoClauses) {
                        stmt.setCatchClause((CatchClause)clause);
                    } else {
                        last.setNextStatement(clause);
                    }
                    last = clause;
                    fNoClauses = false;
                }
                if (this.token.id == 18) {
                    clause = new FinallyClause(stmt, this.current());
                    clause.setInnerStatement(this.parseBlock(clause));
                    stmt.setFinallyClause((FinallyClause)clause);
                    fNoClauses = false;
                }
                if (fNoClauses) {
                    // empty if block
                }
                return stmt;
            }
            case 41: {
                SynchronizedStatement stmt = new SynchronizedStatement(outer, this.current());
                this.match(50);
                stmt.setExpression(this.parseExpression(block));
                this.match(51);
                Block inner = this.parseBlock(stmt);
                stmt.setInnerStatement(inner);
                stmt.setEndToken(inner.getEndToken());
                return stmt;
            }
            case 13: {
                DoStatement stmt = new DoStatement(outer, this.current());
                stmt.setInnerStatement(this.parseStatement(stmt));
                this.match(49);
                this.match(50);
                stmt.setTest(this.parseExpression(block));
                this.match(51);
                stmt.setEndToken(this.match(56));
                return stmt;
            }
            case 49: {
                WhileStatement stmt = new WhileStatement(outer, this.current());
                this.match(50);
                stmt.setTest(this.parseExpression(block));
                this.match(51);
                stmt.setInnerStatement(this.parseStatement(stmt));
                return stmt;
            }
            case 20: {
                ForStatement stmt = new ForStatement(outer, this.current());
                this.match(50);
                if (this.token.id != 56) {
                    stmt.setInit(this.parseStatementList(stmt, true));
                }
                this.match(56);
                if (this.token.id != 56) {
                    stmt.setTest(this.parseExpression(stmt));
                }
                this.match(56);
                if (this.token.id != 51) {
                    stmt.setUpdate(this.parseStatementList(stmt, false));
                }
                this.match(51);
                stmt.setInnerStatement(this.parseStatement(stmt));
                return stmt;
            }
            case 22: {
                IfStatement stmt = new IfStatement(outer, this.current());
                this.match(50);
                stmt.setTest(this.parseExpression(block));
                this.match(51);
                stmt.setThenStatement(this.parseStatement(stmt));
                if (this.peek(15) != null) {
                    stmt.setElseStatement(this.parseStatement(stmt));
                }
                return stmt;
            }
            case 35: {
                ReturnStatement stmt = new ReturnStatement(outer, this.current());
                if (this.token.id != 56) {
                    stmt.setExpression(this.parseExpression(block));
                }
                stmt.setEndToken(this.match(56));
                return stmt;
            }
            case 43: {
                ThrowStatement stmt = new ThrowStatement(outer, this.current());
                stmt.setExpression(this.parseExpression(block));
                stmt.setEndToken(this.match(56));
                return stmt;
            }
            case 40: {
                SwitchStatement stmt = new SwitchStatement(outer, this.current());
                this.match(50);
                stmt.setTest(this.parseExpression(block));
                this.match(51);
                this.match(52);
                block38: while (true) {
                    try {
                        switch (this.token.id) {
                            case 6: {
                                TargetStatement clause = new CaseClause((Statement)stmt, this.current());
                                ((CaseClause)clause).setTest(this.parseExpression(stmt));
                                clause.setEndToken(this.match(95));
                                stmt.addStatement(clause);
                                continue block38;
                            }
                            case 12: {
                                TargetStatement clause = new DefaultClause((Statement)stmt, this.current());
                                clause.setEndToken(this.match(95));
                                stmt.addStatement(clause);
                                continue block38;
                            }
                            default: {
                                stmt.addStatement(this.parseStatement(stmt));
                                continue block38;
                            }
                            case 53: 
                        }
                    }
                    catch (SyntaxException e) {
                        this.expurgateStatement();
                        continue;
                    }
                    break;
                }
                stmt.setEndToken(this.current());
                return stmt;
            }
            case 4: {
                BreakStatement stmt = new BreakStatement(outer, this.current(), this.peek(105));
                stmt.setEndToken(this.match(56));
                return stmt;
            }
            case 11: {
                ContinueStatement stmt = new ContinueStatement(outer, this.current(), this.peek(105));
                stmt.setEndToken(this.match(56));
                return stmt;
            }
            case 3: 
            case 5: 
            case 8: 
            case 14: 
            case 17: 
            case 19: 
            case 26: 
            case 28: 
            case 36: {
                DeclarationStatement stmt = this.parseDeclaration(outer);
                stmt.setEndToken(this.match(56));
                return stmt;
            }
            case 105: {
                Expression expr = this.parseExpression(block);
                switch (this.token.id) {
                    case 105: {
                        DeclarationStatement stmt = this.parseDeclaration(outer, null, this.toTypeExpression(expr));
                        stmt.setEndToken(this.match(56));
                        return stmt;
                    }
                    case 95: {
                        Token tokLabel = expr.getStartToken();
                        if (tokLabel != expr.getEndToken() || tokLabel.getCategory() != 1) break;
                        LabelStatement stmt = new LabelStatement(outer, tokLabel, this.match(95));
                        stmt.setInnerStatement(this.parseStatement(stmt));
                        return stmt;
                    }
                }
                ExpressionStatement stmt = this.createExpressionStatement(outer, expr);
                stmt.setEndToken(this.match(56));
                return stmt;
            }
            case 30: 
            case 39: 
            case 42: 
            case 50: 
            case 92: 
            case 93: {
                Expression expr = this.parseExpression(block);
                ExpressionStatement stmt = this.createExpressionStatement(outer, expr);
                stmt.setEndToken(this.match(56));
                return stmt;
            }
            case 15: {
                this.logError(3, "JC-023", new String[]{this.token.getText()}, this.token);
                throw new SyntaxException();
            }
            case 7: {
                this.logError(3, "JC-024", new String[]{this.token.getText()}, this.token);
                throw new SyntaxException();
            }
            case 18: {
                this.logError(3, "JC-025", new String[]{this.token.getText()}, this.token);
                throw new SyntaxException();
            }
            case 6: 
            case 12: {
                this.logError(3, "JC-026", new String[]{this.token.getText()}, this.token);
                throw new SyntaxException();
            }
            case 25: 
            case 51: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                this.logError(3, "JC-018", new String[]{this.token.getText()}, this.token);
                throw new SyntaxException();
            }
            case 24: 
            case 53: {
                this.logError(3, "JC-019", new String[]{this.token.getText()}, this.token);
                throw new CompilerException();
            }
            case 1: 
            case 9: 
            case 16: 
            case 23: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 44: 
            case 45: 
            case 47: 
            case 48: {
                this.logError(3, "JC-020", new String[]{this.token.getText()}, this.token);
                throw new CompilerException();
            }
            case 10: 
            case 21: {
                this.logError(3, "JC-021", new String[]{this.token.getText()}, this.token);
                throw new CompilerException();
            }
        }
        this.logError(3, "JC-022", new String[]{this.token.getText()}, this.token);
        throw new CompilerException();
    }

    protected Statement parseStatementList(Statement outer, boolean fDeclare) throws CompilerException {
        ExpressionStatement stmt;
        Block block = outer instanceof Block ? (Block)outer : outer.getBlock();
        Token tokFinal = fDeclare ? this.peek(17) : null;
        Expression expr = this.parseExpression(block);
        if (fDeclare && (tokFinal != null || this.token.id == 105)) {
            return this.parseDeclaration(outer, tokFinal, this.toTypeExpression(expr));
        }
        ExpressionStatement last = stmt = this.createExpressionStatement(outer, expr);
        while (this.peek(57) != null) {
            ExpressionStatement next = this.createExpressionStatement(outer, this.parseExpression(block));
            last.setNextStatement(next);
            last = next;
        }
        return stmt;
    }

    protected ExpressionStatement createExpressionStatement(Statement outer, Expression expr) throws CompilerException {
        if (expr instanceof AssignExpression || expr instanceof InvocationExpression || expr instanceof NewClassExpression || expr instanceof PreIncExpression || expr instanceof PostIncExpression || expr instanceof PreDecExpression || expr instanceof PostDecExpression) {
            ExpressionStatement stmt = new ExpressionStatement(outer, expr.getStartToken());
            stmt.setExpression(expr);
            return stmt;
        }
        expr.logError(3, "JC-028", null, this.errlist);
        throw new SyntaxException();
    }

    protected DeclarationStatement parseDeclaration(Statement outer) throws CompilerException {
        TypeExpression type;
        Block block = outer instanceof Block ? (Block)outer : outer.getBlock();
        Token tokFinal = this.peek(17);
        switch (this.token.id) {
            case 3: 
            case 5: 
            case 8: 
            case 14: 
            case 19: 
            case 26: 
            case 28: 
            case 36: {
                type = this.parseDimensionedExpression(block, new TypeExpression(block, this.current()));
                break;
            }
            default: {
                type = this.toTypeExpression(this.parseExpression(block));
            }
        }
        return this.parseDeclaration(outer, tokFinal, type);
    }

    protected DeclarationStatement parseDeclaration(Statement outer, Token tokFinal, TypeExpression type) throws CompilerException {
        Block block = outer instanceof Block ? (Block)outer : outer.getBlock();
        Token tokFirst = tokFinal == null ? type.getStartToken() : tokFinal;
        DeclarationStatement decl = new DeclarationStatement(outer, tokFirst);
        decl.setModifier(tokFinal);
        decl.setTypeExpression(type);
        Statement last = null;
        do {
            ExpressionStatement stmt = new ExpressionStatement(decl, this.token);
            stmt.setExpression(this.parseExpression(block));
            if (last == null) {
                decl.setInnerStatement(stmt);
            } else {
                last.setNextStatement(stmt);
            }
            last = stmt;
        } while (this.peek(57) != null);
        return decl;
    }

    protected Statement createParameterDeclaration(Block block, boolean fFinal, DataType dtParam, String sName) {
        Token tokFinal = fFinal ? new Token(Token.TOK_FINAL, 0, 0, 0) : null;
        Token tokType = null;
        Token tokLast = null;
        Token tokIdent = new Token(1, 0, 105, null, sName, 0, 0, 0);
        DataType dt = dtParam;
        while (dt.isArray()) {
            dt = dt.getElementType();
            if (tokLast == null) continue;
            tokLast = new Token(Token.TOK_RBRACKET, 0, 0, 0);
        }
        if (dt.isPrimitive()) {
            switch (dt.getJVMSignature().charAt(0)) {
                case 'Z': {
                    tokType = Token.TOK_BOOLEAN;
                    break;
                }
                case 'B': {
                    tokType = Token.TOK_BYTE;
                    break;
                }
                case 'C': {
                    tokType = Token.TOK_CHAR;
                    break;
                }
                case 'S': {
                    tokType = Token.TOK_SHORT;
                    break;
                }
                case 'I': {
                    tokType = Token.TOK_INT;
                    break;
                }
                case 'J': {
                    tokType = Token.TOK_LONG;
                    break;
                }
                case 'F': {
                    tokType = Token.TOK_FLOAT;
                    break;
                }
                case 'D': {
                    tokType = Token.TOK_DOUBLE;
                }
            }
            tokType = new Token(tokType, 0, 0, 0);
        } else {
            String sType = dt.isComponent() ? dt.getComponentName() : dt.getClassName();
            int of = sType.indexOf(46);
            if (of >= 0) {
                if (tokLast != null) {
                    tokLast = new Token(1, 0, 105, null, sType.substring(sType.lastIndexOf(46) + 1), 0, 0, 0);
                }
                sType = sType.substring(0, of);
            }
            tokType = new Token(1, 0, 105, null, sType, 0, 0, 0);
        }
        TypeExpression type = new TypeExpression(block, tokType, dtParam);
        type.setEndToken(tokLast == null ? tokType : tokLast);
        DeclarationStatement decl = new DeclarationStatement((Statement)block, tokFinal == null ? tokType : tokFinal);
        decl.setParameter(true);
        decl.setModifier(tokFinal);
        decl.setTypeExpression(type);
        ExpressionStatement stmt = new ExpressionStatement(decl, tokIdent);
        stmt.setExpression(new NameExpression(block, tokIdent));
        decl.setInnerStatement(stmt);
        return decl;
    }

    protected void expurgateStatement() throws CompilerException {
        block6: while (true) {
            switch (this.token.id) {
                case 56: {
                    this.next();
                    return;
                }
                case 4: 
                case 11: 
                case 13: 
                case 17: 
                case 20: 
                case 22: 
                case 35: 
                case 40: 
                case 41: 
                case 43: 
                case 46: 
                case 49: {
                    return;
                }
                case 50: 
                case 52: 
                case 54: {
                    this.expurgateParenthetical();
                    continue block6;
                }
                case 53: {
                    return;
                }
            }
            this.next();
        }
    }

    protected void expurgateParenthetical() throws CompilerException {
        String sClose;
        int idClose;
        int idOpen = this.token.id;
        switch (idOpen) {
            default: {
                idClose = 53;
                sClose = "}";
                break;
            }
            case 50: {
                idClose = 51;
                sClose = ")";
                break;
            }
            case 54: {
                idClose = 55;
                sClose = "]";
            }
        }
        Token tokUnmatched = this.token;
        int cUnmatched = 0;
        do {
            int id;
            if ((id = this.token.id) == 53 && this.token.length == 0) {
                this.logError(3, "JC-017", new String[]{sClose}, this.token.getLine(), this.token.getOffset(), 0);
            } else if (id == idOpen) {
                ++cUnmatched;
            } else if (id == idClose) {
                --cUnmatched;
            }
            this.next();
        } while (cUnmatched > 0);
    }

    /*
     * WARNING - void declaration
     */
    protected Expression parseExpression(Block block) throws CompilerException {
        void var4_4;
        void var3_3;
        Expression exprLeft = this.parseConditionalExpression(block);
        switch (this.token.id) {
            case 71: {
                return new AssignExpression(exprLeft, this.current(), this.parseExpression(block));
            }
            case 72: {
                Token tokOp = this.current();
                BinaryExpression exprRight = new AddExpression(exprLeft, tokOp, this.parseExpression(block));
                break;
            }
            case 73: {
                Token tokOp = this.current();
                BinaryExpression exprRight = new SubtractExpression(exprLeft, tokOp, this.parseExpression(block));
                break;
            }
            case 74: {
                Token tokOp = this.current();
                BinaryExpression exprRight = new MultiplyExpression(exprLeft, tokOp, this.parseExpression(block));
                break;
            }
            case 75: {
                Token tokOp = this.current();
                BinaryExpression exprRight = new DivideExpression(exprLeft, tokOp, this.parseExpression(block));
                break;
            }
            case 76: {
                Token tokOp = this.current();
                BinaryExpression exprRight = new ModuloExpression(exprLeft, tokOp, this.parseExpression(block));
                break;
            }
            case 77: {
                Token tokOp = this.current();
                BinaryExpression exprRight = new LeftShiftExpression(exprLeft, tokOp, this.parseExpression(block));
                break;
            }
            case 78: {
                Token tokOp = this.current();
                BinaryExpression exprRight = new RightShiftExpression(exprLeft, tokOp, this.parseExpression(block));
                break;
            }
            case 79: {
                Token tokOp = this.current();
                BinaryExpression exprRight = new UnsignedShiftExpression(exprLeft, tokOp, this.parseExpression(block));
                break;
            }
            case 80: {
                Token tokOp = this.current();
                BinaryExpression exprRight = new BitAndExpression(exprLeft, tokOp, this.parseExpression(block));
                break;
            }
            case 81: {
                Token tokOp = this.current();
                BinaryExpression exprRight = new BitOrExpression(exprLeft, tokOp, this.parseExpression(block));
                break;
            }
            case 82: {
                Token tokOp = this.current();
                BinaryExpression exprRight = new BitXorExpression(exprLeft, tokOp, this.parseExpression(block));
                break;
            }
            default: {
                return exprLeft;
            }
        }
        return new CastAssignExpression(exprLeft, (Token)var3_3, (Expression)var4_4);
    }

    protected Expression parseConditionalExpression(Block block) throws CompilerException {
        Expression expr = this.parseOrExpression(block);
        if (this.token.id == 94) {
            expr = new ConditionalExpression(expr, this.current(), this.parseExpression(block), this.match(95), this.parseConditionalExpression(block));
        }
        return expr;
    }

    protected Expression parseOrExpression(Block block) throws CompilerException {
        Expression expr = this.parseAndExpression(block);
        while (this.token.id == 90) {
            expr = new OrExpression(expr, this.current(), this.parseAndExpression(block));
        }
        return expr;
    }

    protected Expression parseAndExpression(Block block) throws CompilerException {
        Expression expr = this.parseBitOrExpression(block);
        while (this.token.id == 89) {
            expr = new AndExpression(expr, this.current(), this.parseBitOrExpression(block));
        }
        return expr;
    }

    protected Expression parseBitOrExpression(Block block) throws CompilerException {
        Expression expr = this.parseBitXorExpression(block);
        while (this.token.id == 68) {
            expr = new BitOrExpression(expr, this.current(), this.parseBitXorExpression(block));
        }
        return expr;
    }

    protected Expression parseBitXorExpression(Block block) throws CompilerException {
        Expression expr = this.parseBitAndExpression(block);
        while (this.token.id == 69) {
            expr = new BitXorExpression(expr, this.current(), this.parseBitAndExpression(block));
        }
        return expr;
    }

    protected Expression parseBitAndExpression(Block block) throws CompilerException {
        Expression expr = this.parseEqualityExpression(block);
        while (this.token.id == 67) {
            expr = new BitAndExpression(expr, this.current(), this.parseEqualityExpression(block));
        }
        return expr;
    }

    protected Expression parseEqualityExpression(Block block) throws CompilerException {
        Expression expr = this.parseRelationalExpression(block);
        block4: while (true) {
            switch (this.token.id) {
                case 83: {
                    expr = new EqualExpression(expr, this.current(), this.parseRelationalExpression(block));
                    continue block4;
                }
                case 84: {
                    expr = new NotEqualExpression(expr, this.current(), this.parseRelationalExpression(block));
                    continue block4;
                }
            }
            break;
        }
        return expr;
    }

    protected Expression parseRelationalExpression(Block block) throws CompilerException {
        Expression expr = this.parseShiftExpression(block);
        block7: while (true) {
            switch (this.token.id) {
                case 87: {
                    expr = new LessExpression(expr, this.current(), this.parseShiftExpression(block));
                    continue block7;
                }
                case 86: {
                    expr = new NotLessExpression(expr, this.current(), this.parseShiftExpression(block));
                    continue block7;
                }
                case 85: {
                    expr = new GreaterExpression(expr, this.current(), this.parseShiftExpression(block));
                    continue block7;
                }
                case 88: {
                    expr = new NotGreaterExpression(expr, this.current(), this.parseShiftExpression(block));
                    continue block7;
                }
                case 25: {
                    expr = new InstanceOfExpression(expr, this.current(), this.parseShiftExpression(block));
                    continue block7;
                }
            }
            break;
        }
        return expr;
    }

    protected Expression parseShiftExpression(Block block) throws CompilerException {
        Expression expr = this.parseAdditiveExpression(block);
        block5: while (true) {
            switch (this.token.id) {
                case 64: {
                    expr = new LeftShiftExpression(expr, this.current(), this.parseAdditiveExpression(block));
                    continue block5;
                }
                case 65: {
                    expr = new RightShiftExpression(expr, this.current(), this.parseAdditiveExpression(block));
                    continue block5;
                }
                case 66: {
                    expr = new UnsignedShiftExpression(expr, this.current(), this.parseAdditiveExpression(block));
                    continue block5;
                }
            }
            break;
        }
        return expr;
    }

    protected Expression parseAdditiveExpression(Block block) throws CompilerException {
        Expression expr = this.parseMultiplicativeExpression(block);
        block4: while (true) {
            switch (this.token.id) {
                case 59: {
                    expr = new AddExpression(expr, this.current(), this.parseMultiplicativeExpression(block));
                    continue block4;
                }
                case 60: {
                    expr = new SubtractExpression(expr, this.current(), this.parseMultiplicativeExpression(block));
                    continue block4;
                }
            }
            break;
        }
        return expr;
    }

    protected Expression parseMultiplicativeExpression(Block block) throws CompilerException {
        Expression expr = this.parseUnaryExpression(block);
        block5: while (true) {
            switch (this.token.id) {
                case 61: {
                    expr = new MultiplyExpression(expr, this.current(), this.parseUnaryExpression(block));
                    continue block5;
                }
                case 62: {
                    expr = new DivideExpression(expr, this.current(), this.parseUnaryExpression(block));
                    continue block5;
                }
                case 63: {
                    expr = new ModuloExpression(expr, this.current(), this.parseUnaryExpression(block));
                    continue block5;
                }
            }
            break;
        }
        return expr;
    }

    protected Expression parseUnaryExpression(Block block) throws CompilerException {
        Expression expr = null;
        block0 : switch (this.token.id) {
            case 3: 
            case 5: 
            case 8: 
            case 14: 
            case 19: 
            case 26: 
            case 28: 
            case 36: {
                expr = this.parseNarrowingExpression(block, new TypeExpression(block, this.current()));
                if (!(expr instanceof TypeExpression)) break;
                return expr;
            }
            case 52: {
                return this.parseArrayInitializer(block);
            }
            case 59: {
                expr = new PlusExpression(this.current(), this.parseUnaryExpression(block));
                break;
            }
            case 60: {
                Token tokMinus = this.current();
                switch (this.token.id) {
                    case 100: {
                        expr = new IntExpression(block, tokMinus, this.current());
                        break block0;
                    }
                    case 101: {
                        expr = new LongExpression(block, tokMinus, this.current());
                        break block0;
                    }
                }
                expr = new MinusExpression(tokMinus, this.parseUnaryExpression(block));
                break;
            }
            case 92: {
                expr = new PreIncExpression(this.current(), this.parseUnaryExpression(block));
                break;
            }
            case 93: {
                expr = new PreDecExpression(this.current(), this.parseUnaryExpression(block));
                break;
            }
            case 70: {
                expr = new BitNotExpression(this.current(), this.parseUnaryExpression(block));
                break;
            }
            case 91: {
                expr = new NotExpression(this.current(), this.parseUnaryExpression(block));
                break;
            }
            case 50: {
                Token tokParen = this.current();
                expr = this.parseExpression(block);
                this.match(51);
                boolean fCast = false;
                if (expr instanceof TypeExpression) {
                    fCast = true;
                } else {
                    switch (this.token.id) {
                        case 30: 
                        case 39: 
                        case 42: 
                        case 50: 
                        case 70: 
                        case 91: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: {
                            fCast = true;
                        }
                    }
                }
                if (fCast) {
                    expr = new CastExpression(tokParen, this.parseUnaryExpression(block), this.toTypeExpression(expr));
                    break;
                }
                expr = this.parseNarrowingExpression(block, expr);
                break;
            }
            case 30: {
                Token tokFirst = this.current();
                TypeExpression type = null;
                boolean fArray = false;
                switch (this.token.id) {
                    case 3: 
                    case 5: 
                    case 8: 
                    case 14: 
                    case 19: 
                    case 26: 
                    case 28: 
                    case 36: {
                        type = new TypeExpression(block, this.current());
                        fArray = true;
                        break;
                    }
                    default: {
                        NameExpression name = new NameExpression(block, this.current());
                        while (this.peek(58) != null) {
                            name.addName(this.match(105));
                        }
                        type = new TypeExpression(name);
                        boolean bl = fArray = this.token.id == 54;
                    }
                }
                if (fArray) {
                    ArrayList<Expression> list = new ArrayList<Expression>();
                    boolean fEmpty = false;
                    boolean fInit = true;
                    Token tokLast = null;
                    this.match(54);
                    do {
                        if (fEmpty || this.token.id == 55) {
                            list.add(null);
                            fEmpty = true;
                        } else {
                            list.add(this.parseExpression(block));
                            fInit = false;
                        }
                        tokLast = this.match(55);
                    } while (this.peek(54) != null);
                    Expression[] aexpr = list.toArray(new Expression[list.size()]);
                    ArrayExpression value = null;
                    if (fInit || this.token.id == 52) {
                        value = this.parseArrayInitializer(block);
                        tokLast = value.getEndToken();
                    }
                    expr = new NewArrayExpression(block, tokFirst, tokLast, type, aexpr, value);
                    break;
                }
                Token tokLParen = this.match(50);
                Expression[] aexpr = this.parseParameters(block);
                Token tokRParen = this.match(51);
                expr = this.parseNarrowingExpression(block, new NewClassExpression(block, tokFirst, type, tokLParen, aexpr, tokRParen));
                break;
            }
            case 42: {
                expr = this.parseNarrowingExpression(block, new ThisExpression(block, this.current()));
                break;
            }
            case 39: {
                expr = this.parseNarrowingExpression(block, new SuperExpression(block, this.current()));
                break;
            }
            case 105: {
                expr = this.parseNarrowingExpression(block, new NameExpression(block, this.current()));
                break;
            }
            case 96: {
                expr = new NullExpression(block, this.current());
                break;
            }
            case 97: 
            case 98: {
                expr = new BooleanExpression(block, this.current());
                break;
            }
            case 99: {
                expr = new CharExpression(block, this.current());
                break;
            }
            case 100: {
                LiteralToken literal = (LiteralToken)this.current();
                if (literal.isOutOfRange()) {
                    this.logError(3, "JC-027", null, literal);
                }
                expr = new IntExpression(block, literal);
                break;
            }
            case 101: {
                LiteralToken literal = (LiteralToken)this.current();
                if (literal.isOutOfRange()) {
                    this.logError(3, "JC-027", null, literal);
                }
                expr = new LongExpression(block, literal);
                break;
            }
            case 102: {
                expr = new FloatExpression(block, this.current());
                break;
            }
            case 103: {
                expr = new DoubleExpression(block, this.current());
                break;
            }
            case 104: {
                expr = this.parseNarrowingExpression(block, new StringExpression(block, this.current()));
                break;
            }
            default: {
                if (this.token.getCategory() == 2) {
                    this.logError(3, "JC-075", new String[]{this.token.getText()}, this.token.getLine(), this.token.getOffset(), 0);
                } else {
                    this.logError(3, "JC-074", null, this.token.getLine(), this.token.getOffset(), 0);
                }
                throw new SyntaxException();
            }
        }
        block39: while (true) {
            switch (this.token.id) {
                case 92: {
                    expr = new PostIncExpression(this.current(), expr);
                    continue block39;
                }
                case 93: {
                    expr = new PostDecExpression(this.current(), expr);
                    continue block39;
                }
            }
            break;
        }
        return expr;
    }

    protected Expression parseNarrowingExpression(Block block, Expression expr) throws CompilerException {
        block5: while (true) {
            switch (this.token.id) {
                case 58: {
                    Token tokDot = this.current();
                    if (this.token.id == 9) {
                        expr = new ClassExpression(tokDot, this.toTypeExpression(expr), this.current());
                        continue block5;
                    }
                    Token tokName = this.match(105);
                    if (expr instanceof NameExpression) {
                        ((NameExpression)expr).addName(tokName);
                        continue block5;
                    }
                    expr = new FieldAccessExpression(tokDot, expr, tokName);
                    continue block5;
                }
                case 50: {
                    Expression exprQual;
                    Token tokName;
                    if (expr instanceof FieldAccessExpression) {
                        exprQual = ((FieldAccessExpression)expr).getExpression();
                        tokName = expr.getEndToken();
                    } else if (expr instanceof NameExpression) {
                        NameExpression exprName = (NameExpression)expr;
                        if (exprName.isQualified()) {
                            exprQual = exprName;
                        } else {
                            Token tokFirst = exprName.getStartToken();
                            Token tokThis = new Token(Token.TOK_THIS, tokFirst.getLine(), tokFirst.getOffset(), 0);
                            exprQual = new ThisExpression(block, tokThis);
                        }
                        tokName = exprName.removeName();
                    } else {
                        expr.logError(3, "JC-031", null, this.errlist);
                        throw new SyntaxException();
                    }
                    expr = new InvocationExpression(exprQual, tokName, this.current(), this.parseParameters(block), this.match(51));
                    continue block5;
                }
                case 54: {
                    Token tokFirst = this.current();
                    if (this.token.id == 55) {
                        TypeExpression type = this.toTypeExpression(expr);
                        type = new DimensionedExpression(type, this.match(55));
                        type = this.parseDimensionedExpression(expr.getBlock(), type);
                        expr = type;
                        continue block5;
                    }
                    expr = new ArrayAccessExpression(tokFirst, expr, this.parseExpression(block), this.match(55));
                    continue block5;
                }
            }
            break;
        }
        return expr;
    }

    protected ArrayExpression parseArrayInitializer(Block block) throws CompilerException {
        Token tokFirst = this.match(52);
        Expression[] aexpr = NO_EXPRESSIONS;
        if (this.token.id != 53 && this.peek(57) == null) {
            ArrayList<ArrayExpression> list = new ArrayList<ArrayExpression>();
            boolean fMore = true;
            do {
                Expression expr = null;
                expr = this.token.id == 52 ? this.parseArrayInitializer(block) : this.parseExpression(block);
                list.add((ArrayExpression)expr);
            } while (this.peek(57) != null && this.token.id != 53);
            aexpr = list.toArray(new Expression[list.size()]);
        }
        Token tokLast = this.match(53);
        return new ArrayExpression(block, tokFirst, tokLast, aexpr);
    }

    protected Expression[] parseParameters(Block block) throws CompilerException {
        Expression[] aexpr = NO_EXPRESSIONS;
        if (this.token.id != 51) {
            ArrayList<Expression> list = new ArrayList<Expression>();
            do {
                list.add(this.parseExpression(block));
            } while (this.peek(57) != null);
            aexpr = list.toArray(new Expression[list.size()]);
        }
        return aexpr;
    }

    protected TypeExpression parseDimensionedExpression(Block block, TypeExpression expr) throws CompilerException {
        while (this.peek(54) != null) {
            expr = new DimensionedExpression(expr, this.match(55));
        }
        return expr;
    }

    protected TypeExpression toTypeExpression(Expression expr) throws CompilerException {
        if (expr instanceof TypeExpression) {
            return (TypeExpression)expr;
        }
        if (expr instanceof NameExpression) {
            return new TypeExpression((NameExpression)expr);
        }
        expr.logError(3, "JC-032", null, this.errlist);
        throw new SyntaxException();
    }

    protected Token current() throws CompilerException {
        Token current = this.token;
        this.next();
        return current;
    }

    protected Token next() throws CompilerException {
        Tokenizer toker = this.toker;
        if (toker.hasMoreTokens()) {
            this.token = (Token)toker.nextToken();
            return this.token;
        }
        if (this.token != null && this.token.id == 53 && this.token.length == 0) {
            this.logError(3, "JC-029", null, this.token);
            throw new CompilerException();
        }
        int iLine = 0;
        int of = 0;
        if (this.token != null) {
            iLine = this.token.getLine();
            of = this.token.getOffset() + this.token.getLength();
        }
        this.token = new Token(Token.TOK_RCURLYBRACE, iLine, of, 0);
        return this.token;
    }

    protected Token match(int id) throws CompilerException {
        if (this.token.id != id) {
            this.logError(3, "JC-017", new String[]{Token.DESC[id]}, this.token.getLine(), this.token.getOffset(), 0);
            throw new SyntaxException();
        }
        return this.current();
    }

    protected Token peek(int id) throws CompilerException {
        return this.token.id == id ? this.current() : null;
    }

    protected Token peek(int cat, int subcat) throws CompilerException {
        Token token = this.token;
        return token.cat == cat && token.subcat == subcat ? this.current() : null;
    }

    protected void checkImports(Context ctx) throws CompilerException {
        DataType DEFAULT = DataType.OBJECT;
        HashMap tblNames = this.tblImports;
        HashMap<String, DataType> tblTypes = new HashMap<String, DataType>();
        Iterator iter = tblNames.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Token tokName = (Token)entry.getKey();
            String sFull = (String)entry.getValue();
            String sName = tokName.getText();
            TypeInfo type = ctx.getTypeInfo(sFull);
            DataType dt = DEFAULT;
            if (type == null) {
                this.logError(3, "JC-030", new String[]{sFull}, tokName);
            } else {
                dt = type.getDataType();
            }
            if (tblTypes.containsKey(sName)) {
                this.logError(3, "JC-054", new String[]{sName}, tokName);
            }
            tblTypes.put(sName, dt);
            ctx.addImport(sName, dt);
        }
        this.tblImports = tblTypes;
    }

    protected void logError(int nSeverity, String sCode, String[] asParams, Token token) throws CompilerException {
        this.logError(nSeverity, sCode, asParams, token.getLine(), token.getOffset(), token.getLength());
    }

    protected void logError(int nSeverity, String sCode, String[] asParams, int iLine, int ofInLine, int cchError) throws CompilerException {
        if (this.errlist != null) {
            try {
                this.errlist.add(new CompilerErrorInfo(nSeverity, sCode, RESOURCES, asParams, iLine, ofInLine, cchError));
            }
            catch (ErrorList.OverflowException e) {
                throw new CompilerException();
            }
        }
    }

    public static void printMethodInfo(MethodInfo method) {
        StringBuffer sb = new StringBuffer();
        if (method.isPublic()) {
            sb.append("public ");
        }
        if (method.isProtected()) {
            sb.append("protected ");
        }
        if (method.isPackage()) {
            sb.append("package ");
        }
        if (method.isPrivate()) {
            sb.append("private ");
        }
        if (method.isAbstract()) {
            sb.append("abstract ");
        }
        if (method.isStatic()) {
            sb.append("static ");
        }
        if (method.isFinal()) {
            sb.append("final ");
        }
        if (method.isAccessible()) {
            sb.append("[accessible] ");
        }
        sb.append(method.getDataType()).append(' ').append(method.getName()).append('(');
        int c = method.getParamCount();
        for (int i = 0; i < c; ++i) {
            ParamInfo param = method.getParamInfo(i);
            if (i > 0) {
                sb.append(", ");
            }
            if (param.isFinal()) {
                sb.append("final ");
            }
            sb.append(param.getDataType()).append(' ').append(param.getName());
        }
        sb.append(')');
        Compiler.out(sb.toString());
    }
}

