/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Goto;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.BranchStatement;
import com.tangosol.dev.compiler.java.DoStatement;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.ForStatement;
import com.tangosol.dev.compiler.java.LabelStatement;
import com.tangosol.dev.compiler.java.Statement;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.WhileStatement;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class ContinueStatement
extends BranchStatement {
    private static final String CLASS = "ContinueStatement";

    public ContinueStatement(Statement stmt, Token tokFirst, Token tokLabel) {
        super(stmt, tokFirst, tokLabel);
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Statement stmt;
        String sName = this.getLabelName();
        if (sName == null) {
            for (stmt = this.getOuterStatement(); !(stmt == null || stmt instanceof WhileStatement || stmt instanceof DoStatement || stmt instanceof ForStatement); stmt = stmt.getOuterStatement()) {
            }
            if (stmt == null) {
                this.logError(3, "JC-004", null, errlist);
            }
        } else {
            while (!(stmt == null || stmt instanceof LabelStatement && sName.equals(((LabelStatement)stmt).getName()))) {
                stmt = stmt.getOuterStatement();
            }
            if (stmt == null) {
                this.getLabelToken().logError(3, "JC-002", new String[]{sName}, errlist);
            } else if (!((stmt = stmt.getInnerStatement()) instanceof WhileStatement || stmt instanceof DoStatement || stmt instanceof ForStatement)) {
                this.logError(3, "JC-004", null, errlist);
                stmt = null;
            }
        }
        if (stmt != null) {
            stmt.getContinuationLabel();
            if (!setUVars.isEmpty()) {
                stmt.addContinueUVars(setUVars);
            }
            if (!setFVars.isEmpty()) {
                stmt.addContinueFVars(setFVars);
            }
            this.setTargetStatement(stmt);
        }
        setUVars.clear();
        setFVars.clear();
        return this;
    }

    protected boolean compileImpl(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        this.compileFinallyClauses(code);
        code.add(new Goto(this.getTargetStatement().getContinuationLabel()));
        return false;
    }
}

