/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Avar;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Dvar;
import com.tangosol.dev.assembler.Fvar;
import com.tangosol.dev.assembler.Ivar;
import com.tangosol.dev.assembler.Lvar;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.OpDeclare;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.ArrayExpression;
import com.tangosol.dev.compiler.java.AssignExpression;
import com.tangosol.dev.compiler.java.Block;
import com.tangosol.dev.compiler.java.DimensionedExpression;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.ExpressionStatement;
import com.tangosol.dev.compiler.java.NameExpression;
import com.tangosol.dev.compiler.java.Statement;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.TypeExpression;
import com.tangosol.dev.compiler.java.Variable;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class DeclarationStatement
extends Statement {
    private static final String CLASS = "DeclarationStatement";
    private boolean fParam;
    private Token tokMod;
    private TypeExpression exprType;
    private static final Variable[] NO_VARS = new Variable[0];
    private Variable[] avar = NO_VARS;

    public DeclarationStatement(Statement stmt, Token token) {
        super(stmt, token);
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        TypeExpression exprType = this.exprType;
        this.exprType = exprType = (TypeExpression)exprType.precompile(ctx, null, null, null, errlist);
        Block block = this.getBlock();
        if (block != this.getOuterStatement()) {
            this.logError(3, "JC-014", null, errlist);
        }
        DataType dtStmt = exprType.getType();
        boolean fFinal = this.isFinal();
        boolean fParam = this.isParameter();
        ArrayList<Variable> listVars = new ArrayList<Variable>();
        Iterator iter = this.getDeclarators();
        while (iter.hasNext()) {
            ExpressionStatement stmtDeclarator = (ExpressionStatement)iter.next();
            AssignExpression exprAssignment = null;
            Expression exprDeclarator = stmtDeclarator.getExpression();
            Expression exprInitializer = null;
            DataType dtDeclarator = dtStmt;
            if (exprDeclarator instanceof AssignExpression) {
                exprAssignment = (AssignExpression)exprDeclarator;
                exprDeclarator = exprAssignment.getLeftExpression();
                exprInitializer = exprAssignment.getRightExpression();
            }
            boolean fDimensioned = false;
            while (exprDeclarator instanceof DimensionedExpression) {
                dtDeclarator = dtDeclarator.getArrayType();
                exprDeclarator = ((DimensionedExpression)exprDeclarator).getTypeExpression();
                fDimensioned = true;
            }
            if (fDimensioned && exprDeclarator instanceof TypeExpression && (exprType = (TypeExpression)exprDeclarator).getNameExpression() != null) {
                exprDeclarator = exprType.getNameExpression();
            }
            if (!(exprDeclarator instanceof NameExpression)) {
                exprDeclarator.logError(3, "JC-015", null, errlist);
                continue;
            }
            NameExpression exprName = (NameExpression)exprDeclarator;
            if (exprName.isQualified()) {
                exprDeclarator.logError(3, "JC-015", null, errlist);
                continue;
            }
            String sName = exprName.getName();
            Variable var = new Variable(block, sName, dtDeclarator, fParam, fFinal);
            if (!block.registerVariable(var)) {
                this.logError(3, "JC-009", new String[]{var.getName()}, errlist);
            }
            if (fParam) {
                if (fFinal) {
                    setFVars.add(var);
                }
            } else {
                setUVars.add(var);
            }
            if (exprAssignment != null) {
                Expression exprValue;
                exprAssignment.setLeftExpression(exprName);
                if (dtDeclarator.isArray() && exprInitializer instanceof ArrayExpression) {
                    ((ArrayExpression)exprInitializer).setType(dtDeclarator);
                }
                stmtDeclarator.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
                if (fFinal && (exprValue = ((AssignExpression)stmtDeclarator.getExpression()).getRightExpression()).isConstant()) {
                    var.setValue(exprValue.getValue());
                }
            }
            listVars.add(var);
        }
        this.avar = listVars.toArray(NO_VARS);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean compileImpl(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Iterator iterDecl = this.getDeclarators();
        Iterator iterVars = this.getVariables();
        while (iterDecl.hasNext()) {
            void var11_11;
            ExpressionStatement stmt = (ExpressionStatement)iterDecl.next();
            Variable var = (Variable)iterVars.next();
            String sName = var.getName();
            DataType dt = var.getType();
            switch (dt.getTypeString().charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    OpDeclare op = new Ivar(sName, dt.getJVMSignature());
                    break;
                }
                case 'J': {
                    OpDeclare op = new Lvar(sName);
                    break;
                }
                case 'F': {
                    OpDeclare op = new Fvar(sName);
                    break;
                }
                case 'D': {
                    OpDeclare op = new Dvar(sName);
                    break;
                }
                case 'L': 
                case 'R': 
                case '[': {
                    OpDeclare op = new Avar(sName, dt.getJVMSignature());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            code.add((Op)var11_11);
            var.setOp((OpDeclare)var11_11);
            if (!(stmt.getExpression() instanceof AssignExpression)) continue;
            stmt.compile(ctx, code, fReached, errlist);
        }
        return fReached;
    }

    public boolean isParameter() {
        return this.fParam;
    }

    protected void setParameter(boolean fParam) {
        this.fParam = fParam;
    }

    public boolean isFinal() {
        return this.tokMod != null;
    }

    public Token getModifier() {
        return this.tokMod;
    }

    protected void setModifier(Token tokMod) {
        this.tokMod = tokMod;
    }

    public TypeExpression getTypeExpression() {
        return this.exprType;
    }

    protected void setTypeExpression(TypeExpression exprType) {
        this.exprType = exprType;
    }

    public boolean isSingleDeclaration() {
        return this.getInnerStatement().getNextStatement() == null;
    }

    public boolean isAssignmentDeclaration() {
        for (ExpressionStatement stmt = (ExpressionStatement)this.getInnerStatement(); stmt != null; stmt = (ExpressionStatement)stmt.getNextStatement()) {
            if (!(stmt.getExpression() instanceof AssignExpression)) continue;
            return true;
        }
        return false;
    }

    protected Iterator getDeclarators() {
        return new Iterator(){
            private Statement stmt;
            {
                this.stmt = DeclarationStatement.this.getInnerStatement();
            }

            public boolean hasNext() {
                return this.stmt != null;
            }

            public Object next() {
                Statement stmtRet = this.stmt;
                if (stmtRet == null) {
                    throw new NoSuchElementException();
                }
                this.stmt = stmtRet.getNextStatement();
                return stmtRet;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator getVariables() {
        return new Iterator(){
            private int i = 0;

            public boolean hasNext() {
                return this.i < DeclarationStatement.this.avar.length;
            }

            public Object next() {
                try {
                    return DeclarationStatement.this.avar[this.i++];
                }
                catch (RuntimeException e) {
                    throw new NoSuchElementException();
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected Variable getVariable() {
        return this.avar[0];
    }

    public void print(String sIndent) {
        Statement inner;
        DeclarationStatement.out(sIndent + this.toString() + " (" + (this.tokMod != null ? this.tokMod.text + " " : "") + (this.fParam ? "parameter" : "local") + ")");
        if (this.exprType != null) {
            DeclarationStatement.out(sIndent + "  Type:");
            this.exprType.print(sIndent + "    ");
        }
        if ((inner = this.getInnerStatement()) != null) {
            DeclarationStatement.out(sIndent + "  Declarations:");
            inner.printList(sIndent + "    ");
        }
    }
}

