/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Ddiv;
import com.tangosol.dev.assembler.Fdiv;
import com.tangosol.dev.assembler.Idiv;
import com.tangosol.dev.assembler.Ldiv;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.MultiplicativeExpression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.util.ErrorList;

public class DivideExpression
extends MultiplicativeExpression {
    private static final String CLASS = "DivideExpression";

    public DivideExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        if (!ctx.isDebug() && this.isConstant()) {
            if (this.getType().isIntegral() && ((Number)this.getRightExpression().getValue()).longValue() == 0L) {
                this.notValidDivisor(errlist);
            } else {
                return super.compile(ctx, code, fReached, errlist);
            }
        }
        this.getLeftExpression().compile(ctx, code, fReached, errlist);
        this.getRightExpression().compile(ctx, code, fReached, errlist);
        switch (this.getType().getTypeString().charAt(0)) {
            case 'I': {
                code.add(new Idiv());
                break;
            }
            case 'J': {
                code.add(new Ldiv());
                break;
            }
            case 'F': {
                code.add(new Fdiv());
                break;
            }
            case 'D': {
                code.add(new Ddiv());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return fReached;
    }

    public Object getValue() {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        Number nbrLeft = (Number)left.getValue();
        Number nbrRight = (Number)right.getValue();
        switch (left.getType().getTypeString().charAt(0)) {
            case 'I': {
                return DivideExpression.makeInteger(nbrLeft.intValue() / nbrRight.intValue());
            }
            case 'J': {
                return DivideExpression.makeLong(nbrLeft.longValue() / nbrRight.longValue());
            }
            case 'F': {
                return new Float(nbrLeft.floatValue() / nbrRight.floatValue());
            }
            case 'D': {
                return new Double(nbrLeft.doubleValue() / nbrRight.doubleValue());
            }
        }
        throw new IllegalStateException();
    }
}

