/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Goto;
import com.tangosol.dev.assembler.Ifne;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.BooleanExpression;
import com.tangosol.dev.compiler.java.ConditionalStatement;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Statement;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.Variable;
import com.tangosol.util.ErrorList;
import com.tangosol.util.NullImplementation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class DoStatement
extends ConditionalStatement {
    private static final String CLASS = "DoStatement";

    public DoStatement(Statement stmt, Token token) {
        super(stmt, token);
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        HashSet setFInitAssigned = NullImplementation.getSet();
        if (!setFVars.isEmpty()) {
            setFInitAssigned = new HashSet(setFVars);
        }
        this.getInnerStatement().precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        setUVars.addAll(this.getContinueUVars());
        setFVars.addAll(this.getContinueFVars());
        Expression exprTest = this.precompileTest(ctx, setUVars, setFVars, mapThrown, errlist);
        setUVars.getTrueSet().clear();
        setUVars.merge();
        setUVars.addAll(this.getBreakUVars());
        setFVars.getTrueSet().clear();
        setFVars.merge();
        setFVars.addAll(this.getBreakFVars());
        this.getStartLabel();
        this.getContinuationLabel();
        this.getEndLabel();
        if (!(setFVars.equals(setFInitAssigned) || exprTest.isConstant() && !((Boolean)exprTest.getValue()).booleanValue())) {
            Iterator iter = setFVars.iterator();
            while (iter.hasNext()) {
                Variable var = (Variable)iter.next();
                if (setFInitAssigned.contains(var)) continue;
                this.logError(3, "JC-034", new String[]{var.getName()}, errlist);
            }
        }
        return this;
    }

    protected boolean compileImpl(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Label lblStart = this.getStartLabel();
        Statement stmt = this.getInnerStatement();
        Label lblTest = this.getContinuationLabel();
        Expression exprTest = this.getTest();
        boolean fCompletes = stmt.compile(ctx, code, fReached, errlist);
        code.add(lblTest);
        if (exprTest instanceof BooleanExpression || !ctx.isDebug() && exprTest.isConstant()) {
            if (((Boolean)exprTest.getValue()).booleanValue()) {
                code.add(new Goto(lblStart));
                fCompletes = false;
            }
        } else {
            exprTest.compile(ctx, code, fReached, errlist);
            code.add(new Ifne(lblStart));
        }
        return fCompletes;
    }
}

