/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.compiler.CompilerErrorInfo;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.Block;
import com.tangosol.dev.compiler.java.Constants;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.Variable;
import com.tangosol.util.Base;
import com.tangosol.util.ErrorList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Element
extends Base
implements Constants {
    private Block block;
    private Token tokFirst;
    private Token tokLast;

    protected Element(Block block, Token token) {
        this.block = block;
        this.tokFirst = token;
    }

    protected Element(Block block, Token tokFirst, Token tokLast) {
        this.block = block;
        this.tokFirst = tokFirst;
        this.tokLast = tokLast;
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        return this;
    }

    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        return true;
    }

    public Block getBlock() {
        return this.block;
    }

    public Token getStartToken() {
        return this.tokFirst;
    }

    protected void setStartToken(Token tokFirst) {
        this.tokFirst = tokFirst;
    }

    public int getStartLine() {
        return this.getStartToken().getLine();
    }

    public int getStartOffset() {
        return this.getStartToken().getOffset();
    }

    public Token getEndToken() {
        return this.tokLast == null ? this.tokFirst : this.tokLast;
    }

    protected void setEndToken(Token tokLast) {
        this.tokLast = tokLast;
    }

    public int getEndLine() {
        return this.getEndToken().getLine();
    }

    public int getEndOffset() {
        Token token = this.getEndToken();
        return token.getOffset() + token.getLength();
    }

    protected void logError(int nSeverity, String sCode, String[] asParams, ErrorList errlist) throws CompilerException {
        Element.logError(nSeverity, sCode, asParams, errlist, this.getStartLine(), this.getStartOffset(), this.getEndLine(), this.getEndOffset());
    }

    protected static void logError(int nSeverity, String sCode, String[] asParams, ErrorList errlist, int iStart, int ofStart, int iEnd, int ofEnd) throws CompilerException {
        if (errlist != null) {
            try {
                errlist.add(new CompilerErrorInfo(nSeverity, sCode, RESOURCES, asParams, iStart, ofStart, iEnd, ofEnd));
            }
            catch (ErrorList.OverflowException e) {
                throw new CompilerException();
            }
        }
    }

    public void print() {
        Element.out();
    }

    public void print(String sIndent) {
        Element.out(sIndent + this.toString());
    }

    public void printVars(Set set) {
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Variable var = (Variable)iter.next();
            Element.out(var.getType().toString() + " " + var.getName());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        if (this.getStartToken() == null) {
            sb.append("?, ?, ");
        } else {
            sb.append(this.getStartLine()).append(", ").append(this.getStartOffset()).append(", ");
        }
        if (this.getStartToken() == null) {
            sb.append("?, ?");
        } else {
            sb.append(this.getEndLine()).append(", ").append(this.getEndOffset());
        }
        sb.append(") ");
        String sClass = this.getClass().getName();
        int of = sClass.lastIndexOf(46);
        if (of < 0) {
            of = 0;
        }
        sClass = sClass.substring(of + 1, sClass.length());
        sb.append(sClass);
        return sb.toString();
    }
}

