/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.IntConstant;
import com.tangosol.dev.compiler.java.BinaryExpression;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.component.DataType;

public abstract class EqualityExpression
extends BinaryExpression {
    private static final String CLASS = "EqualityExpression";
    protected static final DataType STRING = DataType.STRING;
    protected static final DataType BOOLEAN = DataType.BOOLEAN;
    protected static final IntConstant TRUE = Constants.CONSTANT_ICONST_1;
    protected static final IntConstant FALSE = Constants.CONSTANT_ICONST_0;

    protected EqualityExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    public Object getValue() {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        boolean fVal = EqualityExpression.compareEquality(left.getValue(), right.getValue(), left.getType());
        return fVal ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean compareEquality(Object oLeft, Object oRight, DataType dt) {
        switch (dt.getTypeString().charAt(0)) {
            case 'Z': {
                return ((Boolean)oLeft).booleanValue() == ((Boolean)oRight).booleanValue();
            }
            case 'I': {
                return ((Number)oLeft).intValue() == ((Number)oRight).intValue();
            }
            case 'J': {
                return ((Number)oLeft).longValue() == ((Number)oRight).longValue();
            }
            case 'F': {
                return ((Number)oLeft).floatValue() == ((Number)oRight).floatValue();
            }
            case 'D': {
                return ((Number)oLeft).doubleValue() == ((Number)oRight).doubleValue();
            }
            case 'L': 
            case 'N': 
            case 'R': {
                return oLeft == null ? oRight == null : oLeft.equals(oRight);
            }
            case '[': {
                if (oLeft == null) {
                    return oRight == null;
                }
                Object[] aoLeft = (Object[])oLeft;
                int cLeft = aoLeft.length;
                Object[] aoRight = (Object[])oRight;
                int cRight = aoRight.length;
                if (cLeft != cRight) {
                    return false;
                }
                DataType dtElement = dt.getElementType();
                for (int i = 0; i < cLeft; ++i) {
                    if (EqualityExpression.compareEquality(aoLeft[i], aoRight[i], dtElement)) continue;
                    return false;
                }
                return true;
            }
        }
        throw new IllegalStateException();
    }
}

