/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Aconst;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Dconst;
import com.tangosol.dev.assembler.Fconst;
import com.tangosol.dev.assembler.Iconst;
import com.tangosol.dev.assembler.IntConstant;
import com.tangosol.dev.assembler.Lconst;
import com.tangosol.dev.assembler.MethodConstant;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.MethodInfo;
import com.tangosol.dev.compiler.TypeInfo;
import com.tangosol.dev.compiler.java.Block;
import com.tangosol.dev.compiler.java.CastExpression;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.TypeExpression;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import com.tangosol.util.SortedEnumerator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class Expression
extends Element {
    private static final IntConstant FALSE = Constants.CONSTANT_ICONST_0;
    private static final IntConstant TRUE = Constants.CONSTANT_ICONST_1;
    private static final String STRING = "java/lang/String";
    private static final String TOSTRING = "valueOf";
    private static final MethodConstant BOOLEAN_TOSTRING = new MethodConstant("java/lang/String", "valueOf", "(Z)Ljava/lang/String;");
    private static final MethodConstant CHAR_TOSTRING = new MethodConstant("java/lang/String", "valueOf", "(C)Ljava/lang/String;");
    private static final MethodConstant INT_TOSTRING = new MethodConstant("java/lang/String", "valueOf", "(I)Ljava/lang/String;");
    private static final MethodConstant LONG_TOSTRING = new MethodConstant("java/lang/String", "valueOf", "(J)Ljava/lang/String;");
    private static final MethodConstant FLOAT_TOSTRING = new MethodConstant("java/lang/String", "valueOf", "(F)Ljava/lang/String;");
    private static final MethodConstant DOUBLE_TOSTRING = new MethodConstant("java/lang/String", "valueOf", "(D)Ljava/lang/String;");
    private static final MethodConstant OBJECT_TOSTRING = new MethodConstant("java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
    private static final String STRINGBUFFER = "java/lang/StringBuffer";
    private static final String APPEND = "append";
    private static final MethodConstant BOOLEAN_APPEND = new MethodConstant("java/lang/StringBuffer", "append", "(Z)Ljava/lang/StringBuffer;");
    private static final MethodConstant CHAR_APPEND = new MethodConstant("java/lang/StringBuffer", "append", "(C)Ljava/lang/StringBuffer;");
    private static final MethodConstant INT_APPEND = new MethodConstant("java/lang/StringBuffer", "append", "(I)Ljava/lang/StringBuffer;");
    private static final MethodConstant LONG_APPEND = new MethodConstant("java/lang/StringBuffer", "append", "(J)Ljava/lang/StringBuffer;");
    private static final MethodConstant FLOAT_APPEND = new MethodConstant("java/lang/StringBuffer", "append", "(F)Ljava/lang/StringBuffer;");
    private static final MethodConstant DOUBLE_APPEND = new MethodConstant("java/lang/StringBuffer", "append", "(D)Ljava/lang/StringBuffer;");
    private static final MethodConstant STRING_APPEND = new MethodConstant("java/lang/StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
    private static final MethodConstant OBJECT_APPEND = new MethodConstant("java/lang/StringBuffer", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuffer;");
    private static final String CLASS = "Expression";
    private static final DataType UNKNOWN = DataType.UNKNOWN;
    private static final DataType VOID = DataType.VOID;
    private static final DataType BOOLEAN = DataType.BOOLEAN;
    private static final DataType BYTE = DataType.BYTE;
    private static final DataType CHAR = DataType.CHAR;
    private static final DataType SHORT = DataType.SHORT;
    private static final DataType INT = DataType.INT;
    private static final DataType LONG = DataType.LONG;
    private static final DataType FLOAT = DataType.FLOAT;
    private static final DataType DOUBLE = DataType.DOUBLE;
    private static final DataType NULL = DataType.NULL;
    private static final DataType OBJECT = DataType.OBJECT;
    private static final DataType CLONEABLE = DataType.CLONEABLE;
    private DataType dt = UNKNOWN;
    private boolean fDiscard;

    protected Expression(Block block, Token tokFirst) {
        super(block, tokFirst);
    }

    protected Expression(Block block, Token tokFirst, Token tokLast) {
        super(block, tokFirst, tokLast);
    }

    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Op op;
        block12: {
            Object oVal;
            DataType dt;
            block11: {
                dt = this.getType();
                oVal = this.getValue();
                op = null;
                if (!dt.isPrimitive()) break block11;
                switch (dt.getTypeString().charAt(0)) {
                    case 'Z': {
                        op = new Iconst((Boolean)oVal != false ? TRUE : FALSE);
                        break block12;
                    }
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': {
                        op = new Iconst(((Number)oVal).intValue());
                        break block12;
                    }
                    case 'J': {
                        op = new Lconst((Long)oVal);
                        break block12;
                    }
                    case 'F': {
                        op = new Fconst(((Float)oVal).floatValue());
                        break block12;
                    }
                    case 'D': {
                        op = new Dconst((Double)oVal);
                        break block12;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (dt.isReference() && oVal == null) {
                op = new Aconst();
            } else if (dt == DataType.STRING) {
                op = new Aconst((String)oVal);
            } else {
                throw new IllegalStateException();
            }
        }
        code.add(op);
        return fReached;
    }

    public DataType getType() {
        return this.dt;
    }

    protected void setType(DataType dt) {
        this.dt = dt;
    }

    public void setDiscarded(boolean fDiscard) {
        this.fDiscard = fDiscard;
    }

    public boolean isDiscarded() {
        return this.fDiscard;
    }

    public boolean isConstant() {
        return false;
    }

    public Object getValue() {
        throw new IllegalStateException();
    }

    protected static boolean isCastable(Context ctx, DataType dtThis, DataType dtThat, ErrorList errlist) throws CompilerException {
        if (dtThis == dtThat) {
            return true;
        }
        if (dtThis.isPrimitive()) {
            if (dtThis.isNumeric() && dtThat.isNumeric()) {
                return true;
            }
        } else if (dtThis == NULL) {
            if (dtThat.isReference()) {
                return true;
            }
        } else if (dtThis != VOID) {
            TypeInfo infoThat;
            if (Expression.isAssignable(ctx, dtThis, dtThat, errlist)) {
                return true;
            }
            while (dtThis.isArray() && dtThat.isArray()) {
                dtThis = dtThis.getElementType();
                dtThat = dtThat.getElementType();
            }
            if (dtThis.isArray() || !dtThis.isReference() || !dtThat.isReference()) {
                return false;
            }
            if (dtThis == DataType.OBJECT) {
                return true;
            }
            if (dtThat.isArray()) {
                return false;
            }
            TypeInfo infoThis = ctx.getTypeInfo(dtThis);
            if (infoThis == null || infoThat == null) {
                return false;
            }
            if (infoThis.isInterface()) {
                if (infoThat.isInterface()) {
                    if (infoThat.isInterface(infoThis.getDataType())) {
                        return true;
                    }
                    SortedEnumerator enmrThisMethods = new SortedEnumerator(infoThis.methodNames());
                    SortedEnumerator enmrThatMethods = new SortedEnumerator(infoThat.methodNames());
                    if (!enmrThisMethods.hasMoreElements() || !enmrThatMethods.hasMoreElements()) {
                        return true;
                    }
                    String sThisMethod = (String)enmrThisMethods.nextElement();
                    String sThatMethod = (String)enmrThatMethods.nextElement();
                    while (true) {
                        int nCmp;
                        if ((nCmp = sThisMethod.compareTo(sThatMethod)) == 0) {
                            Enumeration enmrParams = infoThis.paramTypes(sThisMethod, -1);
                            while (enmrParams.hasMoreElements()) {
                                MethodInfo methodThis;
                                DataType[] adtParams = (DataType[])enmrParams.nextElement();
                                MethodInfo methodThat = infoThat.getMethodInfo(sThisMethod, adtParams);
                                if (methodThat == null || (methodThis = infoThis.getMethodInfo(sThisMethod, adtParams)).getDataType() == methodThat.getDataType()) continue;
                                return false;
                            }
                            if (!enmrThisMethods.hasMoreElements() || !enmrThatMethods.hasMoreElements()) {
                                return true;
                            }
                            sThisMethod = (String)enmrThisMethods.nextElement();
                            sThatMethod = (String)enmrThatMethods.nextElement();
                            continue;
                        }
                        if (nCmp < 0) {
                            if (!enmrThisMethods.hasMoreElements()) {
                                return true;
                            }
                            sThisMethod = (String)enmrThisMethods.nextElement();
                            continue;
                        }
                        if (!enmrThatMethods.hasMoreElements()) {
                            return true;
                        }
                        sThatMethod = (String)enmrThatMethods.nextElement();
                    }
                }
                return !infoThat.isFinal() || infoThat.isInterface(infoThis.getDataType());
            }
            if (infoThat.isInterface()) {
                return !infoThis.isFinal();
            }
            for (infoThat = ctx.getTypeInfo(dtThat); infoThat != null; infoThat = infoThat.getSuperInfo()) {
                if (infoThis.getDataType() != infoThat.getDataType()) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isAssignable(Context ctx, DataType dtThis, DataType dtThat, ErrorList errlist) throws CompilerException {
        block31: {
            block30: {
                if (dtThis == dtThat) {
                    return true;
                }
                if (dtThis == UNKNOWN || dtThat == UNKNOWN) {
                    return true;
                }
                if (dtThis == VOID || dtThat == VOID) {
                    return false;
                }
                if (!dtThis.isPrimitive()) break block30;
                switch (dtThis.getTypeString().charAt(0)) {
                    case 'B': {
                        if (dtThat == SHORT) {
                            return true;
                        }
                    }
                    case 'C': 
                    case 'S': {
                        if (dtThat == INT) {
                            return true;
                        }
                    }
                    case 'I': {
                        if (dtThat == LONG) {
                            return true;
                        }
                    }
                    case 'J': {
                        if (dtThat == FLOAT) {
                            return true;
                        }
                    }
                    case 'F': {
                        if (dtThat == DOUBLE) {
                            return true;
                        }
                    }
                    case 'D': {
                        break block31;
                    }
                    case 'Z': {
                        break block31;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (dtThis == NULL) {
                if (dtThat.isReference()) {
                    return true;
                }
            } else {
                while (dtThis.isArray() && dtThat.isArray()) {
                    dtThis = dtThis.getElementType();
                    dtThat = dtThat.getElementType();
                }
                if (dtThis.isArray()) {
                    if (dtThat == OBJECT || dtThat == CLONEABLE) {
                        return true;
                    }
                } else if (!dtThat.isArray()) {
                    if (dtThat == OBJECT) {
                        return true;
                    }
                    TypeInfo infoThis = ctx.getTypeInfo(dtThis);
                    if (infoThis == null) {
                        return false;
                    }
                    if (infoThis.isInterface(dtThat)) {
                        return true;
                    }
                    while (infoThis != null) {
                        if (infoThis.getDataType() == dtThat) {
                            return true;
                        }
                        infoThis = infoThis.getSuperInfo();
                    }
                }
            }
        }
        return false;
    }

    protected static boolean isComparable(Context ctx, DataType dtThis, DataType dtThat, ErrorList errlist) throws CompilerException {
        return Expression.isCastable(ctx, dtThis, dtThat, errlist) || Expression.isCastable(ctx, dtThat, dtThis, errlist);
    }

    protected Expression promoteNumeric() throws CompilerException {
        DataType dt = this.getType();
        switch (dt.getTypeString().charAt(0)) {
            case 'B': 
            case 'C': 
            case 'S': {
                return new CastExpression(this, INT);
            }
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'U': {
                return this;
            }
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    protected Expression promoteNumeric(Expression exprOther) throws CompilerException {
        void var5_5;
        void var4_4;
        DataType dtThis = this.getType();
        DataType dtThat = exprOther.getType();
        switch (dtThis.getTypeString().charAt(0)) {
            case 'B': 
            case 'C': 
            case 'S': {
                int nThis = 0;
                break;
            }
            case 'I': {
                int nThis = 1;
                break;
            }
            case 'J': {
                int nThis = 2;
                break;
            }
            case 'F': {
                int nThis = 3;
                break;
            }
            case 'D': {
                int nThis = 4;
                break;
            }
            case 'U': {
                return this;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (dtThat.getTypeString().charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': {
                int nThat = 1;
                break;
            }
            case 'J': {
                int nThat = 2;
                break;
            }
            case 'F': {
                int nThat = 3;
                break;
            }
            case 'D': {
                int nThat = 4;
                break;
            }
            case 'U': {
                return this;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (var4_4 >= var5_5) {
            return this;
        }
        switch (var5_5) {
            case 1: {
                return new CastExpression(this, INT);
            }
            case 2: {
                return new CastExpression(this, LONG);
            }
            case 3: {
                return new CastExpression(this, FLOAT);
            }
            case 4: {
                return new CastExpression(this, DOUBLE);
            }
        }
        throw new IllegalStateException();
    }

    protected Expression convertAssignable(Context ctx, DataType dtThat) {
        DataType dtThis = this.getType();
        if (dtThis != dtThat && dtThis.isPrimitive() && dtThat.isPrimitive()) {
            return new CastExpression(this, dtThat);
        }
        return this;
    }

    protected boolean checkValue(ErrorList errlist) throws CompilerException {
        boolean fValue;
        boolean bl = fValue = !(this instanceof TypeExpression) && this.getType() != VOID;
        if (!fValue) {
            this.notValue(errlist);
        }
        return fValue;
    }

    protected boolean checkConstant(ErrorList errlist) throws CompilerException {
        if (!this.checkValue(errlist)) {
            return false;
        }
        boolean fConst = this.isConstant();
        if (!fConst && this.getType() != UNKNOWN) {
            this.notConstant(errlist);
        }
        return fConst;
    }

    protected boolean checkNumeric(ErrorList errlist) throws CompilerException {
        if (!this.checkValue(errlist)) {
            return false;
        }
        boolean fNumeric = this.getType().isNumeric();
        if (!fNumeric && this.getType() != UNKNOWN) {
            this.notNumeric(errlist);
        }
        return fNumeric;
    }

    protected boolean checkIntegral(ErrorList errlist) throws CompilerException {
        if (!this.checkValue(errlist)) {
            return false;
        }
        boolean fIntegral = this.getType().isIntegral();
        if (!fIntegral && this.getType() != UNKNOWN) {
            this.notIntegral(errlist);
        }
        return fIntegral;
    }

    protected boolean checkBoolean(ErrorList errlist) throws CompilerException {
        boolean fBoolean;
        if (!this.checkValue(errlist)) {
            return false;
        }
        boolean bl = fBoolean = this.getType() == DataType.BOOLEAN;
        if (!fBoolean && this.getType() != UNKNOWN) {
            this.notBoolean(errlist);
        }
        return fBoolean;
    }

    protected boolean checkReference(ErrorList errlist) throws CompilerException {
        return this.checkReference(true, errlist);
    }

    protected boolean checkReference(boolean fNull, ErrorList errlist) throws CompilerException {
        if (!this.checkValue(errlist)) {
            return false;
        }
        return this.checkReferenceType(fNull, errlist);
    }

    protected boolean checkReferenceType(boolean fNull, ErrorList errlist) throws CompilerException {
        boolean fRef = this.getType().isReference();
        if (!fRef && this.getType() != UNKNOWN) {
            this.notReference(errlist);
        } else if (!fNull && this.getType() == DataType.NULL) {
            this.logError(3, "JC-038", null, errlist);
        }
        return fRef;
    }

    protected boolean checkArray(ErrorList errlist) throws CompilerException {
        if (!this.checkValue(errlist)) {
            return false;
        }
        return this.checkArray(true, errlist);
    }

    protected boolean checkArray(boolean fNull, ErrorList errlist) throws CompilerException {
        if (!this.checkValue(errlist)) {
            return false;
        }
        boolean fArray = this.getType().isArray();
        if (!fArray) {
            if (this.getType() == DataType.NULL) {
                if (fNull) {
                    fArray = true;
                } else {
                    this.logError(3, "JC-038", null, errlist);
                }
            } else if (this.getType() != UNKNOWN) {
                this.notArray(errlist);
            }
        }
        return fArray;
    }

    protected boolean checkCastable(Context ctx, DataType type, ErrorList errlist) throws CompilerException {
        DataType dtThat;
        if (!this.checkValue(errlist)) {
            return false;
        }
        DataType dtThis = this.getType();
        boolean fCastable = Expression.isCastable(ctx, dtThis, dtThat = type, errlist);
        if (!fCastable && dtThis != UNKNOWN) {
            this.notCastable(dtThat, errlist);
        }
        return fCastable;
    }

    protected boolean checkInvocationAssignable(Context ctx, DataType type, ErrorList errlist) throws CompilerException {
        DataType dtThat;
        if (!this.checkValue(errlist)) {
            return false;
        }
        DataType dtThis = this.getType();
        boolean fAssignable = Expression.isAssignable(ctx, dtThis, dtThat = type, errlist);
        if (!fAssignable && dtThis != UNKNOWN) {
            this.notAssignable(dtThat, errlist);
        }
        return fAssignable;
    }

    protected boolean checkAssignable(Context ctx, DataType type, ErrorList errlist) throws CompilerException {
        DataType dtThat;
        if (!this.checkValue(errlist)) {
            return false;
        }
        DataType dtThis = this.getType();
        boolean fAssignable = Expression.isAssignable(ctx, dtThis, dtThat = type, errlist);
        if (!fAssignable) {
            if (dtThis == INT && this.isConstant() && (dtThat == BYTE || dtThat == SHORT || dtThat == CHAR)) {
                int n = ((Number)this.getValue()).intValue();
                if (dtThat == BYTE) {
                    if (n >= -128 && n <= 127) {
                        fAssignable = true;
                    }
                } else if (dtThat == SHORT) {
                    if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
                        fAssignable = true;
                    }
                } else if (n >= 0 && n <= 65535) {
                    fAssignable = true;
                }
            }
            if (!fAssignable && dtThis != UNKNOWN) {
                this.notAssignable(dtThat, errlist);
            }
        }
        return fAssignable;
    }

    protected boolean checkComparable(Context ctx, Expression that, ErrorList errlist) throws CompilerException {
        DataType dtThat;
        if (!this.checkValue(errlist) || !that.checkValue(errlist)) {
            return false;
        }
        DataType dtThis = this.getType();
        boolean fComparable = Expression.isComparable(ctx, dtThis, dtThat = that.getType(), errlist);
        if (!fComparable && dtThis != UNKNOWN) {
            this.notComparable(dtThat, errlist);
        }
        return fComparable;
    }

    protected boolean checkAssignable(ErrorList errlist) throws CompilerException {
        if (this.getType() != UNKNOWN) {
            this.notAssignable(errlist);
        }
        return false;
    }

    protected boolean checkThrownException(Context ctx, DataType dt, Map mapThrown, ErrorList errlist) throws CompilerException {
        if (dt == UNKNOWN) {
            return true;
        }
        TypeInfo info = ctx.getTypeInfo(dt);
        if (info == null) {
            this.notType(dt, errlist);
            return false;
        }
        if (!info.isThrowable()) {
            this.notThrowable(dt, errlist);
            return false;
        }
        if (!Expression.isChecked(ctx, dt)) {
            return true;
        }
        HashSet<Expression> set = (HashSet<Expression>)mapThrown.get(dt);
        if (set == null) {
            set = new HashSet<Expression>();
            mapThrown.put(dt, set);
        }
        set.add(this);
        return true;
    }

    protected boolean checkCaughtException(Context ctx, DataType dt, Map mapThrown, ErrorList errlist) throws CompilerException {
        if (dt == UNKNOWN) {
            return true;
        }
        TypeInfo info = ctx.getTypeInfo(dt);
        if (info == null) {
            this.notType(dt, errlist);
            return false;
        }
        if (!info.isThrowable()) {
            this.notThrowable(dt, errlist);
            return false;
        }
        if (!Expression.isChecked(ctx, dt)) {
            return true;
        }
        boolean fThrown = Expression.catchException(ctx, dt, mapThrown);
        if (!fThrown) {
            this.notCatchable(dt, errlist);
        }
        return fThrown;
    }

    protected static boolean catchException(Context ctx, DataType dt, Map mapThrown) {
        boolean fThrown = false;
        Iterator iter = mapThrown.keySet().iterator();
        block0: while (iter.hasNext()) {
            DataType dtThrown = (DataType)iter.next();
            TypeInfo infoThrown = ctx.getTypeInfo(dtThrown);
            if (infoThrown == null) {
                throw new IllegalStateException("No type info for " + dtThrown);
            }
            do {
                if (dt == dtThrown) {
                    iter.remove();
                    fThrown = true;
                    continue block0;
                }
                infoThrown = infoThrown.getSuperInfo();
                dtThrown = infoThrown.getDataType();
            } while (infoThrown.isThrowable());
        }
        if (!(fThrown || dt != DataType.THROWABLE && dt != DataType.EXCEPTION && Expression.isChecked(ctx, dt))) {
            fThrown = true;
        }
        if (!fThrown) {
            DataType dtCaught = dt;
            TypeInfo infoCaught = ctx.getTypeInfo(dtCaught);
            if (infoCaught == null) {
                throw new IllegalStateException("No type info for " + dtCaught);
            }
            do {
                if (mapThrown.containsKey(dtCaught)) {
                    fThrown = true;
                    break;
                }
                infoCaught = infoCaught.getSuperInfo();
                dtCaught = infoCaught.getDataType();
            } while (infoCaught.isThrowable());
        }
        return fThrown;
    }

    protected static boolean isChecked(Context ctx, DataType dt) {
        DataType THROWABLE = DataType.THROWABLE;
        DataType ERROR = DataType.ERROR;
        DataType RUNTIME = DataType.RUNTIME;
        TypeInfo info = ctx.getTypeInfo(dt);
        while (dt != THROWABLE) {
            if (dt == ERROR || dt == RUNTIME) {
                return false;
            }
            info = info.getSuperInfo();
            dt = info.getDataType();
        }
        return true;
    }

    protected void notValue(ErrorList errlist) throws CompilerException {
        this.logError(3, "JC-061", null, errlist);
    }

    protected void notConstant(ErrorList errlist) throws CompilerException {
        this.logError(3, "JC-039", null, errlist);
    }

    protected void notNumeric(ErrorList errlist) throws CompilerException {
        this.logError(3, "JC-040", null, errlist);
    }

    protected void notIntegral(ErrorList errlist) throws CompilerException {
        this.logError(3, "JC-041", null, errlist);
    }

    protected void notValidIntegral(ErrorList errlist) throws CompilerException {
        this.logError(3, "JC-042", null, errlist);
    }

    protected void notValidDivisor(ErrorList errlist) throws CompilerException {
        this.logError(3, "JC-043", null, errlist);
    }

    protected void notBoolean(ErrorList errlist) throws CompilerException {
        this.logError(3, "JC-044", null, errlist);
    }

    protected void notReference(ErrorList errlist) throws CompilerException {
        this.logError(3, "JC-045", null, errlist);
    }

    protected void notArray(ErrorList errlist) throws CompilerException {
        this.logError(3, "JC-052", null, errlist);
    }

    protected void notCastable(DataType type, ErrorList errlist) throws CompilerException {
        this.logError(3, "JC-046", new String[]{this.getType().toString(), type.toString()}, errlist);
    }

    protected void notComparable(DataType type, ErrorList errlist) throws CompilerException {
        this.logError(3, "JC-047", new String[]{this.getType().toString(), type.toString()}, errlist);
    }

    protected void notAssignable(ErrorList errlist) throws CompilerException {
        this.logError(3, "JC-049", null, errlist);
    }

    protected void notAssignable(DataType type, ErrorList errlist) throws CompilerException {
        this.logError(3, "JC-048", new String[]{this.getType().toString(), type.toString()}, errlist);
    }

    protected void notReached(ErrorList errlist) throws CompilerException {
    }

    protected void notThrowable(DataType type, ErrorList errlist) throws CompilerException {
        this.logError(3, "JC-071", new String[]{type.toString()}, errlist);
    }

    protected void notCatchable(DataType type, ErrorList errlist) throws CompilerException {
        this.logError(3, "JC-072", new String[]{type.toString()}, errlist);
    }

    protected void notType(DataType type, ErrorList errlist) throws CompilerException {
        String sFull = type.toString();
        int ofDot = sFull.lastIndexOf(46);
        String sPkg = ofDot < 0 ? "" : sFull.substring(0, ofDot);
        String sName = ofDot < 0 ? sFull : sFull.substring(ofDot + 1);
        this.logError(3, "JC-055", new String[]{sName, sPkg}, errlist);
    }

    protected MethodConstant getConvertMethod() {
        switch (this.getType().getTypeString().charAt(0)) {
            case 'Z': {
                return BOOLEAN_TOSTRING;
            }
            case 'C': {
                return CHAR_TOSTRING;
            }
            case 'B': 
            case 'I': 
            case 'S': {
                return INT_TOSTRING;
            }
            case 'J': {
                return LONG_TOSTRING;
            }
            case 'F': {
                return FLOAT_TOSTRING;
            }
            case 'D': {
                return DOUBLE_TOSTRING;
            }
            case 'L': 
            case 'N': 
            case 'R': 
            case '[': {
                return OBJECT_TOSTRING;
            }
        }
        throw new IllegalStateException();
    }

    protected MethodConstant getAppendMethod() {
        switch (this.getType().getTypeString().charAt(0)) {
            case 'Z': {
                return BOOLEAN_APPEND;
            }
            case 'C': {
                return CHAR_APPEND;
            }
            case 'B': 
            case 'I': 
            case 'S': {
                return INT_APPEND;
            }
            case 'J': {
                return LONG_APPEND;
            }
            case 'F': {
                return FLOAT_APPEND;
            }
            case 'D': {
                return DOUBLE_APPEND;
            }
            case 'L': 
            case 'N': 
            case 'R': 
            case '[': {
                return this.getType() == DataType.STRING ? STRING_APPEND : OBJECT_APPEND;
            }
        }
        throw new IllegalStateException();
    }

    public String getStringValue() {
        DataType dt = this.getType();
        Object oVal = this.getValue();
        switch (dt.getTypeString().charAt(0)) {
            case 'Z': {
                return String.valueOf((Boolean)oVal);
            }
            case 'C': {
                return String.valueOf((char)((Number)oVal).intValue());
            }
            case 'B': 
            case 'I': 
            case 'S': {
                return String.valueOf(((Number)oVal).intValue());
            }
            case 'J': {
                return String.valueOf(((Number)oVal).longValue());
            }
            case 'F': {
                return String.valueOf(((Number)oVal).floatValue());
            }
            case 'D': {
                return String.valueOf(((Number)oVal).doubleValue());
            }
            case 'L': 
            case 'N': 
            case 'R': 
            case '[': {
                return String.valueOf(oVal);
            }
        }
        throw new IllegalStateException();
    }
}

