/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Begin;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.End;
import com.tangosol.dev.assembler.Goto;
import com.tangosol.dev.assembler.Ifne;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.Block;
import com.tangosol.dev.compiler.java.BooleanExpression;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Statement;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.Variable;
import com.tangosol.util.ErrorList;
import com.tangosol.util.NullImplementation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ForStatement
extends Block {
    private static final String CLASS = "ForStatement";
    private Expression test;
    private Statement init;
    private Statement update;

    public ForStatement(Statement stmt, Token token) {
        super(stmt, token);
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression exprTest = this.getTest();
        Statement stmtUpdate = this.getUpdate();
        Statement stmtBody = this.getBody();
        DualSet setUBlockVars = new DualSet(setUVars);
        DualSet setFBlockVars = new DualSet(setFVars);
        for (Statement stmtInit = this.getInit(); stmtInit != null; stmtInit = stmtInit.getNextStatement()) {
            stmtInit.precompile(ctx, setUBlockVars, setFBlockVars, mapThrown, errlist);
        }
        HashSet setFInitAssigned = NullImplementation.getSet();
        if (!setFBlockVars.getAdded().isEmpty()) {
            setFInitAssigned = new HashSet(setFBlockVars.getAdded());
        }
        if (exprTest != null) {
            exprTest = (Expression)exprTest.precompile(ctx, setUBlockVars, setFBlockVars, mapThrown, errlist);
            exprTest.checkBoolean(errlist);
            this.setTest(exprTest);
        }
        DualSet setUTrueVars = new DualSet(setUBlockVars.getTrueSet());
        DualSet setFTrueVars = new DualSet(setFBlockVars.getTrueSet());
        stmtBody.precompile(ctx, setUTrueVars, setFTrueVars, mapThrown, errlist);
        while (stmtUpdate != null) {
            stmtUpdate.precompile(ctx, setUTrueVars, setFTrueVars, mapThrown, errlist);
            stmtUpdate = stmtUpdate.getNextStatement();
        }
        setUTrueVars.addAll(this.getBreakUVars());
        setUTrueVars.resolve();
        setUBlockVars.merge();
        Set setAssigned = setUBlockVars.getRemoved();
        if (!setAssigned.isEmpty()) {
            setUVars.removeAll(setAssigned);
        }
        setFTrueVars.addAll(this.getBreakFVars());
        setFTrueVars.resolve();
        setFBlockVars.merge();
        setAssigned = setFBlockVars.getAdded();
        if (!setAssigned.isEmpty()) {
            setAssigned.retainAll(this.getBlock().getVariables());
            if (!setAssigned.isEmpty()) {
                setFVars.addAll(setAssigned);
            }
            setAssigned.removeAll(setFInitAssigned);
            if (!setAssigned.isEmpty()) {
                Iterator iter = setAssigned.iterator();
                while (iter.hasNext()) {
                    Variable var = (Variable)iter.next();
                    this.logError(3, "JC-034", new String[]{var.getName()}, errlist);
                }
            }
        }
        return this;
    }

    protected boolean compileImpl(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Statement stmtInit = this.getInit();
        Expression exprTest = this.getTest();
        Statement stmtUpdate = this.getUpdate();
        Statement stmtBody = this.getBody();
        boolean fEndless = false;
        if (exprTest == null) {
            fEndless = true;
        } else if (exprTest instanceof BooleanExpression || !ctx.isDebug() && exprTest.isConstant()) {
            if (((Boolean)exprTest.getValue()).booleanValue()) {
                fEndless = true;
            } else {
                if (fReached) {
                    stmtBody.notReached(errlist);
                }
                return fReached;
            }
        }
        code.add(new Begin());
        Label lblAgain = new Label();
        Label lblContinue = this.getContinuationLabel();
        Label lblTest = new Label();
        while (stmtInit != null) {
            stmtInit.compile(ctx, code, fReached, errlist);
            stmtInit = stmtInit.getNextStatement();
        }
        if (!fEndless) {
            code.add(new Goto(lblTest));
        }
        code.add(lblAgain);
        stmtBody.compile(ctx, code, fReached, errlist);
        code.add(lblContinue);
        while (stmtUpdate != null) {
            stmtUpdate.compile(ctx, code, fReached, errlist);
            stmtUpdate = stmtUpdate.getNextStatement();
        }
        code.add(lblTest);
        if (fEndless) {
            code.add(new Goto(lblAgain));
        } else {
            exprTest.compile(ctx, code, fReached, errlist);
            code.add(new Ifne(lblAgain));
        }
        code.add(new End());
        return fReached && !fEndless;
    }

    public Statement getInit() {
        return this.init;
    }

    protected void setInit(Statement init) {
        this.init = init;
    }

    public Expression getTest() {
        return this.test;
    }

    protected void setTest(Expression test) {
        this.test = test;
    }

    public Statement getUpdate() {
        return this.update;
    }

    protected void setUpdate(Statement update) {
        this.update = update;
    }

    public Statement getBody() {
        return this.getInnerStatement();
    }

    public void print(String sIndent) {
        ForStatement.out(sIndent + this.toString());
        ForStatement.out(sIndent + "  Init:");
        if (this.init == null) {
            ForStatement.out(sIndent + "    <null>");
        } else {
            this.init.print(sIndent + "    ");
        }
        ForStatement.out(sIndent + "  Test:");
        if (this.test == null) {
            ForStatement.out(sIndent + "    <null>");
        } else {
            this.test.print(sIndent + "    ");
        }
        ForStatement.out(sIndent + "  Update:");
        if (this.update == null) {
            ForStatement.out(sIndent + "    <null>");
        } else {
            this.update.print(sIndent + "    ");
        }
        ForStatement.out(sIndent + "  Statement:");
        this.getInnerStatement().print(sIndent + "    ");
    }
}

