/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Goto;
import com.tangosol.dev.assembler.Iconst;
import com.tangosol.dev.assembler.Ifnonnull;
import com.tangosol.dev.assembler.Instanceof;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.NullExpression;
import com.tangosol.dev.compiler.java.RelationalExpression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class InstanceOfExpression
extends RelationalExpression {
    private static final String CLASS = "InstanceOfExpression";
    private static final DataType BOOLEAN = DataType.BOOLEAN;

    public InstanceOfExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        left = (Expression)left.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        right = (Expression)right.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        if (left.checkReference(true, errlist) & right.checkReferenceType(false, errlist)) {
            left.checkCastable(ctx, right.getType(), errlist);
        }
        this.setLeftExpression(left);
        this.setRightExpression(right);
        this.setType(BOOLEAN);
        return this;
    }

    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        if (!ctx.isDebug() && this.isConstant()) {
            return super.compile(ctx, code, fReached, errlist);
        }
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        left.compile(ctx, code, fReached, errlist);
        DataType type = right.getType();
        if (!ctx.isDebug() && left.checkAssignable(ctx, type, null)) {
            Label lblTrue = new Label();
            Label lblExit = new Label();
            code.add(new Ifnonnull(lblTrue));
            code.add(new Iconst(FALSE));
            code.add(new Goto(lblExit));
            code.add(lblTrue);
            code.add(new Iconst(TRUE));
            code.add(lblExit);
        } else {
            code.add(new Instanceof((ClassConstant)ctx.getTypeInfo(type).getConstant()));
        }
        return fReached;
    }

    public boolean isConstant() {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        return left instanceof NullExpression || left.isConstant() && left.getValue() == null;
    }

    public Object getValue() {
        return Boolean.FALSE;
    }
}

