/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Statement;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.util.ErrorList;
import java.util.Map;
import java.util.Set;

public class LabelStatement
extends Statement {
    private static final String CLASS = "LabelStatement";
    private String sName;

    public LabelStatement(Statement stmt, Token tokName, Token tokColon) {
        super(stmt, tokName);
        this.setEndToken(tokColon);
        this.sName = tokName.getText();
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        for (Statement stmt = this.getOuterStatement(); stmt != null; stmt = stmt.getOuterStatement()) {
            if (!(stmt instanceof LabelStatement) || !this.sName.equals(((LabelStatement)stmt).sName)) continue;
            this.getStartToken().logError(3, "JC-001", new String[]{this.sName}, errlist);
            break;
        }
        this.getInnerStatement().precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        setUVars.addAll(this.getBreakUVars());
        Set setAssigned = this.getBreakFVars();
        if (!setAssigned.isEmpty()) {
            setAssigned.retainAll(this.getBlock().getVariables());
            setFVars.addAll(setAssigned);
        }
        this.getStartLabel();
        this.getEndLabel();
        return this;
    }

    protected boolean compileImpl(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        return this.getInnerStatement().compile(ctx, code, fReached, errlist);
    }

    public String getName() {
        return this.sName;
    }

    public String toString() {
        return super.toString() + " " + this.sName;
    }
}

