/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.compiler.java.Token;

public class LiteralToken
extends Token {
    protected boolean fStoredNeg;

    public LiteralToken(int iValue, int iLine, int ofInLine, int cchToken) {
        super(3, 1, 100, LiteralToken.makeInteger(iValue), null, iLine, ofInLine, cchToken);
    }

    public LiteralToken(int iValue, boolean bStoredNeg, int iLine, int ofInLine, int cchToken) {
        super(3, 1, 100, LiteralToken.makeInteger(iValue), null, iLine, ofInLine, cchToken);
        this.fStoredNeg = bStoredNeg;
    }

    public LiteralToken(long lValue, int iLine, int ofInLine, int cchToken) {
        super(3, 2, 101, LiteralToken.makeLong(lValue), null, iLine, ofInLine, cchToken);
    }

    public LiteralToken(long lValue, boolean bStoredNeg, int iLine, int ofInLine, int cchToken) {
        super(3, 2, 101, LiteralToken.makeLong(lValue), null, iLine, ofInLine, cchToken);
        this.fStoredNeg = bStoredNeg;
    }

    public LiteralToken(float flValue, int iLine, int ofInLine, int cchToken) {
        super(3, 3, 102, new Float(flValue), null, iLine, ofInLine, cchToken);
    }

    public LiteralToken(double dflValue, int iLine, int ofInLine, int cchToken) {
        super(3, 4, 103, new Double(dflValue), null, iLine, ofInLine, cchToken);
    }

    public LiteralToken(char chValue, int iLine, int ofInLine, int cchToken) {
        super(3, 6, 99, new Character(chValue), null, iLine, ofInLine, cchToken);
    }

    public LiteralToken(String sValue, int iLine, int ofInLine, int cchToken) {
        super(3, 7, 104, sValue, null, iLine, ofInLine, cchToken);
    }

    public LiteralToken(LiteralToken that, int iLine, int ofInLine, int cchToken) {
        super(that, iLine, ofInLine, cchToken);
        this.fStoredNeg = that.fStoredNeg;
    }

    public Object getValue() {
        Object value = this.value;
        if (this.fStoredNeg) {
            switch (this.subcat) {
                case 1: {
                    if (this.isOutOfRange()) {
                        value = LiteralToken.makeInteger(0);
                        break;
                    }
                    value = LiteralToken.makeInteger(-((Number)value).intValue());
                    break;
                }
                case 2: {
                    value = this.isOutOfRange() ? LiteralToken.makeLong(0L) : LiteralToken.makeLong(-((Number)value).longValue());
                }
            }
        }
        return value;
    }

    public String getText() {
        if (this.text == null) {
            switch (this.subcat) {
                case 1: {
                    if (this.isOutOfRange()) {
                        this.text = "0";
                        break;
                    }
                    if (this.fStoredNeg) {
                        int i = (Integer)this.value;
                        this.text = Integer.toString(-i);
                        break;
                    }
                    this.text = ((Integer)this.value).toString();
                    break;
                }
                case 2: {
                    if (this.isOutOfRange()) {
                        this.text = "0";
                        break;
                    }
                    if (this.fStoredNeg) {
                        long l = (Long)this.value;
                        this.text = Long.toString(-l);
                        break;
                    }
                    this.text = ((Long)this.value).toString();
                    break;
                }
                case 3: {
                    this.text = ((Float)this.value).toString() + "F";
                    break;
                }
                case 4: {
                    this.text = ((Double)this.value).toString();
                    break;
                }
                case 6: {
                    this.text = LiteralToken.printableChar(this.charValue());
                    break;
                }
                case 7: {
                    this.text = LiteralToken.printableString(this.stringValue());
                }
            }
        }
        return this.text;
    }

    public int intValue() {
        int iValue;
        switch (this.subcat) {
            case 6: {
                iValue = ((Character)this.value).charValue();
                break;
            }
            case 7: {
                iValue = Integer.decode((String)this.value);
                break;
            }
            default: {
                iValue = ((Number)this.value).intValue();
            }
        }
        return this.fStoredNeg ? -iValue : iValue;
    }

    public long longValue() {
        long lValue;
        switch (this.subcat) {
            case 6: {
                lValue = ((Character)this.value).charValue();
                break;
            }
            case 7: {
                lValue = Long.decode((String)this.value);
                break;
            }
            default: {
                lValue = ((Number)this.value).longValue();
            }
        }
        return this.fStoredNeg ? -lValue : lValue;
    }

    public float floatValue() {
        float flValue;
        switch (this.subcat) {
            case 6: {
                flValue = ((Character)this.value).charValue();
                break;
            }
            case 7: {
                flValue = Float.valueOf((String)this.value).floatValue();
                break;
            }
            default: {
                flValue = ((Number)this.value).floatValue();
            }
        }
        return this.fStoredNeg ? -flValue : flValue;
    }

    public double doubleValue() {
        double dflValue;
        switch (this.subcat) {
            case 6: {
                dflValue = ((Character)this.value).charValue();
                break;
            }
            case 7: {
                dflValue = Double.valueOf((String)this.value);
                break;
            }
            default: {
                dflValue = ((Number)this.value).doubleValue();
            }
        }
        return this.fStoredNeg ? -dflValue : dflValue;
    }

    public char charValue() {
        char chValue;
        switch (this.subcat) {
            case 6: {
                chValue = ((Character)this.value).charValue();
                break;
            }
            case 7: {
                String sValue = (String)this.value;
                chValue = sValue.length() > 0 ? sValue.charAt(0) : (char)'\u0000';
                break;
            }
            default: {
                int iValue = ((Number)this.value).intValue();
                chValue = (char)(this.fStoredNeg ? -iValue : iValue);
            }
        }
        return chValue;
    }

    public String stringValue() {
        return this.value.toString();
    }

    public void negate() {
        this.fStoredNeg = !this.fStoredNeg;
        this.text = null;
    }

    public boolean isOutOfRange() {
        switch (this.subcat) {
            case 1: {
                int iValue = (Integer)this.value;
                return this.fStoredNeg && iValue == Integer.MIN_VALUE;
            }
            case 2: {
                long lValue = (Long)this.value;
                return this.fStoredNeg && lValue == Long.MIN_VALUE;
            }
        }
        return false;
    }

    public static String printableChar(char ch) {
        return LiteralToken.toQuotedCharEscape(ch);
    }

    public static String printableString(String s) {
        return LiteralToken.toQuotedStringEscape(s);
    }
}

